/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.model.fomula.token;

import java.util.List;
import kd.mmc.phm.mservice.model.data.DBRows;
import kd.mmc.phm.mservice.model.fomula.ExprContext;
import kd.mmc.phm.mservice.model.fomula.IToken;
import kd.mmc.phm.mservice.model.fomula.enums.ConnectType;
import kd.mmc.phm.mservice.model.fomula.enums.TokenType;
import kd.mmc.phm.mservice.model.fomula.util.FormulaUtil;

public class ConnectToken
implements IToken {
    private ConnectType type;

    public ConnectToken(ConnectType type) {
        this.type = type;
    }

    @Override
    public void action(ExprContext ctx) {
        Object left = ctx.getStack().pop();
        Object right = ctx.getStack().pop();
        switch (this.type) {
            case AND: {
                if (left instanceof Boolean) {
                    ctx.getStack().push((Boolean)left != false && (Boolean)right != false);
                    break;
                }
                if (left instanceof List) {
                    ctx.getStack().push(FormulaUtil.and((List)left, (List)right));
                    break;
                }
                if (!(left instanceof DBRows)) break;
                ctx.getStack().push(((DBRows)left).and((DBRows)right));
                break;
            }
            case OR: {
                if (left instanceof Boolean) {
                    ctx.getStack().push((Boolean)left != false || (Boolean)right != false);
                    break;
                }
                if (left instanceof List) {
                    ctx.getStack().push(FormulaUtil.or((List)left, (List)right));
                    break;
                }
                if (!(left instanceof DBRows)) break;
                ctx.getStack().push(((DBRows)left).or((DBRows)right));
                break;
            }
        }
    }

    public ConnectType getConnectType() {
        return this.type;
    }

    @Override
    public TokenType getType() {
        TokenType en = TokenType.CONNECT;
        return en;
    }

    public String toString() {
        switch (this.type) {
            case AND: {
                return " AND ";
            }
            case OR: {
                return " OR ";
            }
        }
        return "";
    }
}

