/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.model.fomula.token;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.utils.StringUtils;
import kd.mmc.phm.mservice.model.fomula.ExprContext;
import kd.mmc.phm.mservice.model.fomula.IToken;
import kd.mmc.phm.mservice.model.fomula.enums.OperatorType;
import kd.mmc.phm.mservice.model.fomula.enums.TokenType;
import org.apache.log4j.Logger;

public class OperatorToken
implements IToken {
    private static Logger logger = Logger.getLogger(OperatorToken.class);
    private OperatorType type;

    public OperatorToken(OperatorType type) {
        this.type = type;
    }

    @Override
    public void action(ExprContext ctx) {
        Object rightOperand = ctx.getStack().pop();
        Object leftOperand = null;
        if (this.type != OperatorType.ISNULL && this.type != OperatorType.ISNOTNULL) {
            leftOperand = ctx.getStack().pop();
        }
        boolean compareValue = false;
        if (rightOperand == null) {
            if (this.type == OperatorType.ISNULL) {
                compareValue = true;
            }
        } else if (this.type == OperatorType.ISNOTNULL) {
            compareValue = true;
        }
        block10 : switch (this.type) {
            case BETWEEN: {
                Array.get(rightOperand, 0);
                Array.get(rightOperand, 1);
                break;
            }
            case NOTBETWEEN: {
                Array.get(rightOperand, 0);
                Array.get(rightOperand, 1);
                break;
            }
            case EQUALS: {
                if (rightOperand == null && leftOperand == null) {
                    compareValue = true;
                    break;
                }
                if (rightOperand == null || leftOperand == null) {
                    compareValue = false;
                    break;
                }
                String leftOperandStr = leftOperand.toString();
                String rightOperandStr = rightOperand.toString();
                try {
                    BigDecimal leftNum = new BigDecimal(leftOperandStr);
                    BigDecimal rightNum = new BigDecimal(rightOperandStr);
                    compareValue = leftNum.compareTo(rightNum) == 0;
                }
                catch (Throwable e) {
                    logger.error((Object)"--\u8ba1\u7b97\u5f02\u5e38--", e);
                    compareValue = StringUtils.equals((CharSequence)leftOperandStr, (CharSequence)rightOperandStr);
                }
                break;
            }
            case NOTEQUALS: {
                if (rightOperand == null && leftOperand == null) {
                    compareValue = false;
                    break;
                }
                if (rightOperand == null || leftOperand == null) {
                    compareValue = true;
                    break;
                }
                String leftOperandStr = leftOperand.toString();
                String rightOperandStr = rightOperand.toString();
                try {
                    BigDecimal leftNum = new BigDecimal(leftOperandStr);
                    BigDecimal rightNum = new BigDecimal(rightOperandStr);
                    compareValue = leftNum.compareTo(rightNum) != 0;
                }
                catch (Throwable e) {
                    logger.error((Object)"--\u8ba1\u7b97\u5f02\u5e38--", e);
                    compareValue = !StringUtils.equals((CharSequence)leftOperandStr, (CharSequence)rightOperandStr);
                }
                break;
            }
            case LESS: {
                if (rightOperand == null && leftOperand == null) {
                    compareValue = false;
                    break;
                }
                if (rightOperand == null) {
                    compareValue = false;
                    break;
                }
                if (leftOperand == null) {
                    compareValue = true;
                    break;
                }
                String leftOperandStr = leftOperand.toString();
                String rightOperandStr = rightOperand.toString();
                try {
                    BigDecimal leftNum = new BigDecimal(leftOperandStr);
                    BigDecimal rightNum = new BigDecimal(rightOperandStr);
                    compareValue = leftNum.compareTo(rightNum) < 0;
                }
                catch (Throwable e) {
                    logger.error((Object)"--\u8ba1\u7b97\u5f02\u5e38--", e);
                    compareValue = leftOperandStr.compareTo(rightOperandStr) < 0;
                }
                break;
            }
            case EQUALSLESS: {
                if (rightOperand == null && leftOperand == null) {
                    compareValue = true;
                    break;
                }
                if (rightOperand == null) {
                    compareValue = false;
                    break;
                }
                if (leftOperand == null) {
                    compareValue = true;
                    break;
                }
                try {
                    BigDecimal leftNum = new BigDecimal(leftOperand.toString());
                    BigDecimal rightNum = new BigDecimal(rightOperand.toString());
                    compareValue = leftNum.compareTo(rightNum) <= 0;
                }
                catch (Throwable e) {
                    logger.error((Object)"--\u8ba1\u7b97\u5f02\u5e38--", e);
                    compareValue = leftOperand.toString().compareTo(rightOperand.toString()) <= 0;
                }
                break;
            }
            case OVER: {
                if (rightOperand == null && leftOperand == null) {
                    compareValue = false;
                    break;
                }
                if (rightOperand == null) {
                    compareValue = true;
                    break;
                }
                if (leftOperand == null) {
                    compareValue = false;
                    break;
                }
                String leftOperandStr = leftOperand.toString();
                String rightOperandStr = rightOperand.toString();
                try {
                    BigDecimal leftNum = new BigDecimal(leftOperandStr);
                    BigDecimal rightNum = new BigDecimal(rightOperandStr);
                    compareValue = leftNum.compareTo(rightNum) > 0;
                }
                catch (Throwable e) {
                    logger.error((Object)"--\u8ba1\u7b97\u5f02\u5e38--", e);
                    compareValue = leftOperandStr.compareTo(rightOperandStr) > 0;
                }
                break;
            }
            case EQUALSOVER: {
                if (rightOperand == null && leftOperand == null) {
                    compareValue = true;
                    break;
                }
                if (rightOperand == null) {
                    compareValue = true;
                    break;
                }
                if (leftOperand == null) {
                    compareValue = false;
                    break;
                }
                try {
                    BigDecimal leftNum = new BigDecimal(leftOperand.toString());
                    BigDecimal rightNum = new BigDecimal(rightOperand.toString());
                    compareValue = leftNum.compareTo(rightNum) >= 0;
                }
                catch (Throwable e) {
                    logger.error((Object)"--\u8ba1\u7b97\u5f02\u5e38--", e);
                    compareValue = leftOperand.toString().compareTo(rightOperand.toString()) >= 0;
                }
                break;
            }
            case IN: {
                compareValue = false;
                int len = Array.getLength(rightOperand);
                for (int i = 0; i < len; ++i) {
                    Object operand = Array.get(rightOperand, i);
                    if (leftOperand == null || operand == null) continue;
                    try {
                        BigDecimal leftNum = new BigDecimal(leftOperand.toString());
                        BigDecimal rightNum = new BigDecimal(operand.toString());
                        compareValue = leftNum.compareTo(rightNum) == 0;
                    }
                    catch (Throwable e) {
                        logger.error((Object)"--\u8ba1\u7b97\u5f02\u5e38--", e);
                        boolean bl = compareValue = leftOperand.toString().compareTo(operand.toString()) == 0;
                    }
                    if (compareValue) break block10;
                }
                break;
            }
            case NOTIN: {
                compareValue = true;
                int len = Array.getLength(rightOperand);
                for (int i = 0; i < len; ++i) {
                    Object operand = Array.get(rightOperand, i);
                    if (leftOperand == null || operand == null) continue;
                    try {
                        BigDecimal leftNum = new BigDecimal(leftOperand.toString());
                        BigDecimal rightNum = new BigDecimal(operand.toString());
                        compareValue = leftNum.compareTo(rightNum) != 0;
                    }
                    catch (Throwable e) {
                        logger.error((Object)"--\u8ba1\u7b97\u5f02\u5e38--", e);
                        boolean bl = compareValue = leftOperand.toString().compareTo(operand.toString()) != 0;
                    }
                    if (!compareValue) break block10;
                }
                break;
            }
            case LIKE: {
                String content = (String)leftOperand;
                String value = (String)rightOperand;
                if (value == null && content == null) {
                    compareValue = true;
                    break;
                }
                if (value == null || content == null) {
                    compareValue = false;
                    break;
                }
                if (value.startsWith("%") && value.endsWith("%")) {
                    compareValue = content.indexOf(content) >= 0;
                    break;
                }
                if (value.startsWith("%")) {
                    compareValue = content.endsWith(value);
                    break;
                }
                if (value.endsWith("%")) {
                    compareValue = content.startsWith(value);
                    break;
                }
                compareValue = content.equals(value);
                break;
            }
            case NOTLIKE: {
                String content = (String)leftOperand;
                String value = (String)rightOperand;
                if (value == null && content == null) {
                    compareValue = false;
                    break;
                }
                if (value == null || content == null) {
                    compareValue = true;
                    break;
                }
                if (value.startsWith("%") && value.endsWith("%")) {
                    compareValue = content.indexOf(value) < 0;
                    break;
                }
                if (value.startsWith("%")) {
                    compareValue = !content.endsWith(value);
                    break;
                }
                if (value.endsWith("%")) {
                    compareValue = !content.startsWith(value);
                    break;
                }
                compareValue = !content.equals(value);
                break;
            }
            case PLUS: {
                if (leftOperand != null && leftOperand.getClass().isArray()) {
                    leftOperand = Array.get(leftOperand, 0);
                }
                if (rightOperand != null && rightOperand.getClass().isArray()) {
                    rightOperand = Array.get(rightOperand, 0);
                }
                if (leftOperand instanceof Number || rightOperand instanceof Number) {
                    if (!(leftOperand instanceof Number)) {
                        try {
                            ctx.getStack().push(new BigDecimal(leftOperand == null ? "0" : leftOperand.toString()).add(new BigDecimal(rightOperand == null ? "0" : rightOperand.toString())));
                        }
                        catch (NumberFormatException e) {
                            logger.error((Object)"--NumberFormatException--", (Throwable)e);
                            ctx.getStack().push(String.valueOf(leftOperand) + String.valueOf(rightOperand));
                        }
                    } else {
                        try {
                            ctx.getStack().push(new BigDecimal(leftOperand.toString()).add(new BigDecimal(rightOperand == null ? "0" : rightOperand.toString())));
                        }
                        catch (NumberFormatException e) {
                            logger.error((Object)"--NumberFormatException--", (Throwable)e);
                            ctx.getStack().push(String.valueOf(leftOperand) + String.valueOf(rightOperand));
                        }
                    }
                } else {
                    ctx.getStack().push(String.valueOf(leftOperand) + String.valueOf(rightOperand));
                }
                return;
            }
            case MINUS: {
                ctx.getStack().push(this.getBigDecimal(leftOperand).add(this.getBigDecimal(rightOperand).negate()));
                return;
            }
            case MULTIPLE: {
                ctx.getStack().push(this.getBigDecimal(leftOperand).multiply(this.getBigDecimal(rightOperand)));
                return;
            }
            case DIVIDE: {
                BigDecimal rightBigDecimal = this.getBigDecimal(rightOperand);
                if (rightBigDecimal.compareTo(BigDecimal.ZERO) != 0) {
                    ctx.getStack().push(this.getBigDecimal(leftOperand).divide(rightBigDecimal, RoundingMode.UP));
                }
                return;
            }
            case REMAINDER: {
                int left = this.getBigDecimal(leftOperand).intValue();
                int right = this.getBigDecimal(rightOperand).intValue();
                ctx.getStack().push(new BigDecimal(left % right));
                return;
            }
        }
        ctx.getStack().push(compareValue);
    }

    private BigDecimal getBigDecimal(Object operand) {
        if (operand == null) {
            return new BigDecimal("0");
        }
        if (operand.getClass().isArray()) {
            Object first = Array.get(operand, 0);
            return new BigDecimal(first.toString());
        }
        return new BigDecimal(operand.toString());
    }

    public OperatorType getOperatorType() {
        return this.type;
    }

    @Override
    public TokenType getType() {
        TokenType en = TokenType.OPERATOR;
        return en;
    }

    public String toString() {
        switch (this.type) {
            case BETWEEN: {
                return " BETWEEN ";
            }
            case NOTBETWEEN: {
                return " NOT BETWEEN ";
            }
            case EQUALS: {
                return " = ";
            }
            case EQUALSLESS: {
                return " <= ";
            }
            case EQUALSOVER: {
                return " >= ";
            }
            case IN: {
                return " IN ";
            }
            case LESS: {
                return " < ";
            }
            case LIKE: {
                return " LIKE ";
            }
            case NOTEQUALS: {
                return " <> ";
            }
            case NOTIN: {
                return " NOT IN ";
            }
            case NOTLIKE: {
                return " NOT LIKE ";
            }
            case OVER: {
                return " > ";
            }
            case PLUS: {
                return " + ";
            }
            case MINUS: {
                return " - ";
            }
            case MULTIPLE: {
                return " * ";
            }
            case DIVIDE: {
                return " / ";
            }
            case REMAINDER: {
                return " % ";
            }
            case ISNULL: {
                return " IS NULL";
            }
            case ISNOTNULL: {
                return " IS NOT NULL";
            }
        }
        return " __UNRESOLVED_OPERATOR_TYPE__";
    }
}

