/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.model.fomula.util;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class FormulaUtil {
    public static Calendar createCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static boolean dateEquals(Calendar d1, Calendar d2) {
        if (d1 == null && d2 != null || d1 != null && d2 == null) {
            return false;
        }
        if (d1 == null && d2 == null) {
            return true;
        }
        return d1.get(1) == d2.get(1) && d1.get(2) == d2.get(2) && d1.get(5) == d2.get(5);
    }

    public static Boolean convert(Object src, Boolean defaultValue) {
        if (src == null) {
            return defaultValue;
        }
        if (src instanceof Boolean) {
            return (Boolean)src;
        }
        if (src instanceof Number) {
            Integer result = FormulaUtil.convert(src, 0);
            if (result == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return Boolean.TRUE;
    }

    public static boolean isTrue(Object val) {
        if (val == null) {
            return false;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        String literal = String.valueOf(val);
        return !"false".equalsIgnoreCase(literal) && !"0".equals(literal);
    }

    public static boolean isEmpty(List<?> collection) {
        return collection == null || collection.isEmpty();
    }

    @SafeVarargs
    public static <T> HashSet<T> array2Set(T ... values) {
        HashSet<T> set = new HashSet<T>();
        for (T value : values) {
            set.add(value);
        }
        return set;
    }

    public static <T> HashSet<T> array2Set(List<T> values) {
        HashSet<T> set = new HashSet<T>(values);
        return set;
    }

    public static Collection<Integer> and(Collection<Integer> src0, Collection<Integer> src1) {
        Collection<Integer> max = src0.size() > src1.size() ? src0 : src1;
        Collection<Integer> min = src0.size() > src1.size() ? src1 : src0;
        HashSet<Integer> set = new HashSet<Integer>();
        set.addAll(max);
        Iterator<Integer> iter = min.iterator();
        while (iter.hasNext()) {
            Integer item = iter.next();
            if (set.contains(item)) continue;
            iter.remove();
        }
        return min;
    }

    public static Collection<Integer> or(Collection<Integer> src0, Collection<Integer> src1) {
        Collection<Integer> max = src0.size() > src1.size() ? src0 : src1;
        Collection<Integer> min = src0.size() > src1.size() ? src1 : src0;
        HashSet<Integer> set = new HashSet<Integer>();
        set.addAll(max);
        for (Integer item : min) {
            if (set.contains(item)) continue;
            max.add(item);
        }
        return max;
    }

    public static <T> T convert(Object src, T defaultValue) {
        if (src == null) {
            return defaultValue;
        }
        if (src instanceof BigDecimal) {
            if (defaultValue instanceof BigDecimal) {
                return (T)src;
            }
            if (defaultValue instanceof Integer) {
                return (T)Integer.valueOf(((BigDecimal)src).intValue());
            }
        } else if (src instanceof Integer) {
            if (defaultValue instanceof BigDecimal) {
                return (T)new BigDecimal((Integer)src);
            }
            if (defaultValue instanceof Integer) {
                return (T)src;
            }
        } else if (src instanceof Long) {
            if (defaultValue instanceof BigDecimal) {
                return (T)new BigDecimal((Long)src);
            }
            if (defaultValue instanceof Integer) {
                return (T)src;
            }
            if (defaultValue instanceof Long) {
                return (T)src;
            }
        } else if (src instanceof String) {
            if (defaultValue instanceof BigDecimal) {
                return (T)new BigDecimal((String)src);
            }
            if (defaultValue instanceof Integer) {
                return (T)Integer.valueOf((String)src);
            }
            if (defaultValue instanceof Long) {
                return (T)Long.valueOf((String)src);
            }
        }
        throw new RuntimeException("unimplement number type.");
    }
}

