/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.process;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.mmc.phm.common.domian.process.AutoSubmitParam;
import kd.mmc.phm.common.enums.DealTypeEnum;
import kd.mmc.phm.common.enums.ProcessErrorTypeEnum;
import kd.mmc.phm.common.enums.ResourceTypeEnum;
import kd.mmc.phm.common.enums.TaskStatusEnum;
import kd.mmc.phm.common.serviece.workbench.DealProcessErrorDateTempLog;
import kd.mmc.phm.common.serviece.workbench.ProcessCalcLogService;
import kd.mmc.phm.common.serviece.workbench.impl.IDealPorcessErrorLog;
import kd.mmc.phm.common.util.process.AutoSubmitUtil;
import kd.mmc.phm.mservice.process.ProcessAutoUpdateRunner;

public class ManualUpdate {
    private static final ExecutorService updateExecutorService = ThreadPools.newCachedExecutorService((String)"manualUpdateThreadPool", (int)4, (int)8);

    public static List<String> dealProcessError(DynamicObject processHistory, DynamicObjectCollection errorLogs) {
        List<String> errors;
        if (errorLogs == null || errorLogs.isEmpty()) {
            return null;
        }
        String number = processHistory.getString("number");
        ArrayList errorMsgs = Lists.newArrayListWithCapacity((int)10);
        Map<Object, List<DynamicObject>> errorLogInfos = errorLogs.stream().collect(Collectors.groupingBy(item -> item.getString("errortype")));
        List<DynamicObject> manualSaveLogs = errorLogInfos.get(ProcessErrorTypeEnum.MANUAL_SAVE_ERR.getValue());
        List<DynamicObject> manualSubmitLogs = errorLogInfos.get(ProcessErrorTypeEnum.MANUAL_SUBMIT_ERR.getValue());
        if (manualSaveLogs != null && !manualSaveLogs.isEmpty() || manualSubmitLogs != null && !manualSubmitLogs.isEmpty()) {
            errorMsgs.add(number + ResManager.loadKDString((String)":\u624b\u5de5\u4fdd\u5b58\u5f02\u5e38\u548c\u624b\u5de5\u63d0\u4ea4\u5f02\u5e38\u4e0d\u80fd\u624b\u5de5\u66f4\u65b0", (String)"ManualUpdate_0", (String)"mmc-phm-mservice", (Object[])new Object[0]));
        }
        List<DynamicObject> manualAuditLogs = errorLogInfos.get(ProcessErrorTypeEnum.MANUAL_AUDIT_ERR.getValue());
        List<DynamicObject> createAuditLogs = errorLogInfos.get(ProcessErrorTypeEnum.AUTO_AUDIT_ERR.getValue());
        List<DynamicObject> autoCreateAuditLogs = null;
        List<DynamicObject> cycleCreateAuditLogs = null;
        List<DynamicObject> waitCreateAuditLogs = null;
        List<DynamicObject> loadErrorLogs = errorLogInfos.get(ProcessErrorTypeEnum.AUTO_LOAD_ERR.getValue());
        if (createAuditLogs != null && !createAuditLogs.isEmpty()) {
            Map<Object, List<DynamicObject>> autoCreateAuditMapLogs = createAuditLogs.stream().collect(Collectors.groupingBy(item -> item.getString("dealtype")));
            autoCreateAuditLogs = autoCreateAuditMapLogs.get(DealTypeEnum.AUTO.getName());
            cycleCreateAuditLogs = autoCreateAuditMapLogs.get(DealTypeEnum.CYCLE.getName());
            waitCreateAuditLogs = autoCreateAuditMapLogs.get(DealTypeEnum.WAIT.getName());
        }
        if (!CollectionUtils.isEmpty(waitCreateAuditLogs) && !CollectionUtils.isEmpty(errors = ManualUpdate.validatorWaitResource(processHistory, waitCreateAuditLogs))) {
            errorMsgs.addAll(errors);
        }
        if (!CollectionUtils.isEmpty((Collection)errorMsgs)) {
            return errorMsgs;
        }
        List<DynamicObject> autoUpdateLogs = errorLogInfos.get(ProcessErrorTypeEnum.AUTO_UPDATE_ERR.getValue());
        Map<Object, List<DynamicObject>> autoUpeateNode = autoUpdateLogs == null ? null : autoUpdateLogs.stream().collect(Collectors.groupingBy(item -> item.getLong("node")));
        int manualUpdateStatus = 0;
        if (autoUpeateNode != null && !CollectionUtils.isEmpty(autoUpeateNode)) {
            manualUpdateStatus += autoUpeateNode.size();
        }
        if (!(CollectionUtils.isEmpty(autoCreateAuditLogs) && CollectionUtils.isEmpty(cycleCreateAuditLogs) && CollectionUtils.isEmpty(manualAuditLogs))) {
            ++manualUpdateStatus;
        }
        if (!CollectionUtils.isEmpty(waitCreateAuditLogs)) {
            ++manualUpdateStatus;
        }
        if (!CollectionUtils.isEmpty(loadErrorLogs)) {
            ++manualUpdateStatus;
        }
        ProcessCalcLogService.changeProcessManualUpdateStatus((Long)processHistory.getLong("id"), (int)manualUpdateStatus);
        ManualUpdate.dealProcessAutoUpdateError(processHistory, autoUpeateNode);
        List<CompletableFuture<Void>> manualAuditFuture = ManualUpdate.dealProcessManualAuditError(processHistory, manualAuditLogs);
        List<CompletableFuture<Void>> autoAuditErrorFuture = ManualUpdate.dealProcessAutoAuditError(processHistory, autoCreateAuditLogs);
        List<CompletableFuture<Void>> clcleAuditErrorFuture = ManualUpdate.dealProcessAutoAuditError(processHistory, cycleCreateAuditLogs);
        ManualUpdate.dealProcessAutoLoadError(processHistory, loadErrorLogs);
        ArrayList allNodesFuture = Lists.newArrayListWithExpectedSize((int)10);
        if (!CollectionUtils.isEmpty(manualAuditFuture)) {
            allNodesFuture.addAll(manualAuditFuture);
        }
        if (!CollectionUtils.isEmpty(autoAuditErrorFuture)) {
            allNodesFuture.addAll(autoAuditErrorFuture);
        }
        if (!CollectionUtils.isEmpty(clcleAuditErrorFuture)) {
            allNodesFuture.addAll(clcleAuditErrorFuture);
        }
        ManualUpdate.dealProcessWaitAuditError(processHistory, waitCreateAuditLogs, allNodesFuture);
        return null;
    }

    private static void dealProcessAutoLoadError(DynamicObject processHistory, List<DynamicObject> cycleCreateAuditLogs) {
        if (cycleCreateAuditLogs == null || cycleCreateAuditLogs.isEmpty()) {
            return;
        }
        ArrayList completableFutures = Lists.newArrayListWithCapacity((int)cycleCreateAuditLogs.size());
        for (DynamicObject errorLog : cycleCreateAuditLogs) {
            IDealPorcessErrorLog dealPorcessErrorLog = ManualUpdate.getErrorDealType(processHistory, errorLog);
            if (dealPorcessErrorLog == null) continue;
            CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> ((IDealPorcessErrorLog)dealPorcessErrorLog).dealError(), updateExecutorService);
            completableFutures.add(completableFuture);
        }
        RequestContext requestContext = RequestContext.get();
        if (completableFutures != null && !completableFutures.isEmpty()) {
            CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).whenCompleteAsync((result1, throwable1) -> {
                RequestContext.copyAndSet((RequestContext)requestContext);
                ProcessCalcLogService.changeProcessManualUpdateStatus((Long)processHistory.getLong("id"), (int)0);
            }, (Executor)updateExecutorService);
        }
    }

    private static void dealProcessWaitAuditError(DynamicObject processHistory, List<DynamicObject> waitCreateLogs, List<CompletableFuture<Void>> allNodesFuture) {
        RequestContext requestContext = RequestContext.get();
        if (allNodesFuture == null || allNodesFuture.isEmpty()) {
            List<CompletableFuture<Void>> waitFuture = ManualUpdate.dealProcessAutoAuditError(processHistory, waitCreateLogs);
            if (waitFuture != null && !waitFuture.isEmpty()) {
                CompletableFuture.allOf(waitFuture.toArray(new CompletableFuture[0])).whenCompleteAsync((result, throwable) -> {
                    RequestContext.copyAndSet((RequestContext)requestContext);
                    ProcessCalcLogService.changeProcessManualUpdateStatus((Long)processHistory.getLong("id"), (int)0);
                }, (Executor)updateExecutorService);
            }
        } else {
            CompletableFuture.allOf(allNodesFuture.toArray(new CompletableFuture[0])).whenCompleteAsync((result, throwable) -> {
                RequestContext.copyAndSet((RequestContext)requestContext);
                ProcessCalcLogService.changeProcessManualUpdateStatus((Long)processHistory.getLong("id"), (int)0);
                List<CompletableFuture<Void>> waitFuture = ManualUpdate.dealProcessAutoAuditError(processHistory, waitCreateLogs);
                if (waitFuture != null && !waitFuture.isEmpty()) {
                    CompletableFuture.allOf(waitFuture.toArray(new CompletableFuture[0])).whenCompleteAsync((result1, throwable1) -> {
                        RequestContext.copyAndSet((RequestContext)requestContext);
                        ProcessCalcLogService.changeProcessManualUpdateStatus((Long)processHistory.getLong("id"), (int)0);
                    }, (Executor)updateExecutorService);
                }
            }, (Executor)updateExecutorService);
        }
    }

    private static List<CompletableFuture<Void>> dealProcessManualAuditError(DynamicObject processHistory, List<DynamicObject> manualAutoLogs) {
        if (manualAutoLogs == null || manualAutoLogs.isEmpty()) {
            return null;
        }
        ArrayList completableFutures = Lists.newArrayListWithCapacity((int)manualAutoLogs.size());
        for (DynamicObject errorLog : manualAutoLogs) {
            IDealPorcessErrorLog dealPorcessErrorLog = ManualUpdate.getErrorDealType(processHistory, errorLog);
            if (dealPorcessErrorLog == null) continue;
            CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> ((IDealPorcessErrorLog)dealPorcessErrorLog).dealError(), updateExecutorService);
            completableFutures.add(completableFuture);
        }
        return completableFutures;
    }

    public static void dealProcessAutoUpdateError(DynamicObject processHistory, Map<Object, List<DynamicObject>> autoUpeateNode) {
        if (autoUpeateNode == null || autoUpeateNode.isEmpty()) {
            return;
        }
        long historyId = processHistory.getLong("id");
        for (Map.Entry<Object, List<DynamicObject>> entry : autoUpeateNode.entrySet()) {
            List<DynamicObject> errors = entry.getValue();
            HashSet startNodes = Sets.newHashSetWithExpectedSize((int)8);
            String nodeId = null;
            for (DynamicObject error : errors) {
                String startNodesString;
                if (nodeId == null) {
                    nodeId = error.getString("startnodeid");
                }
                if (StringUtils.isEmpty((CharSequence)(startNodesString = error.getString("endnodes")))) continue;
                List startNods = SerializationUtils.fromJsonStringToList((String)startNodesString, String.class);
                startNodes.addAll(startNods);
            }
            ArrayList startnodes = Lists.newArrayList((Iterable)startNodes);
            ProcessAutoUpdateRunner.autoUpdate(historyId, nodeId, startnodes, true);
        }
    }

    public static List<CompletableFuture<Void>> dealProcessAutoAuditError(DynamicObject processHistory, List<DynamicObject> autoCreateLogs) {
        if (autoCreateLogs == null || autoCreateLogs.isEmpty()) {
            return null;
        }
        Long processId = processHistory.getLong("flowdefine_id");
        Long historyId = processHistory.getLong("id");
        HashSet sameError = Sets.newHashSetWithExpectedSize((int)autoCreateLogs.size());
        ArrayList completableFutures = Lists.newArrayListWithCapacity((int)autoCreateLogs.size());
        RequestContext requestContext = RequestContext.get();
        for (DynamicObject errorLog : autoCreateLogs) {
            Long nodeId = errorLog.getLong("node");
            String resourceType = errorLog.getString("resourcetype");
            Long resourceId = errorLog.getLong("resource");
            StringBuilder uniqueKey = new StringBuilder();
            uniqueKey.append(historyId).append(nodeId).append(resourceType).append(resourceId);
            String key = uniqueKey.toString();
            if (sameError.contains(key)) continue;
            sameError.add(key);
            AutoSubmitParam autoSubmitParam = new AutoSubmitParam();
            autoSubmitParam.setDealType(errorLog.getString("dealtype"));
            autoSubmitParam.setEntryNodeId(nodeId);
            autoSubmitParam.setProcessHistoryId(historyId);
            autoSubmitParam.setResourceId(resourceId);
            autoSubmitParam.setResourceType(resourceType);
            autoSubmitParam.setProcessId(processId);
            CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> AutoSubmitUtil.manualUpdateAutoCreateResource((AutoSubmitParam)autoSubmitParam, (RequestContext)requestContext), updateExecutorService);
            completableFutures.add(completableFuture);
        }
        return completableFutures;
    }

    private static List<String> validatorWaitResource(DynamicObject processHistory, List<DynamicObject> waitErrorLogs) {
        if (CollectionUtils.isEmpty(waitErrorLogs)) {
            return null;
        }
        Set<Long> nodeIds = waitErrorLogs.stream().map(item -> item.getLong("node")).collect(Collectors.toSet());
        Map<Long, Boolean> taskComplete = ManualUpdate.selectTaskComplete(nodeIds);
        if (taskComplete == null) {
            return null;
        }
        String number = processHistory.getString("number");
        ArrayList errroMsgs = Lists.newArrayListWithCapacity((int)nodeIds.size());
        for (DynamicObject waitLog : waitErrorLogs) {
            Long nodeId = waitLog.getLong("node");
            String errorMsg = waitLog.getString("errormsg");
            Boolean complete = taskComplete.get(nodeId);
            if (complete != null && complete.booleanValue()) continue;
            List<String> sts = ManualUpdate.extractMessageByRegular(errorMsg);
            StringBuilder error = new StringBuilder(number);
            error.append(ResManager.loadKDString((String)":\u8282\u70b9[", (String)"ManualUpdate_1", (String)"mmc-phm-mservice", (Object[])new Object[0]));
            if (sts.size() > 3) {
                error.append(sts.get(2));
            }
            error.append(ResManager.loadKDString((String)"]\u624b\u5de5\u5904\u7406\u7684\u8d44\u6e90\u672a\u5173\u95ed\u4e0d\u80fd\u751f\u4ea7\u7b49\u5f85\u8d44\u6e90", (String)"ManualUpdate_2", (String)"mmc-phm-mservice", (Object[])new Object[0]));
            errroMsgs.add(error.toString());
        }
        return errroMsgs;
    }

    private static Map<Long, Boolean> selectTaskComplete(Set<Long> nodeIds) {
        if (CollectionUtils.isEmpty(nodeIds)) {
            return null;
        }
        QFilter qFilter = new QFilter("entry_node", "in", nodeIds);
        qFilter.and(new QFilter("task_dealtype", "=", (Object)DealTypeEnum.MANUAL.getName()));
        DynamicObjectCollection taskStatuss = QueryServiceHelper.query((String)"phm_process_task", (String)"entry_node,task_status", (QFilter[])qFilter.toArray());
        if (taskStatuss == null) {
            return null;
        }
        HashMap<Long, Boolean> taskComplete = new HashMap<Long, Boolean>(nodeIds.size());
        for (DynamicObject taskStatus : taskStatuss) {
            Long nodeId = taskStatus.getLong("entry_node");
            String taskState = taskStatus.getString("task_status");
            Boolean status = (Boolean)taskComplete.get(nodeId);
            if (status != null && !status.booleanValue()) continue;
            taskComplete.put(nodeId, StringUtils.equals((CharSequence)taskState, (CharSequence)TaskStatusEnum.CLOSED.getValue()));
        }
        return taskComplete;
    }

    public static List<String> extractMessageByRegular(String msg) {
        ArrayList<String> list = new ArrayList<String>();
        Pattern p = Pattern.compile("(\\[[^\\]]*\\])");
        Matcher m = p.matcher(msg);
        while (m.find()) {
            list.add(m.group().substring(1, m.group().length() - 1));
        }
        return list;
    }

    public static void manualUpdateAll(long historyId) {
        ProcessCalcLogService.changeProcessManualUpdateStatus((Long)historyId, (int)1);
        ProcessAutoUpdateRunner.autoUpdate(historyId);
    }

    public static IDealPorcessErrorLog getErrorDealType(DynamicObject processHistory, DynamicObject errorLog) {
        String resourceType = errorLog.getString("resourcetype");
        if (StringUtils.equals((CharSequence)ResourceTypeEnum.DATETEMP.getValue(), (CharSequence)resourceType)) {
            return new DealProcessErrorDateTempLog(processHistory, errorLog, RequestContext.get());
        }
        return null;
    }
}

