/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.process;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPools;
import kd.mmc.phm.common.consts.CommonConsts;
import kd.mmc.phm.common.domian.process.MainDataUpateParam;
import kd.mmc.phm.common.enums.RunningState;
import kd.mmc.phm.mservice.framework.mq.IEventManager;
import kd.mmc.phm.mservice.framework.mq.MQServiceHelper;
import kd.mmc.phm.mservice.framework.mq.event.ProcessAutoUpdateEvent;
import kd.mmc.phm.mservice.framework.mq.manager.ProcessAutoUpdateEventManager;
import kd.mmc.phm.mservice.framework.runner.CalcManager;
import kd.mmc.phm.mservice.model.process.ProcessEventNode;

public class ProcessAutoUpdateRunner {
    private static final Log log = LogFactory.getLog(ProcessAutoUpdateRunner.class);
    private static final String ALGO_KEY = "ProcessAutoUpdateRunner.";
    private static final long CALC_LOG_TIMEOUT = 5000L;
    private static final String LOCK_PREFIX = "mmc/phm/getCalcLog/";
    private static final ExecutorService executorService = ThreadPools.newCachedExecutorService((String)"PHM_PROCESS_AUTOUPDATE_WORKER", (int)5, (int)32);

    public static void autoUpdate(Long historyId, List<MainDataUpateParam> upateParams, boolean sync) {
        Map<String, ProcessEventNode> nodeMap = ProcessAutoUpdateRunner.queryNodeInfo(historyId, false);
        if (nodeMap.isEmpty()) {
            log.warn("\u81ea\u52a8\u66f4\u65b0\u8282\u70b9\u7ed3\u675f, \u6ca1\u6709\u53ef\u66f4\u65b0\u7684\u8282\u70b9\u4fe1\u606f, historyId: {}", (Object)historyId);
            return;
        }
        if (sync) {
            ProcessAutoUpdateRunner.autoUpdate(historyId, nodeMap, upateParams, sync);
        } else {
            ThreadPools.executeOnce((String)"PhmProcessAutoUpdate", () -> ProcessAutoUpdateRunner.autoUpdate(historyId, nodeMap, upateParams, sync), (String)"phm");
        }
    }

    public static void autoUpdate(Long historyId, Map<String, ProcessEventNode> nodeMap, List<MainDataUpateParam> upateParams, boolean sync) {
        Map<String, ProcessEventNode> tailNodeMap = nodeMap.entrySet().stream().filter(entry -> {
            List<String> nextNodeIds = ((ProcessEventNode)entry.getValue()).getNextNodeIds();
            boolean isEmpty = nextNodeIds.isEmpty();
            if (isEmpty) {
                return true;
            }
            return nextNodeIds.stream().noneMatch(nodeMap::containsKey);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ProcessAutoUpdateRunner.updateNodeStatus(historyId, nodeMap.keySet());
        String eventId = UUID.randomUUID().toString();
        ProcessAutoUpdateEventManager eventManager = new ProcessAutoUpdateEventManager(eventId, historyId);
        eventManager.setUpateParams(upateParams);
        CalcManager.registEventManager(eventManager);
        HashMap completableFutureMap = Maps.newHashMapWithExpectedSize((int)nodeMap.size());
        ProcessEventNode headNode = new ProcessEventNode("head", ResManager.loadKDString((String)"\u865a\u62df\u5934\u8282\u70b9", (String)"ProcessAutoUpdateRunner_0", (String)"mmc-phm-mservice", (Object[])new Object[0]), "", 0L, Collections.emptyList(), Collections.emptyList());
        RequestContext rc = RequestContext.get();
        EventInfo eventInfo = new EventInfo(eventId, headNode, nodeMap.keySet(), nodeMap, Collections.emptyMap(), rc);
        eventInfo.setUpateParams(upateParams);
        for (Map.Entry<String, ProcessEventNode> entry2 : tailNodeMap.entrySet()) {
            ProcessAutoUpdateRunner.findPreviousCompletableFuture(entry2.getValue(), completableFutureMap, eventInfo);
        }
        eventManager.putAllExecutionChain(completableFutureMap);
        if (sync) {
            eventManager.completeSync(executorService, rc);
        } else {
            eventManager.complete(executorService, rc);
        }
    }

    public static void autoUpdate(long historyId) {
        Map<String, ProcessEventNode> nodeMap = ProcessAutoUpdateRunner.queryNodeInfo(historyId, false);
        if (nodeMap.isEmpty()) {
            log.warn("\u81ea\u52a8\u66f4\u65b0\u8282\u70b9\u7ed3\u675f, \u6ca1\u6709\u53ef\u66f4\u65b0\u7684\u8282\u70b9\u4fe1\u606f, historyId: {}", (Object)historyId);
            return;
        }
        ThreadPools.executeOnce((String)"PhmProcessAutoUpdate", () -> {
            Map<String, ProcessEventNode> tailNodeMap = nodeMap.entrySet().stream().filter(entry -> {
                List<String> nextNodeIds = ((ProcessEventNode)entry.getValue()).getNextNodeIds();
                boolean isEmpty = nextNodeIds.isEmpty();
                if (isEmpty) {
                    return true;
                }
                return nextNodeIds.stream().noneMatch(nodeMap::containsKey);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            ProcessAutoUpdateRunner.updateNodeStatus(historyId, nodeMap.keySet());
            String eventId = UUID.randomUUID().toString();
            ProcessAutoUpdateEventManager eventManager = new ProcessAutoUpdateEventManager(eventId, historyId);
            CalcManager.registEventManager(eventManager);
            HashMap completableFutureMap = Maps.newHashMapWithExpectedSize((int)nodeMap.size());
            ProcessEventNode headNode = new ProcessEventNode("head", ResManager.loadKDString((String)"\u865a\u62df\u5934\u8282\u70b9", (String)"ProcessAutoUpdateRunner_0", (String)"mmc-phm-mservice", (Object[])new Object[0]), "", 0L, Collections.emptyList(), Collections.emptyList());
            RequestContext rc = RequestContext.get();
            EventInfo eventInfo = new EventInfo(eventId, headNode, nodeMap.keySet(), nodeMap, Collections.emptyMap(), rc);
            for (Map.Entry<String, ProcessEventNode> entry2 : tailNodeMap.entrySet()) {
                ProcessAutoUpdateRunner.findPreviousCompletableFuture(entry2.getValue(), completableFutureMap, eventInfo);
            }
            eventManager.putAllExecutionChain(completableFutureMap);
            eventManager.complete(executorService, rc);
        }, (String)"phm");
    }

    public static void autoUpdate(long historyId, String startNodeId, List<String> sourceNodeIds, boolean calculateStartNode) {
        Map<String, ProcessEventNode> nodeMap = ProcessAutoUpdateRunner.queryNodeInfo(historyId, true);
        ThreadPools.executeOnceIncludeRequestContext((String)"PhmProcessAutoUpdate", () -> {
            if (startNodeId == null || CollectionUtils.isEmpty((Collection)sourceNodeIds)) {
                log.warn("\u81ea\u52a8\u66f4\u65b0\u8282\u70b9\u5931\u8d25, startNodeId: {}, sourceNodeIds: {}", (Object)startNodeId, (Object)sourceNodeIds);
                return;
            }
            ProcessEventNode startNode = (ProcessEventNode)nodeMap.get(startNodeId);
            List<String> targetNextNodeIds = startNode.getNextNodeIds();
            if (targetNextNodeIds.isEmpty()) {
                log.warn("\u81ea\u52a8\u66f4\u65b0\u8282\u70b9\u5931\u8d25: \u5f00\u59cb\u8282\u70b9\u6ca1\u6709\u5b69\u5b50\u8282\u70b9, startNode: {}", (Object)startNode);
                return;
            }
            HashSet<String> autoUpdateNodeIds = new HashSet<String>();
            if (calculateStartNode) {
                autoUpdateNodeIds.add(startNodeId);
            }
            for (String sourceNodeId : sourceNodeIds) {
                ProcessAutoUpdateRunner.addUpdateNodeId(startNode, nodeMap, autoUpdateNodeIds, sourceNodeId);
            }
            if (autoUpdateNodeIds.isEmpty()) {
                log.warn("\u81ea\u52a8\u66f4\u65b0\u8282\u70b9\u5931\u8d25: \u6ca1\u6709\u53ef\u66f4\u65b0\u7684\u8282\u70b9, sourceNodeIds: {}", (Object)sourceNodeIds);
                return;
            }
            String eventId = UUID.randomUUID().toString();
            Map<String, Set<String>> nodeId2TailNodeIds = ProcessAutoUpdateRunner.getNodeId2TailNodeIds(nodeMap, autoUpdateNodeIds);
            ProcessAutoUpdateRunner.updateNodeStatus(historyId, autoUpdateNodeIds);
            ProcessAutoUpdateEventManager eventManager = new ProcessAutoUpdateEventManager(eventId, historyId);
            CalcManager.registEventManager(eventManager);
            HashMap completableFutureMap = Maps.newHashMapWithExpectedSize((int)autoUpdateNodeIds.size());
            RequestContext rc = RequestContext.get();
            EventInfo eventInfo = new EventInfo(eventId, startNode, autoUpdateNodeIds, nodeMap, nodeId2TailNodeIds, rc);
            if (calculateStartNode) {
                ProcessAutoUpdateRunner.recursiveCall(startNode, completableFutureMap, eventInfo);
            } else {
                for (String targetNextNodeId : targetNextNodeIds) {
                    ProcessAutoUpdateRunner.recursiveCall((ProcessEventNode)nodeMap.get(targetNextNodeId), completableFutureMap, eventInfo);
                }
            }
            eventManager.putAllExecutionChain(completableFutureMap);
            eventManager.complete(executorService, rc);
        }, (String)"phm");
    }

    private static void recursiveCall(ProcessEventNode currentNode, Map<ProcessEventNode, CompletableFuture> completableFutureMap, EventInfo eventInfo) {
        ProcessAutoUpdateRunner.findPreviousCompletableFuture(currentNode, completableFutureMap, eventInfo);
        Set<String> autoUpdateNodeIds = eventInfo.getAutoUpdateNodeIds();
        Map<String, ProcessEventNode> nodeMap = eventInfo.getNodeMap();
        List<String> nextNodeIds = currentNode.getNextNodeIds();
        for (String nextNodeId : nextNodeIds) {
            if (!autoUpdateNodeIds.contains(nextNodeId)) continue;
            ProcessAutoUpdateRunner.recursiveCall(nodeMap.get(nextNodeId), completableFutureMap, eventInfo);
        }
    }

    private static CompletableFuture findPreviousCompletableFuture(ProcessEventNode currentNode, Map<ProcessEventNode, CompletableFuture> completableFutureMap, EventInfo eventInfo) {
        CompletionStage<Void> completableFuture;
        block10: {
            block9: {
                completableFuture = completableFutureMap.get(currentNode);
                if (completableFuture != null) {
                    return completableFuture;
                }
                List<String> previousNodeIds = currentNode.getPreviousNodeIds();
                previousNodeIds.retainAll(eventInfo.getAutoUpdateNodeIds());
                int previousNodeIdsSize = previousNodeIds.size();
                if (previousNodeIds.isEmpty()) {
                    completableFuture = CompletableFuture.runAsync(() -> ProcessAutoUpdateRunner.publish(currentNode, Lists.newArrayList((Object[])new ProcessEventNode[]{eventInfo.getStartNode()}), eventInfo), executorService);
                } else if (previousNodeIdsSize == 1) {
                    String previousNodeId = previousNodeIds.get(0);
                    ProcessEventNode processEventNode = eventInfo.getNodeMap().get(previousNodeId);
                    CompletableFuture previouseCompletableFuture = completableFutureMap.getOrDefault(processEventNode, ProcessAutoUpdateRunner.findPreviousCompletableFuture(processEventNode, completableFutureMap, eventInfo));
                    completableFuture = previouseCompletableFuture.thenRunAsync(() -> ProcessAutoUpdateRunner.publish(currentNode, Lists.newArrayList((Object[])new ProcessEventNode[]{processEventNode}), eventInfo), executorService);
                } else {
                    CompletableFuture[] completableFutures = new CompletableFuture[previousNodeIdsSize];
                    ArrayList previousNodes = Lists.newArrayListWithExpectedSize((int)previousNodeIdsSize);
                    for (int i = 0; i < previousNodeIdsSize; ++i) {
                        String previousNodeId = previousNodeIds.get(i);
                        ProcessEventNode previousNode = eventInfo.getNodeMap().get(previousNodeId);
                        previousNodes.add(previousNode);
                        completableFutures[i] = completableFutureMap.getOrDefault(previousNode, ProcessAutoUpdateRunner.findPreviousCompletableFuture(previousNode, completableFutureMap, eventInfo));
                    }
                    completableFuture = CompletableFuture.allOf(completableFutures).thenRunAsync(() -> ProcessAutoUpdateRunner.publish(currentNode, previousNodes, eventInfo), executorService);
                }
                completableFutureMap.put(currentNode, (CompletableFuture)completableFuture);
                List<String> nextNodeIds = currentNode.getNextNodeIds();
                if (nextNodeIds.isEmpty()) break block9;
                if (!nextNodeIds.stream().noneMatch(eventInfo.getAutoUpdateNodeIds()::contains)) break block10;
            }
            ProcessAutoUpdateEventManager eventManager = (ProcessAutoUpdateEventManager)CalcManager.getEventManager(eventInfo.getEventId());
            eventManager.addParallelExecutionChain(currentNode, (CompletableFuture)completableFuture);
        }
        return completableFuture;
    }

    private static void publish(ProcessEventNode currentNode, List<ProcessEventNode> previousNodes, EventInfo eventInfo) {
        RequestContext.copyAndSet((RequestContext)eventInfo.getRc());
        ProcessAutoUpdateEvent processAutoUpdateEvent = new ProcessAutoUpdateEvent();
        String eventId = eventInfo.getEventId();
        processAutoUpdateEvent.setEventId(eventId);
        processAutoUpdateEvent.setControlQueueName(MQServiceHelper.getRealControlQueueName("kd.mmc.phm.process.control_queue", eventId));
        processAutoUpdateEvent.setStartNode(eventInfo.getStartNode());
        processAutoUpdateEvent.setCurrentNode(currentNode);
        processAutoUpdateEvent.setPreviousNodes(previousNodes);
        processAutoUpdateEvent.setTailNodeIds(eventInfo.getNodeId2TailNodeIds().getOrDefault(currentNode.getId(), Collections.emptySet()));
        processAutoUpdateEvent.setUpateParams(eventInfo.getUpateParams());
        MQServiceHelper.publishCalcEvent(processAutoUpdateEvent);
        IEventManager eventManager = CalcManager.getEventManager(eventId);
        eventManager.wait4Response(processAutoUpdateEvent);
    }

    private static Map<String, Set<String>> getNodeId2TailNodeIds(Map<String, ProcessEventNode> nodeMap, Set<String> autoUpdateNodeIds) {
        HashMap<String, Set<String>> node2TailNodes = new HashMap<String, Set<String>>(16);
        HashSet<String> tailNodeIds = new HashSet<String>();
        for (Map.Entry<String, ProcessEventNode> entry : nodeMap.entrySet()) {
            String nodeId = entry.getKey();
            if (!autoUpdateNodeIds.contains(nodeId)) continue;
            ProcessEventNode currentNode = entry.getValue();
            tailNodeIds.clear();
            ProcessAutoUpdateRunner.addTailNodeId(currentNode, nodeMap, autoUpdateNodeIds, tailNodeIds);
            node2TailNodes.put(nodeId, tailNodeIds);
        }
        return node2TailNodes;
    }

    private static void addTailNodeId(ProcessEventNode currentNode, Map<String, ProcessEventNode> nodeMap, Set<String> autoUpdateNodeIds, Set<String> tailNodeIds) {
        List<String> nextNodeIds;
        block4: {
            block3: {
                nextNodeIds = currentNode.getNextNodeIds();
                if (nextNodeIds.isEmpty()) break block3;
                if (!nextNodeIds.stream().noneMatch(autoUpdateNodeIds::contains)) break block4;
            }
            tailNodeIds.add(currentNode.getId());
            return;
        }
        for (String nextNodeId : nextNodeIds) {
            ProcessAutoUpdateRunner.addTailNodeId(nodeMap.get(nextNodeId), nodeMap, autoUpdateNodeIds, tailNodeIds);
        }
    }

    private static void updateNodeStatus(long historyId, Set<String> autoUpdateNodeIds) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("UPDATE T_PHM_PROCESS_NODE SET FSTATUS = ? WHERE FID = ? AND ", new Object[]{RunningState.AUTO.getValue(), historyId});
        sqlBuilder.appendIn("FNODEID", autoUpdateNodeIds.toArray());
        DB.update((DBRoute)CommonConsts.ROUTE_PHM, (SqlBuilder)sqlBuilder);
    }

    private static Map<String, ProcessEventNode> queryNodeInfo(long historyId, boolean containPrepareNode) {
        HashMap<String, ProcessEventNode> nodeMap = new HashMap<String, ProcessEventNode>(16);
        String selectFields = "id, nodeid, prenodeids, nextnodeids, node_name, node_status";
        QFilter[] filters = new QFilter[]{new QFilter("historyid", "=", (Object)historyId)};
        try (DataSet dataSet = ORM.create().queryDataSet("ProcessAutoUpdateRunner.getNodeInfo", "phm_process_node", selectFields, filters);){
            for (Row row : dataSet) {
                String status = row.getString("node_status");
                if (!containPrepareNode && RunningState.PREPARE.getValue().equals(status)) continue;
                String nodeId = row.getString("nodeid");
                String previousNodeIdStr = row.getString("prenodeids");
                String nextNodeIdStr = row.getString("nextnodeids");
                String nodeName = row.getString("node_name");
                long entryId = row.getLong("id");
                List previousNodeIds = StringUtils.isBlank((CharSequence)previousNodeIdStr) ? Collections.emptyList() : (List)SerializationUtils.fromJsonString((String)previousNodeIdStr, List.class);
                List nextNodeIds = StringUtils.isBlank((CharSequence)nextNodeIdStr) ? Collections.emptyList() : (List)SerializationUtils.fromJsonString((String)nextNodeIdStr, List.class);
                nodeMap.put(nodeId, new ProcessEventNode(nodeId, nodeName, status, entryId, previousNodeIds, nextNodeIds));
            }
        }
        return nodeMap;
    }

    private static void addUpdateNodeId(ProcessEventNode node, Map<String, ProcessEventNode> nodeMap, Set<String> autoUpdateNodeIds, String sourceNodeId) {
        if (StringUtils.equals((CharSequence)node.getId(), (CharSequence)sourceNodeId)) {
            return;
        }
        List<String> nextNodeIds = node.getNextNodeIds();
        if (nextNodeIds.isEmpty()) {
            return;
        }
        for (String nextNodeId : nextNodeIds) {
            ProcessEventNode nextNode = nodeMap.get(nextNodeId);
            if (RunningState.PREPARE.getValue().equals(nextNode.getStatus())) continue;
            autoUpdateNodeIds.add(nextNodeId);
        }
        for (String nextNodeId : nextNodeIds) {
            ProcessAutoUpdateRunner.addUpdateNodeId(nodeMap.get(nextNodeId), nodeMap, autoUpdateNodeIds, sourceNodeId);
        }
    }

    private static class EventInfo {
        private final String eventId;
        private final ProcessEventNode startNode;
        private final Set<String> autoUpdateNodeIds;
        private final Map<String, ProcessEventNode> nodeMap;
        private final Map<String, Set<String>> nodeId2TailNodeIds;
        private final RequestContext rc;
        private List<MainDataUpateParam> upateParams;

        public EventInfo(String eventId, ProcessEventNode startNode, Set<String> autoUpdateNodeIds, Map<String, ProcessEventNode> nodeMap, Map<String, Set<String>> nodeId2TailNodeIds, RequestContext rc) {
            this.eventId = eventId;
            this.startNode = startNode;
            this.autoUpdateNodeIds = autoUpdateNodeIds;
            this.nodeMap = nodeMap;
            this.nodeId2TailNodeIds = nodeId2TailNodeIds;
            this.rc = rc;
        }

        public RequestContext getRc() {
            return this.rc;
        }

        public String getEventId() {
            return this.eventId;
        }

        public ProcessEventNode getStartNode() {
            return this.startNode;
        }

        public Set<String> getAutoUpdateNodeIds() {
            return this.autoUpdateNodeIds;
        }

        public Map<String, ProcessEventNode> getNodeMap() {
            return this.nodeMap;
        }

        public Map<String, Set<String>> getNodeId2TailNodeIds() {
            return this.nodeId2TailNodeIds;
        }

        public List<MainDataUpateParam> getUpateParams() {
            return this.upateParams;
        }

        public void setUpateParams(List<MainDataUpateParam> upateParams) {
            this.upateParams = upateParams;
        }
    }
}

