/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.process;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.xml.crypto.Data;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.phm.common.consts.CommonConsts;
import kd.mmc.phm.common.domian.process.MainDataUpateParam;
import kd.mmc.phm.common.enums.DataTempClassifyEnum;
import kd.mmc.phm.common.enums.DataTempDataSourceEnum;
import kd.mmc.phm.common.enums.FieldType;
import kd.mmc.phm.common.enums.ResourceTypeEnum;
import kd.mmc.phm.common.serviece.workbench.ProcessCalcLogService;
import kd.mmc.phm.common.spread.SpreadPraseUtil;
import kd.mmc.phm.common.spread.SpreadUtils;
import kd.mmc.phm.mservice.process.ProcessAutoUpdateRunner;

public class ProcessResourceDataTableUpdate {
    private static final String ALGO_KEY = "ProcessResourceDataTableUpdate";

    public static void updateResourceTableData(Long processHistoryId, List<MainDataUpateParam> upateParams, boolean sync) {
        if (CollectionUtils.isEmpty(upateParams)) {
            return;
        }
        ProcessCalcLogService.changeProcessManualUpdateStatus((Long)processHistoryId, (int)1);
        ProcessAutoUpdateRunner.autoUpdate(processHistoryId, upateParams, sync);
    }

    public static void updateReousrceDataTableData(DynamicObject resource, List<MainDataUpateParam> upateParams) {
        if (resource == null || upateParams == null || upateParams.isEmpty()) {
            return;
        }
        DynamicObject resourceObj = resource.getDynamicObject("resource_number");
        if (resourceObj == null) {
            return;
        }
        try (TXHandle tx = TX.requiresNew();){
            String resourceType = resource.getString("resource_type");
            if (!ResourceTypeEnum.DATETEMP.getValue().equals(resourceType)) {
                return;
            }
            long resourceId = resourceObj.getLong("id");
            Map<String, List<MainDataUpateParam>> mapParams = upateParams.stream().filter(item -> item.getResourceId() == resourceId).collect(Collectors.groupingBy(MainDataUpateParam::getDataTable));
            DynamicObject dateTemp = ProcessResourceDataTableUpdate.getDataTemp(resourceId);
            if (dateTemp == null) {
                return;
            }
            String tempclassify = dateTemp.getString("tempclassify");
            long tempConfId = dateTemp.getLong("tempconf");
            DynamicObject tempConf = BusinessDataServiceHelper.loadSingleFromCache((Object)tempConfId, (String)"phm_billtemp_set");
            DynamicObjectCollection fieldConf = tempConf.getDynamicObjectCollection("fieldentryentity");
            if (fieldConf == null || fieldConf.isEmpty()) {
                return;
            }
            try {
                Map<String, List<DynamicObject>> dataTableMap = fieldConf.stream().filter(item -> StringUtils.equals((CharSequence)DataTempDataSourceEnum.DATATABLE.getValue(), (CharSequence)item.getString("dataresource"))).collect(Collectors.groupingBy(item -> item.getDynamicObject("datatable").getString("number")));
                DynamicObject dataTempHistoryData = resource.getDynamicObject("resource_data");
                Object dataTempHistoryId = dataTempHistoryData == null ? null : dataTempHistoryData.get("id");
                DynamicObject dataTempHistory = ProcessResourceDataTableUpdate.getDataTempHistory(dataTempHistoryId, resource.getString("resource_datatype"));
                if (StringUtils.equals((CharSequence)tempclassify, (CharSequence)DataTempClassifyEnum.SINGLE.getValue()) || StringUtils.equals((CharSequence)tempclassify, (CharSequence)DataTempClassifyEnum.MULTI.getValue())) {
                    ProcessResourceDataTableUpdate.updateData(dateTemp, dataTempHistory, dataTableMap, mapParams);
                }
                ProcessResourceDataTableUpdate.updateSourceUpdate(resource);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private static void updateSourceUpdate(DynamicObject resource) {
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"phm_process_resources"), resource.get("id"));
        dynamicObject.set("resource_modifytime", (Object)new Date());
        SaveServiceHelper.update((DynamicObject)dynamicObject);
    }

    private static void updateData(DynamicObject dataTemp, DynamicObject dataTempHistory, Map<String, List<DynamicObject>> dataTableMap, Map<String, List<MainDataUpateParam>> mapParams) {
        if (dataTemp == null || dataTempHistory == null || dataTableMap == null || mapParams == null) {
            return;
        }
        int realRow = dataTemp.getInt("realrow");
        String spreadString = dataTempHistory.getString("spreadjson_tag");
        Map spreadObject = SpreadPraseUtil.getSpreadObject((String)spreadString);
        Map dataTableObject = SpreadPraseUtil.getSpreadDataTableObject((Map)spreadObject);
        for (Map.Entry<String, List<DynamicObject>> mapEntry : dataTableMap.entrySet()) {
            List<DynamicObject> columnConfs = mapEntry.getValue();
            String tableName = mapEntry.getKey();
            List<MainDataUpateParam> updateColumns = mapParams.get(tableName);
            ProcessResourceDataTableUpdate.updateSpreadByDataTable(tableName, realRow, dataTableObject, columnConfs, updateColumns);
        }
        String spreadJson = SerializationUtils.toJsonString((Object)spreadObject);
        spreadString = SpreadUtils.convertCompressJson((String)spreadJson);
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"phm_filldata_history"), dataTempHistory.get("id"));
        dynamicObject.set("spreadjson_tag", (Object)spreadString);
        SaveServiceHelper.update((DynamicObject)dynamicObject);
    }

    private static void updateSpreadByDataTable(String tableName, Integer realRow, Map<String, Object> dataTableObject, List<DynamicObject> columnConfs, List<MainDataUpateParam> updateColumns) {
        StringJoiner selectFieldJoiner = new StringJoiner(",");
        StringJoiner whereJoiner = new StringJoiner(" and ");
        Map<String, List<DynamicObject>> logicTypes = columnConfs.stream().collect(Collectors.groupingBy(item -> item.getString("fieldlogic")));
        List<DynamicObject> indexItems = logicTypes.get("1");
        List<DynamicObject> indexValues = logicTypes.get("2");
        indexValues = ProcessResourceDataTableUpdate.fielterIndexItems(indexValues, updateColumns);
        if (indexItems == null || indexItems.isEmpty() || indexValues == null || indexValues.isEmpty()) {
            return;
        }
        int startRow = realRow;
        for (DynamicObject indexItem : indexItems) {
            String fieldNumber = indexItem.getString("fieldnumber");
            int startrow = indexItem.getInt("startrow") - 1;
            if (startrow > startRow) {
                startRow = startrow;
            }
            whereJoiner.add(fieldNumber + " = ? ");
        }
        indexValues.forEach(item -> {
            String fieldNumber = item.getString("fieldnumber");
            selectFieldJoiner.add(fieldNumber);
        });
        String selectField = selectFieldJoiner.toString();
        String where = whereJoiner.toString();
        int cycle = 20;
        int num = 0;
        SqlBuilder unionSql = new SqlBuilder();
        if (dataTableObject == null) {
            return;
        }
        Iterator<Map.Entry<String, Object>> iterator = dataTableObject.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> row = iterator.next();
            int index = Integer.parseInt(row.getKey());
            if (index < startRow) continue;
            ++num;
            Map rowData = (Map)row.getValue();
            Object[] params = new Object[indexItems.size()];
            for (int j = 0; j < indexItems.size(); ++j) {
                DynamicObject field = indexItems.get(j);
                int col = field.getInt("cellcol");
                String fieldType = field.getString("fieldtype");
                Object cellValue = SpreadPraseUtil.getCellValue((Map)((Map)rowData.get(col + "")));
                params[j] = (cellValue = ProcessResourceDataTableUpdate.coverDataToFieldType(fieldType, cellValue)) == null ? "null" : cellValue;
            }
            SqlBuilder sql = new SqlBuilder();
            sql.append("select ", new Object[0]).append("'" + index + "',", new Object[0]).append(selectField, new Object[0]).append(" from ", new Object[0]).append(tableName, new Object[0]).append(" where ", new Object[0]).append(where, params);
            unionSql.appendSqlBuilder(sql);
            if (iterator.hasNext() && num < cycle) {
                unionSql.append(" union all ", new Object[0]);
            }
            if (num != cycle && iterator.hasNext()) continue;
            ProcessResourceDataTableUpdate.setSpreadValue(dataTableObject, unionSql, indexValues);
            num = 0;
            unionSql = new SqlBuilder();
        }
    }

    private static List<DynamicObject> fielterIndexItems(List<DynamicObject> indexItems, List<MainDataUpateParam> updateColumns) {
        return indexItems.stream().filter(x -> {
            if (updateColumns == null || updateColumns.isEmpty()) {
                return false;
            }
            String fieldName = x.getString("fieldnumber");
            for (MainDataUpateParam updateColumn : updateColumns) {
                String updateField = updateColumn.getField();
                if (!StringUtils.equals((CharSequence)fieldName, (CharSequence)updateField)) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
    }

    public static Object coverDataToFieldType(String fieldType, Object value) {
        if (value == null) {
            return null;
        }
        try {
            if (FieldType.BIGINT.getValue().equals(fieldType) || FieldType.DECIMAL.getValue().equals(fieldType)) {
                if (value instanceof BigDecimal) {
                    return value;
                }
                return new BigDecimal(String.valueOf(value));
            }
            if (FieldType.NVARCHAR.getValue().equals(fieldType)) {
                if (value instanceof String) {
                    return value;
                }
                return String.valueOf(value);
            }
            if (FieldType.DATETIME.getValue().equals(fieldType)) {
                if (value instanceof Data) {
                    return value;
                }
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private static void setSpreadValue(Map<String, Object> dataTableObject, SqlBuilder sql, List<DynamicObject> indexValues) {
        try (DataSet ds = DB.queryDataSet((String)ALGO_KEY, (DBRoute)CommonConsts.ROUTE_PHM, (SqlBuilder)sql);){
            while (ds.hasNext()) {
                Row row = ds.next();
                int columnSize = indexValues.size() + 1;
                String rowIndex = row.getString(0);
                Map dataRow = (Map)dataTableObject.get(rowIndex);
                if (dataRow == null) continue;
                for (int i = 1; i < columnSize; ++i) {
                    DynamicObject indexVal = indexValues.get(i - 1);
                    int colIndx = indexVal.getInt("cellcol");
                    Object columnValue = row.get(i);
                    Map cell = (Map)dataRow.computeIfAbsent(colIndx + "", x -> new HashMap(2));
                    cell.put("value", columnValue);
                }
            }
        }
    }

    private static DynamicObject getDataTempHistory(Object pk, String enetityName) {
        StringJoiner selectField = new StringJoiner(",");
        selectField.add("id").add("spreadjson_tag");
        QFilter filter = new QFilter("id", "=", pk);
        return QueryServiceHelper.queryOne((String)enetityName, (String)selectField.toString(), (QFilter[])new QFilter[]{filter});
    }

    private static DynamicObject getDataTemp(Object pk) {
        StringJoiner selectField = new StringJoiner(",");
        selectField.add("tempclassify").add("tempconf").add("realrow").add("realcol");
        QFilter filter = new QFilter("id", "=", pk);
        return QueryServiceHelper.queryOne((String)"phm_billtemp", (String)selectField.toString(), (QFilter[])new QFilter[]{filter});
    }

    public static void updateProcessDiff(List<MainDataUpateParam> upateParams) {
        if (upateParams == null || upateParams.isEmpty()) {
            return;
        }
        List list = upateParams.stream().map(MainDataUpateParam::getId).collect(Collectors.toList());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("UPDATE t_phm_process_updatediff  SET flatest = ? , fmodifydate = ? where ", new Object[]{"1", new Date()});
        sqlBuilder.appendIn(" fid", list);
        DB.execute((DBRoute)CommonConsts.ROUTE_PHM, (SqlBuilder)sqlBuilder);
    }
}

