/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.service.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.mmc.phm.common.consts.CommonConsts;
import kd.mmc.phm.common.enums.DealTypeEnum;
import kd.mmc.phm.common.enums.ProcessErrorTypeEnum;
import kd.mmc.phm.common.errorcode.PHMErrorCode;
import kd.mmc.phm.common.serviece.workbench.ProcessCalcLogService;
import kd.mmc.phm.mservice.factory.ResourceAutoUpdateServiceFactory;
import kd.mmc.phm.mservice.framework.mq.MQServiceHelper;
import kd.mmc.phm.mservice.framework.mq.event.ProcessAutoUpdateEvent;
import kd.mmc.phm.mservice.model.process.ProcessEventNode;
import kd.mmc.phm.mservice.service.ConsumerService;
import kd.mmc.phm.mservice.service.ResourceAutoUpdateService;

public class ProcessAutoUpdateServiceImpl
implements ConsumerService {
    private static final Log log = LogFactory.getLog(ProcessAutoUpdateServiceImpl.class);
    private static final long RESOURCE_TIMEOUT = 300000L;
    private static final String PREFIX = "mmc/phm/autoUpdateService/";
    private static final ExecutorService executorService = ThreadPools.newCachedExecutorService((String)"PHM_PROCESS_AUTOUPDATE_EXECUTEOR", (int)5, (int)32);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Object body) {
        DynamicObject[] resourceDataArray;
        long entryId;
        ProcessEventNode currentNode;
        ProcessAutoUpdateEvent processAutoUpdateEvent;
        block15: {
            processAutoUpdateEvent = (ProcessAutoUpdateEvent)body;
            currentNode = processAutoUpdateEvent.getCurrentNode();
            entryId = currentNode.getEntryId();
            log.info("\u5f00\u59cb\u81ea\u52a8\u66f4\u65b0\u8282\u70b9[{}], \u4e0a\u8282\u70b9\u96c6\u5408{}", (Object)currentNode, processAutoUpdateEvent.getPreviousNodes());
            String selectFields = "id,resource_type, resource_number, resource_datatype, resource_data, resource_role, resource_processhistory, resource_modifytime, resource_dealtype";
            resourceDataArray = BusinessDataServiceHelper.load((String)"phm_process_resources", (String)selectFields, (QFilter[])new QFilter("entry_node", "=", (Object)entryId).toArray());
            int length = resourceDataArray.length;
            if (length != 0) break block15;
            log.info("\u81ea\u52a8\u66f4\u65b0\u8282\u70b9[{}]\u6210\u529f, \u8d44\u6e90\u4e3a\u7a7a", (Object)currentNode);
            MQServiceHelper.publishControlEvent(processAutoUpdateEvent);
            String updateSql = "UPDATE T_PHM_PROCESS_NODE SET FSTATUS = ? WHERE FENTRYID = ?";
            DB.update((DBRoute)CommonConsts.ROUTE_PHM, (String)updateSql, (Object[])new Object[]{currentNode.getStatus(), entryId});
            return;
        }
        try {
            RequestContext rc = RequestContext.get();
            Map<String, List<DynamicObject>> dealTypeGroup = Arrays.stream(resourceDataArray).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getString("resource_dealtype")));
            ArrayList<CompletionStage> completableFutureList = new ArrayList<CompletionStage>();
            List<DynamicObject> autoResources = dealTypeGroup.get(DealTypeEnum.AUTO.getName());
            if (!CollectionUtils.isEmpty(autoResources)) {
                for (DynamicObject autoResource : autoResources) {
                    completableFutureList.add(CompletableFuture.runAsync(() -> this.autoUpdateResourceData(autoResource, processAutoUpdateEvent, rc), executorService));
                }
            }
            CompletableFuture<Integer> autoCompletableFuture = completableFutureList.isEmpty() ? CompletableFuture.completedFuture(1) : CompletableFuture.allOf(completableFutureList.toArray(new CompletableFuture[0]));
            List<DynamicObject> manualResources = dealTypeGroup.get(DealTypeEnum.MANUAL.getName());
            if (!CollectionUtils.isEmpty(manualResources)) {
                for (DynamicObject manualResource : manualResources) {
                    completableFutureList.add(autoCompletableFuture.thenRunAsync(() -> this.autoUpdateResourceData(manualResource, processAutoUpdateEvent, rc), executorService));
                }
            }
            CompletableFuture<Integer> manualCompletableFuture = completableFutureList.isEmpty() ? CompletableFuture.completedFuture(1) : CompletableFuture.allOf(completableFutureList.toArray(new CompletableFuture[0]));
            List<DynamicObject> waitResources = dealTypeGroup.get(DealTypeEnum.WAIT.getName());
            if (!CollectionUtils.isEmpty(waitResources)) {
                for (DynamicObject waitResource : waitResources) {
                    completableFutureList.add(manualCompletableFuture.thenRunAsync(() -> this.autoUpdateResourceData(waitResource, processAutoUpdateEvent, rc), executorService));
                }
            }
            CompletableFuture<Integer> cycleCompletableFuture = completableFutureList.isEmpty() ? CompletableFuture.completedFuture(1) : CompletableFuture.allOf(completableFutureList.toArray(new CompletableFuture[0]));
            List<DynamicObject> cycleResources = dealTypeGroup.get(DealTypeEnum.CYCLE.getName());
            if (!CollectionUtils.isEmpty(cycleResources)) {
                for (DynamicObject cycleResource : cycleResources) {
                    completableFutureList.add(cycleCompletableFuture.thenRunAsync(() -> this.autoUpdateResourceData(cycleResource, processAutoUpdateEvent, rc), executorService));
                }
            }
            CompletableFuture<Void> completableFuture = CompletableFuture.allOf(completableFutureList.toArray(new CompletableFuture[0]));
            try {
                completableFuture.get(30L, TimeUnit.MINUTES);
                log.info("\u81ea\u52a8\u66f4\u65b0\u8282\u70b9[{}]\u6210\u529f", (Object)currentNode);
            }
            catch (ExecutionException exception) {
                String exceptionMsg;
                processAutoUpdateEvent.setFail(true);
                Throwable cause = exception.getCause();
                String string = exceptionMsg = cause == null ? exception.getMessage() : cause.getMessage();
                if (StringUtils.isBlank((CharSequence)exceptionMsg)) {
                    exceptionMsg = ResManager.loadKDString((String)"\u7a0b\u5e8f\u51fa\u73b0\u5f02\u5e38, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"ProcessAutoUpdateServiceImpl_0", (String)"mmc-phm-mservice", (Object[])new Object[0]);
                }
                processAutoUpdateEvent.setExceptionMessage(exceptionMsg);
            }
            catch (InterruptedException | TimeoutException exception) {
                processAutoUpdateEvent.setFail(true);
                processAutoUpdateEvent.setExceptionMessage(String.format(ResManager.loadKDString((String)"\u8282\u70b9[%s]\u66f4\u65b0\u5931\u8d25: \u5e76\u884c\u8ba1\u7b97\u8d85\u65f6", (String)"ProcessAutoUpdateServiceImpl_1", (String)"mmc-phm-mservice", (Object[])new Object[0]), currentNode.getName()));
            }
        }
        catch (Throwable throwable) {
            MQServiceHelper.publishControlEvent(processAutoUpdateEvent);
            String updateSql = "UPDATE T_PHM_PROCESS_NODE SET FSTATUS = ? WHERE FENTRYID = ?";
            DB.update((DBRoute)CommonConsts.ROUTE_PHM, (String)updateSql, (Object[])new Object[]{currentNode.getStatus(), entryId});
            throw throwable;
        }
        MQServiceHelper.publishControlEvent(processAutoUpdateEvent);
        String updateSql = "UPDATE T_PHM_PROCESS_NODE SET FSTATUS = ? WHERE FENTRYID = ?";
        DB.update((DBRoute)CommonConsts.ROUTE_PHM, (String)updateSql, (Object[])new Object[]{currentNode.getStatus(), entryId});
    }

    private void autoUpdateResourceData(DynamicObject resourceData, ProcessAutoUpdateEvent processAutoUpdateEvent, RequestContext rc) {
        RequestContext.copyAndSet((RequestContext)rc);
        ProcessEventNode currentNode = processAutoUpdateEvent.getCurrentNode();
        DynamicObject resource = resourceData.getDynamicObject("resource_number");
        DynamicObject resourceHistory = resourceData.getDynamicObject("resource_data");
        DynamicObject role = resourceData.getDynamicObject("resource_role");
        String resourceNumber = resource == null ? "" : resource.getString("number");
        String resourceName = resource == null ? "" : resource.getString("name");
        String resourceRunVersion = resourceHistory == null ? "" : resourceHistory.getString("number");
        String roleName = role == null ? "" : role.getString("name");
        DLock lock = DLock.create((String)(PREFIX + resourceData.getPkValue()));
        if (!lock.tryLock(300000L)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8282\u70b9[%s]\u66f4\u65b0\u8d44\u6e90[%s]\u5931\u8d25: \u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u8d85\u65f6", (String)"ProcessAutoUpdateServiceImpl_2", (String)"mmc-phm-mservice", (Object[])new Object[0]), currentNode.getName(), resourceRunVersion));
        }
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                String resourceType = resourceData.getString("resource_type");
                this.clearErrorLog(processAutoUpdateEvent, resourceData);
                ResourceAutoUpdateService resourceAutoUpdateService = ResourceAutoUpdateServiceFactory.get(resourceType);
                resourceAutoUpdateService.execute(processAutoUpdateEvent, resourceData);
                resourceData.set("resource_modifytime", (Object)new Date());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{resourceData});
                log.info("\u81ea\u52a8\u66f4\u65b0\u8282\u70b9\u8d44\u6e90[{}]\u6210\u529f, \u66f4\u65b0\u8d44\u6e90\u7f16\u7801[{}], \u66f4\u65b0\u8d44\u6e90\u7248\u672c\u53f7[{}]", new Object[]{currentNode, resourceNumber, resourceRunVersion});
            }
            catch (Exception exception) {
                txHandle.markRollback();
                throw exception;
            }
        }
        catch (Exception exception) {
            try {
                this.insertErrorLog(processAutoUpdateEvent, resourceData, exception);
            }
            catch (Exception logException) {
                exception = logException;
            }
            String exceptionMsg = String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25, \u8282\u70b9[%s]\u66f4\u65b0\u8d44\u6e90[%s]\u5931\u8d25, \u8d44\u6e90\u7f16\u7801[%s], \u8d44\u6e90\u540d\u79f0[%s], \u5904\u7406\u89d2\u8272[%s]", (String)"ProcessAutoUpdateServiceImpl_3", (String)"mmc-phm-mservice", (Object[])new Object[0]), currentNode.getName(), resourceRunVersion, resourceNumber, resourceName, roleName);
            throw new KDBizException((Throwable)exception, PHMErrorCode.bizException, new Object[]{exceptionMsg});
        }
        finally {
            lock.unlock();
        }
    }

    private void clearErrorLog(ProcessAutoUpdateEvent processCloseEvent, DynamicObject resourceData) {
        DynamicObject processHistory = resourceData.getDynamicObject("resource_processhistory");
        Long historyId = processHistory == null ? null : Long.valueOf(processHistory.getLong("id"));
        Long nodeId = processCloseEvent.getCurrentNode().getEntryId();
        Long nodeResourceId = resourceData.getLong("id");
        DynamicObject resource = resourceData.getDynamicObject("resource_number");
        Long resourceId = resource == null ? null : Long.valueOf(resource.getLong("id"));
        DynamicObject role = resourceData.getDynamicObject("resource_role");
        Long roleId = role == null ? null : Long.valueOf(role.getLong("id"));
        ProcessCalcLogService.clearErrorLog((String)ProcessErrorTypeEnum.AUTO_UPDATE_ERR.getValue(), (Long)historyId, (Long)nodeId, (Long)nodeResourceId, (Long)resourceId, (Long)roleId);
    }

    private void insertErrorLog(ProcessAutoUpdateEvent processCloseEvent, DynamicObject resourceData, Exception exception) {
        if (resourceData == null) {
            return;
        }
        DynamicObject processHistory = resourceData.getDynamicObject("resource_processhistory");
        Long historyId = processHistory == null ? null : Long.valueOf(processHistory.getLong("id"));
        Long nodeEntryId = processCloseEvent.getCurrentNode().getEntryId();
        String startnodeId = processCloseEvent.getCurrentNode().getId();
        String nodeName = processCloseEvent.getCurrentNode().getName();
        Set<String> tailNodeIds = processCloseEvent.getTailNodeIds();
        String endNodeIds = SerializationUtils.toJsonString(tailNodeIds);
        DynamicObject resourceHistory = resourceData.getDynamicObject("resource_data");
        String reoureceVersionNumber = resourceHistory == null ? null : resourceHistory.getString("number");
        Long nodeResourceId = resourceData.getLong("id");
        DynamicObject resource = resourceData.getDynamicObject("resource_number");
        Long resourceId = resource == null ? null : Long.valueOf(resource.getLong("id"));
        String resourceNumber = resource == null ? "" : resource.getString("number");
        String resourceName = resource == null ? "" : resource.getString("name");
        DynamicObject role = resourceData.getDynamicObject("resource_role");
        Long roleId = role == null ? null : Long.valueOf(role.getLong("id"));
        String roleName = role == null ? null : role.getString("name");
        String resourceType = resourceData.getString("resource_type");
        List roleIds = null;
        roleIds = roleId != null && roleId != 0L ? Lists.newArrayList((Object[])new Long[]{roleId}) : ProcessCalcLogService.getProcessResourceRoleIds((Long)nodeEntryId, (String)resourceType, (Long)resourceId);
        ProcessCalcLogService service = new ProcessCalcLogService();
        String errorMsgDetail = ProcessCalcLogService.getExceptionMsg((Exception)exception);
        RequestContext requestContext = RequestContext.get();
        String userName = requestContext == null ? null : requestContext.getUserName();
        Long userId = requestContext == null ? null : Long.valueOf(requestContext.getUserId());
        service.createErrorLog(ProcessErrorTypeEnum.AUTO_UPDATE_ERR, DealTypeEnum.AUTO, historyId, nodeEntryId, nodeName, nodeResourceId, resourceType, resourceId, resourceName, reoureceVersionNumber, resourceNumber, roleIds, roleName, userId, userName, processCloseEvent.getEventId(), errorMsgDetail, endNodeIds, startnodeId);
        service.clearCurrentErrorLog();
        service.insertErrorLog();
    }
}

