/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.utils;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.StringUtils;

public class Utils {
    private static String ipAddress;

    public static String getIP() {
        if (!StringUtils.isEmpty((String)ipAddress)) {
            return ipAddress;
        }
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (netInterface.isLoopback() || netInterface.isVirtual() || !netInterface.isUp()) continue;
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    ip = addresses.nextElement();
                    if (!(ip instanceof Inet4Address)) continue;
                    ipAddress = NetAddressUtils.getLocalIpAddress();
                }
            }
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"IP\u5730\u5740\u83b7\u53d6\u5931\u8d25\uff1a%s", (String)"Utils_0", (String)"mmc-phm-mservice", (Object[])new Object[0])), new Object[]{e});
        }
        return ipAddress;
    }

    public static String formatListContent(List<?> list) {
        if (list == null || list.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            Object next = list.get(i);
            sb.append(", ");
            sb.append(next);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(Object data) {
        if (data == null) {
            return "";
        }
        if (data instanceof String) {
            return (String)data;
        }
        if (data instanceof Number) {
            return data.toString();
        }
        if (data instanceof Date) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            return format.format((Date)data);
        }
        throw new KDBizException(new ErrorCode("UNKNOWN_DATA_TYPE", String.format("No data resolver for %s(%s)", data, data.getClass().getName())), new Object[0]);
    }
}

