/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.basedata;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;

public class MilepostEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String BEGINTIME = "begintime";
    private static final String ENDTIME = "endtime";
    private static final String ENTRYENTITY = "entryentity";
    private static final String BASELENTH = "baselenth";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEntityBaselenth();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit supfield = (BasedataEdit)this.getView().getControl("project");
        supfield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private void setEntityBaselenth() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        if (entryEntity != null && entryEntity.size() > 0) {
            for (DynamicObject dynamicObject : entryEntity) {
                int seq = dynamicObject.getInt("seq") - 1;
                this.setBaselenthValue(seq, null, "");
            }
        }
    }

    private void setBaselenthValue(int row, Object oldValue, String name) {
        Object beginTime = this.getEntityValue(row, BEGINTIME);
        Object endTime = this.getEntityValue(row, ENDTIME);
        if (beginTime != null && endTime != null) {
            long begin_time = ((Date)beginTime).getTime();
            long end_time = ((Date)endTime).getTime();
            long last_time = end_time - begin_time;
            if (last_time > 0L) {
                BigDecimal day = BigDecimal.valueOf(last_time).divide(BigDecimal.valueOf(3600000L), 4, RoundingMode.CEILING).divide(BigDecimal.valueOf(24L), 3, RoundingMode.DOWN);
                this.getModel().setValue(BASELENTH, (Object)day, row);
            } else if (!name.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\u5e94\u5927\u4e8e\u5f00\u59cb\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"MilepostEdit_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                this.getModel().beginInit();
                this.getModel().setValue(name, oldValue, row);
                this.getView().updateView(name, row);
                this.getModel().endInit();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        if (BEGINTIME.equals(name) || ENDTIME.equals(name)) {
            Object begintimes = this.getModel().getValue("begintimes");
            Object endtimes = this.getModel().getValue("endtimes");
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows == null || selectRows.length == 0) {
                return;
            }
            if (newValue != null) {
                if (begintimes == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9879\u76ee\u5468\u671f\u3002", (String)"MilepostEdit_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue(name, null, selectRows[0]);
                    return;
                }
                this.isContainTime(begintimes, endtimes, newValue, name, selectRows[0], oldValue);
                this.isOverlapTime(selectRows[0], name, oldValue, newValue);
                this.setBaselenthValue(selectRows[0], oldValue, name);
            }
        }
    }

    private void isOverlapTime(int row, String name, Object oldValue, Object newValue) {
        long time = ((Date)newValue).getTime();
        if (BEGINTIME.equals(name)) {
            long emdtime_pre;
            Object endTimePre;
            DynamicObject preEntryRowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, row - 1);
            if (preEntryRowEntity != null && (endTimePre = preEntryRowEntity.get(ENDTIME)) != null && (emdtime_pre = ((Date)endTimePre).getTime()) > time) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u7684\u5f00\u59cb\u65f6\u95f4\u8ddf\u4e0a\u4e00\u884c\u7684\u7ed3\u675f\u65f6\u95f4\u5b58\u5728\u91cd\u53e0\u3002", (String)"MilepostEdit_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                this.getModel().beginInit();
                this.getModel().setValue(BEGINTIME, oldValue, row);
                this.getView().updateView(BEGINTIME, row);
                this.getModel().endInit();
            }
        } else {
            DynamicObject nextEntryRowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, row + 1);
            if (nextEntryRowEntity != null) {
                Object beginTimeNext = nextEntryRowEntity.get(BEGINTIME);
                if (beginTimeNext != null) {
                    long begintime_next = ((Date)beginTimeNext).getTime();
                    if (time > begintime_next) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u7684\u7ed3\u675f\u65f6\u95f4\u8ddf\u4e0b\u4e00\u884c\u7684\u5f00\u59cb\u65f6\u95f4\u5b58\u5728\u91cd\u53e0\u3002", (String)"MilepostEdit_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                        this.getModel().beginInit();
                        this.getModel().setValue(ENDTIME, oldValue, row);
                        this.getView().updateView(ENDTIME, row);
                        this.getModel().endInit();
                    }
                } else {
                    this.getModel().beginInit();
                    this.getModel().setValue(BEGINTIME, newValue, row + 1);
                    this.getView().updateView(BEGINTIME, row + 1);
                    this.getModel().endInit();
                }
            }
        }
    }

    private void isContainTime(Object begintimes, Object endtimes, Object newValue, String name, int selectRow, Object oldValue) {
        if (!((Date)begintimes).before((Date)newValue) && !((Date)begintimes).equals((Date)newValue) || !((Date)endtimes).after((Date)newValue) && !((Date)endtimes).equals((Date)newValue)) {
            this.getModel().setValue(name, oldValue, selectRow);
            String tip = "";
            tip = BEGINTIME.equals(name) ? ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5728\u9879\u76ee\u5468\u671f\u8303\u56f4\u5185\u3002", (String)"MilepostEdit_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5728\u9879\u76ee\u5468\u671f\u8303\u56f4\u5185\u3002", (String)"MilepostEdit_5", (String)"mmc-phm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tip);
        }
    }

    private Object getEntityValue(int selectRow, String field) {
        Object value = this.getModel().getValue(field, selectRow);
        return value;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        DynamicObject entryRowEntity;
        Object endtime_pre;
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        RowDataEntity rowDataEntity = rowDataEntities[0];
        int rowIndex = rowDataEntity.getRowIndex();
        if (rowIndex != 0 && (endtime_pre = (entryRowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, rowIndex - 1)).get(ENDTIME)) != null) {
            this.getModel().setValue(BEGINTIME, endtime_pre, rowIndex);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        Object createorg;
        Control control = (Control)e.getSource();
        String key = control.getKey();
        if ("project".equals(key) && (createorg = this.getModel().getValue("createorg")) != null) {
            Object orgid = ((DynamicObject)createorg).get("id");
            QFilter qfilter = new QFilter("createorg", "=", orgid);
            ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
            listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
        }
    }
}

