/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.basedata;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class RoleDistributeUser
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String USER = "user";
    private static final String USERENTRY = "entryentity";
    private static final String ORGINFOS = "orginfos";
    private static final String ID = "id";
    private static final String SEQ = "seq";
    private static final String TOOLBAR = "toolbarap";
    private static final String BTNOK = "btnok";
    private static final String ROLEID = "roleid";
    private static final String PHM_ROLE_USER = "phm_role_user";
    private static final String DISORG = "disorg";
    private static final String[] FIELDS = new String[]{"seq", "user", "orginfos"};

    public void registerListener(EventObject e) {
        BasedataEdit userEdit = (BasedataEdit)this.getView().getControl(USER);
        userEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Toolbar bar1 = (Toolbar)this.getView().getControl(TOOLBAR);
        bar1.addItemClickListener((ItemClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.showOrgInfos();
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "btnok": {
                this.clickBtnOK();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        ChangeData cd = e.getChangeSet()[0];
        switch (name) {
            case "user": {
                this.userChange(cd);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String key;
        Control con = (Control)arg0.getSource();
        switch (key = con.getKey()) {
            case "user": {
                this.addUserFilter(arg0);
            }
        }
    }

    private void clickBtnOK() {
        try {
            ArrayList<DynamicObject> addList = new ArrayList<DynamicObject>(8);
            Object disOrg = this.getView().getFormShowParameter().getCustomParam(DISORG);
            Object roleId = this.getView().getFormShowParameter().getCustomParam(ROLEID);
            QFilter[] qfilters = new QFilter[]{new QFilter(ROLEID, "=", roleId), new QFilter(DISORG, "=", disOrg)};
            DynamicObjectCollection entryCol = this.getModel().getEntryEntity(USERENTRY);
            ORM orm = ORM.create();
            for (DynamicObject entry : entryCol) {
                DynamicObject user = entry.getDynamicObject(USER);
                DynamicObject roleUser = orm.newDynamicObject(PHM_ROLE_USER);
                roleUser.set(USER, (Object)user);
                roleUser.set(ROLEID, roleId);
                roleUser.set(DISORG, disOrg);
                addList.add(roleUser);
            }
            DeleteServiceHelper.delete((String)PHM_ROLE_USER, (QFilter[])qfilters);
            SaveServiceHelper.save((DynamicObject[])addList.toArray(new DynamicObject[0]));
        }
        catch (Exception e) {
            throw new KDBizException(new ErrorCode("role_dis_exc", ResManager.loadKDString((String)"\u5206\u914d\u7528\u6237\u53d1\u751f\u9519\u8bef", (String)"RoleDistributeUser_0", (String)"mmc-phm-formplugin", (Object[])new Object[0])), new Object[]{e});
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"RoleDistributeUser_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
    }

    private void addUserFilter(BeforeF7SelectEvent arg0) {
        Object currentOrgId = this.getView().getFormShowParameter().getCustomParam(DISORG);
        ArrayList<Long> orgIds = new ArrayList<Long>(8);
        orgIds.add(Long.valueOf(currentOrgId.toString()));
        List allOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)1L, orgIds, (boolean)true);
        QFilter qfilter = new QFilter("entryentity.dpt", "in", (Object)allOrgIds);
        QFilter qfilter1 = new QFilter(ID, "not in", this.getSelectedUserIds());
        ListShowParameter listShowParameter = (ListShowParameter)arg0.getFormShowParameter();
        listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
        listShowParameter.getListFilterParameter().getQFilters().add(qfilter1);
        listShowParameter.getCustomParams().put("initRootOrgId", currentOrgId);
    }

    private void userChange(ChangeData cd) {
        Object newValue = cd.getNewValue();
        int rowIndx = cd.getRowIndex();
        String orgInfos = "";
        if (newValue != null) {
            DynamicObject user = (DynamicObject)newValue;
            ArrayList<Long> userIds = new ArrayList<Long>(1);
            userIds.add(user.getLong(ID));
            Map<Long, String> orgInfosMap = this.getAllOrgByUser(userIds);
            orgInfos = orgInfosMap.get(user.getLong(ID));
        }
        this.getModel().setValue(ORGINFOS, (Object)orgInfos, rowIndx);
    }

    private List<Long> getSelectedUserIds() {
        ArrayList<Long> selectedUserIds = new ArrayList<Long>(8);
        DynamicObjectCollection entryCol = this.getModel().getEntryEntity(USERENTRY);
        for (DynamicObject entry : entryCol) {
            DynamicObject user = entry.getDynamicObject(USER);
            if (user == null) continue;
            selectedUserIds.add(user.getLong(ID));
        }
        return selectedUserIds;
    }

    private void showOrgInfos() {
        Object currentOrgId = this.getView().getFormShowParameter().getCustomParam(DISORG);
        Object roleId = this.getView().getFormShowParameter().getCustomParam(ROLEID);
        QFilter[] qfilters = new QFilter[]{new QFilter(DISORG, "=", currentOrgId), new QFilter(ROLEID, "=", roleId)};
        DynamicObjectCollection entryCol = QueryServiceHelper.query((String)PHM_ROLE_USER, (String)"id,user", (QFilter[])qfilters);
        ArrayList<Long> userIds = new ArrayList<Long>(8);
        for (DynamicObject entry : entryCol) {
            long userId = entry.getLong(USER);
            userIds.add(userId);
        }
        Map<Long, String> orgInfosMap = this.getAllOrgByUser(userIds);
        TableValueSetter ts = new TableValueSetter(FIELDS);
        for (int i = 0; i < entryCol.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryCol.get(i);
            long userId = entry.getLong(USER);
            String orgInfos = orgInfosMap.get(userId);
            ts.addRow(new Object[]{i + 1, userId, orgInfos});
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow(USERENTRY, ts);
        model.endInit();
    }

    private Map<Long, String> getAllOrgByUser(List<Long> userIds) {
        long id;
        HashMap<Long, String> orgInfosMap = new HashMap<Long, String>(8);
        HashMap<Long, ArrayList<Long>> userDptMap = new HashMap<Long, ArrayList<Long>>(8);
        HashSet<Long> dptSet = new HashSet<Long>(8);
        HashMap<Long, String> dptNameMap = new HashMap<Long, String>(8);
        try (DataSet userDataSet = QueryServiceHelper.queryDataSet((String)this.getPluginName(), (String)"bos_user", (String)"id,entryentity.dpt,entryentity.orgstructure", (QFilter[])new QFilter[]{new QFilter(ID, "in", userIds)}, null);){
            for (Row row : userDataSet) {
                id = row.getLong(ID);
                long dptId = row.getLong("entryentity.orgstructure");
                ArrayList<Long> dptIds = (ArrayList<Long>)userDptMap.get(id);
                if (dptIds == null) {
                    dptIds = new ArrayList<Long>(8);
                }
                dptIds.add(dptId);
                userDptMap.put(id, dptIds);
                dptSet.add(dptId);
            }
        }
        var7_7 = null;
        try (DataSet dptDataSet = QueryServiceHelper.queryDataSet((String)this.getPluginName(), (String)"bos_adminorg_structure", (String)"id,fullname", (QFilter[])new QFilter[]{new QFilter(ID, "in", dptSet)}, null);){
            for (Row row : dptDataSet) {
                id = row.getLong(ID);
                String name = row.getString("fullname") + ";";
                dptNameMap.put(id, name);
            }
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        for (Map.Entry entry : userDptMap.entrySet()) {
            long userId = (Long)entry.getKey();
            StringBuilder dptNames = new StringBuilder();
            List dptIds = (List)entry.getValue();
            Iterator iterator = dptIds.iterator();
            while (iterator.hasNext()) {
                long dptId = (Long)iterator.next();
                dptNames.append((String)dptNameMap.get(dptId));
            }
            orgInfosMap.put(userId, dptNames.toString());
        }
        return orgInfosMap;
    }
}

