/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.basedata;

import java.util.ArrayList;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class RoleEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String ID = "id";
    private static final String RESOURCES = "resources";
    private static final String RESENTRY = "entryentity2";

    public void initialize() {
        this.initUserTypeEdit();
        this.addListener();
    }

    private void addListener() {
        BasedataEdit resourceEdit = (BasedataEdit)this.getView().getControl(RESOURCES);
        resourceEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String key;
        Control con = (Control)arg0.getSource();
        switch (key = con.getKey()) {
            case "resources": {
                this.addResourcesFilter(arg0);
            }
        }
    }

    private void initUserTypeEdit() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{enableFilter};
        DynamicObjectCollection typeList = QueryServiceHelper.query((String)"bos_usertype", (String)"id,name", (QFilter[])filters, (String)"ispreset desc,number");
        if (typeList == null || typeList.isEmpty()) {
            return;
        }
        ComboEdit userTypeField = (ComboEdit)this.getControl("usertype");
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(typeList.size());
        for (DynamicObject obj : typeList) {
            ComboItem comboItem = new ComboItem();
            comboItem.setId(obj.getString(ID));
            comboItem.setValue(obj.getString(ID));
            comboItem.setCaption(new LocaleString(obj.getString("name")));
            propertyItems.add(comboItem);
        }
        userTypeField.setComboItems(propertyItems);
    }

    private void addResourcesFilter(BeforeF7SelectEvent arg0) {
        QFilter qfilter = new QFilter(ID, "not in", this.getSelectedResourceIds());
        ListShowParameter listShowParameter = (ListShowParameter)arg0.getFormShowParameter();
        listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
    }

    private List<Long> getSelectedResourceIds() {
        ArrayList<Long> slelectedResourceIds = new ArrayList<Long>(8);
        DynamicObjectCollection entryCol = this.getModel().getEntryEntity(RESENTRY);
        for (DynamicObject entry : entryCol) {
            DynamicObject res = entry.getDynamicObject(RESOURCES);
            if (res == null) continue;
            slelectedResourceIds.add(res.getLong(ID));
        }
        return slelectedResourceIds;
    }
}

