/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.basemanager;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.mmc.phm.common.util.FormOpener;

public class DataMapEditPlugin
extends AbstractFormPlugin
implements AfterF7SelectListener,
CellClickListener {
    private static final String FIELD_META = "meta";
    private static final String FIELD_DESTFIELD = "destfield";
    private static final String FIELD_DESTFIELDDESCRIPTION = "destfielddesc";
    private static final String FIELD_DESTFIELDNAME = "destfieldname";
    private static final String FIELD_ISPK = "ispk";
    private static final String FIELD_DESTPKFIELD = "destpkfield";
    private static final String FIELD_SRC_TABLE = "src_table";
    private static final String FIELD_SRC_FIELD = "src_field";
    private static final String FIELD_SRCFIELD = "srcfield";
    private static final String FIELD_SRC_FIELDDESCRIPTION = "src_fielddesc";
    private static final String FIELD_SRCFIELDNAME = "srcfieldname";
    private static final String FIELD_KEY_SRCTABLE = "key_srctable";
    private static final String FIELD_KEY_SRCTABLEFIELD = "key_srctablefield";
    private static final String FIELD_SRCTABLE = "srctable";
    private static final String FIELD_RULE_CONDITIONFIELD = "rule_conditionfield";
    private static final String PROP_METAID = "metaid";
    private static final String PROP_ID = "id";
    private static final String PORP_NUMBER = "number";
    private static final String PROP_TABLES = "tables";
    private static final String PROP_NAME = "name";
    private static final String ENTRY_FIELDLINK = "fieldlink";
    private static final String ENTRY_ENTRYENTITY = "entryentity";
    private static final String ENTRY_ENTRYENTITY2 = "entryentity2";
    private static final String ROW = "$row";
    private static final String TYPE = "$type";
    private DynamicObject metaObj = null;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit meta = (BasedataEdit)this.getView().getControl(FIELD_META);
        meta.addAfterF7SelectListener((AfterF7SelectListener)this);
        EntryGrid mappingEntries = (EntryGrid)this.getView().getControl(ENTRY_ENTRYENTITY);
        mappingEntries.addCellClickListener((CellClickListener)this);
        EntryGrid ruleEntries = (EntryGrid)this.getView().getControl(ENTRY_ENTRYENTITY2);
        ruleEntries.addCellClickListener((CellClickListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (operateKey.equalsIgnoreCase("unsubmit")) {
            this.putTableInfo();
            this.fieldLinkInit();
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        String fieldKey = cellClickEvent.getFieldKey();
        String id = this.getPageCache().get(PROP_METAID);
        if (StringUtils.isEmpty((CharSequence)id)) {
            return;
        }
        if (fieldKey.equals(FIELD_KEY_SRCTABLEFIELD)) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTRY_ENTRYENTITY, cellClickEvent.getRow());
            String table = rowEntity.getString(FIELD_KEY_SRCTABLE);
            if (table == null || table.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u8868!", (String)"DataMapEditPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put(PROP_ID, id);
            param.put("table", table);
            param.put("tabletype", 1);
            param.put(TYPE, fieldKey);
            param.put(ROW, cellClickEvent.getRow());
            FormOpener.showForm((AbstractFormPlugin)this, (String)"phm_meta_properties", (String)ResManager.loadKDString((String)"\u9009\u62e9\u5b57\u6bb5", (String)"DataMapEditPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]), param, (String)"get_field");
        } else if (fieldKey.equals(FIELD_RULE_CONDITIONFIELD)) {
            if (this.getModel().getValue("dtgetrule").equals("1")) {
                return;
            }
            String table = (String)this.getModel().getValue("rule_srctable", cellClickEvent.getRow());
            if (StringUtils.isEmpty((CharSequence)table)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u8868\uff01", (String)"DataMapEditPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put(PROP_ID, id);
            param.put("table", table);
            param.put("tabletype", 1);
            param.put(TYPE, fieldKey);
            param.put(ROW, cellClickEvent.getRow());
            FormOpener.showForm((AbstractFormPlugin)this, (String)"phm_meta_properties", (String)ResManager.loadKDString((String)"\u9009\u62e9\u5b57\u6bb5", (String)"DataMapEditPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]), param, (String)"get_allfields");
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        String action = evt.getActionId();
        Map map = (Map)returnData;
        Object rowIndex = map.get(ROW);
        if (rowIndex == null) {
            return;
        }
        if (action.equals("get_field")) {
            int index = Integer.parseInt(rowIndex.toString());
            DynamicObject row = this.getModel().getEntryRowEntity(ENTRY_ENTRYENTITY, index);
            String type = map.get(TYPE).toString();
            String number = map.get(PORP_NUMBER).toString();
            row.set(type, (Object)number);
            this.getView().updateView(ENTRY_ENTRYENTITY);
        } else if (action.equals("get_allfields")) {
            int index = Integer.parseInt(rowIndex.toString());
            DynamicObject row = this.getModel().getEntryRowEntity(ENTRY_ENTRYENTITY2, index);
            String type = map.get(TYPE).toString();
            row.set(type, (Object)map.get(PORP_NUMBER).toString());
            row.set("rule_fielddesc", (Object)map.get(PROP_NAME).toString());
            this.getView().updateView(ENTRY_ENTRYENTITY2);
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        String fieldKey = ((BasedataEdit)evt.getSource()).getFieldKey();
        if (fieldKey.equalsIgnoreCase(FIELD_META) && !evt.getListSelectedRowCollection().isEmpty()) {
            this.putTableInfo();
            this.fieldLinkInit();
            this.combSrcTableInit();
            this.combInit();
        }
    }

    private void putTableInfo() {
        if (this.metaObj == null) {
            this.metaObj = (DynamicObject)this.getModel().getValue(FIELD_META);
        }
        this.getPageCache().put(PROP_METAID, this.metaObj.getString(PROP_ID));
        DynamicObjectCollection rows = this.metaObj.getDynamicObjectCollection("sourcetable");
        StringBuilder tables = new StringBuilder();
        for (DynamicObject row : rows) {
            if (tables.length() > 0) {
                tables.append(',');
            }
            DynamicObject link = row.getDynamicObject("link");
            String linkNum = link.getString(PORP_NUMBER);
            tables.append(linkNum);
            tables.append('-');
            tables.append(row.getString(FIELD_SRCTABLE));
        }
        this.getPageCache().put(PROP_TABLES, tables.toString());
    }

    public void beforeBindData(EventObject e) {
        this.metaObj = (DynamicObject)this.getModel().getValue(FIELD_META);
        if (this.metaObj != null) {
            this.getPageCache().put(PROP_METAID, this.metaObj.getString(PROP_ID));
            this.putTableInfo();
            this.combSrcTableInit();
            this.combInit();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (fieldKey.equalsIgnoreCase(FIELD_KEY_SRCTABLE)) {
            ChangeData[] cd = e.getChangeSet();
            int index = cd[0].getRowIndex();
            this.getModel().setValue(FIELD_KEY_SRCTABLEFIELD, (Object)"", index);
        }
    }

    private void combSrcTableInit() {
        DynamicObjectCollection srcTables = this.metaObj.getDynamicObjectCollection("sourcetable");
        HashMap<String, String> tb = new HashMap<String, String>();
        HashMap<String, String> tb2 = new HashMap<String, String>();
        for (DynamicObject table : srcTables) {
            DynamicObject link = table.getDynamicObject("link");
            String linkNum = link.getString(PORP_NUMBER);
            String tableName = table.getString(FIELD_SRCTABLE);
            String temp = linkNum + "-" + tableName;
            if (!table.getBoolean("ismaintable")) {
                tb.put(temp, temp);
            }
            tb2.put(temp, temp);
        }
        ComboEdit comboField = (ComboEdit)this.getView().getControl(FIELD_KEY_SRCTABLE);
        this.setComboValue(comboField, tb);
        ComboEdit ruleSrcTable = (ComboEdit)this.getView().getControl("rule_srctable");
        this.setComboValue(ruleSrcTable, tb2);
    }

    private void combInit() {
        DynamicObject targTable = (DynamicObject)this.metaObj.get("targetdatatable");
        String table = targTable.getString(PORP_NUMBER);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(table, table);
        ComboEdit comboField = (ComboEdit)this.getView().getControl("key_desttable");
        this.setComboValue(comboField, data);
        ORM orm = ORM.create();
        QFilter f1 = new QFilter(PORP_NUMBER, "=", (Object)table);
        DynamicObject tableInfo = orm.queryOne("phm_datatable", new QFilter[]{f1});
        DynamicObjectCollection cols = tableInfo.getDynamicObjectCollection(ENTRY_ENTRYENTITY);
        data = new HashMap();
        for (DynamicObject col : cols) {
            String desc = col.getString("fieldname");
            if (!StringUtils.isEmpty((CharSequence)col.getString("fielddescription"))) {
                desc = desc + "-" + col.getString("fielddescription");
            }
            data.put(col.getString("fieldname"), desc);
        }
        comboField = (ComboEdit)this.getView().getControl("key_desttablefield");
        this.setComboValue(comboField, data);
    }

    private void setComboValue(ComboEdit comboEdit, Map<String, String> value) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(value.size());
        for (Map.Entry<String, String> entry : value.entrySet()) {
            ComboItem item = new ComboItem();
            item.setValue(entry.getKey());
            item.setCaption(new LocaleString(entry.getValue()));
            comboItems.add(item);
        }
        comboEdit.setComboItems(comboItems);
    }

    private void fieldLinkInit() {
        DynamicObjectCollection fields = (DynamicObjectCollection)this.metaObj.get(ENTRY_FIELDLINK);
        this.getModel().deleteEntryData("entryentity1");
        for (DynamicObject field : fields) {
            if (!StringUtils.isNotBlank((CharSequence)field.getString(FIELD_DESTFIELD))) continue;
            int currentRow = this.getModel().createNewEntryRow("entryentity1");
            this.getModel().setValue(FIELD_DESTFIELD, (Object)field.getString(FIELD_DESTFIELD), currentRow);
            this.getModel().setValue(FIELD_DESTFIELDDESCRIPTION, (Object)field.getString(FIELD_DESTFIELDNAME), currentRow);
            this.getModel().setValue(FIELD_ISPK, (Object)field.getBoolean(FIELD_DESTPKFIELD), currentRow);
            this.getModel().setValue(FIELD_SRC_TABLE, (Object)field.getString(FIELD_SRC_TABLE), currentRow);
            this.getModel().setValue(FIELD_SRC_FIELD, (Object)field.getString(FIELD_SRCFIELD), currentRow);
            this.getModel().setValue(FIELD_SRC_FIELDDESCRIPTION, (Object)field.getString(FIELD_SRCFIELDNAME), currentRow);
        }
    }
}

