/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.basemanager;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.mmc.phm.common.ExecutionResult;
import kd.mmc.phm.common.util.DataCopyTaskUtil;
import kd.mmc.phm.common.util.DataTableCompareUtils;

public class DataPumpProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String KEY_OK = "ok";
    private static final String KEY_CANCEL = "cancel";
    private static final String KEY_RUN_INBACK = "runinback";
    private static final String KEY_YES = "Yes";
    private static final String TOTAL_COUNT = "total_count";
    private static final String IGNORED_COUNT = "ignored_count";
    private static final String SUCCESS_COUNT = "success_count";
    private static final String FAILED_COUNT = "failed_count";
    private static final String STATE = "state";
    private static final String KEY_TOOLBARAP = "toolbarap";
    private static final String KEY_PROGRESSBAR = "progressbarap";
    private static final String CACHEKEY_TASKID = "taskid";
    private static final String CACHEKEY_EXECUTION = "execution";
    private static final String CACHEKEY_CANCEL = "cancel";
    private static final String ISC_DATA_COPY_EXECUTION = "isc_data_copy_execution";
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"DataPumpProgressPlugin", (int)5);
    private static final Log LOG = LogFactory.getLog(DataPumpProgressPlugin.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.FALSE, new String[]{KEY_RUN_INBACK});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_TOOLBARAP});
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (StringUtils.equals((CharSequence)KEY_OK, (CharSequence)evt.getItemKey())) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(KEY_OK, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u6267\u884c\u9009\u5b9a\u7684\u62bd\u53d6\u4efb\u52a1\u5417\uff1f", (String)"DataPumpProgressPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
        } else if (StringUtils.equals((CharSequence)"cancel", (CharSequence)evt.getItemKey())) {
            if (StringUtils.isBlank((CharSequence)this.getTaskId())) {
                this.getView().close();
            } else {
                ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
                progressBar.setPercent(progressBar.getPercent(), ResManager.loadKDString((String)"\u6b63\u5728\u64a4\u9500...", (String)"DataPumpProgressPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                this.cancel();
                QFilter[] filters = new QFilter("number", "in", this.getExecutionNumber()).toArray();
                List executionIds = QueryServiceHelper.queryPrimaryKeys((String)ISC_DATA_COPY_EXECUTION, (QFilter[])filters, null, (int)-1);
                for (Object executionId : executionIds) {
                    DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"cancelExecution", (Object[])new Object[]{executionId});
                }
            }
        } else {
            this.getView().close();
        }
    }

    private void cancel() {
        this.getPageCache().put("cancel", "true");
    }

    private boolean isCancel() {
        String json = this.getPageCache().get("cancel");
        return Objects.nonNull(json) && Boolean.parseBoolean(json);
    }

    private void execute() {
        Object numberArray = this.getView().getFormShowParameter().getCustomParam("triggerNumbers");
        List triggerNumbers = (List)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)numberArray), List.class);
        threadPool.execute(() -> {
            boolean compared;
            ArrayList<String> executionNumbers = new ArrayList<String>(triggerNumbers.size());
            LOG.info(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u6570\u636e\u62bd\u53d6\u624b\u5de5\u62bd\u53d6, triggerNumbers: {}", (String)"DataPumpProgressPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]), (Object)triggerNumbers);
            try {
                compared = DataTableCompareUtils.beforeCompareTable((List)triggerNumbers);
            }
            catch (Exception e) {
                LOG.error(ResManager.loadKDString((String)"\u6570\u636e\u62bd\u53d6\u5907\u4efd\u8868\u5931\u8d25: ", (String)"DataPumpProgressPlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + e.getMessage(), (Throwable)e);
                this.getPageCache().put("exception", "1");
                return;
            }
            LOG.info(ResManager.loadKDString((String)"\u6570\u636e\u62bd\u53d6\u624b\u5de5\u62bd\u53d6\u5907\u4efd\u8868\u903b\u8f91\u5b8c\u6210, \u5f00\u59cb\u6267\u884c\u542f\u52a8\u65b9\u6848, triggerNumbers: {}, compared: {}", (String)"DataPumpProgressPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]), (Object)triggerNumbers, (Object)compared);
            List results = DataCopyTaskUtil.executeBatch((List)triggerNumbers);
            for (Map result : results) {
                if (((Boolean)result.get("success")).booleanValue()) {
                    String exeNumber = (String)result.get("execution_number");
                    executionNumbers.add(exeNumber);
                    continue;
                }
                LOG.warn(ResManager.loadKDString((String)"\u6267\u884c\u542f\u52a8\u65b9\u6848: ", (String)"DataPumpProgressPlugin_5", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + result.get("trigger_number") + ResManager.loadKDString((String)"  \u5931\u8d25\uff0c \u9519\u8bef\u4fe1\u606f\uff1a", (String)"DataPumpProgressPlugin_6", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + result.get("msg"));
            }
            this.setExecutionNumbers(executionNumbers);
            String triggerNumber = (String)this.getView().getFormShowParameter().getCustomParam("number");
            DataCopyTaskUtil.updateDataPumpInfoByNumber((String)triggerNumber);
        });
    }

    public void confirmCallBack(MessageBoxClosedEvent args) {
        String isUnitTest;
        super.confirmCallBack(args);
        IFormView fv = this.getView();
        IPageCache pc = fv.getPageCache();
        String string = isUnitTest = pc == null ? "false" : pc.get("isUnitTest");
        if (StringUtils.equals((CharSequence)KEY_OK, (CharSequence)args.getCallBackId()) && StringUtils.equals((CharSequence)KEY_YES, (CharSequence)args.getResultValue())) {
            ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
            progressBar.start();
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_OK});
            this.getView().setEnable(Boolean.TRUE, new String[]{KEY_RUN_INBACK});
            progressBar.setPercent(0, ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c...", (String)"DataPumpProgressPlugin_7", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            if (StringUtils.equalsIgnoreCase((CharSequence)isUnitTest, (CharSequence)"true")) {
                try {
                    ProgressEvent pe = new ProgressEvent((Object)progressBar);
                    int maxLoop = 10;
                    for (int index = 0; index < 10; ++index) {
                        Thread.sleep(1000L);
                        this.onProgress(pe);
                    }
                }
                catch (Exception exc) {
                    LOG.error((Throwable)exc);
                }
            }
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        if (StringUtils.isBlank((CharSequence)this.getTaskId())) {
            this.setTaskId(DBServiceHelper.genStringId());
            this.execute();
        } else {
            String exception = this.getPageCache().get("exception");
            if (exception != null) {
                ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
                progressBar.stop();
                this.getView().close();
                this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u539f\u56e0\u3002", (String)"DataPumpProgressPlugin_8", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(this.getView().getParentView());
                return;
            }
            ExecutionResult executionResult = this.getExecutionResult();
            if (!this.isCancel()) {
                int progress = this.getProgress(executionResult);
                if (progress >= 100) {
                    progress = 99;
                }
                progressEvent.setProgress(progress);
                progressEvent.setText(progress + "%");
                this.setProgressTip(executionResult);
            }
            if (executionResult.isCompleted()) {
                progressEvent.setProgress(100);
                this.getView().close();
                this.getView().getParentView().invokeOperation("refresh");
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"DataPumpProgressPlugin_9", (String)"mmc-phm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                this.getView().sendFormAction(this.getView().getParentView());
            } else if (executionResult.isCancel()) {
                ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
                progressBar.stop();
                this.getView().close();
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u6210\u529f\u3002", (String)"DataPumpProgressPlugin_10", (String)"mmc-phm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                this.getView().sendFormAction(this.getView().getParentView());
            } else if (executionResult.isFailed()) {
                ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
                progressBar.stop();
                this.getView().close();
                this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u539f\u56e0\u3002", (String)"DataPumpProgressPlugin_8", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(this.getView().getParentView());
            }
        }
    }

    private ExecutionResult getExecutionResult() {
        DynamicObjectCollection queryResults = QueryServiceHelper.query((String)ISC_DATA_COPY_EXECUTION, (String)"total_count, success_count, failed_count, ignored_count, state", (QFilter[])new QFilter[]{new QFilter("number", "in", this.getExecutionNumber())});
        int totalCount = 0;
        int ignoredCount = 0;
        int successCount = 0;
        int failedCount = 0;
        HashSet<String> stateSet = new HashSet<String>();
        for (DynamicObject queryResult : queryResults) {
            totalCount += Integer.parseInt(queryResult.getString(TOTAL_COUNT));
            ignoredCount += Integer.parseInt(queryResult.getString(IGNORED_COUNT));
            successCount += Integer.parseInt(queryResult.getString(SUCCESS_COUNT));
            failedCount += Integer.parseInt(queryResult.getString(FAILED_COUNT));
            stateSet.add(queryResult.getString(STATE));
        }
        return new ExecutionResult(totalCount, ignoredCount, successCount, failedCount, stateSet);
    }

    private int getProgress(ExecutionResult executionResult) {
        return (executionResult.getIgnoredCount() + executionResult.getSuccessCount() + executionResult.getFailedCount()) * 100 / executionResult.getTotalCount();
    }

    private void setProgressTip(ExecutionResult executionResult) {
        Label totalLabel = (Label)this.getView().getControl(TOTAL_COUNT);
        Label ignoredLabel = (Label)this.getView().getControl(IGNORED_COUNT);
        Label successLabel = (Label)this.getView().getControl(SUCCESS_COUNT);
        Label failedLabel = (Label)this.getView().getControl(FAILED_COUNT);
        totalLabel.setText(String.valueOf(executionResult.getTotalCount()));
        ignoredLabel.setText(String.valueOf(executionResult.getIgnoredCount()));
        successLabel.setText(String.valueOf(executionResult.getSuccessCount()));
        failedLabel.setText(String.valueOf(executionResult.getFailedCount()));
    }

    private void setTaskId(String taskId) {
        this.getPageCache().put(CACHEKEY_TASKID, taskId);
    }

    private String getTaskId() {
        return this.getPageCache().get(CACHEKEY_TASKID);
    }

    private void setExecutionNumbers(List<String> executionNumbers) {
        LOG.info(ResManager.loadKDString((String)"\u6267\u884c\u7ed3\u679c\u7f16\u7801\u96c6\uff1a", (String)"DataPumpProgressPlugin_11", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + executionNumbers);
        this.getPageCache().put(CACHEKEY_EXECUTION, SerializationUtils.toJsonString(executionNumbers));
    }

    private List<String> getExecutionNumber() {
        String executionStr = this.getPageCache().get(CACHEKEY_EXECUTION);
        return StringUtils.isBlank((CharSequence)executionStr) ? new ArrayList() : (List)SerializationUtils.fromJsonString((String)executionStr, List.class);
    }
}

