/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.basemanager;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.mmc.phm.common.enums.VType;
import kd.mmc.phm.common.util.EntryUtils;

public class DataTableEdit
extends AbstractFormPlugin {
    private static final String[] FIELDS = new String[]{"fieldname", "fieldtype"};

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.containsKey("sortedColLabels")) {
            IDataModel model = this.getModel();
            Object createOrgId = customParams.get("createorg");
            model.setValue("createorg", createOrgId);
            JSONArray sortedColLabels = (JSONArray)customParams.get("sortedColLabels");
            JSONObject colTypes = (JSONObject)customParams.get("colTypes");
            ArrayList values = Lists.newArrayListWithExpectedSize((int)sortedColLabels.size());
            for (Object sortedColLabel : sortedColLabels) {
                ArrayList value = Lists.newArrayListWithExpectedSize((int)FIELDS.length);
                String sortedColLabelStr = sortedColLabel.toString();
                value.add(sortedColLabelStr.toLowerCase());
                value.add(this.convertValue(sortedColLabelStr, colTypes));
                values.add(value);
            }
            this.getModel().deleteEntryData("entryentity");
            EntryUtils.batchCreateEntryRow((IFormView)this.getView(), (String)"entryentity", (String[])FIELDS, (List)values);
            customParams.put("useorgId", String.valueOf(createOrgId));
            this.getView().cacheFormShowParameter();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.containsKey("sortedColLabels")) {
            EntryUtils.setColumnLock((IFormView)this.getView(), (String)"entryentity", (boolean)true, (String[])FIELDS);
            this.getView().setEnable(Boolean.FALSE, new String[]{"advconbaritemap", "advconbaritemap1"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("submit".equals(formOperate.getOperateKey())) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            if (customParams.containsKey("sortedColLabels")) {
                Map datas = (Map)customParams.get("datas");
                List rows = (List)datas.get("rows");
                OperateOption option = formOperate.getOption();
                String yes = this.getPageCache().get("yes");
                if (yes == null && rows.isEmpty()) {
                    ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("submit", (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u662f\u5426\u7ee7\u7eed\u5efa\u8868", (String)"DataTableEdit_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
                    args.setCancel(true);
                } else {
                    option.setVariableValue("params", SerializationUtils.toJsonString((Object)customParams));
                }
            }
        } else if ("disable".equals(formOperate.getOperateKey())) {
            OperateOption option = formOperate.getOption();
            option.setVariableValue("ignorerefentityids", "phm_eigenvalue_releation");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if ("submit".equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put("yes", "1");
            this.getView().invokeOperation("submit");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getView().returnDataToParent(this.getModel().getValue("status"));
    }

    private String convertValue(String sortedColLabel, JSONObject colTypes) {
        String fieldType = null;
        String vType = colTypes.getString(sortedColLabel);
        if (VType.STRING.name().equals(vType)) {
            fieldType = "NVARCHAR";
        } else if (VType.BIGINT.name().equals(vType)) {
            fieldType = "BIGINT";
        } else if (VType.DECIMAL.name().equals(vType)) {
            fieldType = "DECIMAL";
        } else if (VType.TIMESTAMP.name().equals(vType) || VType.DATE.name().equals(vType)) {
            fieldType = "DATETIME";
        }
        return fieldType;
    }
}

