/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.basemanager;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class DataTableExportAndImportPlugin
extends AbstractListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        Iterator iterator = commonFilterColumns.iterator();
        while (iterator.hasNext()) {
            FilterColumn commonFilterColumn = (FilterColumn)iterator.next();
            String fieldName = commonFilterColumn.getFieldName();
            if (!fieldName.equals("useorg.id") || !(commonFilterColumn instanceof CommonFilterColumn)) continue;
            iterator.remove();
            break;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)"export", (CharSequence)operateKey)) {
            this.exportToExcle();
        } else if (StringUtils.equals((CharSequence)"import", (CharSequence)operateKey)) {
            this.importDatas();
        }
    }

    private void exportToExcle() {
        ListSelectedRowCollection selectCol = this.getSelectedRows();
        if (selectCol.isEmpty()) {
            return;
        }
        ListSelectedRow selectRow = selectCol.get(0);
        Object pkValue = selectRow.getPrimaryKeyValue();
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"phm_datatable");
        String tableName = obj.getString("number");
        DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("entryentity");
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        SXSSFSheet sheet = workbook.createSheet(tableName);
        SXSSFRow firstRow = sheet.createRow(0);
        SXSSFRow secondRow = sheet.createRow(1);
        for (int i = 0; i < entryCol.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryCol.get(i);
            String fieldname = entry.getString("fieldname");
            String fieldtype = entry.getString("fieldtype");
            firstRow.createCell(i).setCellValue(fieldname);
            secondRow.createCell(i).setCellValue(fieldtype);
        }
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)outStream);
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            int timeout = 7200;
            String tempUrl = cache.saveAsUrl(tableName + ".xlsx", (InputStream)inStream, timeout);
            this.getView().download(tempUrl);
            outStream.close();
            inStream.close();
            workbook.close();
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private void importDatas() {
        ListSelectedRowCollection selectCol = this.getSelectedRows();
        if (selectCol.isEmpty()) {
            return;
        }
        ListSelectedRow selectRow = selectCol.get(0);
        String status = selectRow.getBillStatus();
        if (!StringUtils.equals((CharSequence)"C", (CharSequence)status)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u4e2d\u6570\u636e\u672a\u63d0\u4ea4", (String)"DataTableExportAndImportPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
        Object pkValue = selectRow.getPrimaryKeyValue();
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"phm_datatable");
        String tableName = obj.getString("number");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("phm_datatable_import");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "import"));
        formShowParameter.setCustomParam("table", (Object)tableName);
        this.getView().showForm(formShowParameter);
    }
}

