/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.basemanager;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BillClosedCallBackEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.phm.formplugin.basemanager.DataTableGroupListUtils;

public class DataTableGroupListPlugin
extends StandardTreeListPlugin {
    private static final String ROOTNODEID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String ENTITY_GROUP = "group";
    private static final String ENTITY_DATATABLE = "phm_datatable";
    private static final String ENTITY_DATATABLEGROUP = "phm_datatablegroup";
    private static final String ENTITY_DATATABLEGROUPSTANDARD = "phm_groupstd";
    private static final String PROP_STANDARDLST = "cmbstandardlst";
    private static final String PROP_CREATE_ORG = "createorg";
    private static final String PROP_STANDARD = "standard";
    private static final String PROP_PARENT = "parent";
    private static final String PROP_ID = "id";
    private static final String PGCACHE_CREATEORG = "createOrg";
    private static final String DATATABLE_BGS = "890349491587243008";
    private static final String GROUP_NG = "900452829603450880";
    private static final String USEORG_FILEDNAME = "useorg.id";
    private static final String CACHE_USEORG = "useorg";
    private static final String CUSTOMFILTER = "customfilter";
    private static final String PROP_NUMBER = "number";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put(PGCACHE_CREATEORG, this.getDefaultUseOrg().toString());
        Long orgId = RequestContext.get().getOrgId();
        this.getPageCache().put(CACHE_USEORG, orgId.toString());
        this.standardInit();
    }

    private Long getDefaultUseOrg() {
        String createOrg = this.getPageCache().get(PGCACHE_CREATEORG);
        if (createOrg != null && !createOrg.isEmpty()) {
            return Long.parseLong(createOrg);
        }
        Long orgId = RequestContext.get().getOrgId();
        if (orgId == 0L) {
            orgId = 100000L;
        }
        return orgId;
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List defVal;
        CommonFilterColumn test;
        List items;
        CommonFilterColumn orgColumn;
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        if (filterColumnList.contains(orgColumn = this.initOrgCol()) && !this.orgExists(items = (test = (CommonFilterColumn)filterColumnList.get(0)).getComboItems(), defVal = test.getDefaultValues())) {
            test.setDefaultValue(((ComboItem)items.get(0)).getValue());
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customFiterList = (List)filterValues.get(CUSTOMFILTER);
        if (customFiterList == null) {
            return;
        }
        for (Map customFiter : customFiterList) {
            List orgIds;
            List fieldNames = (List)customFiter.get("FieldName");
            if (fieldNames == null || fieldNames.size() <= 0 || !USEORG_FILEDNAME.equals(fieldNames.get(0)) || (orgIds = (List)customFiter.get("Value")) == null || orgIds.size() == 0) continue;
            this.getPageCache().put(CACHE_USEORG, String.valueOf(orgIds.get(0)));
            this.treeListView.refreshTreeView();
        }
    }

    private boolean orgExists(List<ComboItem> items, List<Object> defVal) {
        for (Object defValue : defVal) {
            ComboItem defOrg = new ComboItem();
            defOrg.setValue(defValue.toString());
            if (!items.contains(defOrg)) continue;
            return true;
        }
        return false;
    }

    private CommonFilterColumn initOrgCol() {
        CommonFilterColumn orgColumn = new CommonFilterColumn();
        orgColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7", (String)"DataTableGroupListPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0])));
        orgColumn.setFieldName(USEORG_FILEDNAME);
        orgColumn.setMustInput(true);
        orgColumn.setEntityField(false);
        return orgColumn;
    }

    private List<Map<String, Object>> getGroupStandardList() {
        Set<Long> groupStandard = this.getStandards();
        QFilter[] filters = this.getFilter(groupStandard);
        DynamicObject[] bizMap = BusinessDataServiceHelper.load((String)ENTITY_DATATABLEGROUPSTANDARD, (String)"id,number,name,createtime", (QFilter[])filters, (String)"createtime asc");
        if (bizMap == null || bizMap.length == 0) {
            return new ArrayList<Map<String, Object>>(0);
        }
        ArrayList<Map<String, Object>> listStandard = new ArrayList<Map<String, Object>>(bizMap.length);
        for (DynamicObject entry : bizMap) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(PROP_ID, entry.get(PROP_ID).toString());
            map.put("name", entry.get("name").toString());
            map.put("createtime", entry.get("createtime"));
            listStandard.add(map);
        }
        return listStandard;
    }

    private Set<Long> getStandards() {
        QFilter filter = null;
        String createOrg = this.getPageCache().get(PGCACHE_CREATEORG);
        Set<Long> groupStandard = DataTableGroupListUtils.getGroupStandard(ENTITY_DATATABLEGROUP, Long.valueOf(createOrg), true, filter);
        if (groupStandard.size() == 0) {
            groupStandard.add(Long.valueOf(DATATABLE_BGS));
        }
        return groupStandard;
    }

    private QFilter[] getFilter(Set<Long> groupStandard) {
        String gsId;
        QFilter idFilter = new QFilter(PROP_ID, "in", groupStandard);
        QFilter[] filters = new QFilter[]{idFilter};
        ListShowParameter params = (ListShowParameter)this.getView().getFormShowParameter();
        if (params.isLookUp() && (gsId = (String)params.getCustomParam("groupstandard")) != null) {
            QFilter f7Filter = new QFilter(PROP_ID, "=", (Object)Long.parseLong(gsId));
            filters = new QFilter[]{f7Filter};
        }
        return filters;
    }

    private void setComboEdit(List<Map<String, Object>> standardList) {
        ComboEdit combo = (ComboEdit)this.getView().getControl(PROP_STANDARDLST);
        this.setComboValue(combo, standardList);
    }

    private void setComboValue(ComboEdit comboEdit, List<Map<String, Object>> stdList) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(stdList.size());
        for (Map<String, Object> map : stdList) {
            ComboItem item = new ComboItem();
            item.setValue((String)map.get(PROP_ID));
            item.setCaption(new LocaleString(map.get("name").toString()));
            comboItems.add(item);
        }
        comboEdit.setComboItems(comboItems);
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        TreeNode rootNode = this.getTreeModel().getRoot();
        if (rootNode == null || rootNode.getTreeNode(nodeId, 20) == null) {
            return;
        }
        this.treeListView.getTreeView().queryTreeNodeChildren(e.getParentNodeId().toString(), nodeId);
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        this.initTree();
    }

    private void initTree() {
        TreeNode root = this.getTreeModel().createRootNode();
        if (root != null) {
            root.setChildren(new ArrayList(0));
            this.getTreeModel().setRoot(root);
            String rootId = root.getId();
            this.getTreeModel().setCurrentNodeId((Object)rootId);
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        ITreeModel treeModel;
        String nodeId = e.getNodeId().toString();
        String textFormat = "";
        ITreeListView treeView = this.getTreeListView();
        if (treeView != null && (treeModel = treeView.getTreeModel()) instanceof TreeListModel) {
            TreeListModel treeListModel = (TreeListModel)treeModel;
            textFormat = treeListModel.getTextFormat();
        }
        List<TreeNode> treeNodes = this.getTreeChildren(nodeId, false, false, textFormat);
        e.setChildNodes(treeNodes);
    }

    private boolean groupVisibleOnTree(DynamicObject group) {
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        return group.getString(PROP_ID) != null && (!param.isLookUp() || !group.getString(PROP_ID).equals(GROUP_NG));
    }

    private List<TreeNode> getTreeChildren(String nodeId, boolean isGetAllSub, boolean isOpen, String textFormat) {
        Object value = this.getCurrentGroupStandard();
        if (StringUtils.isBlank((Object)value)) {
            return new ArrayList<TreeNode>();
        }
        DynamicObjectCollection groups = this.loadGroup(nodeId, value);
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(groups.size());
        for (DynamicObject group : groups) {
            if (!this.groupVisibleOnTree(group)) continue;
            TreeNode treeNode = new TreeNode();
            treeNode.setId(group.getString(PROP_ID));
            treeNode.setParentid(group.getString(PROP_PARENT) == null ? ROOTNODEID : group.getString(PROP_PARENT));
            treeNode.setText(this.getNodeText(group, textFormat));
            treeNode.setLongNumber(group.getString("longnumber"));
            boolean parentNode = group.getBoolean("isleaf");
            if (!parentNode) {
                if (isGetAllSub) {
                    treeNode.addChildren(this.getTreeChildren(group.getString(PROP_ID), isGetAllSub, isOpen, textFormat));
                } else {
                    treeNode.addChildren(new ArrayList());
                }
            }
            treeNode.setIsOpened(isOpen);
            treeNodes.add(treeNode);
        }
        return treeNodes;
    }

    private String getNodeText(DynamicObject group, String textFormat) {
        String text;
        String name = group.getString("name");
        String string = text = StringUtils.isBlank((CharSequence)name) ? group.getString("name") : name;
        if (StringUtils.isEmpty((CharSequence)text)) {
            return "";
        }
        if (StringUtils.isNotEmpty((CharSequence)textFormat)) {
            text = textFormat.replace("{name}", text);
            if (StringUtils.isNotEmpty((CharSequence)group.getString(PROP_NUMBER))) {
                text = text.replace("{code}", group.getString(PROP_NUMBER));
            }
        }
        return text;
    }

    private Object getCurrentGroupStandard() {
        Object value = this.getModel().getValue(PROP_STANDARDLST);
        if (value == null) {
            value = DATATABLE_BGS;
        }
        return value;
    }

    private DynamicObjectCollection loadGroup(String nodeId, Object value) {
        QFilter qFilter = new QFilter(PROP_STANDARD, "=", (Object)Long.parseLong(value.toString()));
        nodeId = ROOTNODEID.equals(nodeId) ? "0" : nodeId;
        QFilter qFilter2 = new QFilter(PROP_PARENT, "=", (Object)Long.parseLong(nodeId));
        String createOrg = this.getPageCache().get(PGCACHE_CREATEORG);
        Long org = RequestContext.get().getOrgId();
        if (createOrg == null) {
            createOrg = org.toString();
        }
        QFilter qFilter4 = new QFilter("1", "=", (Object)1);
        if (createOrg != null) {
            Set<Long> orgSets = DataTableGroupListUtils.getOrgList(ENTITY_DATATABLEGROUP, Long.parseLong(createOrg));
            qFilter4 = orgSets.size() < 1 ? new QFilter(PROP_CREATE_ORG, "=", (Object)Long.parseLong(createOrg)) : new QFilter(PROP_CREATE_ORG, "in", orgSets);
        }
        return QueryServiceHelper.query((String)ENTITY_DATATABLEGROUP, (String)"id,number,name,parent,longnumber,isleaf", (QFilter[])new QFilter[]{qFilter, qFilter2, qFilter4});
    }

    public void expendTreeNode(TreeNodeEvent e) {
        TreeNode rootNode = this.getTreeModel().getRoot();
        String nodeId = (String)e.getNodeId();
        if ((rootNode != null && !StringUtils.isBlank((CharSequence)nodeId) ? rootNode.getTreeNode(nodeId, 20) : null) == null) {
            return;
        }
        TreeNode node = this.getTreeListView().getTreeModel().refreshNode((Object)nodeId);
        if (node == null) {
            return;
        }
        node.setIsOpened(true);
        e.setExpandedNode(node);
    }

    private void standardInit() {
        List<Map<String, Object>> standardLists = this.getGroupStandardList();
        this.setComboEdit(standardLists);
        this.setStdDefValue(standardLists);
    }

    private void setStdDefValue(List<Map<String, Object>> standardLists) {
        String standardId;
        ArrayList<String> standardIds = new ArrayList<String>();
        if (standardLists.size() > 0) {
            for (Map<String, Object> standardMap : standardLists) {
                standardIds.add(standardMap.get(PROP_ID).toString());
            }
        }
        String groupStandard = DATATABLE_BGS;
        ListShowParameter params = (ListShowParameter)this.getView().getFormShowParameter();
        if (params.isLookUp() && (standardId = (String)params.getCustomParam("groupstandard")) != null) {
            groupStandard = standardId;
        }
        if (standardIds.size() > 0 && !standardIds.contains(groupStandard)) {
            groupStandard = (String)standardIds.get(0);
        }
        this.getModel().setValue(PROP_STANDARDLST, (Object)groupStandard);
        this.getPageCache().put(PROP_STANDARD, groupStandard);
        this.getView().updateView();
    }

    public void setFilter(SetFilterEvent e) {
        QFilter filter;
        super.setFilter(e);
        List filters = e.getQFilters();
        String nodeId = this.getTreeListView().getTreeView().getTreeState().getFocusNodeId();
        if (nodeId == null) {
            nodeId = ROOTNODEID;
        }
        if ((filter = this.genRefreshFilter(nodeId)) != null) {
            filters.add(filter);
        }
    }

    public void billClosedCallBack(BillClosedCallBackEvent e) {
        this.getTreeListView().focusRootNode();
    }

    private QFilter genRefreshFilter(String nodeId) {
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        QFilter qFilter = null;
        String createOrg = this.getPageCache().get(PGCACHE_CREATEORG);
        if (!param.isLookUp() && StringUtils.isBlank((CharSequence)createOrg)) {
            return qFilter;
        }
        Object value = this.getModel().getValue(PROP_STANDARDLST);
        if (value == null) {
            value = DATATABLE_BGS;
        } else if (StringUtils.isBlank((Object)value)) {
            return new QFilter(PROP_ID, "in", new ArrayList());
        }
        qFilter = new QFilter(PROP_STANDARD, "=", (Object)Long.parseLong(value.toString()));
        if (ROOTNODEID.equals(nodeId)) {
            if (param.isLookUp()) {
                qFilter.and(new QFilter(PROP_ID, "!=", (Object)Long.parseLong(GROUP_NG)));
            }
            return qFilter;
        }
        List<Long> groupIds = DataTableGroupListUtils.queryGroupsByGroupId(ENTITY_DATATABLE, value, nodeId, createOrg);
        qFilter.and(new QFilter(PROP_ID, "in", groupIds));
        return qFilter;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (PROP_STANDARDLST.equals(propertyName)) {
            TreeView treeView = this.getTreeListView().getTreeView();
            String groupStandard = this.getModel().getValue(PROP_STANDARDLST).toString();
            this.getPageCache().put(PROP_STANDARD, groupStandard);
            TreeNode root = this.getTreeModel().createRootNode();
            if (root == null) {
                this.treeListView.refreshTreeView();
            } else {
                this.treeListView.getTreeView().deleteAllNodes();
                treeView.addNode(root);
                treeView.treeNodeClick("", root.getId());
            }
            this.clearPageCache();
        }
    }

    private void clearPageCache() {
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        this.getPageCache().remove(searchNodesCacheKey);
        this.getPageCache().remove(matchNodesCacheKey);
        this.getPageCache().remove(oldSearchTextCacheKey);
        this.getPageCache().remove(searchIndexCacheKey);
    }
}

