/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.basemanager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class DataTableGroupListUtils {
    private static Log logger = LogFactory.getLog(DataTableGroupListUtils.class);
    private static final String ENTITYID_ORG_STRUCTURE = "bos_org_structure";
    private static final String ENTITYID_ORG_ORG = "bos_org";
    private static final String ENTITY_GROUP = "group";
    private static final String PROP_ID = "id";
    private static final String PROP_STANDARD = "standard";
    private static final String PROP_LONGNUMBER = "longnumber";
    private static final String ENTITY_PHM_GROUPSTD = "phm_groupstd";
    private static final String VIEW_ID = "view.id";
    private static final String CREATEORG = "createorg";

    public static Set<Long> getOrgList(String entityNumber, Long createOrg) {
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entityNumber);
        if (ctrlview == null) {
            return new HashSet<Long>();
        }
        ORM ormOV = ORM.create();
        QFilter f1 = new QFilter(VIEW_ID, "=", (Object)Long.parseLong(ctrlview.getPkValue().toString()));
        HashSet<String> orglongnumberSets = new HashSet<String>();
        DataSet ds = ormOV.queryDataSet(DataTableGroupListUtils.class.getName(), ENTITYID_ORG_STRUCTURE, PROP_LONGNUMBER, new QFilter[]{f1});
        Object object = null;
        try {
            for (Row row : ds) {
                if (row.getString(PROP_LONGNUMBER) == null) continue;
                orglongnumberSets.add(row.getString(PROP_LONGNUMBER));
            }
        }
        catch (Throwable iter) {
            object = iter;
            throw iter;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable iter) {
                        ((Throwable)object).addSuppressed(iter);
                    }
                } else {
                    ds.close();
                }
            }
        }
        HashSet<String> orgnumberSets = new HashSet<String>();
        for (String orglongnumber : orglongnumberSets) {
            String[] orgnumbers = orglongnumber.split("!");
            orgnumberSets.addAll(new HashSet<String>(Arrays.asList(orgnumbers)));
        }
        QFilter f = new QFilter("number", "in", orgnumberSets);
        QFilter f2 = new QFilter("enable", "=", (Object)"1");
        QFilter[] qFilters = new QFilter[]{f, f2};
        HashSet<Long> orgIdSets = new HashSet<Long>();
        try (DataSet ds2 = ormOV.queryDataSet(DataTableGroupListUtils.class.getName(), ENTITYID_ORG_ORG, PROP_ID, qFilters);){
            for (Row row : ds2) {
                if (row.getLong(PROP_ID) == null) continue;
                orgIdSets.add(row.getLong(PROP_ID));
            }
        }
        return orgIdSets;
    }

    public static Set<Long> getGroupStandard(String entityNumber, Long createOrg, boolean isAddEnable, QFilter filter) {
        HashSet<Long> standardSetIds = new HashSet<Long>();
        try {
            ORM ormOV = ORM.create();
            Set<Long> orgIdSets = DataTableGroupListUtils.getOrgList(entityNumber, createOrg);
            if (orgIdSets.size() < 1) {
                return standardSetIds;
            }
            QFilter f = new QFilter(CREATEORG, "in", orgIdSets);
            QFilter f2 = new QFilter("enable", "=", (Object)"1");
            QFilter f3 = new QFilter("status", "=", (Object)"C");
            ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
            qfilters.add(f);
            if (isAddEnable) {
                qfilters.add(f2);
                qfilters.add(f3);
            }
            try (DataSet ds = ormOV.queryDataSet(DataTableGroupListUtils.class.getName(), ENTITY_PHM_GROUPSTD, PROP_ID, qfilters.toArray(new QFilter[0]), PROP_ID);){
                for (Row row : ds) {
                    if (row.get(PROP_ID) == null) continue;
                    standardSetIds.add(Long.parseLong(row.get(PROP_ID).toString()));
                }
            }
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ResManager.loadKDString((String)"\u83b7\u53d6\u5bf9\u5e94\u7ec4\u7ec7\u4e0b\u5206\u7c7b\u6807\u51c6\uff1a%s", (String)"DataTableGroupListUtils_0", (String)"mmc-phm-formplugin", (Object[])new Object[0])), new Object[]{ex.getMessage()});
        }
        return standardSetIds;
    }

    public static List<Long> queryGroupsByGroupId(String entity, Object standardId, Object id, String createOrg) {
        if (id == null) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> list = new ArrayList<Long>();
        Long longId = Long.valueOf(id.toString());
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)(entity + ENTITY_GROUP), (String)"longnumber,isleaf", (QFilter[])new QFilter[]{new QFilter(PROP_ID, "=", (Object)longId)});
        if (queryOne.getBoolean("isleaf")) {
            list.add(longId);
            return list;
        }
        String longnumber = queryOne.getString(PROP_LONGNUMBER);
        QFilter f1 = new QFilter(PROP_LONGNUMBER, "like", (Object)(longnumber + "%"));
        QFilter f2 = new QFilter(PROP_STANDARD, "=", (Object)Long.parseLong(standardId.toString()));
        Set<Long> org = DataTableGroupListUtils.getOrgList(entity, Long.parseLong(createOrg));
        QFilter f3 = new QFilter(CREATEORG, "in", org);
        QFilter[] qFilters = new QFilter[]{f1, f2, f3};
        ORM ormOV = ORM.create();
        try (DataSet ds = ormOV.queryDataSet(DataTableGroupListUtils.class.getName(), entity + ENTITY_GROUP, PROP_ID, qFilters);){
            for (Row row : ds) {
                if (row.getString(PROP_ID) == null) continue;
                list.add(row.getLong(PROP_ID));
            }
        }
        return list;
    }
}

