/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.basemanager;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.AlterTableUtil;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.mmc.phm.formplugin.basemanager.DataTableGroupListUtils;

public class DataTableListPlugin
extends StandardTreeListPlugin {
    private static Log logger = LogFactory.getLog(DataTableListPlugin.class);
    private static final String ROOTNODEID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String DATATABLE_BGS = "890349491587243008";
    private static final String GROUP_NG = "900452829603450880";
    private static final String ENTRY_DATATABLE = "phm_datatable";
    private static final String PROP_STANDARDLST = "cmbstandardlst";
    private static final String ENTRY_GROUPSTANDARD = "phm_groupstd";
    private static final String ENTITY_GROUP = "group";
    private static final String PROP_STANDARD = "standard";
    private static final String PROP_CREATE_ORG = "createorg";
    private static final String PROP_PARENT = "parent";
    private static final String ENTITY_DATATABLEGROUP = "phm_datatablegroup";
    private static final String PROP_DELETE = "delete";
    private static final String PROP_DELTABLE = "deltable";
    private static final String CACHE_USEORG = "useorg";
    private static final String PGCACHE_CREATEORG = "createOrg";
    private static final String USEORG_FILEDNAME = "useorg.id";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (operateKey.equals("cleardata") || operateKey.equals(PROP_DELETE) || operateKey.equals("tabledel")) {
            String table = this.getSelectedTable();
            if (StringUtils.isEmpty((CharSequence)table)) {
                args.setCancel(true);
                return;
            }
            if (operateKey.equals("cleardata")) {
                this.toClearData();
            } else if ("tabledel".equals(operateKey)) {
                this.getPageCache().put(PROP_DELTABLE, table);
            } else {
                this.cancelAndDelete(formOperate, table);
                this.getPageCache().put(PROP_DELTABLE, table);
            }
        } else if ("disable".equals(operateKey)) {
            this.cancelRefCheck(formOperate);
        }
    }

    private void cancelAndDelete(FormOperate formOperate, String table) {
        this.cancelRefCheck(formOperate);
        DeleteServiceHelper.delete((String)"phm_eigenvalue_releation", (QFilter[])new QFilter("datatable.number", "=", (Object)table).toArray());
    }

    private void cancelRefCheck(FormOperate formOperate) {
        OperateOption option = formOperate.getOption();
        option.setVariableValue("ignorerefentityids", "phm_eigenvalue_releation");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        FormOperate formOperate = (FormOperate)args.getSource();
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess() && (StringUtils.equals((CharSequence)PROP_DELETE, (CharSequence)(opKey = formOperate.getOperateKey())) || StringUtils.equals((CharSequence)"tabledel", (CharSequence)opKey))) {
            this.toDelTable();
        }
    }

    private String getSelectedTable() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows == null) {
            return null;
        }
        if (rows.size() != 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u652f\u6301\u5355\u884c\u64cd\u4f5c\uff01", (String)"DataTableListPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return null;
        }
        return rows.get(0).getNumber();
    }

    private void toDelTable() {
        String msg = ResManager.loadKDString((String)"\u5220\u9664\u5b9e\u4f53\u8868\u540e\uff0c\u5982\u679c\u8868\u4e2d\u6709\u6570\u636e\uff0c\u5c06\u4e0d\u53ef\u627e\u56de\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u9700\u8981\u540c\u6b65\u5220\u9664\u5b9e\u4f53\u8868\uff01", (String)"DataTableListPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]);
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("del_confirm");
        this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, confirmCallBacks);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        if (callBackId.equals("del_confirm") && evt.getResult() == MessageBoxResult.Yes) {
            this.doDelTable();
        } else if (callBackId.equals("clear_confirm") && evt.getResult() == MessageBoxResult.Yes) {
            this.doClearData();
        }
    }

    private void doClearData() {
        try {
            DBRoute route = new DBRoute("phm");
            String sql = "delete from  " + this.getSelectedTable();
            DB.execute((DBRoute)route, (String)sql);
        }
        finally {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u6e05\u7406\u6210\u529f", (String)"DataTableListPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDelTable() {
        try {
            DBRoute route = new DBRoute("phm");
            String table = this.getPageCache().get(PROP_DELTABLE);
            if (!StringUtils.isEmpty((CharSequence)table)) {
                DbMetadataTable tableSchema = AlterTableUtil.getTableSchema((String)"PHM", (String)table);
                if (tableSchema != null) {
                    String sql = "drop table " + table;
                    DB.execute((DBRoute)route, (String)sql);
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5b9e\u4f53\u8868\u5220\u9664\u6210\u529f", (String)"DataTableListPlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
        }
        finally {
            this.getPageCache().remove(PROP_DELTABLE);
        }
    }

    private void toClearData() {
        String msg = ResManager.loadKDString((String)"\u6570\u636e\u6e05\u7a7a\u540e\u5c06\u4e0d\u53ef\u627e\u56de\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DataTableListPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]);
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("clear_confirm");
        this.getView().showConfirm(msg, MessageBoxOptions.YesNo, confirmCallBacks);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put(PGCACHE_CREATEORG, this.getDefaultUseOrg().toString());
        Long orgId = RequestContext.get().getOrgId();
        this.getPageCache().put(CACHE_USEORG, orgId.toString());
        this.standardInit();
    }

    public void afterBindData(EventObject e) {
        this.getTreeModel().getRoot().setText(ResManager.loadKDString((String)"\u8868\u5206\u7c7b", (String)"DataTableListPlugin_5", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        TreeView treeView = this.getTreeListView().getTreeView();
        TreeNode root = this.getTreeModel().createRootNode();
        treeView.treeNodeClick("", root.getId());
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List defVal;
        CommonFilterColumn test;
        List items;
        CommonFilterColumn orgColumn;
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        if (filterColumnList.contains(orgColumn = this.initOrgCol()) && !this.orgExists(items = (test = (CommonFilterColumn)filterColumnList.get(0)).getComboItems(), defVal = test.getDefaultValues()) && !items.isEmpty()) {
            test.setDefaultValue(((ComboItem)items.get(0)).getValue());
        }
    }

    private boolean orgExists(List<ComboItem> items, List<Object> defVal) {
        for (Object defValue : defVal) {
            ComboItem defOrg = new ComboItem();
            defOrg.setValue(defValue.toString());
            if (!items.contains(defOrg)) continue;
            return true;
        }
        return false;
    }

    private CommonFilterColumn initOrgCol() {
        CommonFilterColumn orgColumn = new CommonFilterColumn();
        orgColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7", (String)"DataTableListPlugin_6", (String)"mmc-phm-formplugin", (Object[])new Object[0])));
        orgColumn.setFieldName(USEORG_FILEDNAME);
        orgColumn.setMustInput(true);
        orgColumn.setEntityField(false);
        return orgColumn;
    }

    private void standardInit() {
        List<Map<String, Object>> standardLists = this.getGroupStandardList();
        this.setComboEdit(standardLists);
        this.setStdDefValue(standardLists);
    }

    private void setStdDefValue(List<Map<String, Object>> standardLists) {
        String standardId;
        ArrayList<String> standardIds = new ArrayList<String>();
        if (standardLists.size() > 0) {
            for (Map<String, Object> standardMap : standardLists) {
                standardIds.add(standardMap.get("id").toString());
            }
        }
        String groupStandard = DATATABLE_BGS;
        ListShowParameter params = (ListShowParameter)this.getView().getFormShowParameter();
        if (params.isLookUp() && (standardId = (String)params.getCustomParam("groupstandard")) != null) {
            groupStandard = standardId;
        }
        if (standardIds.size() > 0 && !standardIds.contains(groupStandard)) {
            groupStandard = (String)standardIds.get(0);
        }
        this.getModel().setValue(PROP_STANDARDLST, (Object)groupStandard);
        this.getPageCache().put(PROP_STANDARD, groupStandard);
        this.getView().updateView();
    }

    private Long getDefaultUseOrg() {
        String createOrg = this.getPageCache().get(PGCACHE_CREATEORG);
        if (createOrg != null && !createOrg.isEmpty()) {
            return Long.parseLong(createOrg);
        }
        Long orgId = RequestContext.get().getOrgId();
        if (orgId == 0L) {
            orgId = 100000L;
        }
        return orgId;
    }

    private QFilter genRefreshFilter(String nodeId, String stdId) {
        QFilter qFilter = null;
        ArrayList<Long> paramList = new ArrayList<Long>();
        paramList.add(Long.valueOf(stdId));
        String useTable = this.getFilterString(nodeId, stdId);
        qFilter = QFilter.joinSQL((String)ENTRY_DATATABLE, (String)useTable, (Object[])paramList.toArray(new Object[0]));
        return qFilter;
    }

    private String getFilterString(String nodeId, String stdId) {
        String createOrg = this.getPageCache().get(PGCACHE_CREATEORG);
        if (StringUtils.isBlank((CharSequence)createOrg)) {
            return null;
        }
        StringBuilder useTable = new StringBuilder();
        useTable.append("(select ftargetdatatable  from t_phm_metadata where fid in");
        useTable.append(" (select fid from ").append("T_PHM_TABLECONTENT").append(" where 1=1 ");
        if (!ROOTNODEID.equals(nodeId)) {
            List<Long> groupIds = DataTableGroupListUtils.queryGroupsByGroupId(ENTRY_DATATABLE, stdId, nodeId, createOrg);
            StringBuilder groupIdStr = this.getGroups(groupIds);
            if (StringUtils.isNotBlank((CharSequence)groupIdStr)) {
                useTable.append(" and  ftablegroup in ( ").append((CharSequence)groupIdStr).append(')');
            }
        } else {
            Map<Object, DynamicObject> loadFromCache = this.loadGroupFromCache(nodeId, stdId);
            StringBuilder groupIds = new StringBuilder();
            for (DynamicObject group : loadFromCache.values()) {
                if (group.getPkValue() == null) continue;
                if (groupIds.length() > 0) {
                    groupIds.append(',');
                }
                if (group.getPkValue() == null) continue;
                groupIds.append(group.getPkValue());
            }
            if (StringUtils.isNotBlank((CharSequence)groupIds)) {
                useTable.append(" and  ftablegroup in ( ").append((CharSequence)groupIds).append(')');
            }
        }
        useTable.append(" and  fgroupstandard = ? and ftablegroup>0 ");
        useTable.append("))");
        return "inner join " + useTable + " ur on ur.ftargetdatatable = " + ENTRY_DATATABLE + ".fid ";
    }

    private StringBuilder getGroups(List<Long> groupIds) {
        StringBuilder groupIdStr = new StringBuilder();
        if (groupIds != null && groupIds.size() >= 1) {
            for (Long groupId : groupIds) {
                if (StringUtils.isBlank((CharSequence)groupIdStr)) {
                    groupIdStr.append(groupId);
                    continue;
                }
                groupIdStr.append(',').append(groupId);
            }
        }
        return groupIdStr;
    }

    private List<Map<String, Object>> getGroupStandardList() {
        QFilter idFilter;
        QFilter[] filters;
        DynamicObject[] bizMap;
        QFilter filter = null;
        String createOrg = this.getPageCache().get(PGCACHE_CREATEORG);
        Set<Long> groupStandard = new HashSet<Long>();
        if (StringUtils.isNotBlank((CharSequence)createOrg)) {
            groupStandard = DataTableGroupListUtils.getGroupStandard(ENTRY_DATATABLE, Long.valueOf(createOrg), true, filter);
        }
        if (groupStandard.size() == 0) {
            groupStandard.add(Long.valueOf(DATATABLE_BGS));
        }
        if ((bizMap = BusinessDataServiceHelper.load((String)ENTRY_GROUPSTANDARD, (String)"id,number,name,createtime", (QFilter[])(filters = new QFilter[]{idFilter = new QFilter("id", "in", groupStandard)}), (String)"createtime asc")) == null || bizMap.length == 0) {
            return new ArrayList<Map<String, Object>>(0);
        }
        ArrayList<Map<String, Object>> listStandard = new ArrayList<Map<String, Object>>(bizMap.length);
        for (DynamicObject entry : bizMap) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", entry.get("id").toString());
            map.put("name", entry.get("name").toString());
            map.put("createtime", entry.get("createtime"));
            listStandard.add(map);
        }
        return listStandard;
    }

    private void setComboEdit(List<Map<String, Object>> stdList) {
        ComboEdit combo = (ComboEdit)this.getView().getControl(PROP_STANDARDLST);
        this.setComboValue(combo, stdList);
    }

    private void setComboValue(ComboEdit comboEdit, List<Map<String, Object>> stdList) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(stdList.size());
        for (Map<String, Object> map : stdList) {
            ComboItem item = new ComboItem();
            item.setValue((String)map.get("id"));
            item.setCaption(new LocaleString(map.get("name").toString()));
            comboItems.add(item);
        }
        comboEdit.setComboItems(comboItems);
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        TreeNode rootNode = this.getTreeModel().getRoot();
        if (rootNode == null || rootNode.getTreeNode(nodeId, 20) == null) {
            return;
        }
        this.treeListView.getTreeView().queryTreeNodeChildren(e.getParentNodeId().toString(), nodeId);
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        this.initTree();
    }

    private void initTree() {
        TreeNode root = this.getTreeModel().createRootNode();
        if (root != null) {
            root.setChildren(new ArrayList(0));
            this.getTreeModel().setRoot(root);
            String rootId = root.getId();
            this.getTreeModel().setCurrentNodeId((Object)rootId);
            logger.info("\u5206\u7c7b\u6807\u51c6\u6839\u8282\u70b9ID\u4e3a\uff1a" + rootId);
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        ITreeModel treeModel;
        String nodeId = e.getNodeId().toString();
        String isOpenAll = this.getPageCache().get("isOpenAll");
        boolean flag = false;
        if (isOpenAll != null && Boolean.TRUE.toString().equals(isOpenAll)) {
            flag = true;
        }
        String textFormat = "";
        ITreeListView treeView = this.getTreeListView();
        if (treeView != null && (treeModel = treeView.getTreeModel()) instanceof TreeListModel) {
            TreeListModel treeListModel = (TreeListModel)treeModel;
            textFormat = treeListModel.getTextFormat();
        }
        List<TreeNode> treeNodes = this.getTreeChildren(nodeId, flag, flag, textFormat);
        e.setChildNodes(treeNodes);
    }

    private List<TreeNode> getTreeChildren(String nodeId, boolean isGetAllSub, boolean isOpen, String textFormat) {
        Object value = this.getCurrentGroupStandard();
        if (StringUtils.isBlank((Object)value)) {
            return new ArrayList<TreeNode>();
        }
        Map<Object, DynamicObject> loadFromCache = this.loadGroupFromCache(nodeId, value);
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(loadFromCache.size());
        for (DynamicObject group : loadFromCache.values()) {
            if (group.getPkValue() == null) continue;
            treeNodes.add(this.getTreeNode(group, isGetAllSub, isOpen, textFormat));
        }
        return treeNodes;
    }

    private TreeNode getTreeNode(DynamicObject group, boolean isGetAllSub, boolean isOpen, String textFormat) {
        String text;
        TreeNode treeNode = new TreeNode();
        treeNode.setId(group.getPkValue().toString());
        treeNode.setParentid(group.get(PROP_PARENT) == null ? ROOTNODEID : group.getDynamicObject(PROP_PARENT).getPkValue().toString());
        String name = group.getLocaleString("name").getLocaleValue();
        String string = text = StringUtils.isBlank((CharSequence)name) ? group.getString("name") : name;
        if (StringUtils.isNotBlank((CharSequence)textFormat)) {
            text = textFormat.replace("{name}", text).replace("{code}", group.getString("number"));
        }
        treeNode.setText(text);
        treeNode.setLongNumber(group.getString("longnumber"));
        Object parentNode = group.get("isleaf");
        if (parentNode != null && !((Boolean)parentNode).booleanValue()) {
            if (isGetAllSub) {
                treeNode.addChildren(this.getTreeChildren(group.getPkValue().toString(), isGetAllSub, isOpen, textFormat));
            } else {
                treeNode.addChildren(new ArrayList());
            }
        }
        treeNode.setIsOpened(isOpen);
        return treeNode;
    }

    private Object getCurrentGroupStandard() {
        Object value = this.getModel().getValue(PROP_STANDARDLST);
        if (value == null) {
            value = DATATABLE_BGS;
        }
        return value;
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String createOrg = this.getPageCache().get(PGCACHE_CREATEORG);
        if (createOrg == null) {
            createOrg = String.valueOf(RequestContext.get().getOrgId());
        }
        QFilter qFilter4 = new QFilter("1", "=", (Object)1);
        if (createOrg != null) {
            Set<Long> orgSets = DataTableGroupListUtils.getOrgList(ENTITY_DATATABLEGROUP, Long.parseLong(createOrg));
            qFilter4 = orgSets.size() < 1 ? new QFilter(PROP_CREATE_ORG, "=", (Object)Long.parseLong(createOrg)) : new QFilter(PROP_CREATE_ORG, "in", orgSets);
        }
        e.addQFilter(qFilter4);
        e.setCancel(true);
    }

    private Map<Object, DynamicObject> loadGroupFromCache(String nodeId, Object value) {
        QFilter qFilter = new QFilter(PROP_STANDARD, "=", (Object)Long.parseLong(value.toString()));
        nodeId = ROOTNODEID.equals(nodeId) ? "0" : nodeId;
        QFilter qFilter2 = new QFilter(PROP_PARENT, "=", (Object)Long.parseLong(nodeId));
        QFilter qFilter3 = new QFilter("enable", "=", (Object)"1");
        QFilter qFilter4 = new QFilter("status", "=", (Object)"C");
        return BusinessDataServiceHelper.loadFromCache((String)ENTITY_DATATABLEGROUP, (String)"id,number,name,parent,longnumber,isleaf", (QFilter[])new QFilter[]{qFilter, qFilter2, qFilter3, qFilter4}, (String)"number");
    }

    public void expendTreeNode(TreeNodeEvent e) {
        TreeNode rootNode = this.getTreeModel().getRoot();
        String nodeId = (String)e.getNodeId();
        if ((rootNode != null && !StringUtils.isBlank((CharSequence)nodeId) ? rootNode.getTreeNode(nodeId, 20) : null) == null) {
            return;
        }
        TreeNode node = this.getTreeListView().getTreeModel().refreshNode((Object)nodeId);
        if (node == null) {
            return;
        }
        node.setIsOpened(true);
        e.setExpandedNode(node);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String nodeId = this.getTreeListView().getTreeView().getTreeState().getFocusNodeId();
        if (StringUtils.isEmpty((CharSequence)nodeId)) {
            nodeId = ROOTNODEID;
        }
        List qFilters = e.getQFilters();
        QFilter filter = null;
        for (int i = qFilters.size() - 1; i >= 0; --i) {
            QFilter f = (QFilter)qFilters.get(i);
            if (!f.getProperty().equals(PROP_CREATE_ORG)) continue;
            qFilters.remove(f);
        }
        String stdId = (String)this.getModel().getValue(PROP_STANDARDLST);
        if (StringUtils.isEmpty((CharSequence)stdId)) {
            stdId = DATATABLE_BGS;
        }
        if ((filter = GROUP_NG.equals(nodeId) ? this.getNGFilter() : (ROOTNODEID.equals(nodeId) && DATATABLE_BGS.equals(stdId) ? this.getRootNodeFilter() : this.genRefreshFilter(nodeId, stdId))) != null) {
            qFilters.add(filter);
        }
    }

    private QFilter getRootNodeFilter() {
        StringBuilder innerJoin = new StringBuilder();
        innerJoin.append("INNER JOIN (");
        innerJoin.append("SELECT fid FROM t_phm_datatable WHERE fid NOT IN (select ftargetdatatable from t_phm_metadata where fid in(select fid from t_phm_tablecontent where ftablegroup>0))");
        innerJoin.append(" union ");
        innerJoin.append("SELECT fid FROM t_phm_datatable WHERE fid IN (select ftargetdatatable from t_phm_metadata where fid in(select fid from T_PHM_TABLECONTENT where fgroupstandard = 890349491587243008 and ftablegroup>0))");
        innerJoin.append(") al ON al.fid = A.fid ");
        return QFilter.joinSQL((String)ENTRY_DATATABLE, (String)innerJoin.toString(), null);
    }

    private QFilter getNGFilter() {
        String innerJoin = "INNER JOIN (SELECT fid FROM t_phm_datatable WHERE fid NOT IN (select ftargetdatatable from t_phm_metadata where fid in(select fid from t_phm_tablecontent where ftablegroup>0))) uk ON uk.fid = A.fid ";
        return QFilter.joinSQL((String)ENTRY_DATATABLE, (String)innerJoin, null);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (PROP_STANDARDLST.equals(propertyName)) {
            TreeView treeView = this.getTreeListView().getTreeView();
            TreeNode root = this.getTreeModel().createRootNode();
            if (root == null) {
                this.treeListView.refreshTreeView();
            } else {
                this.treeListView.getTreeView().deleteAllNodes();
                treeView.addNode(root);
                treeView.treeNodeClick("", root.getId());
            }
            this.clearPageCache();
        }
    }

    private void clearPageCache() {
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        this.getPageCache().remove(searchNodesCacheKey);
        this.getPageCache().remove(matchNodesCacheKey);
        this.getPageCache().remove(oldSearchTextCacheKey);
        this.getPageCache().remove(searchIndexCacheKey);
    }
}

