/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.basemanager;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.mmc.phm.common.basemanager.LinkTypeEnum;

public class DataconnectionEdit
extends AbstractFormPlugin
implements RowClickEventListener {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String linktype = (String)this.getModel().getValue("linktype");
        if (this.isWebApi(linktype)) {
            this.showWebApi(linktype);
            this.setEntryMustInput(true);
        } else {
            this.showOther(linktype);
            this.setEntryMustInput(false);
        }
        if (StringUtils.equals((CharSequence)"self", (CharSequence)linktype)) {
            this.setMustInput(false);
        } else {
            this.setMustInput(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String e = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)"test", (CharSequence)e)) {
            long linkid = (Long)this.getModel().getValue("linkid");
            if (linkid == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u540e\u518d\u8fdb\u884c\u6d4b\u8bd5", (String)"DataconnectionEdit_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            DynamicObject linkObj = BusinessDataServiceHelper.loadSingle((Object)linkid, (String)"isc_database_link");
            if (linkObj == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u540e\u518d\u8fdb\u884c\u6d4b\u8bd5", (String)"DataconnectionEdit_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"testConnection", (Object[])new Object[]{linkObj.get("number")});
            boolean isSuccess = (Boolean)result.get("success");
            if (isSuccess) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6d4b\u8bd5\u6210\u529f\uff01", (String)"DataconnectionEdit_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6d4b\u8bd5\u5931\u8d25", (String)"DataconnectionEdit_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + result.get("message"));
                return;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData cd = e.getChangeSet()[0];
        Object newValue = cd.getNewValue();
        if (newValue != null && "linktype".equals(propertyName)) {
            String newValueStr = newValue.toString();
            if (this.isWebApi(newValueStr)) {
                this.showWebApi(newValueStr);
                this.setEntryMustInput(true);
            } else {
                this.showOther(newValueStr);
                this.setEntryMustInput(false);
            }
            this.setDefaultValue(newValueStr);
            if (StringUtils.equals((CharSequence)"self", (CharSequence)newValueStr)) {
                this.setMustInput(false);
            } else {
                this.setMustInput(true);
            }
        }
    }

    private void setMustInput(boolean isMustInput) {
        FieldEdit ip = (FieldEdit)this.getControl("ip");
        ip.setMustInput(isMustInput);
        FieldEdit host = (FieldEdit)this.getControl("host");
        host.setMustInput(isMustInput);
    }

    private void setEntryMustInput(boolean isMustInput) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.setMustInput("intmark", isMustInput);
        entryGrid.setMustInput("url", isMustInput);
        EntryProp entryProp = (EntryProp)this.getModel().getProperty("entryentity");
        entryProp.setEntryMustInput(isMustInput);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        String url = (String)this.getModel().getValue("url", evt.getRow());
        StringBuilder fullUrl = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            fullUrl.append(this.getModel().getValue("http")).append("://").append(this.getModel().getValue("ip")).append(':').append(this.getModel().getValue("host"));
            if (StringUtils.endsWith((CharSequence)url, (CharSequence)"/")) {
                fullUrl.append(url, 0, url.length() - 1);
            } else {
                fullUrl.append(url);
            }
        }
        this.getModel().setValue("allurl", (Object)fullUrl.toString());
        this.getModel().setValue("allurl_tag", (Object)fullUrl.toString());
    }

    private boolean isWebApi(String value) {
        return LinkTypeEnum.WEBAPI.getValue().equals(value) || LinkTypeEnum.CLOUDHUB.getValue().equals(value);
    }

    private void showWebApi(String value) {
        ArrayList<String> holdfieldslist = new ArrayList<String>();
        ArrayList<String> showfieldslist = new ArrayList<String>();
        holdfieldslist.add("appno");
        holdfieldslist.add("apppassword");
        holdfieldslist.add("accountid");
        holdfieldslist.add("tenantid");
        holdfieldslist.add("dbname");
        holdfieldslist.add("oracleservice");
        holdfieldslist.add("unicode");
        holdfieldslist.add("datacenter");
        holdfieldslist.add("easservice");
        holdfieldslist.add("webappname");
        holdfieldslist.add("proxyuser");
        holdfieldslist.add("language");
        showfieldslist.add("fieldsetpanelap1");
        showfieldslist.add("fieldsetpanelap11");
        showfieldslist.add("advconap1");
        showfieldslist.add("advconap");
        showfieldslist.add("fieldsetpanelap");
        if (LinkTypeEnum.WEBAPI.getValue().equals(value)) {
            showfieldslist.add("http");
        } else {
            holdfieldslist.add("http");
        }
        this.getView().setVisible(Boolean.FALSE, holdfieldslist.toArray(new String[holdfieldslist.size()]));
        this.getView().setVisible(Boolean.TRUE, showfieldslist.toArray(new String[showfieldslist.size()]));
    }

    private void showOther(String value) {
        ArrayList<String> holdfieldslist = new ArrayList<String>(50);
        ArrayList<String> showfieldslist = new ArrayList<String>(50);
        holdfieldslist.add("fieldsetpanelap1");
        holdfieldslist.add("fieldsetpanelap11");
        holdfieldslist.add("advconap1");
        holdfieldslist.add("advconap");
        if (LinkTypeEnum.ORACLE.getValue().equals(value)) {
            holdfieldslist.add("appno");
            holdfieldslist.add("apppassword");
            holdfieldslist.add("accountid");
            holdfieldslist.add("tenantid");
            holdfieldslist.add("dbname");
            holdfieldslist.add("unicode");
            holdfieldslist.add("datacenter");
            holdfieldslist.add("easservice");
            holdfieldslist.add("webappname");
            holdfieldslist.add("proxyuser");
            holdfieldslist.add("http");
            holdfieldslist.add("language");
            showfieldslist.add("oracleservice");
            showfieldslist.add("fieldsetpanelap");
        } else if (LinkTypeEnum.MYSQL.getValue().equals(value)) {
            holdfieldslist.add("appno");
            holdfieldslist.add("apppassword");
            holdfieldslist.add("accountid");
            holdfieldslist.add("tenantid");
            holdfieldslist.add("oracleservice");
            holdfieldslist.add("datacenter");
            holdfieldslist.add("easservice");
            holdfieldslist.add("webappname");
            holdfieldslist.add("proxyuser");
            holdfieldslist.add("http");
            holdfieldslist.add("language");
            showfieldslist.add("dbname");
            showfieldslist.add("unicode");
            showfieldslist.add("fieldsetpanelap");
        } else if (LinkTypeEnum.SQLSERVER.getValue().equals(value)) {
            holdfieldslist.add("appno");
            holdfieldslist.add("apppassword");
            holdfieldslist.add("accountid");
            holdfieldslist.add("tenantid");
            holdfieldslist.add("oracleservice");
            holdfieldslist.add("unicode");
            holdfieldslist.add("datacenter");
            holdfieldslist.add("easservice");
            holdfieldslist.add("webappname");
            holdfieldslist.add("proxyuser");
            holdfieldslist.add("http");
            holdfieldslist.add("language");
            showfieldslist.add("dbname");
            showfieldslist.add("fieldsetpanelap");
        } else if (LinkTypeEnum.EAS.getValue().equals(value)) {
            holdfieldslist.add("appno");
            holdfieldslist.add("apppassword");
            holdfieldslist.add("accountid");
            holdfieldslist.add("tenantid");
            holdfieldslist.add("dbname");
            holdfieldslist.add("oracleservice");
            holdfieldslist.add("unicode");
            holdfieldslist.add("webappname");
            holdfieldslist.add("language");
            showfieldslist.add("datacenter");
            showfieldslist.add("easservice");
            showfieldslist.add("proxyuser");
            showfieldslist.add("http");
            showfieldslist.add("fieldsetpanelap");
        } else if (LinkTypeEnum.K3CLOUD.getValue().equals(value)) {
            holdfieldslist.add("appno");
            holdfieldslist.add("apppassword");
            holdfieldslist.add("accountid");
            holdfieldslist.add("tenantid");
            holdfieldslist.add("dbname");
            holdfieldslist.add("oracleservice");
            holdfieldslist.add("unicode");
            holdfieldslist.add("easservice");
            holdfieldslist.add("proxyuser");
            showfieldslist.add("datacenter");
            showfieldslist.add("webappname");
            showfieldslist.add("language");
            showfieldslist.add("http");
            showfieldslist.add("fieldsetpanelap");
        } else if (LinkTypeEnum.IERP.getValue().equals(value)) {
            holdfieldslist.add("dbname");
            holdfieldslist.add("oracleservice");
            holdfieldslist.add("unicode");
            holdfieldslist.add("datacenter");
            holdfieldslist.add("easservice");
            showfieldslist.add("appno");
            showfieldslist.add("apppassword");
            showfieldslist.add("accountid");
            showfieldslist.add("tenantid");
            showfieldslist.add("webappname");
            showfieldslist.add("proxyuser");
            showfieldslist.add("http");
            showfieldslist.add("language");
            showfieldslist.add("fieldsetpanelap");
        } else if (LinkTypeEnum.DBPROXY.getValue().equals(value)) {
            holdfieldslist.add("appno");
            holdfieldslist.add("apppassword");
            holdfieldslist.add("accountid");
            holdfieldslist.add("tenantid");
            holdfieldslist.add("oracleservice");
            holdfieldslist.add("unicode");
            holdfieldslist.add("datacenter");
            holdfieldslist.add("easservice");
            holdfieldslist.add("webappname");
            holdfieldslist.add("proxyuser");
            holdfieldslist.add("language");
            showfieldslist.add("dbname");
            showfieldslist.add("http");
            showfieldslist.add("fieldsetpanelap");
        } else if (LinkTypeEnum.SELF.getValue().equals(value)) {
            holdfieldslist.add("fieldsetpanelap");
        }
        this.getView().setVisible(Boolean.FALSE, holdfieldslist.toArray(new String[holdfieldslist.size()]));
        this.getView().setVisible(Boolean.TRUE, showfieldslist.toArray(new String[showfieldslist.size()]));
    }

    private void setDefaultValue(String value) {
        if (LinkTypeEnum.ORACLE.getValue().equals(value)) {
            this.getModel().setValue("host", (Object)1521);
            this.getModel().setValue("oracleservice", (Object)"orcl");
            this.getModel().setValue("loginuser", null);
        } else if (LinkTypeEnum.MYSQL.getValue().equals(value)) {
            this.getModel().setValue("host", (Object)3306);
            this.getModel().setValue("unicode", (Object)"utf-8");
            this.getModel().setValue("loginuser", null);
        } else if (LinkTypeEnum.SQLSERVER.getValue().equals(value)) {
            this.getModel().setValue("host", (Object)1433);
            this.getModel().setValue("loginuser", null);
        } else if (LinkTypeEnum.WEBAPI.getValue().equals(value)) {
            this.getModel().setValue("host", (Object)0);
            this.getModel().setValue("loginuser", null);
        } else if (LinkTypeEnum.EAS.getValue().equals(value)) {
            this.getModel().setValue("host", (Object)6888);
            this.getModel().setValue("loginuser", (Object)"db_proxy");
            this.getModel().setValue("easservice", (Object)"/isc/proxy/");
        } else if (LinkTypeEnum.K3CLOUD.getValue().equals(value)) {
            this.getModel().setValue("host", (Object)0);
            this.getModel().setValue("loginuser", null);
        } else if (LinkTypeEnum.IERP.getValue().equals(value)) {
            this.getModel().setValue("host", (Object)0);
            this.getModel().setValue("loginuser", null);
        } else if (LinkTypeEnum.DBPROXY.getValue().equals(value)) {
            this.getModel().setValue("host", (Object)0);
            this.getModel().setValue("loginuser", null);
        } else if (LinkTypeEnum.CLOUDHUB.getValue().equals(value)) {
            this.getModel().setValue("host", (Object)0);
            this.getModel().setValue("loginuser", null);
        }
    }
}

