/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.basemanager;

import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.impl.RequestContextRunnable;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ImportDataPlugin
extends AbstractFormPlugin
implements UploadListener,
ProgresssListener {
    protected static final Log logger = LogFactory.getLog(ImportDataPlugin.class);

    public void initialize() {
        super.initialize();
        String percent = this.getView().getPageCache().get("percent");
        if ("100".equals(percent)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap2", "btndetail"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2", "btndetail"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btndetail"});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
        attachmentPanel.addUploadListener((UploadListener)this);
        ProgressBar importBar = (ProgressBar)this.getControl("progressbarap");
        importBar.addProgressListener((ProgresssListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control con = (Control)evt.getSource();
        String key = con.getKey();
        if (StringUtils.equals((CharSequence)"btnok", (CharSequence)key)) {
            String importWay = (String)this.getModel().getValue("importway");
            this.getView().getPageCache().put("importway", importWay);
            String url = this.getView().getPageCache().get("url");
            if (StringUtils.isEmpty((CharSequence)url)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20Excle\u6587\u4ef6", (String)"ImportDataPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            List urlList = (List)SerializationUtils.fromJsonString((String)url, List.class);
            if (urlList.size() > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u540c\u65f6\u5904\u7406\u591a\u4e2aExcle\u6587\u4ef6", (String)"ImportDataPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            Map urlMap = (Map)urlList.get(0);
            String fileUrl = (String)urlMap.get("url");
            TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
            try {
                String[] queryParams = new URL(fileUrl).getQuery().split("&");
                HashMap<String, String> downloadFileParams = new HashMap<String, String>(1);
                int int_0 = 0;
                int int_1 = 1;
                for (String queryParam : queryParams) {
                    String[] p = queryParam.split("=");
                    downloadFileParams.put(p[int_0], p[int_1]);
                }
                TempFileCacheDownloadable.Content content = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
                InputStream inputStream = content.getInputStream();
                this.dealWorkbookDatas(inputStream);
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1", "btnclose", "btnok", "flexpanelap3"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap2"});
                ProgressBar importBar = (ProgressBar)this.getControl("progressbarap");
                importBar.setPercent(0, ResManager.loadKDString((String)"\u5bfc\u5165\u4e2d\uff0c\u8bf7\u52ff\u5173\u95ed\u754c\u9762", (String)"ImportDataPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                importBar.start();
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff1a%s", (String)"ImportDataPlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0])), new Object[]{e.getMessage()});
            }
        }
        if (StringUtils.equals((CharSequence)"btndetail", (CharSequence)key)) {
            String errormessage = this.getView().getPageCache().get("errormessage");
            if (StringUtils.isEmpty((CharSequence)errormessage)) {
                return;
            }
            List errorList = (List)SerializationUtils.fromJsonString((String)errormessage, List.class);
            StringBuffer errors = new StringBuffer();
            for (String error : errorList) {
                errors.append(error).append('\n');
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("ide_largertextedit");
            showParameter.setCustomParam("largeTextValue", (Object)errors);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    public void afterUpload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        List<Object> urlList = Arrays.asList(urls);
        String cachUrl = this.getView().getPageCache().get("url");
        if (StringUtils.isNotEmpty((CharSequence)cachUrl)) {
            List cachUrlList = (List)SerializationUtils.fromJsonString((String)cachUrl, List.class);
            cachUrlList.addAll(urlList);
            this.getView().getPageCache().put("url", SerializationUtils.toJsonString((Object)cachUrlList));
        } else {
            this.getView().getPageCache().put("url", SerializationUtils.toJsonString(urlList));
        }
    }

    public void afterRemove(UploadEvent evt) {
        Object[] delUrls = evt.getUrls();
        String cachUrl = this.getView().getPageCache().get("url");
        if (StringUtils.isNotEmpty((CharSequence)cachUrl)) {
            List cachUrlList = (List)SerializationUtils.fromJsonString((String)cachUrl, List.class);
            String delUrlUid = (String)((Map)delUrls[0]).get("uid");
            ArrayList<Map> delList = new ArrayList<Map>();
            for (int i = 0; i < cachUrlList.size(); ++i) {
                Map cachUrlMap = (Map)cachUrlList.get(i);
                String cachUrlUid = (String)cachUrlMap.get("uid");
                if (!StringUtils.equals((CharSequence)delUrlUid, (CharSequence)cachUrlUid)) continue;
                delList.add(cachUrlMap);
            }
            cachUrlList.removeAll(delList);
            this.getView().getPageCache().put("url", SerializationUtils.toJsonString((Object)cachUrlList));
        }
    }

    public void onProgress(ProgressEvent arg0) {
        int percent = Integer.parseInt(this.getPageCache().get("progress"));
        String countStr = this.getView().getPageCache().get("count") == null ? "0" : this.getView().getPageCache().get("count");
        String failCountStr = this.getView().getPageCache().get("failcount") == null ? "0" : this.getView().getPageCache().get("failcount");
        String excuteCountStr = this.getView().getPageCache().get("excutecount") == null ? "0" : this.getView().getPageCache().get("excutecount");
        int count = Integer.parseInt(countStr);
        int failcount = Integer.parseInt(failCountStr);
        int excutecount = Integer.parseInt(excuteCountStr);
        int successcount = excutecount - failcount;
        if (percent == 0) {
            RequestContext rc = RequestContextCreator.createForThreadPool();
            Object runnable = new RequestContextRunnable(new Runnable(){

                @Override
                public void run() {
                    ImportDataPlugin.this.startImportDatas();
                }
            }, rc);
            runnable = ThreadLifeCycleManager.wrapRunnable((Runnable)runnable);
            Thread thread = new Thread((Runnable)runnable);
            thread.start();
        }
        if (excutecount != count) {
            Double calPrecent = (double)excutecount / (double)count * 100.0;
            percent = calPrecent.intValue();
            if (percent == 0) {
                percent = 1;
            }
            arg0.setProgress(percent);
            this.getPageCache().put("progress", Integer.toString(percent));
        } else if (count != 0 && excutecount == count) {
            this.getView().getPageCache().get("errormessage");
            arg0.setProgress(100);
            arg0.setText(ResManager.loadKDString((String)"\u6210\u529f", (String)"ImportDataPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + successcount + ResManager.loadKDString((String)"\u6761\uff0c\u5931\u8d25", (String)"ImportDataPlugin_5", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + failcount + ResManager.loadKDString((String)"\u6761", (String)"ImportDataPlugin_6", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            this.getView().getPageCache().put("percent", "100");
            this.getView().setVisible(Boolean.TRUE, new String[]{"btndetail"});
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap2"});
    }

    private void dealWorkbookDatas(InputStream inputStream) throws Exception {
        XSSFWorkbook wb = (XSSFWorkbook)WorkbookFactory.create((InputStream)inputStream);
        XSSFSheet sheet = wb.getSheetAt(0);
        if (sheet == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u5185\u5bb9\u9519\u8bef\uff0c\u8bf7\u4f7f\u7528\u5f15\u51fa\u7684\u6a21\u677f", (String)"ImportDataPlugin_7", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
        XSSFRow firstRow = sheet.getRow(0);
        if (firstRow == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u5185\u5bb9\u9519\u8bef\uff0c\u8bf7\u4f7f\u7528\u5f15\u51fa\u7684\u6a21\u677f", (String)"ImportDataPlugin_7", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
        XSSFRow secondRow = sheet.getRow(1);
        if (secondRow == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u5185\u5bb9\u9519\u8bef\uff0c\u8bf7\u4f7f\u7528\u5f15\u51fa\u7684\u6a21\u677f", (String)"ImportDataPlugin_7", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
        HashMap<Integer, String> dataTypeMap = new HashMap<Integer, String>(1);
        StringBuffer columnStr = new StringBuffer();
        columnStr.append('(');
        for (int i = 0; i < firstRow.getLastCellNum(); ++i) {
            String columnName = firstRow.getCell(i).getStringCellValue();
            if (i == firstRow.getLastCellNum() - 1) {
                columnStr.append(columnName).append(')');
            } else {
                columnStr.append(columnName).append(',');
            }
            String columnType = secondRow.getCell(i).getStringCellValue();
            dataTypeMap.put(i, columnType);
        }
        String tableName = (String)this.getView().getFormShowParameter().getCustomParam("table");
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            return;
        }
        ArrayList<String> sqlList = new ArrayList<String>(1);
        for (int i = 2; i <= sheet.getLastRowNum(); ++i) {
            XSSFRow dataRow = sheet.getRow(i);
            String insertSql = "insert into " + tableName + columnStr + " values ( ";
            for (int j = 0; j < firstRow.getLastCellNum(); ++j) {
                String dataType = (String)dataTypeMap.get(j);
                XSSFCell dataCell = dataRow.getCell(j);
                Object data = null;
                if (StringUtils.equals((CharSequence)"BIGINT", (CharSequence)dataType) || StringUtils.equals((CharSequence)"DECIMAL", (CharSequence)dataType)) {
                    data = this.constractNumberValue(dataCell);
                    if (j != firstRow.getLastCellNum() - 1) {
                        insertSql = insertSql + data + ",";
                        continue;
                    }
                    insertSql = insertSql + data + ");";
                    continue;
                }
                if (StringUtils.equals((CharSequence)"NVARCHAR", (CharSequence)dataType) || StringUtils.equals((CharSequence)"NCLOB", (CharSequence)dataType)) {
                    data = this.constractStringValue(dataCell);
                    if (j != firstRow.getLastCellNum() - 1) {
                        insertSql = insertSql + data + ",";
                        continue;
                    }
                    insertSql = insertSql + data + ");";
                    continue;
                }
                if (!StringUtils.equals((CharSequence)"DATETIME", (CharSequence)dataType)) continue;
                data = this.constractDateValue(dataCell);
                insertSql = j != firstRow.getLastCellNum() - 1 ? insertSql + data + "," : insertSql + data + ");";
            }
            sqlList.add(insertSql);
        }
        if (sqlList.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u4e2d\u7684\u6587\u4ef6\u65e0\u6570\u636e", (String)"ImportDataPlugin_8", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
        this.getView().getPageCache().put("count", Integer.toString(sqlList.size()));
        this.getView().getPageCache().put("excutecount", "0");
        this.getView().getPageCache().put("failcount", "0");
        this.getPageCache().put("progress", "0");
        this.getView().getPageCache().putBigObject("sql", SerializationUtils.toJsonString(sqlList));
    }

    private void startImportDatas() {
        String sql = this.getView().getPageCache().getBigObject("sql");
        String importway = this.getView().getPageCache().get("importway");
        String table = (String)this.getView().getFormShowParameter().getCustomParam("table");
        if (StringUtils.isEmpty((CharSequence)sql)) {
            return;
        }
        List sqlList = (List)SerializationUtils.fromJsonString((String)sql, List.class);
        if (sqlList.isEmpty()) {
            return;
        }
        if (StringUtils.equals((CharSequence)"replace", (CharSequence)importway)) {
            String deleteSql = "delete from " + table + " ;";
            DB.execute((DBRoute)DBRoute.of((String)"phm"), (String)deleteSql);
        }
        this.excuteInsertSql(sqlList);
    }

    private Object constractNumberValue(XSSFCell cell) {
        Number data = null;
        if (cell == null) {
            return 0;
        }
        CellType cellType = cell.getCellType();
        if (cellType.equals((Object)CellType._NONE) || cellType.equals((Object)CellType.FORMULA) || cellType.equals((Object)CellType.ERROR) || cellType.equals((Object)CellType.BOOLEAN)) {
            data = 0;
        } else if (cellType.equals((Object)CellType.NUMERIC)) {
            String value = cell.getCTCell().getV();
            String plainStr = new BigDecimal(value).toPlainString();
            data = new BigDecimal(plainStr);
        } else if (cellType.equals((Object)CellType.STRING)) {
            try {
                data = new BigDecimal(cell.getStringCellValue());
            }
            catch (Exception e) {
                data = 0;
            }
        }
        return data;
    }

    private Object constractStringValue(XSSFCell cell) {
        String data = null;
        if (cell == null) {
            return data;
        }
        CellType cellType = cell.getCellType();
        if (cellType.equals((Object)CellType._NONE) || cellType.equals((Object)CellType.FORMULA) || cellType.equals((Object)CellType.ERROR)) {
            data = null;
        } else if (cellType.equals((Object)CellType.NUMERIC)) {
            String decStr = cell.getCTCell().getV();
            data = "'" + decStr + "'";
        } else if (cellType.equals((Object)CellType.STRING)) {
            data = "'" + cell.getStringCellValue() + "'";
        }
        return data;
    }

    private Object constractDateValue(XSSFCell cell) {
        Object data = null;
        if (cell == null) {
            return data;
        }
        CellType cellType = cell.getCellType();
        if (cellType.equals((Object)CellType._NONE) || cellType.equals((Object)CellType.FORMULA) || cellType.equals((Object)CellType.ERROR) || cellType.equals((Object)CellType.BOOLEAN)) {
            data = null;
        } else {
            if (cellType.equals((Object)CellType.NUMERIC)) {
                Date date = cell.getDateCellValue();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String dateStr = sdf.format(date);
                return "convert(DATETIME,'" + dateStr + "')";
            }
            if (cellType.equals((Object)CellType.STRING)) {
                data = null;
            }
        }
        return data;
    }

    private void excuteInsertSql(List<String> sqlList) {
        for (int i = 0; i < sqlList.size(); ++i) {
            String sql = sqlList.get(i);
            try {
                String excuteCountStr = this.getView().getPageCache().get("excutecount");
                int excuteCount = Integer.parseInt(excuteCountStr);
                this.getView().getPageCache().put("excutecount", Integer.toString(++excuteCount));
                DB.execute((DBRoute)DBRoute.of((String)"phm"), (String)sql);
                continue;
            }
            catch (Exception e) {
                logger.error("--\u5f15\u5165\u672a\u5168\u90e8\u6210\u529f--", (Throwable)e);
                List<String> errorList = new ArrayList<String>();
                String errormessage = this.getView().getPageCache().get("errormessage");
                if (StringUtils.isNotEmpty((CharSequence)errormessage)) {
                    errorList = (List)SerializationUtils.fromJsonString((String)errormessage, List.class);
                }
                errorList.add(ResManager.loadKDString((String)"\u7b2c", (String)"ImportDataPlugin_9", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + (i + 1) + ResManager.loadKDString((String)"\u884c\uff1a", (String)"ImportDataPlugin_10", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + e.getMessage());
                String fail = this.getView().getPageCache().get("failcount");
                int failCount = Integer.parseInt(fail);
                this.getView().getPageCache().put("failcount", Integer.toString(++failCount));
                this.getView().getPageCache().put("errormessage", SerializationUtils.toJsonString(errorList));
            }
        }
    }
}

