/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.basemanager;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.phm.common.util.FormOpener;
import kd.mmc.phm.formplugin.basemanager.DataTableGroupListUtils;

public class MetaDataEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener,
CellClickListener {
    private static final String PROP_TABLECONTENT = "tablecontent";
    private static final String PROP_STANDARD = "standard";
    private static final String PROP_TABLEGROUP = "tablegroup";
    private static final String PROP_GROUPSTANDARD = "groupstandard";
    private static final String PROP_TARGETDATATABLE = "targetdatatable";
    private static final String ENTITY_DATATABLE = "phm_datatable";
    private static final String DESTFIELDINFO = "destField";
    private static final String FIELD = "field";
    private static final String MASTERID = "masterid";
    private static final String PROP_ISMAINTABLE = "ismaintable";
    private static final String PROP_SOURCETABLE = "sourcetable";
    private static final String PROP_LINK = "link";
    private static final String PROP_APILINK = "apilink";
    private static final String PROP_REMARK = "remark";
    private static final String PROP_SCRIPT = "script";
    private static final String PROP_RESULT_JST = "result_jst";
    private static final String PROP_GET_SCRIPT = "get_script";
    private static final String PROP_GET_SRCTABLE = "get_srctable";
    private static final String PROP_PARAM_JST = "param_jst";
    private static final String PROP_SRCTABLE = "srctable";
    private static final String PROP_FIELDLINK = "fieldlink";
    private static final String PROP_SRC_TABLE = "src_table";
    private static final String PGCACHE_CREATEORG = "createOrg";
    private static final String MAINENTITY = "phm_metadatamanager";
    private static final String PROP_FIELDNAME = "fieldname";
    private static final String ROW = "$row";
    private static final String TYPE = "$type";
    private static final String ENTRY_ISC_DATA_SOURCE = "isc_data_source";
    private static final String ENTRY_ISC_METADATA_SCHEMA = "isc_metadata_schema";
    private static final String PROP_ISC_DATASRCID = "isc_ds_id";
    private static final String PROP_TABLE = "table";
    private static final String PROP_FULLNAME = "fullname";
    private static final String CACHE_OLDTABLE = "oldtable";
    private static final String CACHE_OLDTABLENAME = "oldtablename";
    private static final String CACHE_OLDLINKNUM = "oldlinknum";
    private static final String PROP_SRCTABLENAME = "srctablename";
    private static final String PROP_NUMBER = "number";
    private static final String PROP_ENTRYENTITY = "entryentity";
    private static final String PROP_DESTFIELDNAME = "destfieldname";
    private static final String PROP_DESTFIELDTYPE = "destfieldtype";
    private static final String PROP_DESTPKFIELD = "destpkfield";

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        ChangeData[] cd = e.getChangeSet();
        if (fieldKey.equalsIgnoreCase(DESTFIELDINFO)) {
            this.setBaseInfo(cd);
        } else if (fieldKey.equalsIgnoreCase(PROP_ISMAINTABLE)) {
            this.pkCheck(cd);
        }
    }

    private void doAfterSrcTableChange(int index) {
        Object newTable;
        String oldTable = this.getPageCache().get(CACHE_OLDTABLE);
        int op = this.getOp(oldTable, newTable = this.getModel().getValue(PROP_SRCTABLE, index));
        if (op == 1 && !this.srcTableCheck(index, op)) {
            this.addSrcField(index);
        } else if (op == 2) {
            this.delColInfo(oldTable.toString());
        } else if (op == 3 && !this.srcTableCheck(index, op)) {
            this.delColInfo(oldTable.toString());
            this.addSrcField(index);
        }
    }

    private int getOp(Object oldValue, Object newValue) {
        if (StringUtils.isEmpty((Object)oldValue) && StringUtils.isEmpty((Object)newValue)) {
            return 0;
        }
        if (StringUtils.isEmpty((Object)oldValue) && !StringUtils.isEmpty((Object)newValue)) {
            return 1;
        }
        if (!StringUtils.isEmpty((Object)oldValue) && StringUtils.isEmpty((Object)newValue)) {
            return 2;
        }
        if (oldValue.equals(newValue)) {
            return 4;
        }
        return 3;
    }

    private void delColInfo(String tableName) {
        DynamicObjectCollection entry = this.getModel().getEntryEntity(PROP_FIELDLINK);
        String linkNum = this.getPageCache().get(CACHE_OLDLINKNUM);
        tableName = linkNum + "-" + tableName;
        for (int i = entry.size() - 1; i >= 0; --i) {
            if (((DynamicObject)entry.get(i)).getString(PROP_SRC_TABLE) == null || !tableName.equalsIgnoreCase(((DynamicObject)entry.get(i)).getString(PROP_SRC_TABLE))) continue;
            this.getModel().deleteEntryRow(PROP_FIELDLINK, i);
        }
        this.getView().updateView(PROP_FIELDLINK);
    }

    private void addSrcField(int index) {
        DynamicObject linkObj = (DynamicObject)this.getModel().getValue(PROP_LINK, index);
        String linkNum = linkObj.getString(PROP_NUMBER);
        Long iscLinkId = linkObj.getLong("linkid");
        Long dsId = this.getISCDataSrouceID(iscLinkId);
        String table = this.getModel().getValue(PROP_SRCTABLE, index).toString();
        QFilter f1 = new QFilter("group", "=", (Object)dsId);
        QFilter f2 = new QFilter("table_name", "=", (Object)table);
        DynamicObject temp = QueryServiceHelper.queryOne((String)ENTRY_ISC_METADATA_SCHEMA, (String)"id", (QFilter[])new QFilter[]{f1, f2});
        Long id = temp.getLong("id");
        DynamicObject dataSchema = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTRY_ISC_METADATA_SCHEMA);
        DynamicObjectCollection fields = dataSchema.getDynamicObjectCollection("prop_entryentity");
        this.addSrcField(linkNum, table, fields);
    }

    private void addSrcField(String linkNum, String table, DynamicObjectCollection fields) {
        DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection(PROP_FIELDLINK);
        for (DynamicObject field : fields) {
            DynamicObject row = entry.addNew();
            int index = entry.size() - 1;
            row.set(PROP_SRC_TABLE, (Object)(linkNum + "-" + table));
            row.set("srcfield", (Object)field.getString("prop_name"));
            row.set("srcfieldname", (Object)field.getString("prop_label"));
            row.set("srcfieldtype", (Object)field.getString("data_type"));
            row.set("srcpkfield", (Object)field.getBoolean("is_primary_key"));
            this.destFieldAutoSet(row, index);
        }
        this.getView().updateView(PROP_FIELDLINK);
    }

    private void destFieldAutoSet(DynamicObject row, int index) {
        String fieldInfos = this.getPageCache().get(DESTFIELDINFO);
        JSONObject temp = JSONObject.parseObject((String)fieldInfos);
        if (temp == null) {
            return;
        }
        JSONArray entry = JSON.parseArray((String)temp.getString(PROP_ENTRYENTITY));
        String field = row.getString("srcfield");
        for (int i = 0; i < entry.size(); ++i) {
            JSONObject col = (JSONObject)entry.get(i);
            if (!field.equals(col.getString(PROP_FIELDNAME)) || this.isMaped(field, index)) continue;
            row.set(DESTFIELDINFO, (Object)field);
            row.set(PROP_DESTFIELDNAME, (Object)col.getString("fielddescription"));
            row.set(PROP_DESTFIELDTYPE, (Object)col.getString("fieldtype"));
            row.set(PROP_DESTPKFIELD, (Object)col.getBoolean("primarykey"));
        }
    }

    private boolean isMaped(String field, int index) {
        DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection(PROP_FIELDLINK);
        for (int i = 0; i < entry.size(); ++i) {
            DynamicObject row;
            String destField;
            if (i == index || StringUtils.isEmpty((Object)(destField = (row = (DynamicObject)entry.get(i)).getString(DESTFIELDINFO))) || !destField.equalsIgnoreCase(field)) continue;
            return true;
        }
        return false;
    }

    private boolean srcTableCheck(int index, int op) {
        DynamicObjectCollection entry = this.getModel().getEntryEntity(PROP_SOURCETABLE);
        for (int i = 0; i < entry.getRowCount(); ++i) {
            if (i == index || !this.sameRowCheck(i, index)) continue;
            String oldTable = op == 1 ? "" : this.getPageCache().get(CACHE_OLDTABLE);
            String oldTableName = op == 1 ? "" : this.getPageCache().get(CACHE_OLDTABLENAME);
            this.getModel().setValue(PROP_SRCTABLE, (Object)oldTable, index);
            this.getModel().setValue(PROP_SRCTABLENAME, (Object)oldTableName, index);
            this.getView().showMessage(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7684\u6e90\u8868\uff01", (String)"MetaDataEditPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean sameRowCheck(int row1, int row2) {
        if (this.getModel().getValue(PROP_LINK, row1) == null || this.getModel().getValue(PROP_LINK, row2) == null || this.getModel().getValue(PROP_SRCTABLE, row1) == null || this.getModel().getValue(PROP_SRCTABLE, row2) == null) {
            return false;
        }
        String linkId1 = ((DynamicObject)this.getModel().getValue(PROP_LINK, row1)).getString("id");
        String linkId2 = ((DynamicObject)this.getModel().getValue(PROP_LINK, row2)).getString("id");
        String table1 = this.getModel().getValue(PROP_SRCTABLE, row1).toString();
        String table2 = this.getModel().getValue(PROP_SRCTABLE, row2).toString();
        return linkId1.equals(linkId2) && table1.equalsIgnoreCase(table2);
    }

    private void pkCheck(ChangeData[] cd) {
        boolean newValue = (Boolean)cd[0].getNewValue();
        int index = cd[0].getRowIndex();
        int otherOpenRowIndex = this.hasOtherRowOpen(index);
        if (otherOpenRowIndex != -1 && newValue) {
            this.getModel().setValue(PROP_ISMAINTABLE, (Object)Boolean.FALSE, otherOpenRowIndex);
        } else if (otherOpenRowIndex == -1 && !newValue) {
            this.getModel().setValue(PROP_ISMAINTABLE, (Object)Boolean.TRUE, index);
            this.getView().showMessage(ResManager.loadKDString((String)"\u5fc5\u987b\u4e14\u53ea\u80fd\u8bbe\u7f6e\u4e00\u4e2a\u4e3b\u8868\uff01", (String)"MetaDataEditPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
    }

    private int hasOtherRowOpen(int currentRow) {
        DynamicObjectCollection entry = this.getModel().getEntryEntity(PROP_SOURCETABLE);
        for (int i = 0; i < entry.getRowCount(); ++i) {
            if (i == currentRow || !((Boolean)this.getModel().getValue(PROP_ISMAINTABLE, i)).booleanValue()) continue;
            return i;
        }
        return -1;
    }

    private void setBaseInfo(ChangeData[] cd) {
        String newValue = cd[0].getNewValue().toString();
        int index = cd[0].getRowIndex();
        if (StringUtils.isEmpty((Object)newValue)) {
            this.getModel().setValue(PROP_DESTFIELDNAME, (Object)"", index);
            this.getModel().setValue(PROP_DESTFIELDTYPE, (Object)"", index);
            this.getModel().setValue(PROP_DESTPKFIELD, (Object)Boolean.FALSE, index);
            return;
        }
        String fieldInfos = this.getPageCache().get(DESTFIELDINFO);
        JSONObject temp = JSONObject.parseObject((String)fieldInfos);
        if (temp == null) {
            return;
        }
        JSONArray entry = JSON.parseArray((String)temp.getString(PROP_ENTRYENTITY));
        for (int i = 0; i < entry.size(); ++i) {
            JSONObject col = (JSONObject)entry.get(i);
            if (!newValue.equalsIgnoreCase(col.getString(PROP_FIELDNAME))) continue;
            this.getModel().setValue(PROP_DESTFIELDNAME, (Object)col.getString("fielddescription"), index);
            this.getModel().setValue(PROP_DESTFIELDTYPE, (Object)col.getString("fieldtype"), index);
            this.getModel().setValue(PROP_DESTPKFIELD, (Object)col.getBoolean("primarykey"), index);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit tablegroup = (BasedataEdit)this.getView().getControl(PROP_TABLEGROUP);
        tablegroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit targetdatatable = (BasedataEdit)this.getView().getControl(PROP_TARGETDATATABLE);
        targetdatatable.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit link = (BasedataEdit)this.getView().getControl(PROP_LINK);
        link.addAfterF7SelectListener((AfterF7SelectListener)this);
        link.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit apiLink = (BasedataEdit)this.getView().getControl(PROP_APILINK);
        apiLink.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit destTable = (BasedataEdit)this.getView().getControl(PROP_TARGETDATATABLE);
        destTable.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid mappingEntries = (EntryGrid)this.getView().getControl(PROP_SOURCETABLE);
        mappingEntries.addCellClickListener((CellClickListener)this);
        this.addClickListeners(new String[]{"btn_param_script", "btn_result_script"});
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        String fieldKey = cellClickEvent.getFieldKey();
        if (fieldKey.equals(PROP_SRCTABLE)) {
            this.tableF7(cellClickEvent);
        }
    }

    private void cacheOldData(int index) {
        Object obj = this.getModel().getValue(PROP_LINK, index);
        if (obj != null) {
            this.getPageCache().put(CACHE_OLDLINKNUM, ((DynamicObject)obj).getString(PROP_NUMBER));
        }
        if ((obj = this.getModel().getValue(PROP_SRCTABLENAME, index)) != null) {
            this.getPageCache().put(CACHE_OLDTABLENAME, obj.toString());
        }
        if ((obj = this.getModel().getValue(PROP_SRCTABLE, index)) != null) {
            this.getPageCache().put(CACHE_OLDTABLE, obj.toString());
        }
    }

    private void tableF7(CellClickEvent cellClickEvent) {
        int index = cellClickEvent.getRow();
        DynamicObject rowEntity = this.getModel().getEntryRowEntity(PROP_SOURCETABLE, index);
        DynamicObject linkObj = rowEntity.getDynamicObject(PROP_LINK);
        if (linkObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u8fde\u63a5!", (String)"MetaDataEditPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.cacheOldData(index);
        Long iscLinkId = linkObj.getLong("linkid");
        Long dsId = this.getISCDataSrouceID(iscLinkId);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(PROP_ISC_DATASRCID, dsId);
        param.put(TYPE, cellClickEvent.getFieldKey());
        param.put(ROW, index);
        FormOpener.showForm((AbstractFormPlugin)this, (String)"phm_meta_srctablef7", (String)ResManager.loadKDString((String)"\u9009\u62e9\u6e90\u8868", (String)"MetaDataEditPlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]), param, (String)PROP_GET_SRCTABLE);
    }

    private Long getISCDataSrouceID(long linkId) {
        ORM orm = ORM.create();
        QFilter f2 = new QFilter("dblink", "=", (Object)linkId);
        DynamicObject iscDataSource = orm.queryOne(ENTRY_ISC_DATA_SOURCE, "id", new QFilter[]{f2});
        if (iscDataSource == null) {
            return 0L;
        }
        return iscDataSource.getLong("id");
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (src instanceof Button) {
            if ("btn_result_script".equals(((Button)src).getKey())) {
                params.put(PROP_REMARK, this.getModel().getValue(PROP_RESULT_JST));
                params.put(PROP_SCRIPT, this.getModel().getValue("result_jst_tag"));
                params.put(FIELD, PROP_RESULT_JST);
                FormOpener.showForm((AbstractFormPlugin)this, (String)"isc_script_editor", (String)ResManager.loadKDString((String)"\u811a\u672c\u7f16\u8f91", (String)"MetaDataEditPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]), params, (String)PROP_GET_SCRIPT);
            } else if ("btn_param_script".equals(((Button)src).getKey())) {
                params.put(PROP_REMARK, this.getModel().getValue(PROP_PARAM_JST));
                params.put(PROP_SCRIPT, this.getModel().getValue("param_jst_tag"));
                params.put(FIELD, PROP_PARAM_JST);
                FormOpener.showForm((AbstractFormPlugin)this, (String)"isc_script_editor", (String)ResManager.loadKDString((String)"\u811a\u672c\u7f16\u8f91", (String)"MetaDataEditPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]), params, (String)PROP_GET_SCRIPT);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        int index;
        super.closedCallBack(e);
        String action = e.getActionId();
        if (PROP_GET_SCRIPT.equals(action)) {
            this.setScript(e);
        } else if (PROP_GET_SRCTABLE.equals(action) && (index = this.writeBackTable(e)) > -1) {
            this.doAfterSrcTableChange(index);
        }
    }

    private int writeBackTable(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return -1;
        }
        Map map = (Map)returnData;
        if (!map.containsKey(ROW)) {
            return -1;
        }
        int index = Integer.parseInt(map.get(ROW).toString());
        DynamicObject row = this.getModel().getEntryRowEntity(PROP_SOURCETABLE, index);
        String type = map.get(TYPE).toString();
        String table = map.get(PROP_TABLE).toString();
        String fullname = map.get(PROP_FULLNAME).toString();
        row.set(type, (Object)table);
        row.set(PROP_SRCTABLENAME, (Object)fullname);
        row.set("retalemetaid", map.get("iscid"));
        this.getView().updateView(PROP_SOURCETABLE);
        return index;
    }

    private void setScript(ClosedCallBackEvent evt) {
        Map params = (Map)evt.getReturnData();
        if (params != null) {
            if (PROP_PARAM_JST.equals(params.get(FIELD))) {
                this.getModel().setValue(PROP_PARAM_JST, params.get(PROP_REMARK));
                this.getModel().setValue("param_jst_tag", params.get(PROP_SCRIPT));
                this.getView().updateView();
            } else if (PROP_RESULT_JST.equals(params.get(FIELD))) {
                this.getModel().setValue(PROP_RESULT_JST, params.get(PROP_REMARK));
                this.getModel().setValue("result_jst_tag", params.get(PROP_SCRIPT));
                this.getView().updateView();
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        int currentRow = evt.getRow();
        if (fieldKey.equalsIgnoreCase(PROP_TABLEGROUP)) {
            this.setTableGroupFilter(evt, currentRow);
        } else if (fieldKey.equalsIgnoreCase(PROP_APILINK)) {
            this.setAPILinkFilter(evt);
        } else if (fieldKey.equalsIgnoreCase(PROP_LINK)) {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.setMultiSelect(false);
            this.cacheOldData(currentRow);
        } else if (fieldKey.equalsIgnoreCase(PROP_TARGETDATATABLE)) {
            this.setDestTableSelFilter(evt);
        }
    }

    private void setDestTableSelFilter(BeforeF7SelectEvent evt) {
        Long org = this.getDefaultUseOrg();
        Set<Long> orgSet = DataTableGroupListUtils.getOrgList(MAINENTITY, org);
        QFilter filter = new QFilter("createorg", "in", orgSet);
        String innerJoin = "inner join (select fid from t_phm_datatable where fid not in(select distinct ftargetdatatable from t_phm_metadata)) ul ON ul.fid = A.fid";
        QFilter filter2 = QFilter.joinSQL((String)ENTITY_DATATABLE, (String)innerJoin, null);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(filter);
        filters.add(filter2);
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.setCustomParam(PGCACHE_CREATEORG, (Object)org.toString());
        showParameter.getListFilterParameter().setQFilters(filters);
    }

    private Long getDefaultUseOrg() {
        String createOrg = this.getPageCache().get(PGCACHE_CREATEORG);
        if (createOrg != null && !createOrg.isEmpty()) {
            return Long.parseLong(createOrg);
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("createorg");
        String string = createOrg = org == null ? null : org.getString("id");
        if (createOrg != null && !createOrg.isEmpty()) {
            return Long.parseLong(createOrg);
        }
        Long orgId = RequestContext.get().getOrgId();
        if (orgId == 0L) {
            orgId = 100000L;
        }
        return orgId;
    }

    private void setAPILinkFilter(BeforeF7SelectEvent evt) {
        QFilter qFilter = new QFilter("linktype", "=", (Object)"WebAPI");
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void setTableGroupFilter(BeforeF7SelectEvent evt, int currentRow) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(PROP_TABLECONTENT);
        DynamicObject row = (DynamicObject)entryEntity.get(currentRow);
        DynamicObject groupstandard = (DynamicObject)row.get(PROP_GROUPSTANDARD);
        if (groupstandard == null || groupstandard.getLong(MASTERID) == 0L) {
            return;
        }
        QFilter qFilter = new QFilter(PROP_STANDARD, "=", (Object)groupstandard.getLong(MASTERID));
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.setCustomParam(PROP_GROUPSTANDARD, (Object)groupstandard.getString(MASTERID));
        showParameter.setMultiSelect(false);
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        String fieldKey = ((BasedataEdit)evt.getSource()).getFieldKey();
        if (fieldKey.equalsIgnoreCase(PROP_TARGETDATATABLE)) {
            this.clearField();
            this.comBoInit();
            this.autoMap();
        } else if (fieldKey.equalsIgnoreCase(PROP_LINK)) {
            int currentIndex = evt.getCurrentRowIndex();
            Object obj = this.getModel().getValue(PROP_SRCTABLE, currentIndex);
            String tableName = this.getPageCache().get(CACHE_OLDTABLE);
            if (StringUtils.isEmpty((Object)obj)) {
                tableName = obj.toString();
            }
            this.getModel().setValue(PROP_SRCTABLE, (Object)"", currentIndex);
            this.getModel().setValue(PROP_SRCTABLENAME, (Object)"", currentIndex);
            this.delColInfo(tableName);
            if (this.hasOtherRowOpen(currentIndex) == -1) {
                this.getModel().setValue(PROP_ISMAINTABLE, (Object)Boolean.TRUE, currentIndex);
            }
        }
    }

    private void comBoInit() {
        DynamicObject targettable = (DynamicObject)this.getModel().getValue(PROP_TARGETDATATABLE);
        if (targettable == null) {
            return;
        }
        ORM orm = ORM.create();
        QFilter f1 = new QFilter(MASTERID, "=", targettable.get(MASTERID));
        DynamicObject tableInfo = orm.queryOne(ENTITY_DATATABLE, new QFilter[]{f1});
        DynamicObjectCollection cols = (DynamicObjectCollection)tableInfo.get(PROP_ENTRYENTITY);
        HashMap<String, String> colInfo = new HashMap<String, String>();
        for (DynamicObject col : cols) {
            String colName = col.getString(PROP_FIELDNAME);
            String coldescription = col.getString(PROP_FIELDNAME);
            colInfo.put(colName, coldescription);
        }
        String colInfos = SerializationUtils.toJsonString((Object)tableInfo);
        this.getPageCache().remove(DESTFIELDINFO);
        this.getPageCache().put(DESTFIELDINFO, colInfos);
        ComboEdit combo = (ComboEdit)this.getView().getControl(DESTFIELDINFO);
        this.setComboValue(combo, colInfo);
        ComboEdit comboField = (ComboEdit)this.getView().getControl(FIELD);
        this.setComboValue(comboField, colInfo);
    }

    private void clearField() {
        ComboEdit combo = (ComboEdit)this.getView().getControl(DESTFIELDINFO);
        combo.setComboItems(null);
        this.clearDestFieldInfo();
        DynamicObjectCollection rows = this.getModel().getEntryEntity("datacontent");
        int index = rows.getRowCount();
        for (int i = 0; i < index; ++i) {
            this.getModel().setValue(FIELD, (Object)"", i);
            this.getModel().setValue("lable", (Object)"", i);
            this.getModel().setValue(PROP_REMARK, (Object)"", i);
        }
    }

    private void clearDestFieldInfo() {
        DynamicObjectCollection rows = this.getModel().getEntryEntity(PROP_FIELDLINK);
        int index = rows.getRowCount();
        for (int i = 0; i < index; ++i) {
            this.getModel().setValue(DESTFIELDINFO, (Object)"", i);
            this.getModel().setValue(PROP_DESTFIELDNAME, (Object)"", i);
            this.getModel().setValue(PROP_DESTFIELDTYPE, (Object)"", i);
            this.getModel().setValue(PROP_DESTPKFIELD, (Object)Boolean.FALSE, i);
        }
    }

    private void setComboValue(ComboEdit comboEdit, Map<String, String> value) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(value.size());
        for (Map.Entry<String, String> entry : value.entrySet()) {
            ComboItem item = new ComboItem();
            item.setValue(entry.getKey());
            item.setCaption(new LocaleString(entry.getValue()));
            comboItems.add(item);
        }
        comboEdit.setComboItems(comboItems);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject targettable = (DynamicObject)this.getModel().getValue(PROP_TARGETDATATABLE);
        if (targettable != null) {
            this.comBoInit();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setGroupStandard();
    }

    private void setGroupStandard() {
        long createOrg = RequestContext.get().getOrgId();
        if (createOrg <= 0L) {
            return;
        }
        this.getModel().deleteEntryData(PROP_TABLECONTENT);
        Set<Long> groupStandard = DataTableGroupListUtils.getGroupStandard(ENTITY_DATATABLE, createOrg, true, null);
        for (Long standard : groupStandard) {
            int currentRow = this.getModel().createNewEntryRow(PROP_TABLECONTENT);
            this.getModel().setValue(PROP_GROUPSTANDARD, (Object)standard, currentRow);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (operateKey.equalsIgnoreCase("deleteentry")) {
            this.delColInfoBySrcTableDel();
        } else if (operateKey.equalsIgnoreCase("clearmap")) {
            this.clearDestFieldInfo();
        } else if (operateKey.equalsIgnoreCase("automap")) {
            this.autoMap();
        }
    }

    private void autoMap() {
        DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection(PROP_FIELDLINK);
        for (int i = 0; i < entry.size(); ++i) {
            this.destFieldAutoSet((DynamicObject)entry.get(i), i);
        }
        this.getView().updateView(PROP_FIELDLINK);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operationKey = evt.getOperateKey();
        if (operationKey.equals("syncmetaschema")) {
            // empty if block
        }
    }

    private void delColInfoBySrcTableDel() {
        EntryGrid eg = (EntryGrid)this.getView().getControl(PROP_SOURCETABLE);
        int[] selRows = eg.getSelectRows();
        for (int i = 0; i < selRows.length; ++i) {
            if (this.getModel().getValue(PROP_LINK, selRows[i]) == null) continue;
            this.getPageCache().put(CACHE_OLDLINKNUM, ((DynamicObject)this.getModel().getValue(PROP_LINK, selRows[i])).getString(PROP_NUMBER));
            String tableName = this.getModel().getValue(PROP_SRCTABLE, selRows[i]).toString();
            this.delColInfo(tableName);
        }
    }
}

