/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.basemanager;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.phm.common.basemanager.ColumnEntry;

public class MetaPropertiesF7FormPlugin
extends AbstractFormPlugin
implements SearchEnterListener,
RowClickEventListener {
    private static final String KEY_ENTRY_ENTITY = "entryentity";
    private static final String KEY_BTN_OK = "btn_ok";
    private static final String PROP_NUMBER = "number";
    private static final String PROP_IS_PRIMARY_KEY = "is_primary_key";
    private static final String PROP_DATA_TYPE = "data_type";
    private static final String PROP_DATA_SCHEMA = "data_schema";
    private static final String PROP_NAME = "name";
    private static final String ROW = "$row";
    private static final String TYPE = "$type";
    private static final String ID = "id";
    private static final String TABLETYPE = "tabletype";
    private static final String TABLE = "table";
    private static final String CACHE_COL = "colinfo";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map filters = formShowParameter.getCustomParams();
        if (!filters.containsKey(TABLETYPE)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6570\u636e\u8868\u7c7b\u578b!", (String)"MetaPropertiesF7FormPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!filters.containsKey(TABLE)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8868\u540d\u672a\u627e\u5230!", (String)"MetaPropertiesF7FormPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!filters.containsKey(ID)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5143\u6570\u636eID!", (String)"MetaPropertiesF7FormPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        Object obj = filters.get(ROW);
        if (obj != null) {
            this.getPageCache().put(ROW, obj.toString());
        }
        if ((obj = filters.get(TYPE)) != null) {
            this.getPageCache().put(TYPE, obj.toString());
        }
        this.initProperties(Long.parseLong(filters.get(ID).toString()), filters.get(TABLETYPE).toString(), filters.get(TABLE).toString());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTN_OK});
        EntryGrid entry = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
        entry.addRowClickListener((RowClickEventListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void search(SearchEnterEvent event) {
        String searchText = event.getText();
        this.innerSearch(searchText);
    }

    private void innerSearch(String searchText) {
        if (StringUtils.isEmpty((CharSequence)searchText)) {
            return;
        }
        String jsonColInfo = this.getPageCache().get(CACHE_COL);
        if (StringUtils.isEmpty((CharSequence)jsonColInfo)) {
            return;
        }
        JSONArray cols = JSON.parseArray((String)jsonColInfo);
        ArrayList<ColumnEntry> colList = new ArrayList<ColumnEntry>();
        for (int i = 0; i < cols.size(); ++i) {
            JSONObject col = (JSONObject)cols.get(i);
            if (!col.getString("colName").contains(searchText) && !col.getString("colDescribe").contains(searchText)) continue;
            ColumnEntry newCol = new ColumnEntry();
            newCol.setColName(col.getString("colName"));
            newCol.setColDescribe(col.getString("colDescribe"));
            newCol.setColType(col.getString("colType"));
            newCol.setIsPK(col.getBoolean("isPK"));
            colList.add(newCol);
        }
        this.showColInfo(colList);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals(KEY_BTN_OK)) {
            EntryGrid entry = (EntryGrid)this.getControl(KEY_ENTRY_ENTITY);
            int[] rows = entry.getSelectRows();
            if (rows.length == 1) {
                this.getView().returnDataToParent(this.getSelectedRowData(rows[0]));
                this.getView().close();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u6570\u636e\u6216\u9009\u62e9\u8d85\u8fc71\u884c!", (String)"MetaPropertiesF7FormPlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private Map<String, Object> getSelectedRowData(int row) {
        DynamicObject rowEntity = this.getModel().getEntryRowEntity(KEY_ENTRY_ENTITY, row);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(PROP_IS_PRIMARY_KEY, rowEntity.getBoolean(PROP_IS_PRIMARY_KEY));
        map.put(PROP_NUMBER, rowEntity.getString(PROP_NUMBER));
        map.put(PROP_NAME, rowEntity.getString(PROP_NAME));
        map.put(PROP_DATA_TYPE, rowEntity.getString(PROP_DATA_TYPE));
        map.put(PROP_DATA_SCHEMA, rowEntity.getString(PROP_DATA_SCHEMA));
        map.put(ROW, this.getPageCache().get(ROW));
        map.put(TYPE, this.getPageCache().get(TYPE));
        return map;
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        Map<String, Object> data = this.getSelectedRowData(evt.getRow());
        this.getView().returnDataToParent(data);
        this.getView().close();
    }

    private void initProperties(long metaId, String tableType, String table) {
        ArrayList<ColumnEntry> colList = new ArrayList();
        if (tableType.equals("1")) {
            colList = this.getSrcTableInfo(metaId, table);
        } else if (tableType.equals("2")) {
            colList = this.getDestTableInfo(table);
        }
        if (colList.size() <= 0) {
            return;
        }
        String colInfos = SerializationUtils.toJsonString(colList);
        this.getPageCache().remove(CACHE_COL);
        this.getPageCache().put(CACHE_COL, colInfos);
        this.showColInfo(colList);
    }

    private void showColInfo(List<ColumnEntry> colList) {
        DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection(KEY_ENTRY_ENTITY);
        this.getModel().deleteEntryData(KEY_ENTRY_ENTITY);
        for (ColumnEntry col : colList) {
            DynamicObject row = entry.addNew();
            row.set(PROP_NUMBER, (Object)col.getColName());
            row.set(PROP_NAME, (Object)col.getColDescribe());
            row.set(PROP_DATA_TYPE, (Object)col.getColType());
            row.set(PROP_IS_PRIMARY_KEY, (Object)col.getIsPK());
        }
        this.getView().updateView(KEY_ENTRY_ENTITY);
    }

    private List<ColumnEntry> getDestTableInfo(String table) {
        ArrayList<ColumnEntry> colList = new ArrayList<ColumnEntry>();
        ORM orm = ORM.create();
        QFilter f1 = new QFilter(PROP_NUMBER, "=", (Object)table);
        DynamicObject tableInfo = orm.queryOne("phm_datatable", new QFilter[]{f1});
        DynamicObjectCollection properties = tableInfo.getDynamicObjectCollection(KEY_ENTRY_ENTITY);
        for (DynamicObject p : properties) {
            ColumnEntry col = new ColumnEntry();
            col.setColName(table + "-" + p.getString("fieldname"));
            col.setColDescribe(p.getString("fielddescription"));
            col.setColType(p.getString("fieldtype"));
            col.setIsPK(Boolean.valueOf(p.getBoolean("primarykey")));
            colList.add(col);
        }
        return colList;
    }

    private List<ColumnEntry> getSrcTableInfo(Long metaId, String table) {
        ArrayList<ColumnEntry> colList = new ArrayList<ColumnEntry>();
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)metaId, (String)"phm_metadatamanager");
        DynamicObjectCollection properties = meta.getDynamicObjectCollection("fieldlink");
        for (DynamicObject p : properties) {
            if (!table.equalsIgnoreCase(p.getString("src_table"))) continue;
            ColumnEntry col = new ColumnEntry();
            col.setColName(p.getString("srcfield"));
            col.setColDescribe(p.getString("srcfieldname"));
            col.setColType(p.getString("srcfieldtype"));
            col.setIsPK(Boolean.valueOf(p.getBoolean("srcpkfield")));
            colList.add(col);
        }
        return colList;
    }
}

