/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.basemanager;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

public class SrcTableF7FromPlugin
extends AbstractFormPlugin
implements SearchEnterListener,
RowClickEventListener {
    private static final String KEY_ENTRY_ENTITY = "entryentity";
    private static final String KEY_BTN_OK = "btn_ok";
    private static final String ROW = "$row";
    private static final String TYPE = "$type";
    private static final String PROP_ISC_DATASRCID = "isc_ds_id";
    private static final String ENTITY_ISC_METADATA_SCHEMA = "isc_metadata_schema";
    private static final String PROP_TABLE = "table";
    private static final String PROP_FULLNAME = "fullname";
    private static final String PROP_ISCID = "iscid";
    private static final String CACHE_TABLE = "tableinfo";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map filters = formShowParameter.getCustomParams();
        if (!filters.containsKey(PROP_ISC_DATASRCID)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u6e90ID\u672a\u627e\u5230!", (String)"SrcTableF7FromPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        Object obj = filters.get(ROW);
        if (obj != null) {
            this.getPageCache().put(ROW, obj.toString());
        }
        if ((obj = filters.get(TYPE)) != null) {
            this.getPageCache().put(TYPE, obj.toString());
        }
        this.initProperties(Long.parseLong(filters.get(PROP_ISC_DATASRCID).toString()));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTN_OK});
        EntryGrid entry = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
        entry.addRowClickListener((RowClickEventListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void search(SearchEnterEvent event) {
        String searchText = event.getText();
        this.innerSearch(searchText);
    }

    private void innerSearch(String searchText) {
        if (StringUtils.isEmpty((CharSequence)searchText)) {
            return;
        }
        String tableInfo = this.getPageCache().get(CACHE_TABLE);
        if (StringUtils.isEmpty((CharSequence)tableInfo)) {
            return;
        }
        JSONArray tables = JSON.parseArray((String)tableInfo);
        ArrayList<Map<String, String>> tableList = new ArrayList<Map<String, String>>();
        for (int i = 0; i < tables.size(); ++i) {
            JSONObject table = (JSONObject)tables.get(i);
            if (!table.getString(PROP_TABLE).contains(searchText) && !table.getString(PROP_FULLNAME).contains(searchText)) continue;
            HashMap<String, String> tbInfo = new HashMap<String, String>();
            tbInfo.put(PROP_ISCID, table.getString(PROP_ISCID));
            tbInfo.put(PROP_TABLE, table.getString(PROP_TABLE));
            tbInfo.put(PROP_FULLNAME, table.getString(PROP_FULLNAME));
            tableList.add(tbInfo);
        }
        this.showTable(tableList);
        this.getView().updateView(KEY_ENTRY_ENTITY);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals(KEY_BTN_OK)) {
            EntryGrid entry = (EntryGrid)this.getControl(KEY_ENTRY_ENTITY);
            int[] rows = entry.getSelectRows();
            if (rows.length == 1) {
                this.getView().returnDataToParent(this.getSelectedRowData(rows[0]));
                this.getView().close();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u6570\u636e\u6216\u9009\u62e9\u8d85\u8fc71\u884c!", (String)"SrcTableF7FromPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private Map<String, Object> getSelectedRowData(int row) {
        DynamicObject rowEntity = this.getModel().getEntryRowEntity(KEY_ENTRY_ENTITY, row);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(PROP_ISCID, rowEntity.getString(PROP_ISCID));
        map.put(PROP_TABLE, rowEntity.getString(PROP_TABLE));
        map.put(PROP_FULLNAME, rowEntity.getString(PROP_FULLNAME));
        map.put(ROW, this.getPageCache().get(ROW));
        map.put(TYPE, this.getPageCache().get(TYPE));
        return map;
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        Map<String, Object> data = this.getSelectedRowData(evt.getRow());
        this.getView().returnDataToParent(data);
        this.getView().close();
    }

    private void initProperties(long dsId) {
        List<Map<String, String>> tableList = this.getTableInfo(dsId);
        this.showTable(tableList);
    }

    private void showTable(List<Map<String, String>> tableList) {
        if (tableList.size() <= 0) {
            return;
        }
        DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection(KEY_ENTRY_ENTITY);
        this.getModel().deleteEntryData(KEY_ENTRY_ENTITY);
        for (Map<String, String> table : tableList) {
            DynamicObject row = entry.addNew();
            row.set(PROP_ISCID, (Object)Long.parseLong(table.get(PROP_ISCID)));
            row.set(PROP_TABLE, (Object)table.get(PROP_TABLE));
            row.set(PROP_FULLNAME, (Object)table.get(PROP_FULLNAME));
        }
        this.getView().updateView(KEY_ENTRY_ENTITY);
    }

    private List<Map<String, String>> getTableInfo(Long dsId) {
        ArrayList<Map<String, String>> tableList = new ArrayList<Map<String, String>>();
        ORM orm = ORM.create();
        QFilter filter = new QFilter("group", "=", (Object)dsId);
        QFilter filter2 = new QFilter("type", "=", (Object)"TABLE");
        DynamicObjectCollection tables = orm.query(ENTITY_ISC_METADATA_SCHEMA, "id,table_name,full_name", new QFilter[]{filter, filter2});
        for (DynamicObject table : tables) {
            HashMap<String, String> tbInfo = new HashMap<String, String>();
            tbInfo.put(PROP_ISCID, table.getString("id"));
            tbInfo.put(PROP_TABLE, table.getString("table_name"));
            tbInfo.put(PROP_FULLNAME, table.getString("full_name"));
            tableList.add(tbInfo);
        }
        String tableInfo = SerializationUtils.toJsonString(tableList);
        this.getPageCache().remove(CACHE_TABLE);
        this.getPageCache().put(CACHE_TABLE, tableInfo);
        return tableList;
    }
}

