/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.basemanager.flow;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Delete;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.entity.operate.UnAudit;
import kd.bos.entity.operate.UnSubmit;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.mvc.base.BaseModel;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mmc.phm.common.EnableEnum;
import kd.mmc.phm.common.StatusEnum;
import kd.mmc.phm.common.enums.DealTypeEnum;
import kd.mmc.phm.common.util.FlowActiveUtil;
import kd.mmc.phm.common.util.FlowNode;
import kd.mmc.phm.common.util.FlowUtils;
import kd.mmc.phm.common.util.JsonUtil;
import kd.mmc.phm.common.util.basedata.RoleUtils;

public class FlowDefineEditPlugin
extends AbstractBillPlugIn
implements RowClickEventListener,
BeforeF7SelectListener,
TabSelectListener {
    private static final String KEY_CLOSE = "close";
    private static final String MILEPOST = "milepost";
    private static final String LANE = "lane";
    private static final String BASELENTH = "baselength";
    private static final Long DAY = 86400000L;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("flownodeentryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid entryGrid_ex = (EntryGrid)this.getControl("excutesubentryentity");
        entryGrid_ex.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"controlconf", "showfrontcondition", "showaftercondition", "accountabilityscalshow"});
        MulBasedataEdit role = (MulBasedataEdit)this.getControl("role");
        role.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit flownumber = (BasedataEdit)this.getControl("flownumber");
        flownumber.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit resource = (BasedataEdit)this.getControl("resource");
        resource.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit flowdefineconsts = (BasedataEdit)this.getControl("exflownumber");
        flowdefineconsts.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Tab tab = (Tab)this.getView().getControl("tabap1");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("flowleader", (Object)new Object[]{Long.valueOf(RequestContext.get().getUserId())});
        this.setAccountability(new BigDecimal(100), BigDecimal.ZERO, new BigDecimal(20), Boolean.FALSE, Boolean.FALSE, Boolean.FALSE);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.milepostFlexVisable(true, "");
        if (this.getPageCache().get("clear") == null) {
            Map<String, Object> mapData = this.getMapData("1", null);
            this.setCusData(mapData);
        }
        this.getPageCache().remove("clear");
        this.getExistQuoteList();
        this.setAccountabilityShow();
    }

    private void setAccountabilityShow() {
        Object value = this.getModel().getValue("accountabilityscal");
        if (value != null) {
            this.getModel().setValue("accountabilityscalshow", value);
        }
    }

    private Map<String, Object> getMapData(String sign, List<Map<String, Object>> meilpostListMessage) {
        String status;
        Object milepost;
        String flowConf;
        HashMap<String, Object> dataMap = new HashMap<String, Object>(8);
        List<Map<String, String>> milepostList = this.getMilepostOption();
        Map cellMap = this.getMilepostStageMessage(meilpostListMessage);
        Map<String, Object> astrictPosition = this.getAstrictPosition();
        dataMap.put("astrictPosition", astrictPosition);
        dataMap.put("milepostOption", milepostList);
        dataMap.put("defaultMilepost", ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91cc\u7a0b\u7891", (String)"FlowDefineEditPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        if ("1".equals(sign) && StringUtils.isNotEmpty((CharSequence)(flowConf = (String)this.getModel().getValue("flowconf_tag")))) {
            this.putMeilpostListMessageToCache(meilpostListMessage);
            Map cellMaps = (Map)JsonUtil.fromJsonString((String)flowConf, Map.class);
            cellMap = (Map)cellMaps.get("graphData");
            if (!"2".equals(this.getPageCache().get("tabselect"))) {
                this.buildCache(cellMap);
            }
        }
        if ((milepost = this.getModel().getValue(MILEPOST)) != null) {
            DynamicObject milepost_dyn = (DynamicObject)milepost;
            String name = milepost_dyn.getString("name");
            dataMap.put("defaultMilepost", name);
        }
        if (!StringUtils.equals((CharSequence)"A", (CharSequence)(status = (String)this.getModel().getValue("status")))) {
            dataMap.put("locked", Boolean.TRUE);
        }
        Map<String, Object> graphOptionMap = this.getBaseMessage();
        dataMap.put("graphData", cellMap);
        dataMap.put("graphOption", graphOptionMap);
        return dataMap;
    }

    private void buildCache(Map<String, Object> cellMap) {
        List cells = (List)cellMap.get("cells");
        for (Map map : cells) {
            Object shape = map.get("shape");
            if (shape == null || MILEPOST.equals(shape.toString()) || "edge".equals(shape.toString())) continue;
            String nodeId = (String)map.get("id");
            this.putNodeInfoToCache(map);
            Map<String, BigDecimal> nodeCycle = this.getNodeCycle();
            BigDecimal cycle = nodeCycle.get(nodeId);
            Map<String, Object> cycleRanges = this.getCycleRanges(nodeId, cycle);
            this.putModelMessageToCache(nodeId, cycleRanges);
        }
    }

    private void putModelMessageToCache(String nodeId, Map<String, Object> cycleRanges) {
        String modelMessage = this.getPageCache().get("modelMessage");
        HashMap<String, Map> modelMessageMap = modelMessage == null ? new HashMap<String, Map>(8) : (HashMap<String, Map>)SerializationUtils.deSerializeFromBase64((String)modelMessage);
        Map position = (Map)cycleRanges.get("position");
        modelMessageMap.put(nodeId, position);
        this.getPageCache().put("modelMessage", SerializationUtils.serializeToBase64(modelMessageMap));
    }

    private void putMeilpostListMessageToCache(List<Map<String, Object>> meilpostListMessage) {
        Object milepost = this.getModel().getValue(MILEPOST);
        DynamicObject dynamicObject = this.queryMilepost(milepost);
        if (dynamicObject != null) {
            this.setMilepostFieldValue(dynamicObject);
            meilpostListMessage = this.calcStageWidth(dynamicObject);
            this.setCellMapValue(meilpostListMessage);
            this.getPageCache().put("meilpost", SerializationUtils.serializeToBase64(meilpostListMessage));
        }
    }

    private Map<String, Object> getAstrictPosition() {
        HashMap<String, Object> astrictPosition = new HashMap<String, Object>(4);
        astrictPosition.put("startX", 30);
        astrictPosition.put("startY", 50);
        astrictPosition.put("endX", 1990);
        astrictPosition.put("endY", 900);
        return astrictPosition;
    }

    private void setCusData(Map<String, Object> dataMap) {
        CustomControl control = (CustomControl)this.getControl("process");
        CustomControl control1 = (CustomControl)this.getControl("process1");
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("isRunning", Boolean.FALSE);
        map.put("time", new Date());
        map.put("action", "init");
        map.put("data", dataMap);
        control.setData(map);
        control1.setData(map);
    }

    private Map<String, Object> getBaseMessage() {
        HashMap<String, Object> graphOptionMap = new HashMap<String, Object>(8);
        return graphOptionMap;
    }

    private Map<String, Object> getMilepostStageMessage(List<Map<String, Object>> meilpostListMessage) {
        HashMap<String, Object> cellMap = new HashMap<String, Object>(8);
        if (meilpostListMessage == null || meilpostListMessage.size() == 0) {
            HashMap<String, Integer> positionMap = new HashMap<String, Integer>(8);
            Object[] cell = new Object[1];
            HashMap<String, Object> mileMap = new HashMap<String, Object>(8);
            positionMap.put("x", 0);
            positionMap.put("y", 0);
            mileMap.put("id", "1");
            mileMap.put("shape", MILEPOST);
            mileMap.put("height", 0);
            mileMap.put("width", 0);
            mileMap.put("label", "1");
            mileMap.put("position", positionMap);
            cell[0] = mileMap;
            cellMap.put("cells", cell);
        } else {
            Object[] cell = this.setCellMapValue(meilpostListMessage);
            cellMap.put("cells", cell);
        }
        return cellMap;
    }

    private Object[] setCellMapValue(List<Map<String, Object>> meilpostListMessage) {
        Object[] cell = new Object[meilpostListMessage.size()];
        int i = 0;
        BigDecimal k = BigDecimal.ZERO;
        BigDecimal x = new BigDecimal("30");
        for (Map<String, Object> map : meilpostListMessage) {
            HashMap<String, Number> positionMap = new HashMap<String, Number>(8);
            HashMap<String, Object> mileMap = new HashMap<String, Object>(8);
            BigDecimal length = (BigDecimal)map.get("length");
            if (i == 0) {
                k = length;
                x = new BigDecimal("30");
            } else {
                x = x.add(k);
                k = length;
            }
            map.put("position", x.toPlainString() + "," + x.add(k).toPlainString());
            mileMap.put("id", map.get("id"));
            mileMap.put("shape", MILEPOST);
            mileMap.put("height", 900);
            mileMap.put("width", length);
            positionMap.put("x", x);
            positionMap.put("y", 0);
            mileMap.put("label", map.get("stagename"));
            mileMap.put("position", positionMap);
            cell[i] = mileMap;
            ++i;
        }
        this.getPageCache().put("meilpost", SerializationUtils.serializeToBase64(meilpostListMessage));
        return cell;
    }

    private void clearCanvas() {
        CustomControl control1 = (CustomControl)this.getControl("process1");
        CustomControl control = (CustomControl)this.getControl("process");
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        HashMap<String, Object> dataMap = new HashMap<String, Object>(8);
        dataMap.put("time", new Date());
        map.put("action", "clearGraph");
        dataMap.put("isClear", Boolean.TRUE);
        dataMap.put("milepostOption", this.getMilepostOption());
        dataMap.put("defaultMilepost", ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91cc\u7a0b\u7891", (String)"FlowDefineEditPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        map.put("data", dataMap);
        control1.setData(map);
        dataMap.put("111", 1);
        control.setData(map);
        this.getPageCache().put("clear", "clearCanvas");
    }

    private List<Map<String, String>> getMilepostOption() {
        Map<String, String> milepostMap = this.queryAllMilepost();
        ArrayList<Map<String, String>> milepostList = new ArrayList<Map<String, String>>(8);
        for (Map.Entry<String, String> mapEntry : milepostMap.entrySet()) {
            HashMap<String, String> milepostMessage = new HashMap<String, String>(8);
            milepostMessage.put("value", mapEntry.getKey());
            milepostMessage.put("label", mapEntry.getValue());
            milepostList.add(milepostMessage);
        }
        return milepostList;
    }

    private void getExistQuoteList() {
        Map<String, Map<String, List<String>>> quoteCacheMap = this.getQuoteCache();
        DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity("flownodeentryentity");
        for (DynamicObject entryEntity : entryEntitys) {
            DynamicObjectCollection dynamicObjectCollection = entryEntity.getDynamicObjectCollection("resourcesubentryentity");
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                String frontCondition = dynamicObject.getString("frontcondition_tag");
                String afterCondition = dynamicObject.getString("aftercondition_tag");
                String deliverablesNumber = dynamicObject.getString("deliverablesnumber");
                if (frontCondition != null && !frontCondition.isEmpty()) {
                    List frontList = (List)SerializationUtils.deSerializeFromBase64((String)frontCondition);
                    this.putValueToQuoteCacheMap("select", frontList, deliverablesNumber, quoteCacheMap);
                }
                if (afterCondition == null || afterCondition.isEmpty()) continue;
                List afterList = (List)SerializationUtils.deSerializeFromBase64((String)afterCondition);
                this.putValueToQuoteCacheMap("afterselect", afterList, deliverablesNumber, quoteCacheMap);
            }
        }
        this.putQuoteListToCache(quoteCacheMap);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.clearSelectFlowNode();
    }

    private void clearSelectFlowNode() {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        String resourceData = "{\"pagerows\":20,\"pr\":3,\"rowcount\":0,\"pagecount\":0,\"datacount\":0,\"phide\":true,\"dataindex\":{\"cprop\":13,\"role\":7,\"resource\":5,\"pid\":3,\"control\":6,\"controlconf\":8,\"l\":10,\"resourcetype\":4,\"s\":11,\"vi\":12,\"rk\":0,\"formula\":9,\"id\":2,\"seq\":1},\"pageindex\":1,\"isSplitPage\":false,\"rows\":[]}";
        String subFlowData = "{\"pagerows\":20,\"pr\":3,\"rowcount\":0,\"pagecount\":0,\"datacount\":0,\"phide\":true,\"dataindex\":{\"cprop\":9,\"s\":7,\"vi\":8,\"flownumber\":4,\"rk\":0,\"pid\":3,\"flowname\":5,\"id\":2,\"l\":6,\"seq\":1},\"pageindex\":1,\"isSplitPage\":false,\"rows\":[]}";
        clientViewProxy.setEntryProperty("resourcesubentryentity", "data", SerializationUtils.fromJsonString((String)resourceData, Map.class));
        clientViewProxy.setEntryProperty("flowsubentryentity", "data", SerializationUtils.fromJsonString((String)subFlowData, Map.class));
        this.getModel().beginInit();
        this.getModel().setValue("flownodecycle", null);
        this.getModel().setValue("nodenumber", null);
        this.getModel().setValue("begindates", null);
        this.getModel().setValue("enddates", null);
        this.getModel().setValue("flownodename", null);
        this.getModel().endInit();
        this.getView().updateView("flownodecycle");
        this.getView().updateView("nodenumber");
        this.getView().updateView("flownodename");
        this.getView().updateView("begindates");
        this.getView().updateView("enddates");
        this.getModel().setValue("focusnode", null);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)"controlconf", (CharSequence)key)) {
            this.openControlconfForm();
        } else if (StringUtils.equals((CharSequence)"showaftercondition", (CharSequence)key) || StringUtils.equals((CharSequence)"showfrontcondition", (CharSequence)key)) {
            this.openPage(key);
        } else if (StringUtils.equals((CharSequence)"accountabilityscalshow", (CharSequence)key)) {
            this.openAccountabilityPage();
        }
    }

    private void openAccountabilityPage() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("phm_accountability");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.getCustomParams().put("accountability", this.getPageCache().get("accountability"));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "accountability"));
        this.getView().showForm(formShowParameter);
    }

    private void openPage(String key) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("flownodeentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            return;
        }
        int selectRow = selectRows[0];
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("flownodeentryentity", selectRow);
        String nodeId = entryRowEntity.getString("nodeid");
        this.getPageCache().put("openKey", key);
        this.getPageCache().put("openPageNodeId", nodeId);
        this.actionSave();
    }

    private void openSelectConditionPage(String openKey, String eventArgs) {
        FormShowParameter showParameter = new FormShowParameter();
        HashMap<String, String> nodeIdAndName = new HashMap<String, String>(8);
        Map<String, List<DynamicObject>> conditionNode = this.getConditionNode(eventArgs, openKey, nodeIdAndName);
        String selectCondition = this.getSelectCondition(openKey);
        showParameter.setFormId("phm_selectcondition");
        showParameter.getCustomParams().put("dcmessage", SerializationUtils.serializeToBase64(conditionNode));
        showParameter.getCustomParams().put("selectcondition", selectCondition);
        showParameter.getCustomParams().put("nodeIdAndName", SerializationUtils.serializeToBase64(nodeIdAndName));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "select"));
        if (StringUtils.equals((CharSequence)"showaftercondition", (CharSequence)openKey)) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u540e\u7f6e\u6761\u4ef6\u9009\u62e9", (String)"FlowDefineEditPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "afterselect"));
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private String getSelectCondition(String key) {
        EntryGrid entryGrid_resource = (EntryGrid)this.getControl("resourcesubentryentity");
        int[] selectRows = entryGrid_resource.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            return "";
        }
        int selectRow_resource = selectRows[0];
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("resourcesubentryentity", selectRow_resource);
        String condition = "";
        condition = StringUtils.equals((CharSequence)"showaftercondition", (CharSequence)key) ? entryRowEntity.getString("aftercondition_tag") : entryRowEntity.getString("frontcondition_tag");
        return condition;
    }

    private Map<String, List<DynamicObject>> getConditionNode(String eventArgs, String openKey, Map<String, String> nodeIdAndName) {
        HashMap<String, List<DynamicObject>> dynMessage = new HashMap<String, List<DynamicObject>>(8);
        EntryGrid entryGrid = (EntryGrid)this.getControl("flownodeentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            return dynMessage;
        }
        String openPageNodeId = this.getPageCache().get("openPageNodeId");
        Map parentRelations = FlowUtils.getParentRelations((String)eventArgs);
        Map childRelations = FlowUtils.getChildRelations((String)eventArgs);
        ArrayList<String> nodeList = new ArrayList<String>();
        if (StringUtils.equals((CharSequence)"showaftercondition", (CharSequence)openKey)) {
            this.getBeforeOrAfterNode(childRelations, openPageNodeId, nodeList);
        } else {
            this.getBeforeOrAfterNode(parentRelations, openPageNodeId, nodeList);
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("flownodeentryentity");
        for (DynamicObject dynamicObject : entryEntity) {
            String nodeId = dynamicObject.getString("nodeid");
            String nodeName = dynamicObject.getString("nodename");
            if (!nodeList.contains(nodeId)) continue;
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("resourcesubentryentity");
            for (DynamicObject dynamicObject_resource : dynamicObjectCollection) {
                List dynamicObjectList = dynMessage.containsKey(nodeId) ? (List)dynMessage.get(nodeId) : new ArrayList();
                nodeIdAndName.put(nodeId, nodeName);
                dynamicObjectList.add(dynamicObject_resource);
                dynMessage.put(nodeId, dynamicObjectList);
            }
        }
        return dynMessage;
    }

    private void getBeforeOrAfterNode(Map<String, List<String>> Relations, String openPageNodeId, List<String> nodeList) {
        List<String> list;
        if (Relations.size() != 0 && (list = Relations.get(openPageNodeId)) != null) {
            for (String nodeId : list) {
                nodeList.add(nodeId);
                this.getBeforeOrAfterNode(Relations, nodeId, nodeList);
            }
        }
    }

    private void openControlconfForm() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("phm_controlconf");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        EntryGrid resourecEntry = (EntryGrid)this.getControl("resourcesubentryentity");
        int[] selectIndexs = resourecEntry.getSelectRows();
        if (selectIndexs == null || selectIndexs.length == 0) {
            return;
        }
        int selectIndex = selectIndexs[0];
        String resourceType = (String)this.getModel().getValue("resourcetype", selectIndex);
        if (resourceType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7c7b\u578b\u3002", (String)"FlowDefineEditPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection roles = (DynamicObjectCollection)this.getModel().getValue("depersonliable", selectIndex);
        if (roles == null || roles.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d23\u4efb\u4eba\u3002", (String)"FlowDefineEditPlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        String formula = (String)this.getModel().getValue("formula", selectIndex);
        formShowParameter.setCustomParam("formula", (Object)formula);
        formShowParameter.setCustomParam("entityName", (Object)resourceType);
        formShowParameter.setCustomParam("roleSize", (Object)roles.size());
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "formula"));
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"formula")) {
            this.formulaCloseCallBack(closedCallBackEvent);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"select") || StringUtils.equals((CharSequence)key, (CharSequence)"afterselect")) {
            this.conditionCloseCallBack(closedCallBackEvent, key);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"accountability")) {
            this.accountabilityCallBack(closedCallBackEvent);
        }
    }

    private void accountabilityCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        Map scale = (Map)returnData;
        this.setAccountability((BigDecimal)scale.get("funtion"), (BigDecimal)scale.get("flow"), (BigDecimal)scale.get("user"), (Boolean)scale.get("mon"), (Boolean)scale.get("qua"), (Boolean)scale.get("year"));
    }

    private void conditionCloseCallBack(ClosedCallBackEvent closedCallBackEvent, String key) {
        EntryGrid entryGrid;
        int[] selectRows;
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        Map<String, Map<String, List<String>>> quoteCache = this.getQuoteCache();
        ArrayList<String> list = new ArrayList<String>(8);
        List valueTextItems = (List)returnData;
        StringBuilder sb = new StringBuilder();
        for (ValueTextItem valueTextItem : valueTextItems) {
            String value = valueTextItem.getValue();
            sb.append(value).append(",");
            list.add(value);
        }
        String substring = "";
        if (sb.length() > 1) {
            substring = sb.substring(0, sb.length() - 1);
        }
        if ((selectRows = (entryGrid = (EntryGrid)this.getControl("resourcesubentryentity")).getSelectRows()) == null || selectRows.length == 0) {
            return;
        }
        int selectRow = selectRows[0];
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("resourcesubentryentity", selectRow);
        String deliverablesNumber = entryRowEntity.getString("deliverablesnumber");
        if (StringUtils.equals((CharSequence)key, (CharSequence)"select")) {
            entryRowEntity.set("frontcondition_tag", (Object)SerializationUtils.serializeToBase64(list));
            entryRowEntity.set("showfrontcondition", (Object)substring);
            this.getView().updateView("showfrontcondition", selectRows[0]);
        } else {
            entryRowEntity.set("aftercondition_tag", (Object)SerializationUtils.serializeToBase64(list));
            entryRowEntity.set("showaftercondition", (Object)substring);
            this.getView().updateView("showaftercondition", selectRows[0]);
        }
        this.putValueToQuoteCacheMap(key, list, deliverablesNumber, quoteCache);
        this.putQuoteListToCache(quoteCache);
    }

    private void putValueToQuoteCacheMap(String key, List<String> list, String deliverablesNumber, Map<String, Map<String, List<String>>> quoteCache) {
        List<String> quote;
        Map<String, List<String>> numberAndQuote = quoteCache.get(key);
        if (numberAndQuote == null) {
            numberAndQuote = new HashMap<String, List<String>>(8);
        }
        if ((quote = numberAndQuote.get(deliverablesNumber)) == null) {
            quote = new ArrayList<String>(8);
        }
        quote.addAll(list);
        numberAndQuote.put(deliverablesNumber, quote);
        quoteCache.put(key, numberAndQuote);
    }

    private void putQuoteListToCache(Map<String, Map<String, List<String>>> quoteCache) {
        this.getView().getPageCache().put("quoteCondition", SerializationUtils.serializeToBase64(quoteCache));
    }

    private Map<String, Map<String, List<String>>> getQuoteCache() {
        Map<String, Map<String, List<String>>> quoteConditions = new HashMap<String, Map<String, List<String>>>(8);
        String quoteCondition = this.getPageCache().get("quoteCondition");
        if (quoteCondition != null) {
            quoteConditions = (Map)SerializationUtils.deSerializeFromBase64((String)quoteCondition);
        }
        return quoteConditions;
    }

    private void formulaCloseCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        EntryGrid resourecEntry = (EntryGrid)this.getControl("resourcesubentryentity");
        int[] selectIndexs = resourecEntry.getSelectRows();
        if (selectIndexs == null || selectIndexs.length == 0) {
            return;
        }
        int selectIndex = selectIndexs[0];
        this.getModel().setValue("controlconf", returnData.get("controlconf"), selectIndex);
        this.getModel().setValue("formula", returnData.get("formula"), selectIndex);
        this.getModel().setValue("control", (Object)Boolean.TRUE, selectIndex);
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        String entryKey = ((EntryGrid)evt.getSource()).getEntryKey();
        if ("excutesubentryentity".equals(entryKey)) {
            this.setExflowdeleteButtonVisable(row);
        } else {
            if (row == -1) {
                this.clearSelectFlowNode();
                return;
            }
            String nodename = (String)this.getModel().getValue("nodename", row);
            Object nodecycle = this.getModel().getValue("nodecycle", row);
            Object nodecomplete = this.getModel().getValue("nodecomplete", row);
            Object nodedataisolation = this.getModel().getValue("nodedataisolation", row);
            Object begindate = this.getModel().getValue("begindate", row);
            Object enddate = this.getModel().getValue("enddate", row);
            Object personliables = this.getModel().getValue("personliable", row);
            Object liableorgs = this.getModel().getValue("liableorg", row);
            this.getModel().beginInit();
            this.getModel().setValue("begindates", begindate);
            this.getModel().setValue("enddates", enddate);
            this.getModel().setValue("personliables", personliables);
            this.getModel().setValue("liableorgs", liableorgs);
            this.getModel().setValue("flownodecycle", nodecycle);
            this.getModel().setValue("flownodename", (Object)nodename);
            this.getModel().setValue("complete", nodecomplete);
            this.getModel().setValue("dataisolation", nodedataisolation);
            this.getModel().endInit();
            this.getView().updateView("flownodecycle");
            this.getView().updateView("flownodename");
            this.getView().updateView("complete");
            this.getView().updateView("begindates");
            this.getView().updateView("enddates");
            this.getView().updateView("personliables");
            this.getView().updateView("liableorgs");
            this.getView().updateView("dataisolation");
        }
    }

    private void setExflowdeleteButtonVisable(int row) {
        if (row == -1) {
            return;
        }
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("excutesubentryentity", row);
        DynamicObject dynamicObject = entryRowEntity.getDynamicObject("exflownumber");
        List<String> initFlowModel = this.addFlowModel();
        if (dynamicObject != null && initFlowModel.contains(dynamicObject.getString("entrabill"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"exflowdelete"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"exflowdelete"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String key = property.getName();
        if (StringUtils.equals((CharSequence)"flownodecycle", (CharSequence)key)) {
            this.flowNodeCycleChange(e);
        } else if (StringUtils.equals((CharSequence)"control", (CharSequence)key)) {
            this.controlChange(e);
        } else if (StringUtils.equals((CharSequence)"controlconf", (CharSequence)key)) {
            this.controlConfChange(e);
        } else if (StringUtils.equals((CharSequence)"flownodename", (CharSequence)key)) {
            this.updateNodeName(e);
        } else if (StringUtils.equals((CharSequence)"resource", (CharSequence)key)) {
            this.resourceChange(e);
        } else if (StringUtils.equals((CharSequence)"complete", (CharSequence)key)) {
            this.nodeCompleteChange(e);
        } else if (StringUtils.equals((CharSequence)"dealtype", (CharSequence)key)) {
            this.dealTypeChange(e);
        } else if (StringUtils.equals((CharSequence)"dataisolation", (CharSequence)key)) {
            this.nodeDataisolationChange(e);
        } else if (StringUtils.equals((CharSequence)MILEPOST, (CharSequence)key)) {
            this.milepostChange(e);
        } else if (StringUtils.equals((CharSequence)"personliables", (CharSequence)key)) {
            this.nodeFiledChange(e, "personliable", "personliables");
        } else if (StringUtils.equals((CharSequence)"liableorgs", (CharSequence)key)) {
            this.nodeFiledChange(e, "liableorg", "liableorgs");
        } else if (StringUtils.equals((CharSequence)"showfrontcondition", (CharSequence)key) || StringUtils.equals((CharSequence)"showaftercondition", (CharSequence)key)) {
            this.conditionChange(key);
        } else if (StringUtils.equals((CharSequence)"warningcycle", (CharSequence)key) || StringUtils.equals((CharSequence)"seriousoverduecycle", (CharSequence)key)) {
            this.judgeDate(e, key);
        } else if (StringUtils.equals((CharSequence)"laneorgs", (CharSequence)key) || StringUtils.equals((CharSequence)"laneprojects", (CharSequence)key) || StringUtils.equals((CharSequence)"laneusers", (CharSequence)key) || StringUtils.equals((CharSequence)"laneroles", (CharSequence)key) || StringUtils.equals((CharSequence)"laneremakes", (CharSequence)key) || StringUtils.equals((CharSequence)"lanenames", (CharSequence)key) || StringUtils.equals((CharSequence)"laneorglevels", (CharSequence)key)) {
            this.setLaneEntryentityValue(e, key);
        } else if (StringUtils.equals((CharSequence)"role", (CharSequence)key)) {
            this.roleFiledChange(e);
        } else if (StringUtils.equals((CharSequence)"depersonliable", (CharSequence)key)) {
            this.personliableFiledChange(e);
        } else if (StringUtils.equals((CharSequence)"accountability", (CharSequence)key)) {
            this.changeAccounttabilty(e);
        } else if (StringUtils.equals((CharSequence)"accountabilityscalshow", (CharSequence)key)) {
            this.setOldValue(e);
        }
    }

    private void setOldValue(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        if (newValue == null || newValue.toString().isEmpty()) {
            this.getModel().beginInit();
            this.getModel().setValue("accountabilityscalshow", oldValue);
            this.getModel().endInit();
        }
    }

    private void changeAccounttabilty(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        if (newValue != null) {
            String value = newValue.toString();
            if ("0".equals(value)) {
                this.setAccountability(new BigDecimal(100), BigDecimal.ZERO, new BigDecimal(20), Boolean.FALSE, Boolean.FALSE, Boolean.FALSE);
            } else if ("1".equals(value)) {
                this.setAccountability(BigDecimal.ZERO, new BigDecimal(100), new BigDecimal(20), Boolean.FALSE, Boolean.FALSE, Boolean.FALSE);
            } else if ("2".equals(value)) {
                this.setAccountability(new BigDecimal(50), new BigDecimal(50), new BigDecimal(20), Boolean.FALSE, Boolean.FALSE, Boolean.FALSE);
            }
        }
    }

    private void dealTypeChange(PropertyChangedArgs e) {
        DynamicObjectCollection entryEntity;
        long count;
        Object newData = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if (DealTypeEnum.WAIT.getName().equals(newData) && (count = (entryEntity = this.getModel().getEntryEntity("resourcesubentryentity")).stream().filter(x -> DealTypeEnum.MANUAL.getName().equals(x.getString("dealtype"))).count()) == 0L) {
            if (this.getPageCache().get("wait") == null) {
                this.getPageCache().put("wait", "wait");
                this.getModel().setValue("dealtype", oldValue, rowIndex);
                this.getView().updateView("resourcesubentryentity", rowIndex, 3);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u4e3a\u624b\u5de5\u7684\u5904\u7406\u65b9\u5f0f\u65f6\u624d\u53ef\u9009\u62e9\u7b49\u5f85\u3002", (String)"FlowDefineEditPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            } else {
                this.getPageCache().put("wait", null);
                this.getModel().setValue("dealtype", oldValue, rowIndex);
                this.getView().updateView("resourcesubentryentity", rowIndex, 3);
            }
        }
    }

    private void nodeDataisolationChange(PropertyChangedArgs e) {
        Object newData = e.getChangeSet()[0].getNewValue();
        EntryGrid entryGrid = (EntryGrid)this.getControl("flownodeentryentity");
        int[] selectIndexs = entryGrid.getSelectRows();
        if (selectIndexs == null || selectIndexs.length == 0) {
            return;
        }
        int select = selectIndexs[0];
        this.getModel().beginInit();
        this.getModel().setValue("nodedataisolation", newData, select);
        this.getModel().endInit();
        this.getView().updateView("nodedataisolation", select);
    }

    private void nodeCompleteChange(PropertyChangedArgs e) {
        Object newData = e.getChangeSet()[0].getNewValue();
        EntryGrid entryGrid = (EntryGrid)this.getControl("flownodeentryentity");
        int[] selectIndexs = entryGrid.getSelectRows();
        if (selectIndexs == null || selectIndexs.length == 0) {
            return;
        }
        int select = selectIndexs[0];
        this.getModel().beginInit();
        this.getModel().setValue("nodecomplete", newData, select);
        this.getModel().endInit();
        this.getView().updateView("nodecomplete", select);
    }

    private void resourceChange(PropertyChangedArgs e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("resourcesubentryentity");
        int[] selectIndexs = entryGrid.getSelectRows();
        if (selectIndexs == null || selectIndexs.length == 0) {
            return;
        }
        int selectIndex = selectIndexs[0];
        IDataModel model = this.getModel();
        model.beginInit();
        model.setValue("role", null, selectIndex);
        model.endInit();
        this.getView().updateView("role", selectIndex);
    }

    protected void updateNodeName(PropertyChangedArgs e) {
        String newData = (String)e.getChangeSet()[0].getNewValue();
        EntryGrid entryGrid = (EntryGrid)this.getControl("flownodeentryentity");
        int[] selectIndexs = entryGrid.getSelectRows();
        if (selectIndexs == null || selectIndexs.length == 0) {
            this.getModel().beginInit();
            this.getModel().setValue("flownodename", null);
            this.getModel().endInit();
            this.getView().updateView("flownodename");
            return;
        }
        int selectIndex = selectIndexs[0];
        this.getModel().beginInit();
        this.getModel().setValue("nodename", (Object)newData, selectIndex);
        this.getModel().endInit();
        this.getView().updateView("nodename", selectIndex);
        CustomControl control = (CustomControl)this.getView().getControl("process");
        String upSelectid = (String)this.getModel().getValue("nodeid");
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(2);
        paramsMap.put("action", "updateOneNode");
        HashMap<String, String> data = new HashMap<String, String>(2);
        data.put("id", upSelectid);
        data.put("name", newData);
        paramsMap.put("data", data);
        control.setData(paramsMap);
    }

    private void controlConfChange(PropertyChangedArgs e) {
        String newData = (String)e.getChangeSet()[0].getNewValue();
        String oldValue = (String)e.getChangeSet()[0].getOldValue();
        EntryGrid entryGrid = (EntryGrid)this.getControl("resourcesubentryentity");
        int[] selectIndexs = entryGrid.getSelectRows();
        if (selectIndexs == null || selectIndexs.length == 0) {
            return;
        }
        int selectIndex = selectIndexs[0];
        if (StringUtils.isEmpty((CharSequence)newData)) {
            this.getModel().beginInit();
            this.getModel().setValue("controlconf", (Object)oldValue, selectIndex);
            this.getModel().endInit();
            this.getView().updateView("controlconf", selectIndex);
        }
    }

    private void controlChange(PropertyChangedArgs e) {
        Boolean newData = (Boolean)e.getChangeSet()[0].getNewValue();
        EntryGrid entryGrid = (EntryGrid)this.getControl("resourcesubentryentity");
        int[] selectIndexs = entryGrid.getSelectRows();
        if (selectIndexs == null || selectIndexs.length == 0) {
            return;
        }
        int selectIndex = selectIndexs[0];
        if (!newData.booleanValue()) {
            this.getModel().beginInit();
            this.getModel().setValue("controlconf", null, selectIndex);
            this.getModel().setValue("formula", null, selectIndex);
            this.getModel().endInit();
            this.getView().updateView("controlconf", selectIndex);
            this.getView().updateView("formula", selectIndex);
        }
    }

    private void flowNodeCycleChange(PropertyChangedArgs e) {
        Object newData = e.getChangeSet()[0].getNewValue();
        Object oldData = e.getChangeSet()[0].getOldValue();
        EntryGrid entryGrid = (EntryGrid)this.getControl("flownodeentryentity");
        int[] selectIndexs = entryGrid.getSelectRows();
        if (selectIndexs == null || selectIndexs.length == 0) {
            this.getModel().beginInit();
            this.getModel().setValue("flownodecycle", null);
            this.getModel().endInit();
            this.getView().updateView("flownodecycle");
            return;
        }
        int select = selectIndexs[0];
        this.getPageCache().put("nodecycle", select + "," + oldData + "," + newData);
        if (this.checkNodeRule(newData, select)) {
            return;
        }
        this.setNodeCycleAndEntryCycleValue(oldData.toString(), select);
    }

    private void setNodeCycleAndEntryCycleValue(String old_cycles, int select) {
        BigDecimal old_cycle = new BigDecimal(old_cycles);
        String three = this.getPageCache().get("three");
        if (old_cycle.compareTo(BigDecimal.ZERO) == 0 || three != null) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            dataEntity.beginInit();
            this.getModel().setValue("flownodecycle", (Object)old_cycle);
            this.getPageCache().remove("three");
            dataEntity.endInit();
        } else {
            this.getModel().setValue("flownodecycle", (Object)old_cycle);
        }
        this.getModel().beginInit();
        this.getModel().setValue("nodecycle", (Object)old_cycle, select);
        this.getModel().endInit();
        this.getView().updateView("nodecycle", select);
        this.getView().updateView("flownodecycle");
    }

    private boolean checkNodeRule(Object newData, int select) {
        this.checkMilepost();
        BigDecimal cycle = new BigDecimal(newData.toString());
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("flownodeentryentity", select);
        String nodeId = entryRowEntity.getString("nodeid");
        Map<String, Object> cycleRanges = this.getCycleRanges(nodeId, cycle);
        if (!this.checkCycle(cycleRanges, cycle, nodeId)) {
            return false;
        }
        if (this.getPageCache().get("nodecycle") != null) {
            String nodecycle = this.getPageCache().get("nodecycle");
            this.getPageCache().put("cycleRanges", SerializationUtils.serializeToBase64(cycleRanges));
            this.getPageCache().put("nodecycle", nodeId + "," + nodecycle);
            this.actionSave();
        } else {
            this.putModelMessageToCache(nodeId, cycleRanges);
            Map position = (Map)cycleRanges.get("position");
            this.updateOneNodePosition(nodeId, position);
            this.updateNodeCache(nodeId, position);
        }
        return true;
    }

    private void updateNodeCache(String nodeId, Map<String, BigDecimal> positions) {
        Map<String, Object> nodeInfoToCache = this.getNodeInfoToCache();
        Map nodeMessage = (Map)nodeInfoToCache.get(nodeId);
        Map size = (Map)nodeMessage.get("size");
        Map position = (Map)nodeMessage.get("position");
        position.put("x", positions.get("beginPostion"));
        position.put("y", positions.get("y"));
        size.put("width", positions.get("width"));
        size.put("height", positions.get("height"));
        this.getPageCache().put("nodeInfo", SerializationUtils.serializeToBase64(nodeInfoToCache));
    }

    private BigDecimal getSageBeginOrEndPosition(Map<String, Object> milepostMap_lastsec, String sign) {
        Object positions = milepostMap_lastsec.get("position");
        String[] split = positions.toString().split(",");
        BigDecimal position = "begin".equals(sign) ? new BigDecimal(split[0]) : new BigDecimal(split[1]);
        return position;
    }

    private boolean checkMilepost() {
        Object value = this.getModel().getValue(MILEPOST);
        DynamicObject dynamicObject = this.queryMilepost(value);
        if (dynamicObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u91cc\u7a0b\u7891\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u3002", (String)"FlowDefineEditPlugin_5", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
        if (dynamicObjectCollection.size() == 0) {
            return false;
        }
        return false;
    }

    private Date longTimeToDate(long l) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            String format = df.format(l);
            Date parse = df.parse(format);
            return parse;
        }
        catch (Exception e) {
            throw new KDBizException("longTimeToDate :" + e.getMessage());
        }
    }

    public Map<String, Object> getMilepostMap(int seq, List<Map<String, Object>> milepostList) {
        for (Map<String, Object> map : milepostList) {
            if ((Integer)map.get("seq") != seq) continue;
            return map;
        }
        return null;
    }

    private boolean checkCycle(Map<String, Object> cycleRanges, BigDecimal cycle, String nodeId) {
        BigDecimal total = (BigDecimal)cycleRanges.get("total");
        List middleFullStage = (List)cycleRanges.get("middleFullStage");
        BigDecimal min = (BigDecimal)cycleRanges.get("min");
        if (total.compareTo(cycle) < 0) {
            if (middleFullStage.size() >= 2) {
                this.getPageCache().put("three", "1");
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5468\u671f\u5927\u4e8e\u8282\u70b9\u6240\u5728\u7684\u9636\u6bb5\u7684\u603b\u65f6\u95f4\u3002", (String)"FlowDefineEditPlugin_6", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (middleFullStage.size() > 2 && min.compareTo(cycle) >= 0) {
            this.getPageCache().put("three", "1");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5468\u671f\u5c0f\u4e8e\u8282\u70b9\u6240\u5728\u7684\u9636\u6bb5\u7684\u6700\u77ed\u65f6\u95f4\u3002", (String)"FlowDefineEditPlugin_7", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private Map<String, Object> getCycleRanges(String nodeId, BigDecimal cycle) {
        Map<String, Object> nodeInfos = this.getNodeInfoToCache();
        List<Map<String, Object>> milepostList = this.getMilepostListToCache();
        Map nodeInfo = (Map)nodeInfos.get(nodeId);
        Map position = (Map)nodeInfo.get("position");
        BigDecimal x = new BigDecimal(position.get("x").toString());
        BigDecimal y = new BigDecimal(position.get("y").toString());
        Map size = (Map)nodeInfo.get("size");
        BigDecimal width = new BigDecimal(size.get("width").toString());
        BigDecimal height = new BigDecimal(size.get("height").toString());
        BigDecimal endx = x.add(width);
        List<Integer> middleFullStage = this.calcMiddleFullStage(milepostList, x, endx, nodeId);
        Map<String, BigDecimal> nodePosttion = this.getNodePosttion(middleFullStage, endx, x, cycle, milepostList);
        nodePosttion.put("y", y);
        nodePosttion.put("height", height);
        Map<String, Object> message = this.calcCycleRnage(middleFullStage, milepostList);
        nodePosttion.put("min", (BigDecimal)message.get("min"));
        message.put("position", nodePosttion);
        return message;
    }

    private Map<String, Object> getNodeInfoToCache() {
        String nodeInfo_cache = this.getPageCache().get("nodeInfo");
        HashMap<String, Object> nodeInfos = nodeInfo_cache != null ? (HashMap<String, Object>)SerializationUtils.deSerializeFromBase64((String)nodeInfo_cache) : new HashMap<String, Object>(8);
        return nodeInfos;
    }

    private List<Integer> calcMiddleFullStage(List<Map<String, Object>> milepostList, BigDecimal x, BigDecimal endx, String nodeId) {
        String beginmilepostStage = this.getMilepostStage(milepostList, x, endx, "begin");
        String endmilepostStage = this.getMilepostStage(milepostList, x, endx, "end");
        List<Integer> middleFullStage = this.getMiddleFullStage(beginmilepostStage, endmilepostStage);
        this.putMiddleFullStageToCache(middleFullStage, nodeId);
        return middleFullStage;
    }

    private Map<String, BigDecimal> getNodePosttion(List<Integer> middleFullStage, BigDecimal endx, BigDecimal x, BigDecimal cycle, List<Map<String, Object>> milepostList) {
        BigDecimal endPostion = BigDecimal.ZERO;
        BigDecimal beginPostion = BigDecimal.ZERO;
        BigDecimal width = BigDecimal.ZERO;
        HashMap<String, BigDecimal> position = new HashMap<String, BigDecimal>();
        if (middleFullStage.size() > 1) {
            BigDecimal surplus;
            Integer first = middleFullStage.get(0);
            Integer last = middleFullStage.get(middleFullStage.size() - 1);
            Map<String, Object> milepostMap_first = this.getMilepostMap(first, milepostList);
            Map<String, Object> milepostMap_last = this.getMilepostMap(last, milepostList);
            BigDecimal end_first = this.getSageBeginOrEndPosition(milepostMap_first, "end");
            BigDecimal begin_first = this.getSageBeginOrEndPosition(milepostMap_first, "begin");
            BigDecimal begin_last = this.getSageBeginOrEndPosition(milepostMap_last, "begin");
            BigDecimal end_last = this.getSageBeginOrEndPosition(milepostMap_last, "end");
            BigDecimal width_node = endx.subtract(x);
            BigDecimal multiply_firstStage = end_first.subtract(x);
            BigDecimal multiply_lastStage = endx.subtract(begin_last);
            BigDecimal ratio_lastStage = multiply_lastStage.divide(width_node, 4, RoundingMode.DOWN);
            BigDecimal ratio_firstStage = multiply_firstStage.divide(width_node, 4, RoundingMode.DOWN);
            BigDecimal first_day = ratio_firstStage.multiply(cycle);
            BigDecimal last_day = ratio_lastStage.multiply(cycle);
            BigDecimal lengthDay_first = this.getLengthDay(milepostMap_first);
            BigDecimal lengthDay_last = this.getLengthDay(milepostMap_last);
            BigDecimal length_firstStage = first_day.multiply(lengthDay_first);
            BigDecimal length_lastStage = last_day.multiply(lengthDay_last);
            endPostion = begin_last.add(length_lastStage.add(surplus = BigDecimal.ZERO));
            if (endPostion.compareTo(end_last) > 0) {
                surplus = endPostion.subtract(end_last);
                endPostion = end_last;
            }
            if ((beginPostion = end_first.subtract(length_firstStage.add(surplus))).compareTo(begin_first) < 0) {
                surplus = begin_first.subtract(beginPostion);
                beginPostion = begin_first;
                if ((endPostion = endPostion.add(surplus)).compareTo(end_last) > 0) {
                    endPostion = end_last;
                }
            }
            width = endPostion.subtract(beginPostion);
        } else if (middleFullStage.size() != 0) {
            Integer first = middleFullStage.get(0);
            Map<String, Object> milepostMap_first = this.getMilepostMap(first, milepostList);
            BigDecimal lengthDay = this.getLengthDay(milepostMap_first);
            BigDecimal end = this.getSageBeginOrEndPosition(milepostMap_first, "end");
            BigDecimal begin = this.getSageBeginOrEndPosition(milepostMap_first, "begin");
            BigDecimal addValue = endx.add(x);
            BigDecimal dividePos = addValue.divide(new BigDecimal("2"), 4, RoundingMode.DOWN);
            BigDecimal cyclePos = cycle.divide(new BigDecimal("2"), 4, RoundingMode.DOWN);
            BigDecimal subtract = cyclePos.multiply(lengthDay);
            endPostion = dividePos.add(subtract);
            BigDecimal surplus = BigDecimal.ZERO;
            if (endPostion.compareTo(end) > 0) {
                surplus = endPostion.subtract(end);
                endPostion = end;
            }
            if ((beginPostion = dividePos.subtract(subtract.add(surplus))).compareTo(begin) < 0) {
                surplus = begin.subtract(beginPostion);
                beginPostion = begin;
                endPostion = endPostion.add(surplus);
            }
            width = endPostion.subtract(beginPostion);
        }
        position.put("beginPostion", beginPostion);
        position.put("endPostion", endPostion);
        if (width.compareTo(BigDecimal.ZERO) == 0) {
            width = new BigDecimal("0.1");
        }
        position.put("width", width);
        return position;
    }

    private BigDecimal getLengthDay(Map<String, Object> milepostMap_first) {
        BigDecimal end = this.getSageBeginOrEndPosition(milepostMap_first, "end");
        BigDecimal begin = this.getSageBeginOrEndPosition(milepostMap_first, "begin");
        BigDecimal width = end.subtract(begin);
        BigDecimal baselength = (BigDecimal)milepostMap_first.get(BASELENTH);
        BigDecimal baseLenth_day = width.divide(baselength, 4, RoundingMode.DOWN);
        return baseLenth_day;
    }

    private void putMiddleFullStageToCache(List<Integer> middleFullStage, String nodeId) {
        String middleFullStages = this.getPageCache().get("middleFullStage");
        HashMap<String, List<Integer>> middleFullStageMap = middleFullStages != null ? (HashMap<String, List<Integer>>)SerializationUtils.deSerializeFromBase64((String)middleFullStages) : new HashMap<String, List<Integer>>();
        middleFullStageMap.put(nodeId, middleFullStage);
        this.getPageCache().put("middleFullStage", SerializationUtils.serializeToBase64(middleFullStageMap));
    }

    private Map<String, Object> calcCycleRnage(List<Integer> middleFullStage, List<Map<String, Object>> milepostList) {
        HashMap<String, Object> message = new HashMap<String, Object>();
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal mintotal = BigDecimal.ZERO;
        BigDecimal gayDay = BigDecimal.ZERO;
        BigDecimal preBaseLength = BigDecimal.ZERO;
        int size = middleFullStage.size();
        int k = -1;
        Date endTime = null;
        int j = 0;
        for (int i : middleFullStage) {
            for (Map<String, Object> map : milepostList) {
                if ((Integer)map.get("seq") != i) continue;
                BigDecimal baselength = new BigDecimal(map.get(BASELENTH).toString());
                if (k == -1) {
                    k = i;
                } else {
                    if (k == i - 1 && map.get("begintime") != null && endTime != null) {
                        long begintime = ((Date)map.get("begintime")).getTime() - endTime.getTime();
                        gayDay = gayDay.add(BigDecimal.valueOf(begintime).divide(BigDecimal.valueOf(86400000L), 4, RoundingMode.DOWN));
                    }
                    if (size == 2 && j == size - 1) {
                        mintotal = baselength.compareTo(preBaseLength) <= 0 ? baselength : preBaseLength;
                    }
                    if (size != 2 && j != size - 1) {
                        mintotal = mintotal.add(baselength);
                    }
                }
                endTime = (Date)map.get("endtime");
                total = total.add(baselength);
                preBaseLength = baselength;
                break;
            }
            ++j;
        }
        message.put("gayDay", gayDay);
        message.put("total", total);
        message.put("min", mintotal);
        message.put("middleFullStage", middleFullStage);
        message.put("milepostList", milepostList);
        return message;
    }

    private List<Integer> getMiddleFullStage(String beginmilepostStage, String endmilepostStage) {
        ArrayList<Integer> MiddleFullStage = new ArrayList<Integer>(8);
        if (beginmilepostStage == null || beginmilepostStage.isEmpty() || endmilepostStage == null || endmilepostStage.isEmpty()) {
            return MiddleFullStage;
        }
        int beginStage = Integer.parseInt(beginmilepostStage);
        int endStage = Integer.parseInt(endmilepostStage);
        for (int i = beginStage; i <= endStage; ++i) {
            MiddleFullStage.add(i);
        }
        return MiddleFullStage;
    }

    private void selectFlowNode(String nodeInfo) {
        if (nodeInfo == null) {
            return;
        }
        DynamicObjectCollection nodes = this.getModel().getEntryEntity("flownodeentryentity");
        for (DynamicObject node : nodes) {
            String nodeid = node.getString("nodeid");
            if (!StringUtils.equals((CharSequence)nodeid, (CharSequence)nodeInfo)) continue;
            int index = node.getInt("seq") - 1;
            this.getView().setEnable(Boolean.TRUE, new String[]{"exflowdelete"});
            this.getModel().setValue("focusnode", (Object)nodeid);
            this.getModel().beginInit();
            this.getModel().setValue("nodenumber", (Object)nodeid);
            this.getModel().setValue("liableorgs", node.get("liableorg"));
            this.getModel().endInit();
            this.getModel().setValue("personliables", node.get("personliable"));
            this.getView().updateView("nodenumber");
            this.getView().updateView("liableorgs");
            this.setExcutesubentryentityValue(node);
            this.selectFolwNodeRow(index, "flownodeentryentity");
            break;
        }
    }

    private void setExcutesubentryentityEnable(DynamicObject node, List<String> initFlowModel) {
        DynamicObjectCollection dynamicObjectCollection = node.getDynamicObjectCollection("excutesubentryentity");
        int i = 0;
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            DynamicObject dynamicObject_ex = dynamicObject.getDynamicObject("exflownumber");
            if (dynamicObject_ex != null && initFlowModel.contains(dynamicObject_ex.getString("entrabill"))) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"exflownumber"});
            } else {
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"exflownumber"});
            }
            ++i;
        }
    }

    private void setExcutesubentryentityValue(DynamicObject node) {
        DynamicObjectCollection dynamicObjectCollection = node.getDynamicObjectCollection("excutesubentryentity");
        List<String> initFlowModel = this.addFlowModel();
        this.setExcutesubentryentityEnable(node, initFlowModel);
        if (dynamicObjectCollection != null && dynamicObjectCollection.size() == 0) {
            Map<Object, DynamicObject> flowModelMap = this.queryFlowModel(initFlowModel);
            if (flowModelMap == null || flowModelMap.size() < initFlowModel.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd0\u63a7\u4e2d\u5fc3\u4e0d\u5b58\u5728\u76f8\u5e94\u5355\u636e\u7684\u6d41\u7a0b\u6a21\u677f\uff0c\u8bf7\u5148\u65b0\u589e\u6216\u8005\u542f\u52a8\u3002", (String)"FlowDefineEditPlugin_8", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                return;
            }
            for (Map.Entry<Object, DynamicObject> flowModel : flowModelMap.entrySet()) {
                DynamicObject value = flowModel.getValue();
                DynamicObject dynamicObject = dynamicObjectCollection.addNew();
                dynamicObject.set("exflownumber", (Object)value);
            }
        }
    }

    private Map<Object, DynamicObject> queryFlowModel(List<String> initFlowModel) {
        QFilter entrabill_qFilter = new QFilter("entrabillid.number", "in", initFlowModel);
        QFilter enable_qFilter = new QFilter("enable", "=", (Object)"enable");
        QFilter audit_qFilter = new QFilter("type", "=", (Object)"AuditFlow");
        Map flowModelMap = BusinessDataServiceHelper.loadFromCache((String)"wf_processdefinition", (QFilter[])new QFilter[]{entrabill_qFilter, enable_qFilter, audit_qFilter});
        return flowModelMap;
    }

    private List<String> addFlowModel() {
        ArrayList<String> flowModelList = new ArrayList<String>(8);
        flowModelList.add("phm_tasknotice");
        flowModelList.add("phm_taskunusualnotice");
        return flowModelList;
    }

    private void selectFolwNodeRow(int index, String sign) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(sign);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        entryGrid.selectRows(index);
        entryGrid.entryRowClick(Integer.valueOf(index));
    }

    public void addFlowNode(List<Map<String, Object>> nodeInfos) {
        if (nodeInfos == null) {
            return;
        }
        Object value = this.getModel().getValue(MILEPOST);
        Object userliable = null;
        Object liableorg = null;
        if (value != null) {
            userliable = ((DynamicObject)value).getDynamicObject("userliable").getPkValue();
            liableorg = ((DynamicObject)value).getDynamicObject("liableorg").getPkValue();
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter tvs = new TableValueSetter(new String[]{"nodeid", "nodename", "personliable", "liableorg"});
        for (Map<String, Object> nodeInfo : nodeInfos) {
            tvs.addRow(new Object[]{nodeInfo.get("id"), nodeInfo.get("name"), userliable, liableorg});
        }
        int[] index = model.batchCreateNewEntryRow("flownodeentryentity", tvs);
        this.selectCacheFolwNode();
        model.endInit();
        this.getView().updateView("flownodeentryentity");
    }

    private void selectCacheFolwNode() {
        String focusnodeId = (String)this.getModel().getValue("focusnode");
        int index = this.getNodeIndex(focusnodeId, "flownodeentryentity", "nodeid");
        this.selectFolwNodeRow(index, "flownodeentryentity");
    }

    private int getNodeIndex(String focusnodeId, String sign, String NodeSign) {
        DynamicObjectCollection nodes = this.getModel().getEntryEntity(sign);
        if (nodes == null) {
            return -1;
        }
        for (DynamicObject node : nodes) {
            String nodeid = node.getString(NodeSign);
            if (!StringUtils.equals((CharSequence)focusnodeId, (CharSequence)nodeid)) continue;
            return node.getInt("seq") - 1;
        }
        return -1;
    }

    public void deleteFlowNode(List<Map<String, Object>> nodeInfos) {
        if (nodeInfos == null) {
            return;
        }
        Set nodeids = nodeInfos.stream().map(k -> String.valueOf(k.get("id"))).collect(Collectors.toSet());
        for (String nodeid : nodeids) {
            this.removNodeCache(nodeid);
        }
        DynamicObjectCollection nodes = this.getModel().getEntryEntity("flownodeentryentity");
        int[] indexs = new int[nodeids.size()];
        int i = 0;
        String focusnodeId = (String)this.getModel().getValue("focusnode");
        for (DynamicObject node : nodes) {
            String nodeid = node.getString("nodeid");
            if (!nodeids.contains(nodeid)) continue;
            int seq = node.getInt("seq");
            indexs[i] = seq - 1;
            ++i;
            if (!StringUtils.equals((CharSequence)focusnodeId, (CharSequence)nodeid)) continue;
            this.getModel().setValue("focusnode", null);
        }
        if (i == 0) {
            return;
        }
        this.getModel().deleteEntryRows("flownodeentryentity", indexs);
        this.selectCacheFolwNode();
    }

    private void removNodeCache(String nodeid) {
        Map<String, Object> nodeInfoToCache = this.getNodeInfoToCache();
        if (nodeInfoToCache.containsKey(nodeid)) {
            nodeInfoToCache.remove(nodeid);
        }
        this.getPageCache().put("nodeInfo", SerializationUtils.serializeToBase64(nodeInfoToCache));
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String eventArgs = e.getEventArgs();
        switch (eventName) {
            case "addProcessNode": {
                this.addProcessNode(eventArgs);
                break;
            }
            case "deleteProcessNode": {
                this.deleteProcessNode(eventArgs);
                break;
            }
            case "clickProcessNode": {
                this.clickProcessNode(eventArgs);
                break;
            }
            case "saveProcess": {
                this.saveProcess(eventArgs);
                break;
            }
            case "reset": {
                this.clearFlowCustom();
                break;
            }
            case "clickProcessMilepost": {
                this.clickMilepost();
                break;
            }
            case "addProcessLane": {
                this.addLane(eventArgs);
                break;
            }
            case "setMilepost": {
                this.getModel().setValue(MILEPOST, (Object)eventArgs);
                this.getView().updateView(MILEPOST);
                break;
            }
            case "clickProcessLane": {
                this.clickLane(eventArgs);
                break;
            }
            case "nodeMoved": {
                this.nodeMoved(eventArgs);
                break;
            }
            case "nodeResized": {
                this.nodeResized(eventArgs);
                break;
            }
            case "connectedEdge": {
                this.connectedEdge(eventArgs);
                break;
            }
        }
    }

    private void connectedEdge(String eventArgs) {
        Map nodeInfo = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
        if (nodeInfo == null || nodeInfo.isEmpty()) {
            return;
        }
        String edgeId = (String)nodeInfo.get("edgeId");
        Map sourceNode = (Map)nodeInfo.get("sourceNode");
        if (this.checkNodeCycle(sourceNode, "sourceNode").booleanValue()) {
            Map targetNode = (Map)nodeInfo.get("targetNode");
            if (!this.checkNodeCycle(targetNode, "targetNode").booleanValue()) {
                this.deleteEdge(edgeId, "edgeId");
            } else {
                this.getPageCache().put("edge", eventArgs);
                this.actionSave();
            }
        } else {
            this.deleteEdge(edgeId, "edgeId");
        }
    }

    private void deleteEdge(String edgeId, String sign) {
        CustomControl control = (CustomControl)this.getControl("process");
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, String> oneEdgeObject = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> data = new HashMap<String, HashMap<String, String>>();
        map.put("time", new Date());
        map.put("action", "deleteOneCell");
        oneEdgeObject.put(sign, edgeId);
        data.put("oneCellObject", oneEdgeObject);
        map.put("data", data);
        control.setData(map);
    }

    private Boolean checkNodeCycle(Map<String, Object> nodeInfo, String sign) {
        BigDecimal nodecycle;
        String nodeId = (String)nodeInfo.get("id");
        DynamicObject nodeInfoDyn = this.getNodeInfoByNodeId(nodeId);
        if (nodeInfoDyn != null && ((nodecycle = (BigDecimal)nodeInfoDyn.get("nodecycle")) == null || BigDecimal.ZERO.compareTo(nodecycle) == 0)) {
            if ("sourceNode".equals(sign)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u6e90\u8282\u70b9\u7684\u5468\u671f", (String)"FlowDefineEditPlugin_9", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u76ee\u6807\u8282\u70b9\u7684\u5468\u671f", (String)"FlowDefineEditPlugin_10", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }

    private DynamicObject getNodeInfoByNodeId(String nodeId) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("flownodeentryentity");
        for (DynamicObject dynamicObject : entryEntity) {
            if (!nodeId.equals(dynamicObject.getString("nodeId"))) continue;
            return dynamicObject;
        }
        return null;
    }

    private void nodeResized(String eventArgs) {
        Map nodeInfo = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
        if (nodeInfo == null || nodeInfo.isEmpty()) {
            return;
        }
        String id = nodeInfo.get("id").toString();
        DynamicObject nodeInfoByNodeId = this.getNodeInfoByNodeId(id);
        if (nodeInfoByNodeId == null) {
            return;
        }
        BigDecimal nodecycle = nodeInfoByNodeId.getBigDecimal("nodecycle");
        if (nodecycle != null && nodecycle.compareTo(BigDecimal.ZERO) != 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u786e\u5b9a\u5468\u671f\u4e4b\u540e\u4e0d\u80fd\u62d6\u52a8\u8282\u70b9\u7684\u5927\u5c0f\u3002", (String)"FlowDefineEditPlugin_11", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            Map<String, Object> nodeInfoToCache = this.getNodeInfoToCache();
            Map nodeInfoTo_old = (Map)nodeInfoToCache.get(id);
            Object position = nodeInfoTo_old.get("position");
            Map size = (Map)nodeInfoTo_old.get("size");
            this.updateOneNodePosAndSize(id, position, size);
        } else {
            this.putNodeInfoToCache(nodeInfo);
        }
    }

    private void nodeMoved(String eventArgs) {
        Map nodeInfo = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
        if (nodeInfo == null || nodeInfo.isEmpty()) {
            return;
        }
        Map nowNode = (Map)nodeInfo.get("nodeMoved");
        String shape = nowNode.get("shape").toString();
        if ("x-rect".equals(shape) || "x-circle".equals(shape) || "x-diamond".equals(shape)) {
            this.checkNodePosition(nowNode, nodeInfo);
        } else if ("x-lane".equals(shape) || "y-lane".equals(shape)) {
            String id = nowNode.get("id").toString();
            if (this.isOverlapLane(nowNode)) {
                Map<String, Object> nodeInfoToCache = this.getNodeInfoToCache();
                Map nodeInfoTo_old = (Map)nodeInfoToCache.get(id);
                Object position = nodeInfoTo_old.get("position");
                this.updateOneNode(id, position, "position");
            } else {
                this.putNodeInfoToCache(nowNode);
            }
        }
    }

    private void checkNodePosition(Map<String, Object> nowNode, Map<String, Object> nodeInfo) {
        BigDecimal beginNow_x = this.getBeginOrEndX(nowNode, "begin");
        BigDecimal endNow_x = this.getBeginOrEndX(nowNode, "end");
        List frontNodes = (List)nodeInfo.get("frontNodes");
        ArrayList<String> nodeIds = new ArrayList<String>();
        List afterNodes = (List)nodeInfo.get("afterNodes");
        for (Map frontNode : frontNodes) {
            BigDecimal endotherNode_x = this.getBeginOrEndX(frontNode, "end");
            if (beginNow_x.compareTo(endotherNode_x) >= 0) continue;
            nodeIds.add(frontNode.get("id").toString());
        }
        for (Map afterNode : afterNodes) {
            BigDecimal otherNode_x = this.getBeginOrEndX(afterNode, "begin");
            if (endNow_x.compareTo(otherNode_x) <= 0) continue;
            nodeIds.add(afterNode.get("id").toString());
        }
        if (nodeIds.size() != 0) {
            for (String nodeId : nodeIds) {
                this.updateOneNode(nodeId, "red", "bgColor");
            }
            String nodeId = (String)nowNode.get("id");
            this.updateOneNode(nodeId, "red", "bgColor");
            nodeIds.add(nodeId);
            this.getPageCache().put("updateNode", SerializationUtils.serializeToBase64(nodeIds));
            this.getPageCache().put("nowNode", nodeId);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8282\u70b9\u5b58\u5728\u51b2\u7a81\uff0c\u8bf7\u786e\u8ba4\u6570\u636e\u7684\u6b63\u786e\u6027", (String)"FlowDefineEditPlugin_12", (String)"mmc-phm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK, new ConfirmCallBackListener("node", (IFormPlugin)this));
            return;
        }
        this.calcMiddleFullStage(this.getMilepostListToCache(), beginNow_x, endNow_x, (String)nowNode.get("id"));
        this.putNodeInfoToCache(nowNode);
        Object value = this.getModel().getValue("flownodecycle");
        EntryGrid entryGrid = (EntryGrid)this.getControl("flownodeentryentity");
        int[] selectIndexs = entryGrid.getSelectRows();
        if (selectIndexs != null && selectIndexs.length != 0 && value != null && BigDecimal.ZERO.compareTo((BigDecimal)value) != 0 && !this.checkNodeRule(value, selectIndexs[0])) {
            this.getModel().beginInit();
            this.getModel().setValue("flownodecycle", null);
            this.getModel().endInit();
            this.getView().updateView("flownodecycle");
            this.getModel().setValue("nodecycle", null, selectIndexs[0]);
        }
    }

    private void updateOneNode(String id, Object red, String sign) {
        CustomControl control = (CustomControl)this.getControl("process");
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(2);
        paramsMap.put("action", "updateOneNode");
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("id", id);
        data.put(sign, red);
        data.put("time", new Date());
        paramsMap.put("data", data);
        control.setData(paramsMap);
    }

    private void updateOneNodePosAndSize(String id, Object pos, Map<String, Object> size) {
        CustomControl control = (CustomControl)this.getControl("process");
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(2);
        paramsMap.put("action", "updateOneNode");
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("id", id);
        data.put("position", pos);
        data.put("width", size.get("width"));
        data.put("height", size.get("height"));
        data.put("time", new Date());
        paramsMap.put("data", data);
        control.setData(paramsMap);
    }

    private void updateOneNodeColor(String id, Object red, String sign) {
        CustomControl control = (CustomControl)this.getControl("process");
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(2);
        paramsMap.put("action", "updateOneNode");
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("id", id);
        data.put(sign, red);
        data.put("bgColor", "white");
        paramsMap.put("data", data);
        control.setData(paramsMap);
    }

    private void updateOneNodePosition(String id, Map<String, BigDecimal> positions) {
        CustomControl control = (CustomControl)this.getControl("process");
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(2);
        HashMap<String, BigDecimal> position = new HashMap<String, BigDecimal>(2);
        paramsMap.put("action", "updateOneNode");
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("id", id);
        position.put("x", positions.get("beginPostion"));
        position.put("y", positions.get("y"));
        data.put("position", position);
        data.put("width", positions.get("width"));
        data.put("height", positions.get("height"));
        paramsMap.put("data", data);
        control.setData(paramsMap);
    }

    private BigDecimal getBeginOrEndX(Map<String, Object> nodeInfo, String sign) {
        Map position = (Map)nodeInfo.get("position");
        Map size = (Map)nodeInfo.get("size");
        BigDecimal position_x = new BigDecimal(position.get("x").toString());
        if (!"begin".equals(sign)) {
            BigDecimal width = new BigDecimal(size.get("width").toString());
            position_x = position_x.add(width);
        }
        return position_x;
    }

    private void addLane(String eventArgs) {
        List nodeInfos = (List)SerializationUtils.fromJsonString((String)eventArgs, List.class);
        Map map = (Map)nodeInfos.get(0);
        String id = map.get("id").toString();
        if (!this.isSelectMilepost(id)) {
            return;
        }
        if (this.isOverlapLane(map)) {
            this.deleteEdge(id, "nodeId");
        } else {
            this.putNodeInfoToCache(map);
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            TableValueSetter tvs = new TableValueSetter(new String[]{"laneid", "lanemessage"});
            Object focusnodeId = null;
            for (Map nodeInfo : nodeInfos) {
                focusnodeId = nodeInfo.get("id");
                tvs.addRow(new Object[]{focusnodeId, eventArgs});
            }
            model.batchCreateNewEntryRow("laneentryentity", tvs);
            model.endInit();
            int index = this.getNodeIndex(focusnodeId, "laneentryentity", "laneid");
            this.selectFolwNodeRow(index, "laneentryentity");
            this.getView().updateView("laneentryentity");
        }
    }

    private boolean isSelectMilepost(String id) {
        Object value = this.getModel().getValue(MILEPOST);
        if (value == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u91cc\u7a0b\u7891\u3002", (String)"FlowDefineEditPlugin_13", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            this.deleteEdge(id, "nodeId");
            return false;
        }
        return true;
    }

    private boolean isOverlapLane(Map<String, Object> map) {
        BigDecimal end_now;
        BigDecimal length_now;
        BigDecimal begin_now;
        Map<String, Object> nodeInfoToCache = this.getNodeInfoToCache();
        String shape = map.get("shape").toString();
        String id = map.get("id").toString();
        Map position_now = (Map)map.get("position");
        Map size_now = (Map)map.get("size");
        if ("x-lane".equals(shape)) {
            begin_now = new BigDecimal(position_now.get("y").toString());
            length_now = new BigDecimal(size_now.get("height").toString());
            end_now = begin_now.add(length_now);
        } else {
            begin_now = new BigDecimal(position_now.get("x").toString());
            length_now = new BigDecimal(size_now.get("width").toString());
            end_now = begin_now.add(length_now);
        }
        for (Map.Entry<String, Object> mapEntry : nodeInfoToCache.entrySet()) {
            BigDecimal end;
            BigDecimal length;
            BigDecimal begin;
            Map value = (Map)mapEntry.getValue();
            String shape_other = value.get("shape").toString();
            String id_other = value.get("id").toString();
            if (id_other.equals(id) || !shape.equals(shape_other)) continue;
            Map position = (Map)value.get("position");
            Map size = (Map)value.get("size");
            if ("x-lane".equals(shape)) {
                begin = new BigDecimal(position.get("y").toString());
                length = new BigDecimal(size.get("height").toString());
                end = begin.add(length);
            } else {
                begin = new BigDecimal(position.get("x").toString());
                length = new BigDecimal(size.get("width").toString());
                end = begin.add(length);
            }
            if (!(begin_now.compareTo(begin) > 0 && begin_now.compareTo(end) < 0 || end_now.compareTo(begin) > 0 && end_now.compareTo(end) < 0) && (begin_now.compareTo(begin) != 0 || end_now.compareTo(end) != 0)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6cf3\u9053\u4e0e\u5176\u4ed6\u6cf3\u9053\u5b58\u5728\u91cd\u53e0\u3002", (String)"FlowDefineEditPlugin_14", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void clickLane(String eventArgs) {
        this.milepostFlexVisable(true, LANE);
        Map nodeInfos = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
        Object focusnodeId = nodeInfos.get("id");
        int index = this.getNodeIndex((String)focusnodeId, "laneentryentity", "laneid");
        this.selectFolwNodeRow(index, "laneentryentity");
        this.setLaneShowValue();
    }

    private void setLaneShowValue() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("laneentryentity");
        int[] selectIndexs = entryGrid.getSelectRows();
        if (selectIndexs == null || selectIndexs.length == 0) {
            return;
        }
        int selectRow = selectIndexs[0];
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("laneentryentity", selectRow);
        this.getModel().setValue("laneids", entryRowEntity.get("laneid"));
        this.getModel().setValue("laneorgs", entryRowEntity.get("laneorg"));
        this.getModel().setValue("laneprojects", entryRowEntity.get("laneproject"));
        this.getModel().setValue("laneroles", entryRowEntity.get("lanerole"));
        this.getModel().setValue("laneremakes", entryRowEntity.get("laneremake"));
        this.getModel().setValue("laneusers", entryRowEntity.get("laneuser"));
        this.getModel().setValue("lanenames", entryRowEntity.get("lanename"));
        this.getModel().setValue("laneorglevels", entryRowEntity.get("laneorglevel"));
    }

    private void clickMilepost() {
        this.milepostFlexVisable(true, MILEPOST);
        Object newData = this.getModel().getValue(MILEPOST);
        DynamicObject dynamicObject = this.queryMilepost(newData);
        this.setMilepostFieldValue(dynamicObject);
    }

    private void milepostFlexVisable(boolean isShow, String field) {
        if (MILEPOST.equals(field)) {
            this.getView().setVisible(Boolean.valueOf(isShow), new String[]{"flexpanelap3"});
            this.getView().setVisible(Boolean.valueOf(!isShow), new String[]{"flexpanelap1", "flexpanelap31"});
        } else if (LANE.equals(field)) {
            this.getView().setVisible(Boolean.valueOf(isShow), new String[]{"flexpanelap31"});
            this.getView().setVisible(Boolean.valueOf(!isShow), new String[]{"flexpanelap1", "flexpanelap3"});
        } else {
            this.getView().setVisible(Boolean.valueOf(isShow), new String[]{"flexpanelap1"});
            this.getView().setVisible(Boolean.valueOf(!isShow), new String[]{"flexpanelap31", "flexpanelap3"});
        }
    }

    private void clearFlowCustom() {
        CustomControl control = (CustomControl)this.getView().getControl("process");
        control.setData(null);
    }

    private void saveProcess(String eventArgs) {
        this.getModel().setValue("flowconf_tag", (Object)eventArgs);
        if ("1".equals(this.getPageCache().get("tabselect"))) {
            boolean countNode = this.isCountNode(eventArgs);
            this.setOtherTabStyle(eventArgs, "setCus", countNode);
            this.getPageCache().remove("tabselect");
        } else if (this.getPageCache().get("edge") != null) {
            Map childRelations = FlowUtils.getChildRelations((String)eventArgs);
            Map parentRelations = FlowUtils.getParentRelations((String)eventArgs);
            String edge = this.getPageCache().get("edge");
            this.hasTime(childRelations, parentRelations, edge);
            this.getPageCache().remove("edge");
        } else if (this.getPageCache().get("openPageNodeId") != null) {
            String openKey = this.getPageCache().get("openKey");
            this.openSelectConditionPage(openKey, eventArgs);
            this.getPageCache().remove("openPageNodeId");
        } else if (this.getPageCache().get("nodecycle") != null) {
            String nodecycle = this.getPageCache().get("nodecycle");
            this.checkRelationNodeCycleAndSetFieldValue(nodecycle, eventArgs);
            this.getPageCache().remove("nodecycle");
            this.getPageCache().remove("cycleRanges");
        } else {
            String save = this.setOtherTabStyle(eventArgs, "save", true);
            this.getModel().setValue("sysflowconf_tag", (Object)save);
            String operate = this.getPageCache().get("operate");
            if (StringUtils.isNotEmpty((CharSequence)operate)) {
                this.getPageCache().put("hasSaveProcess", "true");
                this.getView().invokeOperation(operate);
            }
        }
    }

    private void checkRelationNodeCycleAndSetFieldValue(String nodecycle, String eventArgs) {
        FlowNode root = FlowUtils.resolveFlowTree((String)eventArgs);
        Map<String, List<Integer>> middleFullStageToCache = this.getMiddleFullStageToCache();
        if (nodecycle.contains(",")) {
            BigDecimal totalStageCycle;
            HashSet<Integer> allStage = new HashSet<Integer>();
            HashSet<String> nodeIds = new HashSet<String>();
            String[] split = nodecycle.split(",");
            String nodeId = split[0];
            int select = Integer.parseInt(split[1]);
            String old_cycle = split[2];
            String new_cycle = split[3];
            ArrayList childNode = new ArrayList(8);
            FlowUtils.getChildNode((FlowNode)root, (String)nodeId, childNode);
            Map childRelations = FlowUtils.getChildRelations((String)eventArgs);
            Map parentRelations = FlowUtils.getParentRelations((String)eventArgs);
            List<Integer> sourceNodeStage = middleFullStageToCache.get(nodeId);
            nodeIds.add(nodeId);
            allStage.addAll(sourceNodeStage);
            if (childNode.size() > 0) {
                for (FlowNode flowNode : childNode) {
                    int i = 0;
                    String childNodeId = flowNode.getId();
                    this.getStageAndNode(middleFullStageToCache, nodeId, childNodeId, childRelations, allStage, nodeIds, i);
                }
            }
            this.getParentStageAndNode(middleFullStageToCache, nodeId, parentRelations, allStage, nodeIds);
            BigDecimal totalCycle = this.getTotalCycle(nodeIds);
            BigDecimal newBig_cycle = new BigDecimal(new_cycle);
            BigDecimal oldBig_cycle = new BigDecimal(old_cycle);
            if (newBig_cycle.compareTo(oldBig_cycle) > 0) {
                BigDecimal diff_cycle = newBig_cycle.subtract(oldBig_cycle);
                totalCycle = totalCycle.add(diff_cycle);
            }
            if (totalCycle.compareTo(totalStageCycle = this.getTotalStageCycle(allStage)) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5468\u671f\u5927\u4e8e\u9636\u6bb5\u6240\u5728\u7684\u5468\u671f\uff0c\u8bf7\u8c03\u6574\u3002", (String)"FlowDefineEditPlugin_15", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                this.setNodeCycleAndEntryCycleValue(old_cycle, select);
            } else {
                String cycleRange = this.getPageCache().get("cycleRanges");
                Map cycleRanges = (Map)SerializationUtils.deSerializeFromBase64((String)cycleRange);
                Map position = (Map)cycleRanges.get("position");
                this.putModelMessageToCache(nodeId, cycleRanges);
                this.updateOneNodePosition(nodeId, position);
                this.updateNodeCache(nodeId, position);
                this.getModel().beginInit();
                this.getModel().setValue("nodecycle", (Object)new_cycle, select);
                this.getModel().endInit();
                this.getView().updateView("nodecycle", select);
            }
        }
    }

    private boolean isCountNode(String eventArgs) {
        Map nodeInfo = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
        Map graphData = (Map)nodeInfo.get("graphData");
        List cells = (List)graphData.get("cells");
        for (Map map : cells) {
            String shape = (String)map.get("shape");
            if (!"x-rect".equals(shape) && !"x-circle".equals(shape) && !"x-diamond".equals(shape)) continue;
            return true;
        }
        return false;
    }

    private void hasTime(Map<String, List<String>> childRelations, Map<String, List<String>> parentRelations, String edge) {
        BigDecimal totalStageCycle;
        BigDecimal totalCycle;
        Map nodeInfo = (Map)SerializationUtils.fromJsonString((String)edge, Map.class);
        Map<String, List<Integer>> middleFullStageMap = this.getMiddleFullStageToCache();
        String edgeId = (String)nodeInfo.get("edgeId");
        Map sourceNode = (Map)nodeInfo.get("sourceNode");
        Map targetNode = (Map)nodeInfo.get("targetNode");
        String sourceNodeId = (String)sourceNode.get("id");
        String targetNodeId = (String)targetNode.get("id");
        HashSet<Integer> allStage = new HashSet<Integer>();
        HashSet<String> nodeIds = new HashSet<String>();
        nodeIds.add(sourceNodeId);
        nodeIds.add(targetNodeId);
        int i = 0;
        if (this.isForwardConnect(middleFullStageMap, sourceNodeId, targetNodeId).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fde\u7ebf\u4e0d\u80fd\u4ece\u540e\u9636\u6bb5\u5f80\u524d\u9636\u6bb5\u8fde\u7ebf\u8bf7\u8c03\u6574\u3002", (String)"FlowDefineEditPlugin_16", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            this.deleteEdge(edgeId, "edgeId");
            return;
        }
        this.getStageAndNode(middleFullStageMap, sourceNodeId, targetNodeId, childRelations, allStage, nodeIds, i);
        this.getParentStageAndNode(middleFullStageMap, sourceNodeId, parentRelations, allStage, nodeIds);
        if (allStage.size() != 0 && (totalCycle = this.getTotalCycle(nodeIds)).compareTo(totalStageCycle = this.getTotalStageCycle(allStage)) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8fde\u7ebf\u7684\u5468\u671f\u5927\u4e8e\u9636\u6bb5\u6240\u5728\u7684\u5468\u671f\uff0c\u8bf7\u8c03\u6574\u3002", (String)"FlowDefineEditPlugin_17", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            this.deleteEdge(edgeId, "edgeId");
        }
    }

    private Boolean isForwardConnect(Map<String, List<Integer>> middleFullStageMap, String sourceNodeId, String targetNodeId) {
        List<Integer> sourceNodeStage = middleFullStageMap.get(sourceNodeId);
        List<Integer> targetNodeStage = middleFullStageMap.get(targetNodeId);
        Integer min_sou = Collections.min(sourceNodeStage);
        Integer min_tar = Collections.min(targetNodeStage);
        if (min_tar < min_sou) {
            return true;
        }
        return false;
    }

    private BigDecimal getTotalStageCycle(Set<Integer> allStage) {
        BigDecimal total = BigDecimal.ZERO;
        String milepost = this.getView().getPageCache().get("meilpost");
        List milepostList = (List)SerializationUtils.deSerializeFromBase64((String)milepost);
        for (Map map : milepostList) {
            Integer seq = (Integer)map.get("seq");
            if (!allStage.contains(seq)) continue;
            BigDecimal baselength = (BigDecimal)map.get(BASELENTH);
            total = total.add(baselength);
        }
        return total;
    }

    private BigDecimal getTotalCycle(Set<String> nodeIds) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("flownodeentryentity");
        BigDecimal total = BigDecimal.ZERO;
        for (DynamicObject dynamicObject : entryEntity) {
            String nodeId = dynamicObject.getString("nodeid");
            if (!nodeIds.contains(nodeId)) continue;
            BigDecimal bigDecimal = dynamicObject.getBigDecimal("nodecycle");
            total = total.add(bigDecimal);
        }
        return total;
    }

    private void getParentStageAndNode(Map<String, List<Integer>> middleFullStageMap, String sourceNodeId, Map<String, List<String>> parentRelations, Set<Integer> allStage, Set<String> nodeIds) {
        List<Integer> sourceNodeStage = middleFullStageMap.get(sourceNodeId);
        List<String> list = parentRelations.get(sourceNodeId);
        if (list != null) {
            for (String s : list) {
                List<Integer> targetNodeStage = middleFullStageMap.get(s);
                List<Integer> cross = this.getCross(sourceNodeStage, targetNodeStage);
                List<Integer> difference = this.getDifference(sourceNodeStage, targetNodeStage);
                if (cross.size() == 0) continue;
                nodeIds.add(s);
                allStage.addAll(difference);
                allStage.addAll(cross);
                this.getParentStageAndNode(middleFullStageMap, s, parentRelations, allStage, nodeIds);
            }
        }
    }

    private void getStageAndNode(Map<String, List<Integer>> middleFullStageMap, String sourceNodeId, String targetNodeId, Map<String, List<String>> childRelations, Set<Integer> allStage, Set<String> nodeIds, int i) {
        List<Integer> sourceNodeStage = middleFullStageMap.get(sourceNodeId);
        List<Integer> targetNodeStage = middleFullStageMap.get(targetNodeId);
        List<Integer> cross = this.getCross(sourceNodeStage, targetNodeStage);
        List<Integer> difference = this.getDifference(sourceNodeStage, targetNodeStage);
        if (cross.size() != 0) {
            ++i;
            nodeIds.add(targetNodeId);
            allStage.addAll(difference);
            allStage.addAll(cross);
            List<String> list = childRelations.get(targetNodeId);
            if (list != null) {
                for (String s : list) {
                    this.getStageAndNode(middleFullStageMap, targetNodeId, s, childRelations, allStage, nodeIds, i);
                }
            }
        } else if (i == 0) {
            allStage.addAll(difference);
        }
    }

    private List<Integer> getDifference(List<Integer> sourceNodeStage, List<Integer> targetNodeStage) {
        List<Integer> reduce = sourceNodeStage.stream().filter(item -> !targetNodeStage.contains(item)).collect(Collectors.toList());
        List reduce1 = targetNodeStage.stream().filter(item -> !sourceNodeStage.contains(item)).collect(Collectors.toList());
        reduce.addAll(reduce1);
        return reduce;
    }

    private List<Integer> getCross(List<Integer> sourceNodeStage, List<Integer> targetNodeStage) {
        List<Integer> intersection = sourceNodeStage.stream().filter(item -> targetNodeStage.contains(item)).collect(Collectors.toList());
        return intersection;
    }

    private void clickProcessNode(String eventArgs) {
        Map nodeInfo = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
        if (nodeInfo == null || nodeInfo.isEmpty()) {
            return;
        }
        this.selectFlowNode(nodeInfo.get("id").toString());
        this.milepostFlexVisable(true, "");
        this.putNodeInfoToCache(nodeInfo);
    }

    private void deleteProcessNode(String eventArgs) {
        List nodeInfos = (List)SerializationUtils.fromJsonString((String)eventArgs, List.class);
        this.deleteFlowNode(nodeInfos);
    }

    private void addProcessNode(String eventArgs) {
        List nodeInfos = (List)SerializationUtils.fromJsonString((String)eventArgs, List.class);
        Map map = (Map)nodeInfos.get(0);
        String id = map.get("id").toString();
        if (!this.isSelectMilepost(id)) {
            return;
        }
        if (this.isOverLimit(map)) {
            this.updateOneNode(id, map.get("position"), "position");
        }
        this.addFlowNode(nodeInfos);
        this.putNodeInfoToCache(map);
    }

    private boolean isOverLimit(Map<String, Object> nodeInfos) {
        boolean isOver = false;
        Map position = (Map)nodeInfos.get("position");
        BigDecimal x = new BigDecimal(position.get("x").toString());
        BigDecimal y = new BigDecimal(position.get("y").toString());
        Map size = (Map)nodeInfos.get("size");
        BigDecimal width = new BigDecimal(size.get("width").toString());
        BigDecimal end_x = new BigDecimal("1990").subtract(width);
        BigDecimal height = new BigDecimal(size.get("height").toString());
        BigDecimal end_y = new BigDecimal("900").subtract(height);
        if (x.compareTo(new BigDecimal("30")) < 0) {
            position.put("x", new BigDecimal("30"));
            isOver = true;
        }
        if (x.compareTo(end_x) > 0) {
            position.put("x", end_x);
            isOver = true;
        }
        if (y.compareTo(new BigDecimal("50")) < 0) {
            position.put("y", new BigDecimal("50"));
            isOver = true;
        }
        if (y.compareTo(end_y) > 0) {
            position.put("y", end_y);
            isOver = true;
        }
        return isOver;
    }

    private void putNodeInfoToCache(Map<String, Object> nodeInfosMap) {
        Map<String, Map<String, Object>> map = null;
        if (this.getPageCache().get("nodeInfo") != null) {
            String nodeInfo = this.getPageCache().get("nodeInfo");
            map = (Map)SerializationUtils.deSerializeFromBase64((String)nodeInfo);
        } else {
            map = new HashMap<String, Map<String, Object>>(8);
        }
        map.put(nodeInfosMap.get("id").toString(), nodeInfosMap);
        this.getPageCache().put("nodeInfo", SerializationUtils.serializeToBase64(map));
    }

    private String getMilepostStage(List<Map<String, Object>> milepostList, BigDecimal b_x, BigDecimal e_x, String sign) {
        String seq_end = null;
        System.out.println();
        for (Map<String, Object> map : milepostList) {
            Object positions = map.get("position");
            String[] split = positions.toString().split(",");
            BigDecimal begin = new BigDecimal(split[0]);
            BigDecimal end = new BigDecimal(split[1]);
            String seq = map.get("seq").toString();
            if (b_x.compareTo(begin) == 0 && e_x.compareTo(end) == 0) {
                return seq;
            }
            if ("begin".equals(sign)) {
                if (begin.compareTo(b_x) > 0 || end.compareTo(b_x) < 0) continue;
                seq_end = seq;
                continue;
            }
            if (begin.compareTo(e_x) > 0 || end.compareTo(e_x) < 0) continue;
            return seq;
        }
        return seq_end;
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name = event.getProperty().getName();
        if (StringUtils.equals((CharSequence)"role", (CharSequence)name)) {
            this.beforeRoleF7Select(event);
        } else if (StringUtils.equals((CharSequence)"resource", (CharSequence)name)) {
            this.beforeResourceF7Select(event);
        } else if (StringUtils.equals((CharSequence)"flownumber", (CharSequence)name)) {
            this.beforeSubFlowNumberF7Select(event);
        }
    }

    private void beforeSubFlowNumberF7Select(BeforeF7SelectEvent event) {
        DynamicObjectCollection resouces = this.getModel().getEntryEntity("flowsubentryentity");
        if (resouces == null || resouces.isEmpty()) {
            return;
        }
        ArrayList selectedIds = Lists.newArrayListWithCapacity((int)6);
        for (DynamicObject resource : resouces) {
            long id = resource.getLong("flownumber_id");
            if (id == 0L) continue;
            selectedIds.add(id);
        }
        if (selectedIds.size() == 0) {
            return;
        }
        event.getCustomQFilters().add(new QFilter("id", "not in", (Object)selectedIds));
    }

    private void beforeResourceF7Select(BeforeF7SelectEvent event) {
        int row = event.getRow();
        String type = (String)this.getModel().getValue("resourcetype", row);
        if (StringUtils.equals((CharSequence)"phm_billtemp", (CharSequence)type)) {
            this.beforeDataTempF7Select(event);
        }
    }

    private void beforeDataTempF7Select(BeforeF7SelectEvent event) {
        event.getCustomQFilters().add(new QFilter("publish", "=", (Object)"2"));
        DynamicObjectCollection resouces = this.getModel().getEntryEntity("resourcesubentryentity");
        if (resouces == null || resouces.isEmpty()) {
            return;
        }
        ArrayList selectedIds = Lists.newArrayListWithCapacity((int)6);
        for (DynamicObject resource : resouces) {
            long id;
            String resourceType = resource.getString("resourcetype");
            if (!StringUtils.equals((CharSequence)"phm_billtemp", (CharSequence)resourceType) || (id = resource.getLong("resource_id")) == 0L) continue;
            selectedIds.add(id);
        }
        if (selectedIds.size() == 0) {
            return;
        }
        event.getCustomQFilters().add(new QFilter("id", "not in", (Object)selectedIds));
    }

    private void beforeRoleF7Select(BeforeF7SelectEvent event) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("resourcesubentryentity");
        int[] selectIndexs = entryGrid.getSelectRows();
        if (selectIndexs == null || selectIndexs.length == 0) {
            return;
        }
        int selectIndex = selectIndexs[0];
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("resourcesubentryentity", selectIndex);
        DynamicObject resource = entryRowEntity.getDynamicObject("deliverables");
        if (resource == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u4ea4\u4ed8\u7269\u7f16\u7801\u201d\u3002", (String)"FlowDefineEditPlugin_18", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        List<Long> roleIds = this.getRoleIdsByResource(resource.getLong("id"));
        if (roleIds.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s:\u8be5\u4ea4\u4ed8\u7269\u672a\u5206\u914d\u89d2\u8272\u3002", (String)"FlowDefineEditPlugin_19", (String)"mmc-phm-formplugin", (Object[])new Object[0]), resource.getString("number")));
            event.setCancel(true);
            return;
        }
        QFilter qFilter = new QFilter("id", "in", roleIds);
        event.getCustomQFilters().add(qFilter);
    }

    private List<Long> getRoleIdsByResource(Long resourceId) {
        QFilter resourceFielter = new QFilter("entryentity2.resources", "=", (Object)resourceId);
        resourceFielter.and(new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue()));
        resourceFielter.and(new QFilter("enable", "=", (Object)EnableEnum.ENABLE.getValue()));
        ArrayList roleIds = Lists.newArrayListWithCapacity((int)4);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"phm_role", (String)"id", (QFilter[])resourceFielter.toArray(), null);){
            for (Row row : ds) {
                roleIds.add(row.getLong(0));
            }
        }
        return roleIds;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ((formOperate instanceof Save || formOperate instanceof Submit) && this.hasSaveProcess()) {
            this.getPageCache().put("operate", formOperate.getOperateKey());
            this.actionSave();
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        boolean success;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        boolean bl = success = args.getOperationResult() != null && args.getOperationResult().isSuccess();
        if (formOperate instanceof Save || formOperate instanceof Submit) {
            this.getPageCache().remove("operate");
            this.getPageCache().remove("hasSaveProcess");
        }
        if (formOperate instanceof Submit && success) {
            this.lockProcessControl(true);
        }
        if (formOperate instanceof Delete && success) {
            this.clearCanvas();
        }
        if ((formOperate instanceof UnSubmit || formOperate instanceof UnAudit) && success) {
            this.lockProcessControl(false);
        }
    }

    public void lockProcessControl(boolean lock) {
        CustomControl control = (CustomControl)this.getView().getControl("process");
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(2);
        HashMap<String, Boolean> data = new HashMap<String, Boolean>(2);
        data.put("locked", lock);
        paramsMap.put("action", "lock");
        paramsMap.put("data", data);
        control.setData(paramsMap);
    }

    public boolean hasSaveProcess() {
        String hasSaveProcess = this.getPageCache().get("hasSaveProcess");
        return StringUtils.isEmpty((CharSequence)hasSaveProcess);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getPageCache().get(KEY_CLOSE) == null) {
            DynamicObject dataEntity1 = this.getModel().getDataEntity(true);
            int flowNodeName1 = dataEntity1.getDynamicObjectType().getProperty("flownodename").getOrdinal();
            dataEntity1.getDataEntityState().setBizChanged(flowNodeName1, false);
            int flowNodeCycle1 = dataEntity1.getDynamicObjectType().getProperty("flownodecycle").getOrdinal();
            dataEntity1.getDataEntityState().setBizChanged(flowNodeCycle1, false);
            int focusNode1 = dataEntity1.getDynamicObjectType().getProperty("focusnode").getOrdinal();
            dataEntity1.getDataEntityState().setBizChanged(focusNode1, false);
            int plan1 = dataEntity1.getDynamicObjectType().getProperty("plan").getOrdinal();
            dataEntity1.getDataEntityState().setBizChanged(plan1, false);
            int txtdesc1 = dataEntity1.getDynamicObjectType().getProperty("txtdesc").getOrdinal();
            dataEntity1.getDataEntityState().setBizChanged(txtdesc1, false);
            int flowconf_tag1 = dataEntity1.getDynamicObjectType().getProperty("flowconf_tag").getOrdinal();
            dataEntity1.getDataEntityState().setBizChanged(flowconf_tag1, false);
            int begindates = dataEntity1.getDynamicObjectType().getProperty("begindates").getOrdinal();
            dataEntity1.getDataEntityState().setBizChanged(begindates, false);
            int enddates = dataEntity1.getDynamicObjectType().getProperty("enddates").getOrdinal();
            dataEntity1.getDataEntityState().setBizChanged(enddates, false);
            int nodenumber = dataEntity1.getDynamicObjectType().getProperty("nodenumber").getOrdinal();
            dataEntity1.getDataEntityState().setBizChanged(nodenumber, false);
            int personliables = dataEntity1.getDynamicObjectType().getProperty("personliables_id").getOrdinal();
            dataEntity1.getDataEntityState().setBizChanged(personliables, false);
            int liableorgs = dataEntity1.getDynamicObjectType().getProperty("liableorgs_id").getOrdinal();
            dataEntity1.getDataEntityState().setBizChanged(liableorgs, false);
            int flownodename = dataEntity1.getDynamicObjectType().getProperty("flownodename").getOrdinal();
            dataEntity1.getDataEntityState().setBizChanged(flownodename, false);
            int laneids = dataEntity1.getDynamicObjectType().getProperty("laneids").getOrdinal();
            dataEntity1.getDataEntityState().setBizChanged(laneids, false);
            int lanenames = dataEntity1.getDynamicObjectType().getProperty("lanenames").getOrdinal();
            dataEntity1.getDataEntityState().setBizChanged(lanenames, false);
            int laneorglevels = dataEntity1.getDynamicObjectType().getProperty("laneorglevels_id").getOrdinal();
            dataEntity1.getDataEntityState().setBizChanged(laneorglevels, false);
            int laneprojects = dataEntity1.getDynamicObjectType().getProperty("laneprojects_id").getOrdinal();
            dataEntity1.getDataEntityState().setBizChanged(laneprojects, false);
            int laneremakes = dataEntity1.getDynamicObjectType().getProperty("laneremakes").getOrdinal();
            dataEntity1.getDataEntityState().setBizChanged(laneremakes, false);
            int laneorgs = dataEntity1.getDynamicObjectType().getProperty("laneorgs_id").getOrdinal();
            dataEntity1.getDataEntityState().setBizChanged(laneorgs, false);
            int laneroles = dataEntity1.getDynamicObjectType().getProperty("laneroles_id").getOrdinal();
            dataEntity1.getDataEntityState().setBizChanged(laneroles, false);
            int laneusers = dataEntity1.getDynamicObjectType().getProperty("laneusers_id").getOrdinal();
            dataEntity1.getDataEntityState().setBizChanged(laneusers, false);
            int milepostname = dataEntity1.getDynamicObjectType().getProperty("milepostname").getOrdinal();
            dataEntity1.getDataEntityState().setBizChanged(milepostname, false);
            if (this.getModel().getDataChanged()) {
                e.setCancel(true);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u6539\u53d8\uff0c\u662f\u5426\u7ee7\u7eed\u9000\u51fa\uff1f", (String)"FlowDefineEditPlugin_20", (String)"mmc-phm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(KEY_CLOSE, (IFormPlugin)this));
            }
        } else {
            e.setCheckDataChange(false);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (KEY_CLOSE.equals(event.getCallBackId()) && event.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.getPageCache().put(KEY_CLOSE, "");
            this.getView().close();
        } else if ("node".equals(event.getCallBackId()) && event.getResult().equals((Object)MessageBoxResult.Cancel)) {
            String updateNode = this.getPageCache().get("updateNode");
            String nowNode = this.getPageCache().get("nowNode");
            if (updateNode != null) {
                Map<String, Object> nodeInfos = this.getNodeInfoToCache();
                Map nowNodeInfo = (Map)nodeInfos.get(nowNode);
                Object position = nowNodeInfo.get("position");
                this.updateOneNodeColor(nowNode, position, "position");
            }
        }
    }

    public void afterCopyData(EventObject e) {
        this.copyFlowConf(e);
    }

    private void copyFlowConf(EventObject e) {
        BaseModel model = (BaseModel)e.getSource();
        DynamicObject flowDefine = model.getDataEntity();
        String flowConf = flowDefine.getString("flowconf_tag");
        DynamicObjectCollection flowNodes = flowDefine.getDynamicObjectCollection("flownodeentryentity");
        if (flowNodes == null || flowNodes.isEmpty()) {
            return;
        }
        long[] nodeids = ID.genLongIds((int)flowNodes.size());
        int nodeSize = 0;
        for (DynamicObject node : flowNodes) {
            DynamicObjectCollection subFlows;
            int subEntryIndex;
            String nodeId = node.getString("nodeid");
            String uuid = UUID.randomUUID().toString();
            flowConf = flowConf.replace(nodeId, uuid);
            node.set("nodeid", (Object)uuid);
            long nodeid = nodeids[nodeSize];
            ++nodeSize;
            node.set("id", (Object)nodeid);
            DynamicObjectCollection resources = node.getDynamicObjectCollection("resourcesubentryentity");
            if (resources != null && !resources.isEmpty()) {
                long[] subEntry = ID.genLongIds((int)resources.size());
                String[] codeRules = this.getCodeRules(resources.size());
                subEntryIndex = 0;
                for (DynamicObject resource : resources) {
                    resource.set("id", (Object)subEntry[subEntryIndex]);
                    resource.set("deliverablesnumber", (Object)codeRules[subEntryIndex]);
                    ++subEntryIndex;
                }
            }
            if ((subFlows = node.getDynamicObjectCollection("flowsubentryentity")) == null || subFlows.isEmpty()) continue;
            long[] subEntry = ID.genLongIds((int)subFlows.size());
            subEntryIndex = 0;
            for (DynamicObject subFlow : subFlows) {
                subFlow.set("id", (Object)subEntry[subEntryIndex]);
                ++subEntryIndex;
            }
        }
        flowDefine.set("flowconf_tag", (Object)flowConf);
    }

    private void personliableFiledChange(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        MulBasedataDynamicObjectCollection mulBasedataDynamicObjectCollection = (MulBasedataDynamicObjectCollection)newValue;
        EntryGrid entryGrid = (EntryGrid)this.getControl("resourcesubentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            return;
        }
        int selectRow = selectRows[0];
        ArrayList<Long> userlist = new ArrayList<Long>(8);
        for (DynamicObject dynamicObject : mulBasedataDynamicObjectCollection) {
            userlist.add(dynamicObject.getLong("fbasedataid_id"));
        }
        this.setControlNum(selectRow);
        List<Long> managerOrglist = this.getMainOrg(userlist);
        Map userDirector = FlowActiveUtil.getUserDirector(managerOrglist, userlist);
        Object[] userPkid = this.getSuperiorValue(userDirector);
        this.getModel().beginInit();
        this.getModel().setValue("superior", (Object)userPkid, selectRow);
        this.getModel().endInit();
        this.getView().updateView("superior", selectRow);
    }

    private void setControlNum(int selectRow) {
        Object controlconf = this.getModel().getValue("controlconf", selectRow);
        if (controlconf != null && controlconf.toString().isEmpty()) {
            this.getModel().setValue("controlconf", (Object)ResManager.loadKDString((String)"\u6267\u884c\u6570\u91cf=1", (String)"FlowDefineEditPlugin_21", (String)"mmc-phm-formplugin", (Object[])new Object[0]), selectRow);
            this.getModel().setValue("formula", (Object)"perform_number;1;1", selectRow);
        }
    }

    private Object[] getSuperiorValue(Map<Long, Long> userDirector) {
        Object[] userPkid = new Object[userDirector.size()];
        int i = 0;
        for (Map.Entry<Long, Long> mapEntry : userDirector.entrySet()) {
            userPkid[i] = mapEntry.getValue();
            ++i;
        }
        return userPkid;
    }

    private List<Long> getMainOrg(List<Long> userlist) {
        ArrayList<Long> managerOrglist = new ArrayList<Long>(8);
        List userMainOrgId = UserServiceHelper.getUserMainOrgId(userlist);
        block0: for (Map map : userMainOrgId) {
            for (Long userId : userlist) {
                if (!map.containsKey(userId)) continue;
                managerOrglist.add((Long)map.get(userId));
                continue block0;
            }
        }
        return managerOrglist;
    }

    private void roleFiledChange(PropertyChangedArgs e) {
        List<Long> roleUsers = this.getRoleUsers(e);
        this.setDepersonliableValue(roleUsers);
    }

    private void setDepersonliableValue(List<Long> roleUsers) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("resourcesubentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            return;
        }
        int selectRow = selectRows[0];
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("resourcesubentryentity", selectRow);
        MulBasedataDynamicObjectCollection mulBasedataDynamicObjectCollection = (MulBasedataDynamicObjectCollection)entryRowEntity.get("depersonliable");
        int size = mulBasedataDynamicObjectCollection.size() + roleUsers.size();
        Object[] pkId = new Object[size];
        int i = 0;
        for (DynamicObject dynamicObject : mulBasedataDynamicObjectCollection) {
            pkId[i] = dynamicObject.getLong("fbasedataid_id");
            ++i;
        }
        for (Long l : roleUsers) {
            pkId[i] = l;
            ++i;
        }
        this.getModel().setValue("depersonliable", (Object)pkId, selectRow);
    }

    private List<Long> getRoleUsers(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        MulBasedataDynamicObjectCollection mudyn = (MulBasedataDynamicObjectCollection)newValue;
        ArrayList<Long> allUserByRole = new ArrayList<Long>();
        for (DynamicObject dynamicObject : mudyn) {
            allUserByRole.addAll(RoleUtils.getAllUserByRole((long)dynamicObject.getLong("fbasedataid_id")));
        }
        return allUserByRole;
    }

    private void setLaneEntryentityValue(PropertyChangedArgs e, String key) {
        ChangeData changeSet = e.getChangeSet()[0];
        Object newValue = changeSet.getNewValue();
        EntryGrid entryGrid = (EntryGrid)this.getControl("laneentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            return;
        }
        int selectRow = selectRows[0];
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("laneentryentity", selectRow);
        if (StringUtils.equals((CharSequence)"lanenames", (CharSequence)key)) {
            String laneId = (String)entryRowEntity.get("laneid");
            this.updateOneNode(laneId, newValue.toString(), "name");
        }
        String value = key.substring(0, key.length() - 1);
        this.getModel().beginInit();
        entryRowEntity.set(value, newValue);
        this.getModel().endInit();
        this.getView().updateView(value, selectRow);
    }

    private void judgeDate(PropertyChangedArgs e, String key) {
        ChangeData changeSet = e.getChangeSet()[0];
        Object newValue = changeSet.getNewValue();
        Object oldValue = changeSet.getOldValue();
        EntryGrid entryGrid = (EntryGrid)this.getControl("resourcesubentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            return;
        }
        int selectRow = selectRows[0];
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("resourcesubentryentity", selectRow);
        if (StringUtils.equals((CharSequence)"warningcycle", (CharSequence)key)) {
            Object value = this.getModel().getValue("flownodecycle");
            if (value == null || ((BigDecimal)value).compareTo(BigDecimal.ZERO) == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u8282\u70b9\u5468\u671f\u3002", (String)"FlowDefineEditPlugin_22", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            } else if (((BigDecimal)value).compareTo((BigDecimal)newValue) < 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u8b66\u5468\u671f\u5e94\u5c0f\u4e8e\u8282\u70b9\u5468\u671f\u3002", (String)"FlowDefineEditPlugin_23", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                entryRowEntity.beginInit();
                entryRowEntity.set("warningcycle", oldValue);
                entryRowEntity.endInit();
                this.getView().updateView("warningcycle", selectRow);
            }
        } else if (StringUtils.equals((CharSequence)"seriousoverduecycle", (CharSequence)key)) {
            Object value = entryRowEntity.get("overduecycle");
            if (value == null || ((BigDecimal)value).compareTo(BigDecimal.ZERO) == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u903e\u671f\u5468\u671f\u3002", (String)"FlowDefineEditPlugin_24", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            } else if (((BigDecimal)value).compareTo((BigDecimal)newValue) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e25\u91cd\u903e\u671f\u5468\u671f\u5e94\u5927\u4e8e\u903e\u671f\u5468\u671f\u3002", (String)"FlowDefineEditPlugin_25", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                entryRowEntity.beginInit();
                entryRowEntity.set("seriousoverduecycle", oldValue);
                entryRowEntity.endInit();
                this.getView().updateView("seriousoverduecycle", selectRow);
            }
        }
    }

    private void conditionChange(String key) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("resourcesubentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            return;
        }
        int selectRow = selectRows[0];
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("resourcesubentryentity", selectRow);
        if (StringUtils.equals((CharSequence)key, (CharSequence)"showfrontcondition")) {
            entryRowEntity.set("frontcondition_tag", null);
        } else {
            entryRowEntity.set("aftercondition_tag", null);
        }
    }

    private void nodeFiledChange(PropertyChangedArgs e, String sign, String showSign) {
        Object newData = e.getChangeSet()[0].getNewValue();
        EntryGrid entryGrid = (EntryGrid)this.getControl("flownodeentryentity");
        int[] selectIndexs = entryGrid.getSelectRows();
        if (selectIndexs == null || selectIndexs.length == 0) {
            this.getModel().beginInit();
            this.getModel().setValue(showSign, null);
            this.getModel().endInit();
            this.getView().updateView(showSign);
            return;
        }
        int select = selectIndexs[0];
        this.getModel().beginInit();
        this.getModel().setValue(sign, newData, select);
        this.getModel().endInit();
        this.getView().updateView(sign, select);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        EntryProp entryProp = e.getEntryProp();
        String name = entryProp.getName();
        if ("resourcesubentryentity".equals(name)) {
            String codeRuleNumber = this.getCodeRule();
            if (codeRuleNumber != null && !codeRuleNumber.isEmpty()) {
                RowDataEntity rowDataEntity = e.getRowDataEntities()[0];
                this.getModel().setValue("deliverablesnumber", (Object)codeRuleNumber, rowDataEntity.getRowIndex());
            }
        } else if ("excutesubentryentity".equals(name)) {
            RowDataEntity rowDataEntity = e.getRowDataEntities()[0];
            DynamicObject dynamicObject = rowDataEntity.getDataEntity().getDynamicObject("exflownumber");
            List<String> initFlowModel = this.addFlowModel();
            if (dynamicObject != null && initFlowModel.contains(dynamicObject.getString("entrabill"))) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"exflowdelete"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"exflowdelete", "exflownumber", "excutesubentryentity"});
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String name = e.getEntryProp().getName();
        if ("excutesubentryentity".equals(name)) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("excutesubentryentity");
            this.setExflowdeleteButtonVisable(entryCurrentRowIndex);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String name = e.getEntryProp().getName();
        if ("resourcesubentryentity".equals(name)) {
            List<String> tipList = this.judgeIsNeedDelete(e);
            this.produceTip(e, tipList);
        }
    }

    private void produceTip(BeforeDeleteRowEventArgs e, List<String> tipList) {
        if (tipList.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (String s : tipList) {
                sb.append(s).append("\n");
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25", (String)"FlowDefineEditPlugin_26", (String)"mmc-phm-formplugin", (Object[])new Object[0]), sb.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, null);
            e.setCancel(true);
        }
    }

    private List<String> judgeIsNeedDelete(BeforeDeleteRowEventArgs e) {
        int[] rowIndexs = e.getRowIndexs();
        Map<String, Map<String, List<String>>> quoteCache = this.getQuoteCache();
        ArrayList<String> tipList = new ArrayList<String>(8);
        block0: for (int rowIndex : rowIndexs) {
            boolean isCon = true;
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("resourcesubentryentity", rowIndex);
            String deliverablesNumber = entryRowEntity.getString("deliverablesnumber");
            block1: for (Map.Entry<String, Map<String, List<String>>> mapEntry : quoteCache.entrySet()) {
                if (!isCon) continue block0;
                String key = mapEntry.getKey();
                Map<String, List<String>> quoteTasks = mapEntry.getValue();
                for (Map.Entry<String, List<String>> quoteTask : quoteTasks.entrySet()) {
                    String taskNumber = quoteTask.getKey();
                    List<String> quoteTaskList = quoteTask.getValue();
                    if (!quoteTaskList.contains(deliverablesNumber)) continue;
                    String tip = "select".equals(key) ? String.format(ResManager.loadKDString((String)"\u4ea4\u4ed8\u7269\u7f16\u7801\u4e3a\uff1a%1s\u7684\u4efb\u52a1\u5df2\u88ab\u7f16\u7801\u4e3a\uff1a%2s\u7684\u524d\u7f6e\u6761\u4ef6\u6240\u5f15\u7528\u3002", (String)"FlowDefineEditPlugin_27", (String)"mmc-phm-formplugin", (Object[])new Object[0]), deliverablesNumber, taskNumber) : String.format(ResManager.loadKDString((String)"\u4ea4\u4ed8\u7269\u7f16\u7801\u4e3a\uff1a%1s\u7684\u4efb\u52a1\u5df2\u88ab\u7f16\u7801\u4e3a\uff1a%2s\u7684\u540e\u7f6e\u6761\u4ef6\u6240\u5f15\u7528\u3002", (String)"FlowDefineEditPlugin_28", (String)"mmc-phm-formplugin", (Object[])new Object[0]), deliverablesNumber, taskNumber);
                    tipList.add(tip);
                    isCon = false;
                    continue block1;
                }
            }
        }
        return tipList;
    }

    private String getCodeRule() {
        DynamicObject dynamicObject = ORM.create().newDynamicObject("phm_orglevelgroup");
        String codeRuleNumber = CodeRuleServiceHelper.getNumber((String)"phm_orglevelgroup", (DynamicObject)dynamicObject, (String)String.valueOf(RequestContext.get().getOrgId()));
        return codeRuleNumber;
    }

    private String[] getCodeRules(int nums) {
        DynamicObject dynamicObject = ORM.create().newDynamicObject("phm_orglevelgroup");
        String[] codeRuleNumber = CodeRuleServiceHelper.getBatchNumber((String)"phm_orglevelgroup", (DynamicObject)dynamicObject, (String)String.valueOf(RequestContext.get().getOrgId()), (int)nums);
        return codeRuleNumber;
    }

    private void milepostChange(PropertyChangedArgs e) {
        this.milepostFlexVisable(true, MILEPOST);
        Object newData = e.getChangeSet()[0].getNewValue();
        DynamicObject dynamicObject = this.queryMilepost(newData);
        this.getModel().deleteEntryData("flownodeentryentity");
        this.getModel().deleteEntryData("resourcesubentryentity");
        if (dynamicObject != null) {
            this.setMilepostFieldValue(dynamicObject);
            List<Map<String, Object>> meilpostListMessage = this.calcStageWidth(dynamicObject);
            this.getPageCache().remove("nodeInfo");
            if (meilpostListMessage != null) {
                Map<String, Object> mapData = this.getMapData("2", meilpostListMessage);
                this.setCusData(mapData);
            }
        }
    }

    private List<Map<String, Object>> calcStageWidth(DynamicObject dynamicObject) {
        Object milepoststagetype = this.getModel().getValue("milepoststagetype");
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (dynamicObjectCollection.size() == 0) {
            return list;
        }
        BigDecimal total = BigDecimal.ZERO;
        for (DynamicObject dynamicObject1 : dynamicObjectCollection) {
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            BigDecimal bigDecimal = dynamicObject1.getBigDecimal("baselenth");
            map.put("id", dynamicObject1.getString("id"));
            map.put("stagename", dynamicObject1.getString("stagename"));
            map.put("begintime", dynamicObject1.get("begintime"));
            map.put("endtime", dynamicObject1.get("endtime"));
            map.put(BASELENTH, bigDecimal);
            map.put("seq", dynamicObject1.getInt("seq"));
            total = total.add(bigDecimal);
            list.add(map);
        }
        if (milepoststagetype != null) {
            BigDecimal size = BigDecimal.valueOf(list.size());
            BigDecimal width = new BigDecimal("1960").divide(size, 4, RoundingMode.DOWN);
            for (Map map : list) {
                if ("2".equals(milepoststagetype.toString())) {
                    map.put("length", width);
                    continue;
                }
                if (!"1".equals(milepoststagetype.toString())) continue;
                BigDecimal divide = ((BigDecimal)map.get(BASELENTH)).divide(total, 4, RoundingMode.UP);
                map.put("length", divide.multiply(new BigDecimal(1960)));
            }
        }
        return list;
    }

    private void setMilepostFieldValue(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return;
        }
        this.getModel().setValue("milepostnumber", dynamicObject.get("number"));
        this.getModel().setValue("milepostname", dynamicObject.get("name"));
        this.getModel().setValue("milepostproject", dynamicObject.get("project"));
        this.getModel().setValue("milepostcontract", dynamicObject.get("contract"));
        this.getModel().setValue("milepoststatus", dynamicObject.get("status"));
        this.getModel().setValue("milepostenable", dynamicObject.get("ENABLE"));
        this.getModel().setValue("milepostuserliable", dynamicObject.get("userliable"));
        this.getModel().setValue("milepostliableorg", dynamicObject.get("liableorg"));
        this.getModel().setValue("milepostbegintimes", dynamicObject.get("begintimes"));
        this.getModel().setValue("milepostendtimes", dynamicObject.get("endtimes"));
        this.getModel().setValue("milepostcreateorg", dynamicObject.get("createorg"));
        this.getModel().setValue("milepostcreator", dynamicObject.get("creator"));
        this.getModel().setValue("milepostcreatetime", dynamicObject.get("createtime"));
        this.getModel().setValue("milepostremarks", dynamicObject.get("remarks"));
    }

    private DynamicObject queryMilepost(Object newData) {
        DynamicObject dynamicObject = null;
        if (newData != null) {
            Object id = ((DynamicObject)newData).get("id");
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"phm_milepost");
        }
        return dynamicObject;
    }

    private Map<String, String> queryAllMilepost() {
        DynamicObjectCollection mileposts = QueryServiceHelper.query((String)"phm_milepost", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("number", "!=", null).and("status", "=", (Object)"C").and("enable", "=", (Object)"1")});
        HashMap<String, String> map = new HashMap<String, String>(8);
        for (DynamicObject dynamicObject : mileposts) {
            map.put(dynamicObject.getString("id"), dynamicObject.getString("name"));
        }
        return map;
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if ("tabpageap1".equals(tabKey)) {
            this.actionSave();
            this.getPageCache().put("tabselect", "1");
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"flownodecycle"});
        } else {
            this.getPageCache().put("tabselect", "2");
            Map<String, Object> mapData = this.getMapData("1", null);
            this.setCusData(mapData);
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"flownodecycle"});
        }
    }

    private String setOtherTabStyle(String eventArgs, String sign, Boolean isInclude) {
        Map nodeInfo = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
        CustomControl control = (CustomControl)this.getControl("process1");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("time", new Date());
        map.put("action", "init");
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        Map<String, Object> astrictPosition = this.getAstrictPosition();
        List<Map<String, String>> milepostList = this.getMilepostOption();
        dataMap.put("astrictPosition", astrictPosition);
        dataMap.put("milepostOption", milepostList);
        Map cells = (Map)nodeInfo.get("graphData");
        List nodeMessages = (List)cells.get("cells");
        if (isInclude.booleanValue()) {
            Map<String, Map<String, Object>> stringListMap = this.rankNodeAndCalcTime(nodeMessages, eventArgs);
            this.setDataToCells(nodeMessages, stringListMap);
        }
        dataMap.put("graphData", nodeInfo.get("graphData"));
        if ("setCus".equals(sign)) {
            dataMap.put("locked", Boolean.TRUE);
            map.put("data", dataMap);
            control.setData(map);
        }
        String nodeInfo_save = JsonUtil.toJsonString((Object)nodeInfo);
        return nodeInfo_save;
    }

    private void setDataToCells(List<Map<String, Object>> nodeMessages, Map<String, Map<String, Object>> stringListMap) {
        for (Map<String, Object> map : nodeMessages) {
            String id = (String)map.get("id");
            if (!stringListMap.containsKey(id)) continue;
            Map<String, Object> maps = stringListMap.get(id);
            Map position = (Map)map.get("position");
            Map size = (Map)map.get("size");
            BigDecimal begin_position = (BigDecimal)maps.get("begin_position");
            BigDecimal end_position = (BigDecimal)maps.get("end_position");
            this.setBeginAndEndTime(maps, id);
            if (end_position == null || begin_position == null) continue;
            BigDecimal width = end_position.subtract(begin_position);
            position.put("x", maps.get("begin_position"));
            size.put("width", width);
        }
    }

    private void setBeginAndEndTime(Map<String, Object> maps, String id) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("flownodeentryentity");
        for (DynamicObject dynamicObject : entryEntity) {
            String nodeId = dynamicObject.getString("nodeid");
            if (!nodeId.equals(id)) continue;
            int seq = dynamicObject.getInt("seq");
            Date beginTime = (Date)maps.get("beginTime");
            Date endTime = (Date)maps.get("endTime");
            this.getModel().setValue("begindates", (Object)beginTime);
            this.getModel().setValue("begindate", (Object)beginTime, seq - 1);
            this.getModel().setValue("enddates", (Object)endTime);
            this.getModel().setValue("enddate", (Object)endTime, seq - 1);
            this.getView().updateView("begindate", seq - 1);
            this.getView().updateView("enddate", seq - 1);
            this.getView().updateView("begindates");
            this.getView().updateView("enddates");
        }
    }

    private Map<String, Map<String, Object>> rankNodeAndCalcTime(List<Map<String, Object>> nodeMessages, String eventArgs) {
        FlowNode flowNodes = FlowUtils.resolveFlowTree((String)eventArgs);
        Map childRelations = FlowUtils.getChildRelations((String)eventArgs);
        Map parentRelations = FlowUtils.getParentRelations((String)eventArgs);
        String progress = (String)this.getModel().getValue("progress");
        List<Map<String, Object>> milepostList = this.getMilepostListToCache();
        Map<String, Map<String, Object>> modelMessage = this.getModelMessageToCache();
        Map<String, BigDecimal> minCycle = this.getMinCycle(modelMessage);
        Map<String, List<Integer>> middleFullStageMap = this.getMiddleFullStageToCache();
        Map<String, BigDecimal> nodeCycle = this.getNodeCycle();
        Map<String, Map<String, BigDecimal>> nodeInfo = this.getNodeInfo(nodeMessages);
        HashMap<String, List<Map<String, Object>>> newNodeInfo = new HashMap<String, List<Map<String, Object>>>();
        HashMap<String, Map<String, Object>> newNodePostion = new HashMap<String, Map<String, Object>>();
        if ("0".equals(progress)) {
            this.getNodePosition(flowNodes, middleFullStageMap, nodeCycle, nodeInfo, newNodeInfo, milepostList, parentRelations, newNodePostion, minCycle);
        } else if ("1".equals(progress)) {
            List aloneList = FlowUtils.getAloneNodeIds((Map)childRelations, (FlowNode)flowNodes, (Map)parentRelations);
            this.rankAloneNode(middleFullStageMap, nodeCycle, nodeInfo, newNodeInfo, milepostList, minCycle, aloneList, newNodePostion);
            Set endNodes = FlowUtils.getLastOrBeginNodeIds((Map)childRelations, (Map)parentRelations, (String)"end");
            this.rankEnd(middleFullStageMap, nodeCycle, nodeInfo, newNodeInfo, milepostList, parentRelations, childRelations, minCycle, endNodes, newNodePostion);
        } else {
            HashMap<String, Map<String, Object>> earliestNodePostion = new HashMap<String, Map<String, Object>>();
            this.getNodePosition(flowNodes, middleFullStageMap, nodeCycle, nodeInfo, newNodeInfo, milepostList, parentRelations, earliestNodePostion, minCycle);
            List aloneList = FlowUtils.getAloneNodeIds((Map)childRelations, (FlowNode)flowNodes, (Map)parentRelations);
            this.rankAloneNode(middleFullStageMap, nodeCycle, nodeInfo, newNodeInfo, milepostList, minCycle, aloneList, newNodePostion);
            Set endNodes = FlowUtils.getLastOrBeginNodeIds((Map)childRelations, (Map)parentRelations, (String)"end");
            this.rankEnd(middleFullStageMap, nodeCycle, nodeInfo, newNodeInfo, milepostList, parentRelations, childRelations, minCycle, endNodes, newNodePostion);
            HashMap<String, Map<String, Object>> nodePostion = new HashMap<String, Map<String, Object>>();
            this.averageStar(flowNodes, earliestNodePostion, newNodePostion, nodePostion);
            newNodePostion.clear();
            newNodePostion.putAll(nodePostion);
        }
        return newNodePostion;
    }

    private void averageStar(FlowNode flowNodes, Map<String, Map<String, Object>> earliestNodePostion, Map<String, Map<String, Object>> newNodePostion, Map<String, Map<String, Object>> nodePostion) {
        List children = flowNodes.getChildren();
        for (FlowNode flowNode : children) {
            HashMap<String, Comparable<Date>> timeAndPositionMap = new HashMap<String, Comparable<Date>>(8);
            String id = flowNode.getId();
            Map<String, Object> earliestmap = earliestNodePostion.get(id);
            if (earliestmap == null) {
                return;
            }
            Map<String, Object> end_map = newNodePostion.get(id);
            BigDecimal beginposition_ear = (BigDecimal)earliestmap.get("begin_position");
            BigDecimal endposition_ear = (BigDecimal)earliestmap.get("end_position");
            BigDecimal beginposition_end = (BigDecimal)end_map.get("begin_position");
            BigDecimal endposition_end = (BigDecimal)end_map.get("end_position");
            Date beginTime_ear = (Date)earliestmap.get("beginTime");
            Date endTime_ear = (Date)earliestmap.get("endTime");
            Date beginTime_end = (Date)end_map.get("beginTime");
            Date endTime_end = (Date)end_map.get("endTime");
            BigDecimal beginposition_new = beginposition_ear.add(beginposition_end).divide(new BigDecimal("2"), 4, RoundingMode.HALF_UP);
            BigDecimal endposition_new = endposition_ear.add(endposition_end).divide(new BigDecimal("2"), 4, RoundingMode.HALF_UP);
            Date beginTime_new = this.longTimeToDate(new BigDecimal(beginTime_ear.getTime() + beginTime_end.getTime()).divide(new BigDecimal("2"), 4, RoundingMode.HALF_UP).longValue());
            Date endTime_new = this.longTimeToDate(new BigDecimal(endTime_ear.getTime() + endTime_end.getTime()).divide(new BigDecimal("2"), 4, RoundingMode.HALF_UP).longValue());
            timeAndPositionMap.put("beginTime", beginTime_new);
            timeAndPositionMap.put("endTime", endTime_new);
            timeAndPositionMap.put("begin_position", beginposition_new);
            timeAndPositionMap.put("end_position", endposition_new);
            nodePostion.put(id, timeAndPositionMap);
            this.averageStar(flowNode, earliestNodePostion, newNodePostion, nodePostion);
        }
    }

    private Map<String, BigDecimal> getMinCycle(Map<String, Map<String, Object>> modelMessage) {
        HashMap<String, BigDecimal> minCycleMap = new HashMap<String, BigDecimal>(8);
        for (Map.Entry<String, Map<String, Object>> mapEntry : modelMessage.entrySet()) {
            Map<String, Object> value = mapEntry.getValue();
            minCycleMap.put(mapEntry.getKey(), (BigDecimal)value.get("min"));
        }
        return minCycleMap;
    }

    private void getNodePosition(FlowNode flowNodes, Map<String, List<Integer>> middleFullStageMap, Map<String, BigDecimal> nodeCycle, Map<String, Map<String, BigDecimal>> nodeInfo, Map<String, List<Map<String, Object>>> newNodeInfo, List<Map<String, Object>> milepostList, Map<String, List<String>> parentRelations, Map<String, Map<String, Object>> newNodePos, Map<String, BigDecimal> minCycleMap) {
        List children = flowNodes.getChildren();
        for (FlowNode flowNode : children) {
            Date beginTime = null;
            Date endTime = null;
            BigDecimal begin_position = null;
            BigDecimal end_position = null;
            HashMap<String, Comparable<Date>> timeAndPositionMap = new HashMap<String, Comparable<Date>>(4);
            String id = flowNode.getId();
            List<Integer> stage = middleFullStageMap.get(id);
            if (stage == null) {
                return;
            }
            int fullStageSize = stage.size();
            Map<String, Object> milepostMap = this.getMilepostMap(stage.get(0), milepostList);
            Map<String, BigDecimal> nodeMessge = nodeInfo.get(id);
            BigDecimal begin_node = nodeMessge.get("begin");
            BigDecimal width_node = nodeMessge.get("width");
            BigDecimal end_node = begin_node.add(width_node);
            BigDecimal baselength_me = (BigDecimal)milepostMap.get(BASELENTH);
            Date begintime_me = (Date)milepostMap.get("begintime");
            Date endtime_me = (Date)milepostMap.get("endtime");
            BigDecimal cycle = nodeCycle.get(id);
            BigDecimal minCycle = minCycleMap.get(id);
            Map<String, Object> parentNodeEndTime = this.getParentNodeEndTime(id, parentRelations, newNodeInfo, "endTime");
            if (fullStageSize > 1) {
                Map<String, Object> milepostMap_last = this.getMilepostMap(stage.get(fullStageSize - 1), milepostList);
                if (fullStageSize == 2) {
                    BigDecimal begin;
                    BigDecimal multiply;
                    BigDecimal surplus_l;
                    BigDecimal cycle_l;
                    if (baselength_me.compareTo(cycle) < 0) {
                        beginTime = begintime_me;
                        beginTime = this.getRankBeginTime(parentNodeEndTime, beginTime);
                        long stage_l = endtime_me.getTime() - beginTime.getTime();
                        cycle_l = cycle.multiply(new BigDecimal(DAY));
                        surplus_l = cycle_l.subtract(new BigDecimal(stage_l));
                        BigDecimal day_stage = surplus_l.divide(new BigDecimal(DAY), 4, RoundingMode.HALF_UP);
                        BigDecimal lengthDay = this.getLengthDay(milepostMap_last);
                        multiply = day_stage.multiply(lengthDay);
                        begin = this.getSageBeginOrEndPosition(milepostMap_last, "begin");
                        end_position = begin.add(multiply);
                        begin_position = parentNodeEndTime.size() == 0 ? this.getSageBeginOrEndPosition(milepostMap, "begin") : (BigDecimal)parentNodeEndTime.get("end_position");
                    } else {
                        beginTime = this.calcEndTime(endtime_me, cycle, "end");
                        beginTime = this.getRankBeginTime(parentNodeEndTime, beginTime);
                        long stage_l = endtime_me.getTime() - beginTime.getTime();
                        cycle_l = cycle.multiply(new BigDecimal(DAY));
                        if (cycle_l.compareTo(new BigDecimal(stage_l)) > 0) {
                            surplus_l = cycle_l.subtract(new BigDecimal(stage_l));
                            BigDecimal lengthDay = this.getLengthDay(milepostMap_last);
                            BigDecimal day_stage = surplus_l.divide(new BigDecimal(DAY), 4, RoundingMode.DOWN);
                            multiply = day_stage.multiply(lengthDay);
                            begin = this.getSageBeginOrEndPosition(milepostMap_last, "begin");
                            end_position = begin.add(multiply);
                            begin_position = (BigDecimal)parentNodeEndTime.get("end_position");
                        } else {
                            BigDecimal lengthDay = this.getLengthDay(milepostMap);
                            end_position = this.getSageBeginOrEndPosition(milepostMap, "end");
                            begin_position = end_position.subtract(cycle.multiply(lengthDay));
                        }
                    }
                } else {
                    BigDecimal lengthDay_last;
                    BigDecimal end_first;
                    BigDecimal surplus_day = cycle.subtract(minCycle);
                    BigDecimal lengthDay = this.getLengthDay(milepostMap);
                    if (surplus_day.compareTo(baselength_me) > 0) {
                        beginTime = begintime_me;
                        beginTime = this.getRankBeginTime(parentNodeEndTime, beginTime);
                        BigDecimal divide = new BigDecimal(endtime_me.getTime() - beginTime.getTime()).divide(new BigDecimal(DAY), 4, RoundingMode.HALF_UP);
                        BigDecimal surplus_last = surplus_day.subtract(divide);
                        BigDecimal multiply_first = divide.multiply(lengthDay);
                        end_first = this.getSageBeginOrEndPosition(milepostMap, "end");
                        begin_position = end_first.subtract(multiply_first);
                        lengthDay_last = this.getLengthDay(milepostMap_last);
                        BigDecimal multiply_last = surplus_last.multiply(lengthDay_last);
                        BigDecimal begin_last = this.getSageBeginOrEndPosition(milepostMap_last, "begin");
                        end_position = begin_last.add(multiply_last);
                    } else {
                        Map<String, Object> milepostMap_sec = this.getMilepostMap(stage.get(fullStageSize - 2), milepostList);
                        beginTime = this.calcEndTime(endtime_me, surplus_day, "end");
                        beginTime = this.getRankBeginTime(parentNodeEndTime, beginTime);
                        BigDecimal divide = new BigDecimal(endtime_me.getTime() - beginTime.getTime()).divide(new BigDecimal(DAY), 4, RoundingMode.HALF_UP);
                        BigDecimal multiply = divide.multiply(lengthDay);
                        end_first = this.getSageBeginOrEndPosition(milepostMap, "end");
                        begin_position = end_first.subtract(multiply);
                        lengthDay_last = this.getLengthDay(milepostMap_last);
                        if (divide.compareTo(surplus_day) != 0) {
                            BigDecimal subtract = surplus_day.subtract(divide);
                            BigDecimal multiply_last = subtract.multiply(lengthDay_last);
                            BigDecimal begin_last = this.getSageBeginOrEndPosition(milepostMap_last, "begin");
                            end_position = begin_last.add(multiply_last);
                        } else {
                            end_position = this.getSageBeginOrEndPosition(milepostMap_sec, "end");
                        }
                    }
                }
                endTime = this.calcEndTime(beginTime, cycle, "begin");
            } else {
                beginTime = this.getRankBeginTime(parentNodeEndTime, begintime_me);
                endTime = this.calcEndTime(beginTime, cycle, "begin");
                BigDecimal begin = this.getSageBeginOrEndPosition(milepostMap, "begin");
                begin_position = this.getBeginPosition(parentNodeEndTime, begin);
                end_position = begin_position.add(width_node);
            }
            timeAndPositionMap.put("beginTime", beginTime);
            timeAndPositionMap.put("endTime", endTime);
            timeAndPositionMap.put("begin_position", begin_position);
            timeAndPositionMap.put("end_position", end_position);
            newNodePos.put(id, timeAndPositionMap);
            List<Map<String, Object>> maps = new ArrayList<HashMap<String, Comparable<Date>>>();
            if (newNodeInfo.containsKey(id)) {
                maps = newNodeInfo.get(id);
            }
            maps.add(timeAndPositionMap);
            newNodeInfo.put(id, maps);
            this.getNodePosition(flowNode, middleFullStageMap, nodeCycle, nodeInfo, newNodeInfo, milepostList, parentRelations, newNodePos, minCycleMap);
        }
    }

    private void rankAloneNode(Map<String, List<Integer>> middleFullStageMap, Map<String, BigDecimal> nodeCycle, Map<String, Map<String, BigDecimal>> nodeInfo, Map<String, List<Map<String, Object>>> newNodeInfo, List<Map<String, Object>> milepostList, Map<String, BigDecimal> minCycleMap, List<String> aloneList, Map<String, Map<String, Object>> newNodePostion) {
        for (String id : aloneList) {
            Date beginTime = null;
            Date endTime = null;
            BigDecimal begin_position = null;
            BigDecimal end_position = null;
            HashMap<String, Comparable<Date>> timeAndPositionMap = new HashMap<String, Comparable<Date>>();
            List<Integer> stage = middleFullStageMap.get(id);
            if (stage == null) {
                return;
            }
            int fullStageSize = stage.size();
            Map<String, Object> milepostMap = this.getMilepostMap(stage.get(0), milepostList);
            Map<String, BigDecimal> nodeMessge = nodeInfo.get(id);
            BigDecimal begin_node = nodeMessge.get("begin");
            BigDecimal width_node = nodeMessge.get("width");
            BigDecimal end_node = begin_node.add(width_node);
            BigDecimal baselength_me = (BigDecimal)milepostMap.get(BASELENTH);
            Date begintime_me = (Date)milepostMap.get("begintime");
            Date endtime_me = (Date)milepostMap.get("endtime");
            BigDecimal cycle = nodeCycle.get(id);
            BigDecimal minCycle = minCycleMap.get(id);
            if (fullStageSize > 1) {
                Map<String, Object> milepostMap_last = this.getMilepostMap(stage.get(fullStageSize - 1), milepostList);
                BigDecimal baselength_last = (BigDecimal)milepostMap_last.get(BASELENTH);
                if (fullStageSize == 2) {
                    if (baselength_last.compareTo(cycle) > 0) {
                        beginTime = (Date)milepostMap_last.get("begintime");
                        endTime = this.calcEndTime(beginTime, cycle, "begin");
                        begin_position = this.getSageBeginOrEndPosition(milepostMap_last, "begin");
                        BigDecimal lengthDay = this.getLengthDay(milepostMap_last);
                        BigDecimal multiply = cycle.multiply(lengthDay);
                        end_position = begin_position.add(multiply);
                    } else {
                        endTime = (Date)milepostMap_last.get("endtime");
                        beginTime = this.calcEndTime(endTime, cycle, "end");
                        BigDecimal surplus = cycle.subtract(baselength_last);
                        BigDecimal lengthDay = this.getLengthDay(milepostMap);
                        BigDecimal surplus_length = surplus.multiply(lengthDay);
                        BigDecimal end = this.getSageBeginOrEndPosition(milepostMap, "end");
                        end_position = this.getSageBeginOrEndPosition(milepostMap_last, "end");
                        begin_position = end.subtract(surplus_length);
                    }
                } else {
                    Map<String, Object> milepostMap_sec = this.getMilepostMap(stage.get(1), milepostList);
                    BigDecimal surplus = cycle.subtract(minCycle);
                    if (surplus.compareTo(baselength_last) <= 0) {
                        beginTime = (Date)milepostMap_sec.get("begintime");
                        endTime = this.calcEndTime(beginTime, cycle, "begin");
                        BigDecimal lengthDay_last = this.getLengthDay(milepostMap_last);
                        BigDecimal surplus_length = surplus.multiply(lengthDay_last);
                        BigDecimal begin = this.getSageBeginOrEndPosition(milepostMap_last, "begin");
                        end_position = begin.add(surplus_length);
                        begin_position = this.getSageBeginOrEndPosition(milepostMap_sec, "begin");
                    } else {
                        endTime = (Date)milepostMap_last.get("endtime");
                        beginTime = this.calcEndTime(endTime, cycle, "end");
                        BigDecimal subtract = surplus.subtract(baselength_last);
                        BigDecimal lengthDay = this.getLengthDay(milepostMap);
                        BigDecimal multiply = subtract.multiply(lengthDay);
                        BigDecimal end_first = this.getSageBeginOrEndPosition(milepostMap, "end");
                        begin_position = end_first.subtract(multiply);
                        end_position = this.getSageBeginOrEndPosition(milepostMap_last, "end");
                    }
                }
            } else {
                endTime = endtime_me;
                beginTime = this.calcEndTime(endTime, cycle, "end");
                end_position = this.getSageBeginOrEndPosition(milepostMap, "end");
                BigDecimal lengthDay = this.getLengthDay(milepostMap);
                BigDecimal cycle_leng = cycle.multiply(lengthDay);
                begin_position = end_position.subtract(cycle_leng);
            }
            timeAndPositionMap.put("beginTime", beginTime);
            timeAndPositionMap.put("endTime", endTime);
            timeAndPositionMap.put("begin_position", begin_position);
            timeAndPositionMap.put("end_position", end_position);
            newNodePostion.put(id, timeAndPositionMap);
            ArrayList<HashMap<String, Comparable<Date>>> maps = new ArrayList<HashMap<String, Comparable<Date>>>();
            maps.add(timeAndPositionMap);
            newNodeInfo.put(id, maps);
        }
    }

    private void rankEnd(Map<String, List<Integer>> middleFullStageMap, Map<String, BigDecimal> nodeCycle, Map<String, Map<String, BigDecimal>> nodeInfo, Map<String, List<Map<String, Object>>> newNodeInfo, List<Map<String, Object>> milepostList, Map<String, List<String>> parentRelations, Map<String, List<String>> childRelations, Map<String, BigDecimal> minCycleMap, Set<String> endNodes, Map<String, Map<String, Object>> newNodePostion) {
        for (String id : endNodes) {
            Date beginTime = null;
            Date endTime = null;
            BigDecimal begin_position = null;
            BigDecimal end_position = null;
            List<Integer> stage = middleFullStageMap.get(id);
            HashMap<String, Comparable<Date>> timeAndPositionMap = new HashMap<String, Comparable<Date>>();
            int fullStageSize = stage.size();
            Map<String, Object> milepostMap = this.getMilepostMap(stage.get(0), milepostList);
            Map<String, BigDecimal> nodeMessge = nodeInfo.get(id);
            BigDecimal begin_node = nodeMessge.get("begin");
            BigDecimal width_node = nodeMessge.get("width");
            BigDecimal end_node = begin_node.add(width_node);
            BigDecimal baselength_me = (BigDecimal)milepostMap.get(BASELENTH);
            Date begintime_me = (Date)milepostMap.get("begintime");
            Date endtime_me = (Date)milepostMap.get("endtime");
            BigDecimal cycle = nodeCycle.get(id);
            BigDecimal minCycle = minCycleMap.get(id);
            Map<String, Object> childNodeEndTime = this.getParentNodeEndTime(id, childRelations, newNodeInfo, "beginTime");
            if (fullStageSize > 1) {
                Map<String, Object> milepostMap_last = this.getMilepostMap(stage.get(fullStageSize - 1), milepostList);
                BigDecimal baselength_melast = (BigDecimal)milepostMap_last.get(BASELENTH);
                Date endtime_lastStage = (Date)milepostMap_last.get("endtime");
                Date begintime_lastStage = (Date)milepostMap_last.get("begintime");
                BigDecimal lengthDay_last = this.getLengthDay(milepostMap_last);
                BigDecimal lengthDay = this.getLengthDay(milepostMap);
                if (fullStageSize == 2) {
                    if (baselength_melast.compareTo(cycle) < 0) {
                        Date beginTime_child;
                        endTime = endtime_lastStage;
                        endTime = this.getRankEndTime(childNodeEndTime, endTime);
                        BigDecimal day_stage = cycle.subtract(baselength_me);
                        BigDecimal length_last = baselength_melast.multiply(lengthDay_last);
                        BigDecimal multiply = day_stage.multiply(lengthDay);
                        end_position = this.getSageBeginOrEndPosition(milepostMap_last, "end");
                        if (childNodeEndTime.size() != 0 && endTime.after(beginTime_child = (Date)childNodeEndTime.get("beginTime"))) {
                            end_position = (BigDecimal)childNodeEndTime.get("begin_position");
                        }
                        begin_position = end_position.subtract(multiply).subtract(length_last);
                    } else {
                        endTime = this.calcEndTime(begintime_lastStage, cycle, "begin");
                        endTime = this.getRankEndTime(childNodeEndTime, endTime);
                        long stage_l = endTime.getTime() - begintime_lastStage.getTime();
                        BigDecimal cycle_l = cycle.multiply(new BigDecimal(DAY));
                        if (cycle_l.compareTo(new BigDecimal(stage_l)) > 0) {
                            BigDecimal surplus_l = cycle_l.subtract(new BigDecimal(stage_l));
                            BigDecimal day_stage = surplus_l.divide(new BigDecimal(DAY), 4, RoundingMode.DOWN);
                            BigDecimal multiply = day_stage.multiply(lengthDay);
                            BigDecimal end = this.getSageBeginOrEndPosition(milepostMap, "end");
                            begin_position = end.subtract(multiply);
                            end_position = (BigDecimal)childNodeEndTime.get("begin_position");
                        } else {
                            begin_position = this.getSageBeginOrEndPosition(milepostMap_last, "begin");
                            end_position = begin_position.add(cycle.multiply(lengthDay));
                        }
                    }
                } else {
                    BigDecimal surplus_day = cycle.subtract(minCycle);
                    if (surplus_day.compareTo(baselength_melast) > 0) {
                        endTime = endtime_lastStage;
                        endTime = this.getRankEndTime(childNodeEndTime, endTime);
                        BigDecimal divide = new BigDecimal(endTime.getTime() - begintime_lastStage.getTime()).divide(new BigDecimal(DAY), 4, RoundingMode.HALF_UP);
                        BigDecimal surplus_first = surplus_day.subtract(divide);
                        BigDecimal multiply_last = divide.multiply(lengthDay_last);
                        BigDecimal begin_last = this.getSageBeginOrEndPosition(milepostMap_last, "begin");
                        end_position = begin_last.add(multiply_last);
                        BigDecimal multiply_first = surplus_first.multiply(lengthDay);
                        BigDecimal end_first = this.getSageBeginOrEndPosition(milepostMap, "end");
                        begin_position = end_first.subtract(multiply_first);
                    } else {
                        Map<String, Object> milepostMap_sec = this.getMilepostMap(stage.get(1), milepostList);
                        Date endTime_old = endTime = this.calcEndTime(begintime_lastStage, surplus_day, "begin");
                        endTime = this.getRankEndTime(childNodeEndTime, endTime);
                        BigDecimal divide = new BigDecimal(endTime.getTime() - begintime_lastStage.getTime()).divide(new BigDecimal(DAY), 4, RoundingMode.HALF_UP);
                        BigDecimal multiply = divide.multiply(lengthDay_last);
                        BigDecimal begin_last = this.getSageBeginOrEndPosition(milepostMap_last, "begin");
                        end_position = begin_last.add(multiply);
                        if (endTime_old.compareTo(endTime) != 0) {
                            BigDecimal subtract = surplus_day.subtract(divide);
                            BigDecimal multiply_first = subtract.multiply(lengthDay);
                            BigDecimal end_first = this.getSageBeginOrEndPosition(milepostMap, "end");
                            begin_position = end_first.subtract(multiply_first);
                        } else {
                            begin_position = this.getSageBeginOrEndPosition(milepostMap_sec, "begin");
                        }
                    }
                }
                beginTime = this.calcEndTime(endTime, cycle, "end");
            } else {
                endTime = this.getRankEndTime(childNodeEndTime, endtime_me);
                beginTime = this.calcEndTime(endTime, cycle, "end");
                BigDecimal end = this.getSageBeginOrEndPosition(milepostMap, "end");
                end_position = this.getEndPosition(childNodeEndTime, end);
                begin_position = end_position.subtract(width_node);
            }
            timeAndPositionMap.put("beginTime", beginTime);
            timeAndPositionMap.put("endTime", endTime);
            timeAndPositionMap.put("begin_position", begin_position);
            timeAndPositionMap.put("end_position", end_position);
            newNodePostion.put(id, timeAndPositionMap);
            List<Map<String, Object>> maps = new ArrayList<HashMap<String, Comparable<Date>>>();
            if (newNodeInfo.containsKey(id)) {
                maps = newNodeInfo.get(id);
            }
            maps.add(timeAndPositionMap);
            newNodeInfo.put(id, maps);
            if (parentRelations.get(id) == null) continue;
            List<String> list = parentRelations.get(id);
            HashSet<String> set = new HashSet<String>();
            set.addAll(list);
            this.rankEnd(middleFullStageMap, nodeCycle, nodeInfo, newNodeInfo, milepostList, parentRelations, childRelations, minCycleMap, set, newNodePostion);
        }
    }

    private BigDecimal getBeginPosition(Map<String, Object> parentNodeEndTime, BigDecimal begin) {
        BigDecimal begin_position;
        if (parentNodeEndTime.size() != 0 && (begin_position = (BigDecimal)parentNodeEndTime.get("end_position")).compareTo(begin) > 0) {
            begin = begin_position;
        }
        return begin;
    }

    private BigDecimal getEndPosition(Map<String, Object> parentNodeEndTime, BigDecimal begin) {
        BigDecimal begin_position;
        if (parentNodeEndTime.size() != 0 && (begin_position = (BigDecimal)parentNodeEndTime.get("begin_position")).compareTo(begin) < 0) {
            begin = begin_position;
        }
        return begin;
    }

    private Date calcEndTime(Date beginTime, BigDecimal cycle, String sign) {
        long time = beginTime.getTime();
        if (cycle == null) {
            cycle = BigDecimal.ZERO;
        }
        BigDecimal leaveTime_long = cycle.multiply(BigDecimal.valueOf(86400000L));
        long l = 0L;
        l = "begin".equals(sign) ? time + leaveTime_long.longValue() : time - leaveTime_long.longValue();
        return this.longTimeToDate(l);
    }

    private Date getRankBeginTime(Map<String, Object> parentNodeEndTime, Date begintime_me) {
        Date parentEndTime;
        if (parentNodeEndTime.size() != 0 && (parentEndTime = (Date)parentNodeEndTime.get("endTime")).after(begintime_me)) {
            begintime_me = parentEndTime;
        }
        return begintime_me;
    }

    private Date getRankEndTime(Map<String, Object> childNodeBeginTime, Date endtime_me) {
        Date chilBeginTime;
        if (childNodeBeginTime.size() != 0 && (chilBeginTime = (Date)childNodeBeginTime.get("beginTime")).before(endtime_me)) {
            endtime_me = chilBeginTime;
        }
        return endtime_me;
    }

    private Map<String, Object> getParentNodeEndTime(String id, Map<String, List<String>> parentRelations, Map<String, List<Map<String, Object>>> newNodeInfo, String sign) {
        List<String> parentNoidList = parentRelations.get(id);
        Date endTime = null;
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (parentNoidList != null) {
            for (String nodid : parentNoidList) {
                List<Map<String, Object>> maps = newNodeInfo.get(nodid);
                if (maps == null) continue;
                for (Map<String, Object> map : maps) {
                    if (endTime != null) {
                        if ("beginTime".equals(sign)) {
                            if (!((Date)map.get(sign)).before(endTime)) continue;
                            returnMap.clear();
                            endTime = (Date)map.get(sign);
                            returnMap.putAll(map);
                            continue;
                        }
                        if (!((Date)map.get(sign)).after(endTime)) continue;
                        returnMap.clear();
                        endTime = (Date)map.get(sign);
                        returnMap.putAll(map);
                        continue;
                    }
                    endTime = (Date)map.get(sign);
                    returnMap.putAll(map);
                }
            }
        }
        return returnMap;
    }

    private Map<String, List<Integer>> getMiddleFullStageToCache() {
        String middleFullStages = this.getPageCache().get("middleFullStage");
        Map<String, List<Integer>> middleFullStageMap = new HashMap<String, List<Integer>>();
        if (middleFullStages != null) {
            middleFullStageMap = (Map)SerializationUtils.deSerializeFromBase64((String)middleFullStages);
        }
        return middleFullStageMap;
    }

    private Map<String, Map<String, Object>> getModelMessageToCache() {
        String modelMessage = this.getPageCache().get("modelMessage");
        Map<String, Map<String, Object>> modelMessageMap = new HashMap<String, Map<String, Object>>();
        if (modelMessage != null) {
            modelMessageMap = (Map)SerializationUtils.deSerializeFromBase64((String)modelMessage);
        }
        return modelMessageMap;
    }

    private List<Map<String, Object>> getMilepostListToCache() {
        String milepost = this.getView().getPageCache().get("meilpost");
        ArrayList<Map<String, Object>> milepostList = milepost != null ? (ArrayList<Map<String, Object>>)SerializationUtils.deSerializeFromBase64((String)milepost) : new ArrayList<Map<String, Object>>();
        return milepostList;
    }

    private Map<String, Map<String, BigDecimal>> getNodeInfo(List<Map<String, Object>> nodeMessages) {
        HashMap<String, Map<String, BigDecimal>> nodeMessageMap = new HashMap<String, Map<String, BigDecimal>>();
        for (Map<String, Object> nodeMessage : nodeMessages) {
            String shape = (String)nodeMessage.get("shape");
            if (!"x-rect".equals(shape) && !"x-circle".equals(shape) && !"x-diamond".equals(shape)) continue;
            HashMap<String, BigDecimal> positions = new HashMap<String, BigDecimal>(8);
            String id = (String)nodeMessage.get("id");
            Map position = (Map)nodeMessage.get("position");
            Map size = (Map)nodeMessage.get("size");
            BigDecimal begin_position = new BigDecimal(position.get("x").toString());
            BigDecimal y = new BigDecimal(position.get("y").toString());
            BigDecimal width = new BigDecimal(size.get("width").toString());
            BigDecimal height = new BigDecimal(size.get("height").toString());
            BigDecimal end_position = begin_position.add(width);
            positions.put("begin", begin_position);
            positions.put("width", width);
            positions.put("end_position", end_position);
            positions.put("y", y);
            positions.put("height", height);
            nodeMessageMap.put(id, positions);
        }
        return nodeMessageMap;
    }

    private Map<String, BigDecimal> getNodeCycle() {
        HashMap<String, BigDecimal> cycle = new HashMap<String, BigDecimal>(8);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("flownodeentryentity");
        for (DynamicObject dynamicObject : entryEntity) {
            cycle.put(dynamicObject.getString("nodeid"), dynamicObject.getBigDecimal("nodecycle"));
        }
        return cycle;
    }

    private void actionSave() {
        CustomControl control = (CustomControl)this.getControl("process");
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Boolean> datamap = new HashMap<String, Boolean>();
        map.put("time", new Date());
        map.put("action", "save");
        datamap.put("isCqSave", Boolean.TRUE);
        map.put("data", datamap);
        control.setData(map);
    }

    private void setAccountability(BigDecimal funtion, BigDecimal flow, BigDecimal user, Boolean mon, Boolean qua, Boolean year) {
        String accountability = this.getPageCache().get("accountability");
        HashMap<String, Object> scale = accountability == null ? new HashMap<String, Object>(8) : (HashMap<String, Object>)SerializationUtils.deSerializeFromBase64((String)accountability);
        scale.put("funtion", funtion);
        scale.put("flow", flow);
        scale.put("user", user);
        scale.put("mon", mon);
        scale.put("qua", qua);
        scale.put("year", year);
        String save = SerializationUtils.serializeToBase64(scale);
        this.getPageCache().put("accountability", SerializationUtils.serializeToBase64(scale));
        String showAccountabilityScale = this.getShowAccountabilityScale(scale);
        this.getModel().setValue("accountabilityscalshow", (Object)showAccountabilityScale);
        this.getModel().setValue("accountabilityscal", (Object)showAccountabilityScale);
        this.getModel().setValue("accountabilityscal_tag", (Object)save);
    }

    private String getShowAccountabilityScale(Map<String, Object> scaleMap) {
        StringBuilder stringBuilder = new StringBuilder(ResManager.loadKDString((String)"\u804c\u80fd\u8d23\u4efb\u6bd4:", (String)"FlowDefineEditPlugin_29", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        stringBuilder.append(scaleMap.get("funtion")).append("%,").append(ResManager.loadKDString((String)"\u6d41\u7a0b\u8d23\u4efb\u6bd4:", (String)"FlowDefineEditPlugin_30", (String)"mmc-phm-formplugin", (Object[])new Object[0])).append(scaleMap.get("flow")).append("%,").append(ResManager.loadKDString((String)"\u7ec4\u5458\u8d23\u4efb\u6bd4", (String)"FlowDefineEditPlugin_31", (String)"mmc-phm-formplugin", (Object[])new Object[0])).append(scaleMap.get("user")).append("%");
        return stringBuilder.toString();
    }
}

