/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.basemanager.flow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;

public class SelectConditionPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
F7SelectedListRemoveListener,
RowClickEventListener {
    private static final String TREEVIEWAP = "treeviewap";
    private static List<ValueTextItem> valueTextItems = new ArrayList<ValueTextItem>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getControl(TREEVIEWAP);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        F7SelectedList f7selectedlist = (F7SelectedList)this.getControl("f7selectedlistap");
        f7selectedlist.addF7SelectedListRemoveListener((F7SelectedListRemoveListener)this);
        f7selectedlist.addF7SelectedListRemoveAllListener((F7SelectedListRemoveListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        this.putCusMessageToChache();
        Map<String, String> milepostStage = this.getMilepostStage();
        this.initTree(milepostStage);
        this.loadEntityEntryData("-1");
        this.setSelectConditionToItem();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.selectDefaultRows();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        valueTextItems.clear();
    }

    private void setSelectConditionToItem() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object selectCondition = formShowParameter.getCustomParam("selectcondition");
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl("f7selectedlistap");
        if (selectCondition != null && !selectCondition.toString().isEmpty()) {
            List conditions = (List)SerializationUtils.deSerializeFromBase64((String)selectCondition.toString());
            for (String condition : conditions) {
                ValueTextItem valueTextItem = new ValueTextItem(condition, condition);
                valueTextItems.add(valueTextItem);
            }
        }
        f7SelectedList.addItems(valueTextItems);
    }

    private void loadEntityEntryData(String id) {
        String customParam_message = this.getCusMessageToChache();
        Map map = (Map)SerializationUtils.deSerializeFromBase64((String)customParam_message);
        this.getModel().deleteEntryData("entryentity");
        for (Map.Entry mapEntry : map.entrySet()) {
            String key = (String)mapEntry.getKey();
            List values = (List)mapEntry.getValue();
            for (DynamicObject dynamicObject : values) {
                if (!this.isNeedAddDny(key, id)) continue;
                int rowIndex = this.getModel().createNewEntryRow("entryentity");
                DynamicPropertyCollection properties = (DynamicPropertyCollection)dynamicObject.getDataEntityType().getProperties();
                for (IDataEntityProperty dataEntityProperty : properties) {
                    String name = dataEntityProperty.getName();
                    IDataEntityProperty property = this.getModel().getProperty(name);
                    if (property == null) continue;
                    this.getModel().setValue(name, dynamicObject.get(name), rowIndex);
                }
            }
        }
        this.getView().updateView("entryentity");
    }

    private boolean isNeedAddDny(String key, String id) {
        if ("-1".equals(id)) {
            return true;
        }
        return key.equals(id);
    }

    private void putCusMessageToChache() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object customParam_message = formShowParameter.getCustomParam("dcmessage");
        this.getPageCache().put("cusmessage", customParam_message.toString());
    }

    private String getCusMessageToChache() {
        String cusmessage = this.getPageCache().get("cusmessage");
        if (cusmessage == null) {
            this.putCusMessageToChache();
            cusmessage = this.getPageCache().get("cusmessage");
        }
        return cusmessage;
    }

    private void initTree(Map<String, String> milepostStage) {
        TreeView treeView = (TreeView)this.getControl(TREEVIEWAP);
        TreeNode root = new TreeNode("", "-1", ResManager.loadKDString((String)"\u8282\u70b9", (String)"SelectConditionPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object nodeidandname = formShowParameter.getCustomParam("nodeIdAndName");
        Map nodeidAndName = new HashMap(8);
        if (nodeidandname != null && !nodeidandname.toString().isEmpty()) {
            nodeidAndName = (Map)SerializationUtils.deSerializeFromBase64((String)nodeidandname.toString());
        }
        root.setIsOpened(true);
        for (Map.Entry<String, String> mapEntry : milepostStage.entrySet()) {
            TreeNode treeNode = new TreeNode();
            String nodeId = mapEntry.getKey();
            treeNode.setId(mapEntry.getKey());
            treeNode.setText((String)nodeidAndName.get(nodeId));
            treeNode.setParentid("-1");
            root.addChild(treeNode);
        }
        treeView.addNode(root);
        treeView.focusNode(root);
    }

    private Map<String, String> getMilepostStage() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        HashMap<String, String> stageMap = new HashMap<String, String>(8);
        Object customParam_message = formShowParameter.getCustomParam("dcmessage");
        Map map = (Map)SerializationUtils.deSerializeFromBase64((String)customParam_message.toString());
        Set strings = map.keySet();
        for (String s : strings) {
            stageMap.put(s, s);
        }
        return stageMap;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey())) {
            ArrayList<ValueTextItem> list = new ArrayList<ValueTextItem>(valueTextItems.size());
            list.addAll(valueTextItems);
            this.getView().returnDataToParent(list);
            this.getView().close();
        }
    }

    public void RemoveClick(F7SelectedListRemoveEvent arg) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        if (arg.getParam() == null) {
            entryGrid.clearEntryState();
            valueTextItems.clear();
        } else {
            String number = (String)arg.getParam();
            DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject entry : entrys) {
                if (!entry.getString("deliverablesnumber").equals(number)) continue;
                List rows = Arrays.stream(entryGrid.getSelectRows()).boxed().collect(Collectors.toList());
                rows = rows.stream().filter(e -> entry.getInt("seq") - 1 != e).collect(Collectors.toList());
                entryGrid.selectRows(rows.stream().mapToInt(Integer::valueOf).toArray(), 0);
                break;
            }
            Iterator<ValueTextItem> iterator = valueTextItems.iterator();
            while (iterator.hasNext()) {
                ValueTextItem next = iterator.next();
                if (!number.equals(next.getValue())) continue;
                iterator.remove();
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl("f7selectedlistap");
        int[] rows = entryGrid.getSelectRows();
        valueTextItems.clear();
        for (int i : rows) {
            ValueTextItem item = new ValueTextItem(((DynamicObject)entrys.get(i)).getString("deliverablesnumber"), ((DynamicObject)entrys.get(i)).getString("deliverablesnumber"));
            valueTextItems.add(item);
        }
        f7SelectedList.addItems(valueTextItems);
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String id = e.getNodeId().toString();
        this.loadEntityEntryData(id);
        if (valueTextItems.size() > 0) {
            this.selectDefaultRows();
        }
    }

    private void selectDefaultRows() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        List numbers = valueTextItems.stream().map(ValueTextItem::getValue).collect(Collectors.toList());
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        ArrayList<Integer> selectRows = new ArrayList<Integer>();
        for (DynamicObject entry : entrys) {
            if (!numbers.contains(entry.getString("deliverablesnumber"))) continue;
            selectRows.add(entry.getInt("seq") - 1);
        }
        entryGrid.selectRows(selectRows.stream().mapToInt(Integer::valueOf).toArray(), 0);
    }
}

