/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.basemanager.version;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.mmc.phm.common.basemanager.WeekEnum;
import kd.mmc.phm.common.enums.RepeatMode;

public class PeriodConstsPlugin
extends AbstractFormPlugin {
    private static final String PANEL_CONTENT = "panel_content";
    private static final String OK = "ok";
    private static final String PERIODS = "periods";
    private static final String HOURS = "hours";
    private static final String BYDAY = "byDay";
    private static final String REPEATMODE = "repeatmode";
    private static final Set<String> ORIGINAL_KEYS = Sets.newHashSetWithExpectedSize((int)3);

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        List periods = (List)formShowParameter.getCustomParam(PERIODS);
        List hours = (List)formShowParameter.getCustomParam(HOURS);
        if (periods.isEmpty() && hours.isEmpty()) {
            return;
        }
        String repeatMode = (String)formShowParameter.getCustomParam(REPEATMODE);
        boolean byDay = (Boolean)formShowParameter.getCustomParam(BYDAY);
        FlexPanelAp flexPanelAp = this.createDynamicPanel(periods, hours, repeatMode, byDay);
        HashMap params = Maps.newHashMapWithExpectedSize((int)2);
        params.put("id", PANEL_CONTENT);
        params.put("items", flexPanelAp.createControl().get("items"));
        e.getItems().add(params);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List periods = (List)formShowParameter.getCustomParam(PERIODS);
        List hours = (List)formShowParameter.getCustomParam(HOURS);
        if (periods.isEmpty() && hours.isEmpty()) {
            return;
        }
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode(this.getPluginName(), exp.getMessage()), new Object[0]);
        }
        String repeatMode = (String)formShowParameter.getCustomParam(REPEATMODE);
        boolean byDay = (Boolean)formShowParameter.getCustomParam(BYDAY);
        this.registerProperty(newMainType, periods, hours, repeatMode, byDay);
        e.setNewEntityType(newMainType);
    }

    public void createNewData(BizDataEventArgs e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String value = (String)formShowParameter.getCustomParam("value");
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        List periods = (List)formShowParameter.getCustomParam(PERIODS);
        List hours = (List)formShowParameter.getCustomParam(HOURS);
        String repeatMode = (String)formShowParameter.getCustomParam(REPEATMODE);
        boolean byDay = (Boolean)formShowParameter.getCustomParam(BYDAY);
        Set<String> timeSegment = this.getTimeSegment(periods, hours, repeatMode, byDay);
        Map params = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        for (Map.Entry entry : params.entrySet()) {
            String key = (String)entry.getKey();
            if (!timeSegment.contains(key)) continue;
            dynamicObject.set(key, entry.getValue());
        }
        e.setDataEntity((Object)dynamicObject);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List periods = (List)formShowParameter.getCustomParam(PERIODS);
        List hours = (List)formShowParameter.getCustomParam(HOURS);
        if (periods.isEmpty() && hours.isEmpty()) {
            return;
        }
        String repeatMode = (String)formShowParameter.getCustomParam(REPEATMODE);
        boolean byDay = (Boolean)formShowParameter.getCustomParam(BYDAY);
        FlexPanelAp flexPanelAp = this.createDynamicPanel(periods, hours, repeatMode, byDay);
        Container container = (Container)this.getControl(PANEL_CONTENT);
        container.getItems().addAll(((Container)flexPanelAp.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(container.getItems());
        Control control = (Control)container.getItems().get(0);
        if (control instanceof TextEdit) {
            TextEdit textEdit = (TextEdit)control;
            Tips tips = new Tips();
            tips.setType("text");
            tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u65f6\u95f4\u6bb5\u7684\u91cd\u53e0\u90e8\u5206\u9ed8\u8ba4\u5f52\u5c5e\u4e8e\u4e0b\u4e00\u4e2a\u65f6\u95f4\u6bb5", (String)"PeriodConstsPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0])));
            textEdit.addTips(tips);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (!ORIGINAL_KEYS.contains(key)) {
            TextEdit textEdit = new TextEdit();
            textEdit.setKey(key);
            textEdit.setView(this.getView());
            e.setControl((Control)textEdit);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (OK.equals(operateKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObjectType dt = dataEntity.getDynamicObjectType();
            LinkedHashMap params = Maps.newLinkedHashMapWithExpectedSize((int)dt.getProperties().size());
            for (IDataEntityProperty property : dt.getProperties()) {
                String key = property.getName();
                params.put(key, dataEntity.get(key));
            }
            this.getView().returnDataToParent((Object)params);
            this.getView().close();
        }
    }

    private void registerProperty(MainEntityType newMainType, List<Integer> periods, List<Integer> hours, String repeatMode, boolean byDay) {
        Set<String> timeSegment = this.getTimeSegment(periods, hours, repeatMode, byDay);
        for (String key : timeSegment) {
            TextProp textProp = new TextProp();
            textProp.setName(key);
            textProp.setDisplayName(new LocaleString(key));
            textProp.setDbIgnore(true);
            newMainType.registerSimpleProperty((DynamicSimpleProperty)textProp);
        }
    }

    private FlexPanelAp createDynamicPanel(List<Integer> periods, List<Integer> hours, String repeatMode, boolean byDay) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey("panel_dynamic");
        flexPanelAp.setAlignItems("center");
        flexPanelAp.setJustifyContent("center");
        List items = flexPanelAp.getItems();
        Set<String> timeSegment = this.getTimeSegment(periods, hours, repeatMode, byDay);
        for (String key : timeSegment) {
            FieldAp fieldAp = new FieldAp();
            fieldAp.setId(key);
            fieldAp.setKey(key);
            fieldAp.setName(new LocaleString(key));
            fieldAp.setFireUpdEvt(true);
            TextField textField = new TextField();
            textField.setId(key);
            textField.setKey(key);
            textField.setMustInput(true);
            fieldAp.setField((Field)textField);
            items.add(fieldAp);
        }
        return flexPanelAp;
    }

    private Set<String> getTimeSegment(List<Integer> periods, List<Integer> hours, String repeatMode, boolean byDay) {
        boolean isMonth = RepeatMode.MONTH.getValue().equals(repeatMode);
        int hourSize = hours.size();
        if (periods.isEmpty()) {
            return this.getTimeSegmentByEmptyPeriod(hours);
        }
        int periodSize = periods.size();
        if (periodSize == 1 && hourSize == 1) {
            if (byDay) {
                return this.getTimeSegmentBySingleDayAndHour(periods, hours, isMonth);
            }
            return Sets.newHashSet((Object[])new String[]{this.convertNoWeek(periods.get(0)) + this.convertHourStr(hours.get(0))});
        }
        if (periodSize == 1 && hourSize > 1) {
            return this.getTimeSegmentBySingleDayAndMuiltyHour(periods, hours, isMonth, byDay);
        }
        if (periodSize > 1 && hourSize == 1) {
            return this.getTimeSegmentByMuiltyDayAndSingleHour(periods, hours, isMonth);
        }
        return this.getTimeSegmentByMuiltyDayAndHour(periods, hours, isMonth);
    }

    private String convertNoWeek(int noWeek) {
        switch (noWeek) {
            case 1: {
                return ResManager.loadKDString((String)"\u661f\u671f\u65e5", (String)"PeriodConstsPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]);
            }
            case 2: {
                return ResManager.loadKDString((String)"\u661f\u671f\u4e00", (String)"PeriodConstsPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]);
            }
            case 3: {
                return ResManager.loadKDString((String)"\u661f\u671f\u4e8c", (String)"PeriodConstsPlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]);
            }
            case 4: {
                return ResManager.loadKDString((String)"\u661f\u671f\u4e09", (String)"PeriodConstsPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]);
            }
            case 5: {
                return ResManager.loadKDString((String)"\u661f\u671f\u56db", (String)"PeriodConstsPlugin_5", (String)"mmc-phm-formplugin", (Object[])new Object[0]);
            }
            case 6: {
                return ResManager.loadKDString((String)"\u661f\u671f\u4e94", (String)"PeriodConstsPlugin_6", (String)"mmc-phm-formplugin", (Object[])new Object[0]);
            }
            case 7: {
                return ResManager.loadKDString((String)"\u661f\u671f\u516d", (String)"PeriodConstsPlugin_7", (String)"mmc-phm-formplugin", (Object[])new Object[0]);
            }
            case 8: {
                return ResManager.loadKDString((String)"\u81ea\u7136\u65e5", (String)"PeriodConstsPlugin_8", (String)"mmc-phm-formplugin", (Object[])new Object[0]);
            }
            case 9: {
                return ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5", (String)"PeriodConstsPlugin_9", (String)"mmc-phm-formplugin", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private Set<String> getTimeSegmentByEmptyPeriod(List<Integer> hours) {
        int hourSize = hours.size();
        if (hourSize == 1) {
            return Sets.newHashSet((Object[])new String[]{this.convertHourStr(hours.get(0))});
        }
        LinkedHashSet timeSegment = Sets.newLinkedHashSetWithExpectedSize((int)hourSize);
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < hourSize; ++i) {
            int previous = hours.get(i - 1);
            this.fillZero(sb, previous);
            sb.append('-');
            int current = hours.get(i);
            this.fillZero(sb, current);
            sb.append('\u65f6');
            timeSegment.add(sb.toString());
            sb.setLength(0);
        }
        int last = hours.get(hourSize - 1);
        this.fillZero(sb, last);
        sb.append('-');
        int first = hours.get(0);
        this.fillZero(sb, first);
        sb.append('\u65f6');
        timeSegment.add(sb.toString());
        return timeSegment;
    }

    private Set<String> getTimeSegmentByMuiltyDayAndHour(List<Integer> periods, List<Integer> hours, boolean isMonth) {
        LinkedHashSet<String> timeSegment = new LinkedHashSet<String>();
        StringBuilder sb = new StringBuilder();
        int periodSize = periods.size();
        int hourSize = hours.size();
        for (int i = 0; i < periodSize; ++i) {
            String periodStr = isMonth ? this.convertDayStr(periods.get(i)) : this.convertWeekStr(periods.get(i));
            for (int j = 1; j < hourSize; ++j) {
                sb.append(periodStr);
                int previous = hours.get(j - 1);
                this.fillZero(sb, previous);
                sb.append('\u65f6').append('-');
                sb.append(periodStr);
                int current = hours.get(j);
                this.fillZero(sb, current);
                sb.append('\u65f6');
                timeSegment.add(sb.toString());
                sb.setLength(0);
            }
            sb.append(periodStr);
            int last = hours.get(hourSize - 1);
            this.fillZero(sb, last);
            sb.append('\u65f6').append('-');
            int nextPeriodIndex = i + 1;
            if (nextPeriodIndex >= periodSize) {
                nextPeriodIndex = 0;
            }
            Integer nextPeriod = periods.get(nextPeriodIndex);
            int first = hours.get(0);
            sb.append(isMonth ? this.convertDayStr(nextPeriod) : this.convertWeekStr(nextPeriod));
            this.fillZero(sb, first);
            sb.append('\u65f6');
            timeSegment.add(sb.toString());
            sb.setLength(0);
        }
        return timeSegment;
    }

    private Set<String> getTimeSegmentByMuiltyDayAndSingleHour(List<Integer> periods, List<Integer> hours, boolean isMonth) {
        StringBuilder sb = new StringBuilder();
        Integer hour = hours.get(0);
        String hourStr = this.convertHourStr(hour);
        int periodSize = periods.size();
        LinkedHashSet timeSegment = Sets.newLinkedHashSetWithExpectedSize((int)periodSize);
        for (int i = 1; i < periodSize; ++i) {
            Integer previous = periods.get(i - 1);
            if (isMonth) {
                this.fillZero(sb, previous);
                sb.append('\u65e5');
            } else {
                sb.append(this.convertWeekStr(previous));
            }
            sb.append(hourStr).append('-');
            int current = periods.get(i);
            if (isMonth) {
                this.fillZero(sb, current);
                sb.append('\u65e5');
            } else {
                sb.append(this.convertWeekStr(current));
            }
            sb.append(hourStr);
            timeSegment.add(sb.toString());
            sb.setLength(0);
        }
        int last = periods.get(periodSize - 1);
        if (isMonth) {
            this.fillZero(sb, last);
            sb.append('\u65e5');
        } else {
            sb.append(this.convertWeekStr(last));
        }
        sb.append(hourStr).append('-');
        int first = periods.get(0);
        if (isMonth) {
            this.fillZero(sb, first);
            sb.append('\u65e5');
        } else {
            sb.append(this.convertWeekStr(first));
        }
        sb.append(hourStr);
        timeSegment.add(sb.toString());
        return timeSegment;
    }

    private Set<String> getTimeSegmentBySingleDayAndHour(List<Integer> periods, List<Integer> hours, boolean isMonth) {
        LinkedHashSet<String> timeSegment = new LinkedHashSet<String>();
        StringBuilder sb = new StringBuilder();
        Integer period = periods.get(0);
        if (period == -1) {
            sb.append(ResManager.loadKDString((String)"\u6700\u540e\u4e00\u65e5", (String)"PeriodConstsPlugin_10", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        } else if (isMonth) {
            this.fillZero(sb, period);
            sb.append('\u65e5');
        } else {
            sb.append(WeekEnum.forValue((int)period).getName());
        }
        this.fillZero(sb, hours.get(0));
        sb.append('\u65f6');
        timeSegment.add(sb.toString());
        return timeSegment;
    }

    private Set<String> getTimeSegmentBySingleDayAndMuiltyHour(List<Integer> periods, List<Integer> hours, boolean isMonth, boolean byDay) {
        StringBuilder sb = new StringBuilder();
        int period = periods.get(0);
        int hourSize = hours.size();
        LinkedHashSet timeSegment = Sets.newLinkedHashSetWithExpectedSize((int)hourSize);
        String periodStr = isMonth ? (byDay ? this.convertDayStr(period) : this.convertNoWeek(period)) : this.convertWeekStr(period);
        for (int i = 1; i < hourSize; ++i) {
            sb.append(periodStr);
            int previous = hours.get(i - 1);
            this.fillZero(sb, previous);
            sb.append('\u65f6').append('-');
            sb.append(periodStr);
            int current = hours.get(i);
            this.fillZero(sb, current);
            sb.append('\u65f6');
            timeSegment.add(sb.toString());
            sb.setLength(0);
        }
        sb.append(periodStr);
        int last = hours.get(hourSize - 1);
        this.fillZero(sb, last);
        sb.append('\u65f6').append('-');
        sb.append(periodStr);
        int first = hours.get(0);
        this.fillZero(sb, first);
        sb.append('\u65f6');
        timeSegment.add(sb.toString());
        return timeSegment;
    }

    private String convertWeekStr(int num) {
        return WeekEnum.forValue((int)num).getName();
    }

    private String convertDayStr(int num) {
        if (num <= 0) {
            return ResManager.loadKDString((String)"\u6700\u540e\u4e00\u65e5", (String)"PeriodConstsPlugin_10", (String)"mmc-phm-formplugin", (Object[])new Object[0]);
        }
        return num < 10 ? "0" + num + ResManager.loadKDString((String)"\u65e5", (String)"PeriodConstsPlugin_11", (String)"mmc-phm-formplugin", (Object[])new Object[0]) : num + ResManager.loadKDString((String)"\u65e5", (String)"PeriodConstsPlugin_11", (String)"mmc-phm-formplugin", (Object[])new Object[0]);
    }

    private String convertHourStr(int num) {
        if (num < 0) {
            num = 23;
        }
        return num < 10 ? "0" + num + ResManager.loadKDString((String)"\u65f6", (String)"PeriodConstsPlugin_12", (String)"mmc-phm-formplugin", (Object[])new Object[0]) : num + ResManager.loadKDString((String)"\u65f6", (String)"PeriodConstsPlugin_12", (String)"mmc-phm-formplugin", (Object[])new Object[0]);
    }

    private void fillZero(StringBuilder sb, int num) {
        if (num < 10) {
            sb.append('0');
        }
        sb.append(num);
    }

    static {
        ORIGINAL_KEYS.add(PANEL_CONTENT);
        ORIGINAL_KEYS.add("btnok");
        ORIGINAL_KEYS.add("btncancel");
    }
}

