/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.basemanager.version;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.coderule.enums.CodeRuleEntryTypeEnum;
import kd.bos.coderule.newedit.NumberUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.mmc.phm.common.basemanager.ScheduleConsts;
import kd.mmc.phm.common.enums.RepeatMode;
import kd.mmc.phm.common.util.ShowFormUtils;
import org.apache.commons.lang3.time.DateUtils;

public class VersionRuleEdit
extends AbstractBillPlugIn {
    private static final String EMPTY = "EMPTY";
    private static final String KEY_CLOSE = "close";
    private static final String ENTITY_PERIOD_CONSTS = "phm_period_consts";

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        model.createNewEntryRow("entryentity");
        model.setValue("codesegment", (Object)ResManager.loadKDString((String)"\u7f16\u7801\u4e00\u6bb5", (String)"VersionRuleEdit_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]), 0);
        model.endInit();
        model.setValue("repeatmode", (Object)RepeatMode.MONTH.getValue());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.hideFirstRowSeparator();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit textEdit = (TextEdit)this.getControl("periodconsts");
        textEdit.addButtonClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("periodconsts".equals(control.getKey())) {
            int i;
            IDataModel model = this.getModel();
            String repeatMode = (String)model.getValue("repeatmode");
            Date startTime = (Date)this.getModel().getValue("validated_time");
            boolean byDay = true;
            ArrayList<Integer> periods = new ArrayList<Integer>();
            if (RepeatMode.MONTH.getValue().equals(repeatMode)) {
                String byDayOrWeek = (String)model.getValue("combdorw");
                if (RepeatMode.DAY.getValue().equals(byDayOrWeek)) {
                    if (((Boolean)model.getValue("cklastday")).booleanValue()) {
                        periods.add(-1);
                    } else {
                        for (i = 0; i < ScheduleConsts.CKDATE.size(); ++i) {
                            if (!((Boolean)model.getValue((String)ScheduleConsts.CKDATE.get(i))).booleanValue()) continue;
                            periods.add(i + 1);
                        }
                    }
                } else if (RepeatMode.WEEK.getValue().equals(byDayOrWeek)) {
                    String no = (String)model.getValue("comno");
                    String noWeek = (String)model.getValue("comweek");
                    if (StringUtils.isNotBlank((CharSequence)no) && StringUtils.isNotBlank((CharSequence)noWeek)) {
                        periods.add(Integer.parseInt(noWeek));
                    }
                    if (periods.isEmpty()) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(startTime);
                        periods.add(calendar.get(7));
                    }
                    byDay = false;
                }
            } else if (RepeatMode.WEEK.getValue().equals(repeatMode)) {
                for (int i2 = 0; i2 < ScheduleConsts.CKWEEK.size(); ++i2) {
                    if (!((Boolean)model.getValue((String)ScheduleConsts.CKWEEK.get(i2))).booleanValue()) continue;
                    periods.add(i2 + 1);
                }
                if (periods.isEmpty()) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(startTime);
                    periods.add(calendar.get(7));
                }
            }
            ArrayList<Integer> hours = new ArrayList<Integer>();
            for (i = 0; i < 24; ++i) {
                String hour;
                String string = hour = i < 10 ? "ckhour_0" + i : "ckhour_" + i;
                if (!((Boolean)model.getValue(hour)).booleanValue()) continue;
                hours.add(i);
            }
            if (hours.isEmpty()) {
                int hour = Integer.parseInt(String.valueOf(DateUtils.getFragmentInHours((Date)startTime, (int)5)));
                hours.add(hour);
            }
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("periods", periods);
            params.put("repeatmode", repeatMode);
            params.put("hours", hours);
            params.put("byDay", byDay);
            int entryCurrentRowIndex = model.getEntryCurrentRowIndex("entryentity");
            params.put("value", model.getValue("constsjson", entryCurrentRowIndex));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "periodconsts");
            FormShowParameter formShowParameter = ShowFormUtils.assembleShowFormParam((String)ENTITY_PERIOD_CONSTS, params, (CloseCallBack)closeCallBack, (ShowType)ShowType.Modal);
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if ("periodconsts".equals(actionId) && returnData instanceof Map) {
            Map returnParams = (Map)returnData;
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : returnParams.entrySet()) {
                sb.append((String)entry.getKey()).append(": ").append(entry.getValue()).append('\n');
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.getModel().setValue("periodconsts", (Object)sb.toString(), entryCurrentRowIndex);
            this.getModel().setValue("constsjson", (Object)SerializationUtils.toJsonString((Object)returnParams), entryCurrentRowIndex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if (changeData.getNewValue() == null) {
            return;
        }
        if ("txtdesc".equals(name)) {
            IDataModel model = this.getModel();
            String desc = (String)model.getValue("txtdesc");
            desc = StringUtils.replace((String)desc, (String)ResManager.loadKDString((String)"\u91cd\u590d", (String)"VersionRuleEdit_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u8fdb\u884c\u7248\u672c\u5207\u6362", (String)"VersionRuleEdit_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            desc = StringUtils.replace((String)desc, (String)ResManager.loadKDString((String)"\u6267\u884c", (String)"VersionRuleEdit_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u7248\u672c\u5207\u6362", (String)"VersionRuleEdit_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            model.setValue("txtdesc", (Object)desc);
            return;
        }
        if ("example".equals(name) || "codesegment".equals(name)) {
            return;
        }
        if ("codetype".equals(name)) {
            if (this.validateCodeType(changeData)) {
                return;
            }
        } else if ("constantvalue".equals(name)) {
            if (this.validateConstsValue(changeData)) {
                return;
            }
        } else if (ScheduleConsts.CKDATE.contains(name) || name.startsWith("ckhour_") || ScheduleConsts.CKWEEK.contains(name) || "comweekbyweek".equals(name) || "combdorw".equals(name)) {
            if (ScheduleConsts.CKDATE.contains(name) && ((Boolean)changeData.getNewValue()).booleanValue()) {
                this.getModel().setValue("cklastday", null);
            }
            this.clearPeriodConsts();
        } else if ("cklastday".equals(name)) {
            this.clearPeriodConsts();
        }
        this.resetExample();
    }

    private void clearPeriodConsts() {
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < entryRowCount; ++i) {
            this.getModel().setValue("periodconsts", null, i);
        }
    }

    private boolean validateConstsValue(ChangeData changeData) {
        String constantValue = (String)changeData.getNewValue();
        if (StringUtils.contains((CharSequence)constantValue, (CharSequence)"!")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u4e2d\u4e0d\u53ef\u5305\u542b\u7b26\u53f7\u201c!\u201d", (String)"VersionRuleEdit_5", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("constantvalue", null, changeData.getRowIndex());
            return true;
        }
        return false;
    }

    private boolean validateCodeType(ChangeData changeData) {
        String codeType = (String)changeData.getNewValue();
        int rowIndex = changeData.getRowIndex();
        CodeRuleEntryTypeEnum typeEnum = CodeRuleEntryTypeEnum.getEnums((String)codeType);
        if (CodeRuleEntryTypeEnum.TYPE_SEQ == typeEnum || CodeRuleEntryTypeEnum.TYPE_RANDOM_NUMBER == typeEnum) {
            DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity");
            CodeRuleEntryTypeEnum mutexTypeEnum = typeEnum == CodeRuleEntryTypeEnum.TYPE_SEQ ? CodeRuleEntryTypeEnum.TYPE_RANDOM_NUMBER : CodeRuleEntryTypeEnum.TYPE_SEQ;
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                boolean isSame;
                DynamicObject dynamicObject = (DynamicObject)collection.get(i);
                String type = dynamicObject.getString("codetype");
                boolean bl = isSame = i != rowIndex && StringUtils.equals((CharSequence)codeType, (CharSequence)type);
                if (isSame) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u201c%s\u201d\u7c7b\u578b\u7684\u7f16\u7801\u6bb5\u3002", (String)"VersionRuleEdit_6", (String)"mmc-phm-formplugin", (Object[])new Object[0]), typeEnum.getDesc()));
                    this.getModel().setValue("codetype", changeData.getOldValue(), rowIndex);
                    return true;
                }
                boolean hasMutexType = mutexTypeEnum.getTypeStr().equals(type);
                if (!hasMutexType) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u968f\u673a\u7801\u201d\u4e0e\u201c\u6d41\u6c34\u53f7\u201d\u7c7b\u578b\u7684\u7f16\u7801\u6bb5\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u3002", (String)"VersionRuleEdit_7", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("codetype", changeData.getOldValue(), rowIndex);
                return true;
            }
        }
        return false;
    }

    private void resetExample() {
        StringBuilder example = new StringBuilder();
        DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity");
        int size = collection.size();
        block6: for (int i = 0; i < size; ++i) {
            DynamicObject dynamicObject = (DynamicObject)collection.get(i);
            if (i != 0) {
                String separators = dynamicObject.getString("separators");
                if (EMPTY.equals(separators)) {
                    separators = "";
                }
                example.append(separators);
            }
            String codyType = dynamicObject.getString("codetype");
            CodeRuleEntryTypeEnum typeEnum = CodeRuleEntryTypeEnum.getEnums((String)codyType);
            switch (typeEnum) {
                case TYPE_FIX_TEXT: {
                    boolean isPeriodConsts = dynamicObject.getBoolean("isperiodconsts");
                    if (isPeriodConsts) {
                        String constsJson = dynamicObject.getString("constsjson");
                        String periodConsts = dynamicObject.getString("periodconsts");
                        if (StringUtils.isBlank((CharSequence)periodConsts) || StringUtils.isBlank((CharSequence)constsJson)) continue block6;
                        Map constsMap = (Map)SerializationUtils.fromJsonString((String)constsJson, Map.class);
                        for (Map.Entry entry : constsMap.entrySet()) {
                            example.append(entry.getValue()).append('/');
                        }
                        example.delete(example.length() - 1, example.length());
                        continue block6;
                    }
                    example.append(dynamicObject.getString("constantvalue"));
                    continue block6;
                }
                case TYPE_SEQ: {
                    String initialValue = dynamicObject.getString("initialvalue");
                    int dValue = dynamicObject.getInt("length") - initialValue.length();
                    if (dValue < 0) {
                        initialValue = "1";
                    }
                    for (int j = 0; j < dValue; ++j) {
                        example.append('0');
                    }
                    example.append(initialValue);
                    continue block6;
                }
                case TYPE_RANDOM_NUMBER: {
                    int length = dynamicObject.getInt("length");
                    for (int j = 0; j < length; ++j) {
                        example.append('X');
                    }
                    continue block6;
                }
                case TYPE_SYSTEM_TIME_FIELD: {
                    String dateFormat = dynamicObject.getString("dateformat");
                    if (StringUtils.isBlank((CharSequence)dateFormat)) continue block6;
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
                    example.append(simpleDateFormat.format(new Date()));
                    continue block6;
                }
            }
        }
        this.getModel().setValue("example", (Object)example.toString());
    }

    private void hideFirstRowSeparator() {
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        if (entryRowCount > 0) {
            CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
            cardEntry.setChildVisible(false, 0, new String[]{"separators"});
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if ("entryentity".equals(e.getEntryProp().getName())) {
            RowDataEntity rowDataEntity = e.getRowDataEntities()[0];
            int rowIndex = rowDataEntity.getRowIndex();
            int entryRowCount = this.getModel().getEntryRowCount("entryentity");
            if (entryRowCount == 21) {
                this.getModel().deleteEntryRow("entryentity", rowIndex);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u6bb5\u6570\u91cf\u8d85\u8fc7\u4e0a\u9650\u503c, \u65e0\u6cd5\u7ee7\u7eed\u65b0\u589e\u3002", (String)"VersionRuleEdit_8", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (rowIndex == 0) {
                CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
                cardEntry.setChildVisible(false, rowIndex, new String[]{"separators"});
            }
            this.getModel().setValue("separators", this.getModel().getValue("default_separators"), rowIndex);
            this.getModel().setValue("codesegment", (Object)(ResManager.loadKDString((String)"\u7f16\u7801", (String)"VersionRuleEdit_9", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + NumberUtil.toChinese((String)String.valueOf(rowIndex + 1)) + ResManager.loadKDString((String)"\u6bb5", (String)"VersionRuleEdit_10", (String)"mmc-phm-formplugin", (Object[])new Object[0])), rowIndex);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        int rowCount;
        if ("entryentity".equals(e.getEntryProp().getName()) && (rowCount = this.getModel().getEntryRowCount("entryentity")) == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u9700\u8981\u4e00\u6761\u7f16\u7801\u89c4\u5219\u5206\u6bb5\u3002", (String)"VersionRuleEdit_11", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if ("entryentity".equals(e.getEntryProp().getName())) {
            int entryRowCount = this.getModel().getEntryRowCount("entryentity");
            for (int i = 0; i < entryRowCount; ++i) {
                this.getModel().setValue("codesegment", (Object)(ResManager.loadKDString((String)"\u7f16\u7801", (String)"VersionRuleEdit_9", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + NumberUtil.toChinese((String)String.valueOf(i + 1)) + ResManager.loadKDString((String)"\u6bb5", (String)"VersionRuleEdit_10", (String)"mmc-phm-formplugin", (Object[])new Object[0])), i);
            }
            this.resetExample();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getPageCache().get(KEY_CLOSE) == null) {
            if (this.getModel().getDataChanged()) {
                e.setCancel(true);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u6539\u53d8\uff0c\u662f\u5426\u7ee7\u7eed\u9000\u51fa\uff1f", (String)"VersionRuleEdit_12", (String)"mmc-phm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(KEY_CLOSE, (IFormPlugin)this));
            }
        } else {
            e.setCheckDataChange(false);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (KEY_CLOSE.equals(event.getCallBackId()) && event.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.getPageCache().put(KEY_CLOSE, "");
            this.getView().close();
        }
    }
}

