/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.mmc.phm.common.info.ComponentInfo;
import kd.mmc.phm.common.util.ComponentUtil;
import kd.mmc.phm.common.util.ShowFormUtils;

public class AbstractConfigurePlugin
extends AbstractFormPlugin {
    protected static final String BACK_COLOR = "backcolor";
    protected static final String ACTION = "Action";
    protected static final String WIDTH = "width";
    protected static final String HEIGHT = "height";
    protected static final String ACTION_EIGENVALUE = "action_eigenvalue";
    protected static final String ACTION_EIGENVALUE_ENTITY = "phm_action_eigenvalue";
    private static final String BACKGROUND_COLOR_ENTITY = "phm_background_color";
    private static final String FONT_COLOR = "fontcolor";
    private static final String CUSTOM_CONTROL = "customcontrolap";
    public static final String HEAD_COLOR = "headcolor";

    public void registerListener(EventObject e) {
        TextEdit actionEigenvalueEdit;
        TextEdit headColorEdit;
        TextEdit fontColorEdit;
        super.registerListener(e);
        TextEdit backColorEdit = (TextEdit)this.getControl(BACK_COLOR);
        if (Objects.nonNull(backColorEdit)) {
            backColorEdit.addButtonClickListener((ClickListener)this);
        }
        if (Objects.nonNull(fontColorEdit = (TextEdit)this.getControl(FONT_COLOR))) {
            fontColorEdit.addButtonClickListener((ClickListener)this);
        }
        if (Objects.nonNull(headColorEdit = (TextEdit)this.getControl(HEAD_COLOR))) {
            headColorEdit.addButtonClickListener((ClickListener)this);
        }
        if (Objects.nonNull(actionEigenvalueEdit = (TextEdit)this.getControl(ACTION_EIGENVALUE))) {
            actionEigenvalueEdit.addButtonClickListener((ClickListener)this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String controlKey = control.getKey();
        if (StringUtils.equals((CharSequence)BACK_COLOR, (CharSequence)controlKey) || StringUtils.equals((CharSequence)FONT_COLOR, (CharSequence)controlKey) || StringUtils.equals((CharSequence)HEAD_COLOR, (CharSequence)controlKey)) {
            String color = (String)this.getModel().getValue(controlKey);
            HashMap<String, String> customParams = new HashMap<String, String>(2);
            customParams.put(BACK_COLOR, color);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, controlKey);
            FormShowParameter formShowParameter = ShowFormUtils.assembleShowFormParam((String)BACKGROUND_COLOR_ENTITY, customParams, (CloseCallBack)closeCallBack, (ShowType)ShowType.Modal);
            this.getView().showForm(formShowParameter);
        } else if (StringUtils.equals((CharSequence)ACTION_EIGENVALUE, (CharSequence)controlKey)) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ACTION_EIGENVALUE);
            HashMap<String, Object> customParams = new HashMap<String, Object>(3);
            customParams.put("bizModelPageId", this.getView().getFormShowParameter().getParentPageId());
            customParams.put("bizModelId", this.getView().getParentView().getFormShowParameter().getCustomParam("bizModelId"));
            FormShowParameter formShowParameter = ShowFormUtils.assembleShowFormParam((String)ACTION_EIGENVALUE_ENTITY, customParams, (CloseCallBack)closeCallBack, (ShowType)ShowType.Modal);
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        boolean isColor;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        IDataModel model = this.getModel();
        boolean bl = isColor = StringUtils.equals((CharSequence)BACK_COLOR, (CharSequence)actionId) || StringUtils.equals((CharSequence)FONT_COLOR, (CharSequence)actionId) || StringUtils.equals((CharSequence)HEAD_COLOR, (CharSequence)actionId);
        if (isColor && Objects.nonNull(returnData)) {
            model.setValue(actionId, returnData);
        } else if (StringUtils.equals((CharSequence)ACTION_EIGENVALUE, (CharSequence)actionId) && returnData instanceof Map) {
            Map result = (Map)returnData;
            for (Map.Entry entry : result.entrySet()) {
                model.setValue((String)entry.getKey(), entry.getValue());
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        String componentId;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String bizModelPageId = formShowParameter.getParentPageId();
        ComponentInfo componentInfo = ComponentUtil.getComponentInfo((String)bizModelPageId, (String)(componentId = (String)formShowParameter.getCustomParam("componentId")));
        if (Objects.isNull(componentInfo)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u4ef6\u4fe1\u606f\u4e0d\u5b58\u5728", (String)"AbstractConfigurePlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
        IDataModel model = this.getModel();
        Map properties = componentInfo.getProperties();
        for (Map.Entry entry : properties.entrySet()) {
            model.setValue((String)entry.getKey(), entry.getValue());
        }
    }

    public void afterBindData(EventObject e) {
        Object billStatus = this.getView().getFormShowParameter().getCustomParam("billStatus");
        if (billStatus instanceof String && "A".equals(billStatus)) {
            this.getView().setStatus(OperationStatus.EDIT);
        } else {
            this.getView().setStatus(OperationStatus.VIEW);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String bizModelPageId = formShowParameter.getParentPageId();
        String componentId = (String)formShowParameter.getCustomParam("componentId");
        Map componentInfoMap = ComponentUtil.getComponentInfoMap((String)bizModelPageId);
        ComponentInfo componentInfo = (ComponentInfo)componentInfoMap.get(componentId);
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if (StringUtils.equals((CharSequence)"number", (CharSequence)name) && StringUtils.isNotBlank((CharSequence)newValue.toString())) {
            boolean exists = componentInfoMap.entrySet().stream().anyMatch(entry -> {
                ComponentInfo value = (ComponentInfo)entry.getValue();
                Map properties = value.getProperties();
                return value.getComponentType() == componentInfo.getComponentType() && StringUtils.equals((CharSequence)newValue.toString(), (CharSequence)((String)properties.get(name)));
            });
            FieldTip fieldTip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, name, ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728", (String)"AbstractConfigurePlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            fieldTip.setSuccess(!exists);
            this.getView().showFieldTip(fieldTip);
            if (exists) {
                this.getModel().setValue(name, (Object)"");
                TextEdit textEdit = (TextEdit)this.getControl(name);
                textEdit.setFocus(true);
                return;
            }
        }
        Map properties = componentInfo.getProperties();
        properties.put(name, newValue);
        ComponentUtil.putComponentInfoMapCache((Map)componentInfoMap, (String)bizModelPageId);
    }

    void setCustomControlData(Map<String, Object> params) {
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        CustomControl customControl = (CustomControl)parentView.getControl(CUSTOM_CONTROL);
        customControl.setData(params);
        view.sendFormAction(parentView);
    }

    void addStyle(String key, Object value) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)4);
        params.put(ACTION, "addStyle");
        params.put("id", this.getView().getFormShowParameter().getCustomParam("componentId"));
        params.put("key", key);
        params.put("value", value);
        this.setCustomControlData(params);
    }
}

