/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.phm.common.bizmodel.ComponentType;
import kd.mmc.phm.common.info.ComponentInfo;
import kd.mmc.phm.common.util.ComponentUtil;

public class ActionEigenvaluePlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String ENTITY = "phm_action_eigenvalue";
    private static final String FILTER_CONTAINER = "filtercontainerap";
    private static final String REGION = "region";
    private static final String REGION_NAME = "region_name";
    private static final String BIZTYPE = "biztype";
    private static final String MODEL_NUMBER = "model_number";
    private static final String MODEL_NAME = "model_name";
    private static final String ENTRYENTITY = "entryentity";
    private static final String ENTRY_ENTRYENTITY = "entry_entryentity";

    public void initialize() {
        super.initialize();
        FilterContainer filterContainer = (FilterContainer)this.getControl(FILTER_CONTAINER);
        filterContainer.setBillFormId(ENTITY);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.isFromQueryComponent()) {
            HashMap<String, Boolean> properties = new HashMap<String, Boolean>(2);
            properties.put("ismul", Boolean.TRUE);
            this.getView().updateControlMetadata(ENTRY_ENTRYENTITY, properties);
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String bizModelPageId = (String)formShowParameter.getCustomParam("bizModelPageId");
        ArrayList<ComponentInfo> elementInfoList = new ArrayList<ComponentInfo>();
        ArrayList<ComponentInfo> eigenInfos = new ArrayList<ComponentInfo>();
        Map componentInfoMap = ComponentUtil.getComponentInfoMap((String)bizModelPageId);
        for (Map.Entry entry : componentInfoMap.entrySet()) {
            ComponentInfo componentInfo = (ComponentInfo)entry.getValue();
            if (componentInfo.getComponentType() == ComponentType.EIGENVALUE && StringUtils.isBlank((CharSequence)componentInfo.getElementId())) {
                eigenInfos.add(componentInfo);
                continue;
            }
            if (ComponentType.ELEMENT != componentInfo.getComponentType()) continue;
            elementInfoList.add(componentInfo);
        }
        if (elementInfoList.isEmpty() && eigenInfos.isEmpty()) {
            return;
        }
        QFilter[] filters = new QFilter("id", "=", formShowParameter.getCustomParam("bizModelId")).toArray();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getPluginName(), (String)"phm_bizmodel", (String)"number, name, group.name", (QFilter[])filters, null);){
            Row row = dataSet.next();
            String bizModelNumber = row.getString("number");
            String bizModelName = row.getString("name");
            String bizTypeName = row.getString("group.name");
            IDataModel model = this.getModel();
            for (ComponentInfo componentInfo : elementInfoList) {
                int entryRow = model.createNewEntryRow(ENTRYENTITY);
                model.setValue(REGION, (Object)componentInfo.getComponentId(), entryRow);
                model.setValue(REGION_NAME, componentInfo.getProperties().get("name"), entryRow);
                model.setValue(BIZTYPE, (Object)bizTypeName, entryRow);
                model.setValue(MODEL_NUMBER, (Object)bizModelNumber, entryRow);
                model.setValue(MODEL_NAME, (Object)bizModelName, entryRow);
            }
            if (!eigenInfos.isEmpty()) {
                int entryRow = model.createNewEntryRow(ENTRYENTITY);
                model.setValue(REGION, null, entryRow);
                model.setValue(REGION_NAME, null, entryRow);
                model.setValue(BIZTYPE, (Object)bizTypeName, entryRow);
                model.setValue(MODEL_NUMBER, (Object)bizModelNumber, entryRow);
                model.setValue(MODEL_NAME, (Object)bizModelName, entryRow);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        IDataModel model = this.getModel();
        if (StringUtils.equals((CharSequence)"btnok", (CharSequence)control.getKey())) {
            String eigenvalueName = null;
            String eigenValueId = null;
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTRYENTITY);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7279\u5f81\u503c\u5206\u5f55", (String)"ActionEigenvaluePlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.isFromQueryComponent()) {
                ArrayList<String> names = new ArrayList<String>(selectRows.length);
                ArrayList<String> ids = new ArrayList<String>(selectRows.length);
                for (int selectRow : selectRows) {
                    names.add((String)model.getValue("name", selectRow));
                    ids.add((String)model.getValue("eigenvalue", selectRow));
                }
                if (!names.isEmpty() && !ids.isEmpty()) {
                    eigenvalueName = ((Object)names).toString();
                    eigenValueId = ((Object)ids).toString();
                }
            } else {
                int rowIndex = selectRows[0];
                eigenvalueName = (String)model.getValue("name", rowIndex);
                eigenValueId = (String)model.getValue("eigenvalue", rowIndex);
            }
            HashMap<String, String> returnData = new HashMap<String, String>(4);
            returnData.put("action_eigenvalue", eigenvalueName);
            returnData.put("eigencomponent", eigenValueId);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        List eigenvalueInfoList;
        int row = evt.getRow();
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRY_ENTRYENTITY);
        String bizModelPageId = (String)this.getView().getFormShowParameter().getCustomParam("bizModelPageId");
        String elementId = (String)model.getValue(REGION, row);
        List<Object> list = eigenvalueInfoList = StringUtils.isBlank((CharSequence)elementId) ? ComponentUtil.getEigenInfoNotInElement((String)bizModelPageId) : ComponentUtil.getEigenvalueInfoList((String)bizModelPageId, (String)elementId);
        if (this.isFromDetailComponent()) {
            Set eigenIds = ComponentUtil.getEigensFromDetail((String)bizModelPageId);
            eigenvalueInfoList = eigenvalueInfoList.stream().filter(componentInfo -> !eigenIds.contains(componentInfo.getComponentId())).collect(Collectors.toList());
        }
        for (ComponentInfo componentInfo2 : eigenvalueInfoList) {
            Map properties = componentInfo2.getProperties();
            int newEntryRow = model.createNewEntryRow(ENTRY_ENTRYENTITY);
            model.setValue("eigenvalue", (Object)componentInfo2.getComponentId(), newEntryRow);
            model.setValue("name", properties.get("name"), newEntryRow);
            model.setValue("value_name", properties.get("name"), newEntryRow);
            model.setValue("value_type", properties.get("valuetype"), newEntryRow);
            model.setValue("value_configuration", properties.get("set"), newEntryRow);
            model.setValue("value", properties.get("value"), newEntryRow);
        }
    }

    private boolean isFromQueryComponent() {
        Object isFromQueryComponent = this.getView().getFormShowParameter().getCustomParam("isFromQueryComponent");
        return Objects.nonNull(isFromQueryComponent);
    }

    private boolean isFromDetailComponent() {
        Object isFromDetailComponent = this.getView().getFormShowParameter().getCustomParam("isFromDetailComponent");
        return Objects.nonNull(isFromDetailComponent);
    }
}

