/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.mmc.phm.common.info.ComponentInfo;
import kd.mmc.phm.common.util.ComponentUtil;
import kd.mmc.phm.formplugin.bizmodel.AbstractConfigurePlugin;

public class AdjustComponentPlugin
extends AbstractConfigurePlugin {
    @Override
    public void afterCreateNewData(EventObject e) {
        String regionName;
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String componentId = (String)formShowParameter.getCustomParam("componentId");
        String parentPageId = formShowParameter.getParentPageId();
        Map componentInfoMap = ComponentUtil.getComponentInfoMap((String)parentPageId);
        ComponentInfo adjustComponentInfo = (ComponentInfo)componentInfoMap.get(componentId);
        String elementId = adjustComponentInfo.getElementId();
        String eigenvalue = (String)this.getModel().getValue("eigencomponent");
        Map properties = adjustComponentInfo.getProperties();
        if (StringUtils.isNotBlank((CharSequence)eigenvalue)) {
            ComponentInfo componentInfo = (ComponentInfo)componentInfoMap.get(eigenvalue);
            properties.put("action_eigenvalue", componentInfo.getProperties().get("name"));
        }
        if (Objects.isNull(elementId)) {
            regionName = null;
        } else {
            ComponentInfo componentInfo = (ComponentInfo)componentInfoMap.get(elementId);
            regionName = (String)componentInfo.getProperties().get("name");
        }
        properties.put("region", regionName);
        ComponentUtil.putComponentInfoMapCache((Map)componentInfoMap, (String)parentPageId);
        super.afterCreateNewData(e);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if (StringUtils.equals((CharSequence)"backcolor", (CharSequence)name)) {
            this.addStyle("fillColor", newValue);
        } else if (StringUtils.equals((CharSequence)"width", (CharSequence)name)) {
            this.addStyle("strokeWidth", newValue);
        } else if (StringUtils.equals((CharSequence)"height", (CharSequence)name)) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("Action", "updateEdgeHeight");
            params.put("id", this.getView().getFormShowParameter().getCustomParam("componentId"));
            params.put(name, newValue);
            this.setCustomControlData(params);
        }
    }
}

