/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.phm.common.bizmodel.ComponentType;
import kd.mmc.phm.common.info.ComponentInfo;
import kd.mmc.phm.common.util.ComponentUtil;
import kd.mmc.phm.common.util.DesignerUtils;
import kd.mmc.phm.common.util.JsonUtil;
import kd.mmc.phm.common.util.ShowFormUtils;

public class BizDesignerPlugin
extends AbstractFormPlugin {
    private static final String PROPERTY_PANEL = "property_panel";
    private static final String CACHEKEY_PANEL_ID = "panel_id";
    private static final String CACHEKEY_COMPONENTINFO = "componentInfo";
    private static final String SELECT_ACTION = "selectCell";
    private static final String CONNECT_ACTION = "connectCell";
    private static final String CLEAR_ACTION = "ClearControlData";
    private static final String BIZMODEL_ID = "bizModelId";
    public static final String SAVE = "save";
    public static final String TEST = "test";
    public static final String CLOSE = "close";
    private static final String SPLITCONTAINER = "splitcontainerap";
    private static final String LEFT_SPLIT = "left_split";
    private static final String RIGHT_SPLIT = "right_split";
    public static final String PHM_BACKGROUND_COLOR = "phm_background_color";

    public void afterCreateNewData(EventObject e) {
        long bizModelId = (Long)this.getView().getFormShowParameter().getCustomParam(BIZMODEL_ID);
        Map componentInfoMap = DesignerUtils.wrapperComponentInfo((long)bizModelId);
        this.getPageCache().put(CACHEKEY_COMPONENTINFO, JsonUtil.toJsonString((Object)componentInfoMap));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "save": {
                this.updateXmlAndDetailXY(true);
                this.getPageCache().put("isChange", "false");
                long bizModelId = (Long)this.getView().getFormShowParameter().getCustomParam(BIZMODEL_ID);
                String resId = String.valueOf(bizModelId);
                HashMap all = (HashMap)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"getLatestSnapshotByUser", (Object[])new Object[]{resId});
                if (all == null) break;
                DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"cancelModelSnapshot", (Object[])new Object[]{resId, RequestContext.get().getUserId()});
                break;
            }
            case "test": {
                List list = ComponentUtil.mustValidate((String)this.getView().getPageId());
                if (list.isEmpty()) {
                    this.updateXmlAndDetailXY(false);
                    break;
                }
                StringBuilder sb = new StringBuilder();
                for (String message : list) {
                    sb.append(message);
                }
                this.getView().showMessage(ResManager.loadKDString((String)"\u5fc5\u5f55\u3001\u91cd\u590d\u6821\u9a8c", (String)"BizDesignerPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
                break;
            }
            case "close": {
                boolean isChange = this.isChange();
                OperationStatus status = this.getView().getFormShowParameter().getStatus();
                if (!isChange || status == OperationStatus.VIEW) break;
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("designerClose", (IFormPlugin)this);
                String confirmMessage = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"BizDesignerPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmMessage, MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBackListener);
                args.cancel = true;
                break;
            }
        }
    }

    private boolean isChange() {
        String isChange = this.getPageCache().get("isChange") == null ? "false" : this.getPageCache().get("isChange");
        return Boolean.parseBoolean(isChange);
    }

    private void save(String xml) {
        try (TXHandle handle = TX.requiresNew();){
            long bizModelId = (Long)this.getView().getFormShowParameter().getCustomParam(BIZMODEL_ID);
            DeleteServiceHelper.delete((String)"phm_component", (QFilter[])new QFilter("bizmodel", "=", (Object)bizModelId).toArray());
            Map<String, ComponentInfo> componentInfoMap = this.getComponentInfoMapCache();
            if (!componentInfoMap.isEmpty()) {
                ArrayList<DynamicObject> components = new ArrayList<DynamicObject>(componentInfoMap.size());
                for (Map.Entry<String, ComponentInfo> entry : componentInfoMap.entrySet()) {
                    ComponentInfo componentInfo = entry.getValue();
                    ComponentType componentType = componentInfo.getComponentType();
                    if (Objects.isNull(componentType)) continue;
                    DynamicObject component = BusinessDataServiceHelper.newDynamicObject((String)"phm_component");
                    component.set("component", (Object)componentInfo.getComponentId());
                    component.set("bizmodel", (Object)componentInfo.getBizModelId());
                    component.set("parent", (Object)componentInfo.getElementId());
                    component.set("type", (Object)componentInfo.getComponentType().getValue());
                    component.set("data_tag", (Object)SerializationUtils.toJsonString((Object)componentInfo.getProperties()));
                    components.add(component);
                }
                SaveServiceHelper.save((DynamicObject[])components.toArray(new DynamicObject[0]));
            }
            DynamicObject bizModel = BusinessDataServiceHelper.loadSingle((Object)this.getView().getFormShowParameter().getCustomParam(BIZMODEL_ID), (String)"phm_bizmodel");
            bizModel.set("xml_tag", (Object)xml);
            String background = this.getPageCache().get("background");
            bizModel.set("background", (Object)background);
            bizModel.set("modifytime", (Object)System.currentTimeMillis());
            SaveServiceHelper.update((DynamicObject)bizModel);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"BizDesignerPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
    }

    private void updateXmlAndDetailXY(boolean isSave) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("Action", "updateXmlAndDetailXY");
        params.put("isSave", isSave);
        this.setCustomControlData(params);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)"importprocdef", (CharSequence)operateKey)) {
            ListShowParameter phm_procdef = ShowFormHelper.createShowListForm((String)"phm_procdef", (boolean)false);
            List qFilters = phm_procdef.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("status", "=", (Object)"C"));
            qFilters.add(new QFilter("enable", "=", (Object)"1"));
            phm_procdef.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "importProcdef"));
            this.getView().showForm((FormShowParameter)phm_procdef);
        } else if (StringUtils.equals((CharSequence)"impbizmodel", (CharSequence)operateKey)) {
            ListShowParameter phm_procdef = ShowFormHelper.createShowListForm((String)"phm_bizmodel", (boolean)false);
            List qFilters = phm_procdef.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("status", "=", (Object)"C"));
            qFilters.add(new QFilter("enable", "=", (Object)"1"));
            phm_procdef.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "impbizmodel"));
            this.getView().showForm((FormShowParameter)phm_procdef);
        } else if (StringUtils.equals((CharSequence)CLOSE, (CharSequence)operateKey)) {
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (Objects.isNull(returnData)) {
            return;
        }
        if (StringUtils.equals((CharSequence)"importProcdef", (CharSequence)actionId) && returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            Object primaryKeyValue = selectedRows.get(0).getPrimaryKeyValue();
            QFilter[] filters = new QFilter[]{new QFilter("id", "=", primaryKeyValue)};
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"phm_procdef", (String)"content_tag", (QFilter[])filters);
            String content_tag = dynamicObject.getString("content_tag");
            HashMap<String, Object> paramsMap = new HashMap<String, Object>(4);
            paramsMap.put("Action", "importFlowFromXML");
            paramsMap.put("xml", content_tag);
            this.getPageCache().put("isChange", "true");
            this.setCustomControlData(paramsMap);
        } else if (StringUtils.equals((CharSequence)"impbizmodel", (CharSequence)actionId) && returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            Object primaryKeyValue = selectedRows.get(0).getPrimaryKeyValue();
            long bizModelId = (Long)this.getView().getFormShowParameter().getCustomParam(BIZMODEL_ID);
            long queryBizModelId = Long.parseLong(primaryKeyValue.toString());
            Map copyComponentInfo = DesignerUtils.wrapperComponentInfo(new HashMap(16), (long)bizModelId, (long)queryBizModelId);
            Map<String, ComponentInfo> componentInfoMap = this.getComponentInfoMapCache();
            componentInfoMap.putAll(copyComponentInfo);
            this.getPageCache().put(CACHEKEY_COMPONENTINFO, JsonUtil.toJsonString(componentInfoMap));
            QFilter[] filters = new QFilter[]{new QFilter("id", "=", primaryKeyValue)};
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"phm_bizmodel", (String)"xml_tag", (QFilter[])filters);
            String xml_tag = dynamicObject.getString("xml_tag");
            HashMap<String, Object> paramsMap = new HashMap<String, Object>(4);
            paramsMap.put("Action", "importFlowFromXML");
            String newStr = xml_tag.replace("<mxGraphModel>", "").replace("</mxGraphModel>", "").replace("<mxCell id=\"0\"/>", "").replace("<mxCell id=\"1\" parent=\"0\"/>", "");
            paramsMap.put("xml", newStr);
            List details = copyComponentInfo.values().stream().filter(componentInfo -> componentInfo.getComponentType() == ComponentType.DETAIL).collect(Collectors.toList());
            List detailTables = details.stream().map(detail -> DesignerUtils.wrapperDetailTable((ComponentInfo)detail, (boolean)false)).collect(Collectors.toList());
            paramsMap.put("details", detailTables);
            this.getPageCache().put("isChange", "true");
            this.setCustomControlData(paramsMap);
        } else if (StringUtils.equals((CharSequence)"setBackground", (CharSequence)actionId)) {
            HashMap<String, Object> paramsMap = new HashMap<String, Object>(4);
            paramsMap.put("Action", "setBackground");
            paramsMap.put("backgroundcolor", returnData);
            this.getPageCache().put("background", returnData.toString());
            this.setCustomControlData(paramsMap);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{PROPERTY_PANEL});
        SplitContainer splitContainer = (SplitContainer)this.getControl(SPLITCONTAINER);
        splitContainer.setCollapse(RIGHT_SPLIT, true);
        Object billStatus = this.getView().getFormShowParameter().getCustomParam("billStatus");
        if (billStatus instanceof String && "A".equals(billStatus)) {
            this.getView().setStatus(OperationStatus.EDIT);
        } else {
            this.getView().setStatus(OperationStatus.VIEW);
        }
        this.getView().cacheFormShowParameter();
    }

    public void pageRelease(EventObject e) {
        long bizModelId = (Long)this.getView().getFormShowParameter().getCustomParam(BIZMODEL_ID);
        String s = String.valueOf(bizModelId);
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            MutexHelper.release((String)"phm_bizmodel", (String)"modify", (String)s);
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String returnValue = e.getEventArgs();
        switch (eventName) {
            case "updateXmlAndDetailXY": {
                boolean isSave;
                Map returnParams = (Map)SerializationUtils.fromJsonString((String)returnValue, HashMap.class);
                String xml = (String)returnParams.get("xml");
                this.getModel().setValue("xml_tag", (Object)xml);
                List details = (List)returnParams.get("details");
                if (Objects.nonNull(details) && !details.isEmpty()) {
                    Map<String, ComponentInfo> componentInfoMapCache = this.getComponentInfoMapCache();
                    for (Map detail : details) {
                        String componentId = (String)detail.get("id");
                        ComponentInfo componentInfo = componentInfoMapCache.get(componentId);
                        Map properties = componentInfo.getProperties();
                        properties.put("x", detail.get("x"));
                        properties.put("y", detail.get("y"));
                    }
                    this.updateComponentInfoCache(componentInfoMapCache);
                }
                if (isSave = ((Boolean)returnParams.get("isSave")).booleanValue()) {
                    this.save(xml);
                    break;
                }
                this.showRunForm(xml);
                break;
            }
            case "selectCell": {
                Map selectParams = (Map)SerializationUtils.fromJsonString((String)returnValue, HashMap.class);
                String key = (String)selectParams.get("cellId");
                String formId = (String)selectParams.get("componentType");
                this.showPropertyPanel(key, formId);
                this.getPageCache().put("isChange", "true");
                break;
            }
            case "ClearControlData": {
                this.setCustomControlData(null);
                break;
            }
            case "connectCell": {
                this.updateConnectComponent(returnValue);
                break;
            }
            case "removeCells": {
                this.removeComponents(returnValue);
                break;
            }
            case "hidePropertyPanel": {
                this.getView().setVisible(Boolean.FALSE, new String[]{PROPERTY_PANEL});
                SplitContainer splitContainer = (SplitContainer)this.getControl(SPLITCONTAINER);
                splitContainer.setCollapse(RIGHT_SPLIT, true);
                break;
            }
            case "removeElementId": {
                this.removeElementId(returnValue);
                break;
            }
            case "addElementId": {
                this.addElementId(returnValue);
                break;
            }
            case "initData": {
                this.init();
                break;
            }
            case "resizeCell": {
                this.updateWidthAndheightInfo(returnValue);
                break;
            }
            case "confirmDelete": {
                List ids = (List)SerializationUtils.fromJsonString((String)returnValue, ArrayList.class);
                int numberCount = this.getNumberCount(ids);
                List componentInfos = ComponentUtil.getComponentInfoByIds((String)this.getView().getPageId(), (List)ids);
                String message = ComponentUtil.refValidate((String)this.getView().getPageId(), (List)componentInfos);
                if (StringUtils.isBlank((CharSequence)message)) {
                    ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("delete", (IFormPlugin)this);
                    String confirmMessage = String.format(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684%s\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\r\n\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"BizDesignerPlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]), componentInfos.size() + numberCount);
                    this.getView().showConfirm(confirmMessage, MessageBoxOptions.OKCancel, ConfirmTypes.Delete, confirmCallBackListener);
                    break;
                }
                this.getView().showMessage(ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u5220\u9664", (String)"BizDesignerPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]), message, MessageTypes.Default);
                break;
            }
            case "initComponentInfo": {
                this.initComponentInfo(returnValue);
                this.getPageCache().put("isChange", "true");
                break;
            }
            case "syncQueryInfo": {
                this.syncQueryInfo(returnValue);
                break;
            }
            case "copy": {
                this.getPageCache().put("copyIds", returnValue);
                break;
            }
            case "paste": {
                this.paste(returnValue);
                break;
            }
            case "getElementGroup": {
                List elementGroup = DesignerUtils.getElementGroup();
                HashMap<String, Object> params = new HashMap<String, Object>(3);
                params.put("Action", "initElementGroup");
                params.put("returnData", elementGroup);
                this.setCustomControlData(params);
                break;
            }
            case "pageTurning": {
                Map pageParams = (Map)SerializationUtils.fromJsonString((String)returnValue, HashMap.class);
                String detailId = (String)pageParams.get("id");
                int pageSize = (Integer)pageParams.get("pageSize");
                Map<String, ComponentInfo> componentInfoMap = this.getComponentInfoMapCache();
                ComponentInfo componentInfo = componentInfoMap.get(detailId);
                Map properties = componentInfo.getProperties();
                properties.put("pagerow", String.valueOf(pageSize));
                this.updateComponentInfoCache(componentInfoMap);
                break;
            }
            case "deleteDetail": {
                this.getPageCache().put("detailId", returnValue);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\r\n\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"BizDesignerPlugin_5", (String)"mmc-phm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener("deleteDetail", (IFormPlugin)this));
                break;
            }
            case "setBackground": {
                HashMap<String, String> customParams = new HashMap<String, String>(2);
                String background = this.getPageCache().get("background");
                customParams.put("backcolor", background);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "setBackground");
                FormShowParameter formShowParameter = ShowFormUtils.assembleShowFormParam((String)PHM_BACKGROUND_COLOR, customParams, (CloseCallBack)closeCallBack, (ShowType)ShowType.Modal);
                this.getView().showForm(formShowParameter);
                break;
            }
            case "eigen_detail": {
                Map selectParams_eigen = (Map)SerializationUtils.fromJsonString((String)returnValue, HashMap.class);
                String _id = (String)selectParams_eigen.get("id");
                String _formId = (String)selectParams_eigen.get("componentType");
                if (!StringUtils.equals((CharSequence)"phm_eigen_component", (CharSequence)_formId)) break;
                String _detailId = "";
                Map<String, ComponentInfo> _componentInfoMap = this.getComponentInfoMapCache();
                Map<String, ComponentInfo> newComponentInfoMap = _componentInfoMap.entrySet().stream().filter(_e -> ((ComponentInfo)_e.getValue()).getComponentType() == ComponentType.DETAIL && StringUtils.equals((CharSequence)(((ComponentInfo)_e.getValue()).getProperties().get("eigencomponent") == null ? "" : ((ComponentInfo)_e.getValue()).getProperties().get("eigencomponent").toString()), (CharSequence)_id)).collect(Collectors.toMap(k -> (String)k.getKey(), v -> (ComponentInfo)v.getValue()));
                if (!newComponentInfoMap.isEmpty()) {
                    Set<String> detailKeys = newComponentInfoMap.keySet();
                    Iterator<String> iterator = detailKeys.iterator();
                    while (iterator.hasNext()) {
                        String detailKey;
                        _detailId = detailKey = iterator.next();
                    }
                }
                if (!StringUtils.isNotEmpty((CharSequence)_detailId)) break;
                HashMap<String, Object> _params = new HashMap<String, Object>(2);
                _params.put("Action", "eigen_detail");
                _params.put("detailid", _detailId);
                this.setCustomControlData(_params);
                break;
            }
        }
    }

    private void paste(String returnValue) {
        List copyIds = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("copyIds"), List.class);
        List pasteIds = (List)SerializationUtils.fromJsonString((String)returnValue, List.class);
        Map<String, ComponentInfo> componentInfoMap = this.getComponentInfoMapCache();
        for (int i = 0; i < pasteIds.size(); ++i) {
            String oldId = (String)copyIds.get(i);
            String newId = (String)pasteIds.get(i);
            ComponentInfo oldComponentInfo = componentInfoMap.get(oldId);
            if (Objects.isNull(oldComponentInfo)) continue;
            ComponentInfo newComponentInfo = (ComponentInfo)oldComponentInfo.clone();
            newComponentInfo.setComponentId(newId);
            newComponentInfo.getMustInputFields().putAll(oldComponentInfo.getMustInputFields());
            Map properties = newComponentInfo.getProperties();
            properties.putAll(oldComponentInfo.getProperties());
            ComponentType componentType = newComponentInfo.getComponentType();
            if (componentType != ComponentType.TEXT) {
                properties.remove("number");
                if (componentType == ComponentType.EIGENVALUE) {
                    properties.remove("name");
                }
            }
            componentInfoMap.put(newId, newComponentInfo);
        }
        this.updateComponentInfoCache(componentInfoMap);
    }

    private void syncQueryInfo(String returnValue) {
        Map returnParams = (Map)SerializationUtils.fromJsonString((String)returnValue, HashMap.class);
        String componentId = (String)returnParams.get("componentId");
        Object height = returnParams.get("height");
        Object name = returnParams.get("name");
        Map<String, ComponentInfo> componentInfoMap = this.getComponentInfoMapCache();
        ComponentInfo componentInfo = componentInfoMap.get(componentId);
        Map properties = componentInfo.getProperties();
        if (Objects.nonNull(name)) {
            properties.put("name", name);
        }
        if (Objects.nonNull(height)) {
            properties.put("height", height);
        }
        this.updateComponentInfoCache(componentInfoMap);
    }

    private void showRunForm(String xml) {
        long bizModelId = (Long)this.getView().getFormShowParameter().getCustomParam(BIZMODEL_ID);
        HashMap<String, Object> customParams = new HashMap<String, Object>(2);
        customParams.put("xml", xml);
        customParams.put(BIZMODEL_ID, bizModelId);
        String background = this.getPageCache().get("background");
        customParams.put("background", background);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "engdesignRunClose");
        FormShowParameter formShowParameter = ShowFormUtils.assembleShowFormParam((String)"phm_engdesign_run", customParams, (CloseCallBack)closeCallBack, (ShowType)ShowType.Modal);
        formShowParameter.setShowTitle(false);
        this.getView().showForm(formShowParameter);
    }

    private void initComponentInfo(String returnValue) {
        Map<String, ComponentInfo> componentInfoMap = this.getComponentInfoMapCache();
        List returnData = (List)SerializationUtils.fromJsonString((String)returnValue, List.class);
        for (Map returnDataMap : returnData) {
            ComponentInfo componentInfo;
            String componentId = (String)returnDataMap.get("componentId");
            ComponentType componentType = ComponentType.fromValue((String)((String)returnDataMap.get("componentType")));
            switch (componentType) {
                case ELEMENT: {
                    componentInfo = ComponentInfo.initElementInfo();
                    break;
                }
                case ADJUSTMENT: {
                    componentInfo = ComponentInfo.initAdjustmentInfo();
                    break;
                }
                case CONNECTION: {
                    componentInfo = ComponentInfo.initConnectionInfo();
                    break;
                }
                case EIGENVALUE: {
                    componentInfo = ComponentInfo.initEigenvalueInfo();
                    break;
                }
                case DETAIL: {
                    componentInfo = ComponentInfo.initDetailInfo((Map)returnDataMap);
                    break;
                }
                case QUERY: {
                    componentInfo = ComponentInfo.initQueryInfo();
                    break;
                }
                case TEXT: {
                    componentInfo = ComponentInfo.initTextInfo();
                    break;
                }
                default: {
                    componentInfo = new ComponentInfo();
                }
            }
            componentInfo.setBizModelId(((Long)this.getView().getFormShowParameter().getCustomParam(BIZMODEL_ID)).longValue());
            componentInfo.setComponentId(componentId);
            componentInfo.setComponentType(componentType);
            String parentId = (String)returnDataMap.get("parentId");
            if (StringUtils.isNotBlank((CharSequence)parentId)) {
                componentInfo.setElementId(parentId);
            }
            componentInfoMap.put(componentId, componentInfo);
        }
        this.getPageCache().put(CACHEKEY_COMPONENTINFO, JsonUtil.toJsonString(componentInfoMap));
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        if (StringUtils.equals((CharSequence)"delete", (CharSequence)callBackId) && result == MessageBoxResult.Yes) {
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            params.put("Action", "removeCells");
            this.setCustomControlData(params);
        } else if (StringUtils.equals((CharSequence)"designerClose", (CharSequence)callBackId) && result == MessageBoxResult.Yes) {
            this.getView().close();
        } else if (StringUtils.equals((CharSequence)"deleteDetail", (CharSequence)callBackId) && result == MessageBoxResult.Yes) {
            String detailId = this.getPageCache().get("detailId");
            ComponentUtil.removeComponentInfo((String)this.getView().getPageId(), (String[])new String[]{detailId});
            this.getPageCache().remove("detailId");
            HashMap params = Maps.newHashMapWithExpectedSize((int)2);
            params.put("Action", "deleteDetailById");
            params.put("id", detailId);
            this.setCustomControlData(params);
            this.getView().setVisible(Boolean.FALSE, new String[]{PROPERTY_PANEL});
        }
    }

    private void updateWidthAndheightInfo(String param) {
        Map params = (Map)SerializationUtils.fromJsonString((String)param, HashMap.class);
        String componentId = (String)params.get("componentId");
        Map<String, ComponentInfo> componentInfoMap = this.getComponentInfoMapCache();
        ComponentInfo componentInfo = componentInfoMap.get(componentId);
        Map properties = componentInfo.getProperties();
        properties.put("width", params.get("width"));
        properties.put("height", params.get("height"));
        componentInfoMap.put(componentId, componentInfo);
        this.getPageCache().put(CACHEKEY_COMPONENTINFO, JsonUtil.toJsonString(componentInfoMap));
        this.refreshPropertyPanel(componentId, componentInfo.getComponentType().getValue());
    }

    private void init() {
        HashMap params = Maps.newHashMapWithExpectedSize((int)3);
        params.put("Action", "init");
        long bizModelId = (Long)this.getView().getFormShowParameter().getCustomParam(BIZMODEL_ID);
        DynamicObject bizModelObj = this.getBackground(bizModelId);
        String background = bizModelObj.getString("background");
        String number = bizModelObj.getString("number");
        String name = bizModelObj.getString("name");
        this.getPageCache().put("background", background);
        params.put("backgroundcolor", background);
        params.put("name", name);
        params.put("number", number);
        QFilter[] filters = new QFilter("id", "=", (Object)bizModelId).toArray();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getPluginName(), (String)"phm_bizmodel", (String)"xml_tag", (QFilter[])filters, null);){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                String xml = row.getString("xml_tag");
                if (StringUtils.isBlank((CharSequence)xml)) {
                    this.setCustomControlData(params);
                    return;
                }
                params.put("xml", xml);
            }
        }
        List details = ComponentUtil.getAllComponentInfoByType((String)this.getView().getPageId(), (ComponentType)ComponentType.DETAIL);
        List detailTables = details.stream().map(detail -> DesignerUtils.wrapperDetailTable((ComponentInfo)detail, (boolean)false)).collect(Collectors.toList());
        params.put("details", detailTables);
        this.setCustomControlData(params);
    }

    private void addElementId(String eventArgs) {
        Map params = (Map)SerializationUtils.fromJsonString((String)eventArgs, HashMap.class);
        String elementId = (String)params.get("elementId");
        List componentIds = (List)params.get("componentIds");
        Map<String, ComponentInfo> componentInfoMap = this.getComponentInfoMapCache();
        for (String componentId : componentIds) {
            ComponentInfo componentInfo = componentInfoMap.get(componentId);
            if (Objects.isNull(componentInfo)) continue;
            componentInfo.setElementId(elementId);
            componentInfoMap.put(componentId, componentInfo);
        }
        this.updateComponentInfoCache(componentInfoMap);
        this.getPageCache().put(CACHEKEY_PANEL_ID, null);
    }

    private void removeElementId(String eventArgs) {
        Map<String, ComponentInfo> componentInfoMap = this.getComponentInfoMapCache();
        List componentIds = (List)SerializationUtils.fromJsonString((String)eventArgs, List.class);
        for (String componentId : componentIds) {
            ComponentInfo componentInfo = componentInfoMap.get(componentId);
            if (!Objects.nonNull(componentInfo)) continue;
            componentInfo.setElementId(null);
        }
        this.updateComponentInfoCache(componentInfoMap);
        this.getPageCache().put(CACHEKEY_PANEL_ID, null);
    }

    private void updateConnectComponent(String eventArgs) {
        Map params = (Map)SerializationUtils.fromJsonString((String)eventArgs, HashMap.class);
        String componentId = (String)params.get("componentId");
        Map<String, ComponentInfo> componentInfoMap = this.getComponentInfoMapCache();
        ComponentInfo componentInfo = componentInfoMap.get(componentId);
        Map properties = componentInfo.getProperties();
        properties.put("source_region", params.get("source"));
        properties.put("target_region", params.get("target"));
        String type = (String)properties.get("type");
        if (StringUtils.isBlank((CharSequence)type) || !StringUtils.equals((CharSequence)"B", (CharSequence)type)) {
            properties.put("lower_node", params.get("sourceName"));
            properties.put("upper_node", params.get("targetName"));
        }
        componentInfoMap.put(componentId, componentInfo);
        this.updateComponentInfoCache(componentInfoMap);
    }

    private void removeComponents(String eventArgs) {
        Map<String, ComponentInfo> componentInfoMap = this.getComponentInfoMapCache();
        List ids = (List)SerializationUtils.fromJsonString((String)eventArgs, List.class);
        for (String id : ids) {
            componentInfoMap.remove(id);
        }
        this.updateComponentInfoCache(componentInfoMap);
        this.getView().setVisible(Boolean.FALSE, new String[]{PROPERTY_PANEL});
    }

    private void showPropertyPanel(String dataKey, String formId) {
        this.getView().setVisible(Boolean.TRUE, new String[]{PROPERTY_PANEL});
        SplitContainer splitContainer = (SplitContainer)this.getControl(SPLITCONTAINER);
        splitContainer.setCollapse(RIGHT_SPLIT, false);
        String panelId = formId + "." + dataKey;
        if (StringUtils.equals((CharSequence)panelId, (CharSequence)this.getPageCache().get(CACHEKEY_PANEL_ID))) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)formId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{PROPERTY_PANEL});
            splitContainer.setCollapse(RIGHT_SPLIT, true);
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>(2);
        customParams.put("componentId", dataKey);
        Object billStatus = this.getView().getFormShowParameter().getCustomParam("billStatus");
        customParams.put("billStatus", billStatus);
        FormShowParameter formShowParameter = ShowFormUtils.assembleShowFormParam((String)formId, customParams, null, (ShowType)ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(PROPERTY_PANEL);
        this.getView().showForm(formShowParameter);
        this.getPageCache().put(CACHEKEY_PANEL_ID, panelId);
    }

    private void refreshPropertyPanel(String dataKey, String formId) {
        this.getPageCache().put(CACHEKEY_PANEL_ID, null);
        this.showPropertyPanel(dataKey, formId);
    }

    private void setCustomControlData(Map<String, Object> data) {
        CustomControl customControl = (CustomControl)this.getControl("customcontrolap");
        customControl.setData(data);
    }

    private Map<String, ComponentInfo> getComponentInfoMapCache() {
        String json = this.getPageCache().get(CACHEKEY_COMPONENTINFO);
        return StringUtils.isBlank((CharSequence)json) ? new HashMap(16) : (Map)JsonUtil.fromJsonStringByComponentInfo((String)json);
    }

    private void updateComponentInfoCache(Map<String, ComponentInfo> componentInfoMap) {
        this.getPageCache().put(CACHEKEY_COMPONENTINFO, JsonUtil.toJsonString(componentInfoMap));
    }

    private DynamicObject getBackground(Object bizModelId) {
        Objects.requireNonNull(bizModelId);
        DynamicObject bizModelObj = QueryServiceHelper.queryOne((String)"phm_bizmodel", (String)"number,name,background", (QFilter[])new QFilter[]{new QFilter("id", "=", bizModelId)});
        return bizModelObj;
    }

    private int getNumberCount(List<String> ids) {
        int count = 0;
        for (String id : ids) {
            Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
            if (!pattern.matcher(id).matches()) continue;
            ++count;
        }
        return count;
    }
}

