/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel;

import java.util.HashMap;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BizModelList
extends AbstractListPlugin {
    public void billListHyperLinkClick(HyperLinkClickArgs e) {
        String fieldName = e.getFieldName();
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("number".equals(fieldName) && !StringUtils.equals((CharSequence)"bos_templatetreelistf7", (CharSequence)formId)) {
            e.setCancel(true);
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
            if (currentSelectedRowInfo == null) {
                return;
            }
            Object primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
            String bizModleId = primaryKeyValue.toString();
            this.getPageCache().put("bizModelId", bizModleId);
            StringBuilder errMsg = new StringBuilder();
            boolean isMutexLocked = MutexHelper.require((IFormView)this.getView(), (String)"phm_bizmodel", (Object)bizModleId, (String)"modify", (boolean)true, (StringBuilder)errMsg);
            if (!isMutexLocked) {
                throw new KDBizException(new ErrorCode("MutexLocked ", errMsg.toString()), new Object[0]);
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("phm_engdesign_board");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.EDIT);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("bizModelId", primaryKeyValue);
            String billStatus = currentSelectedRowInfo.getBillStatus();
            params.put("billStatus", billStatus);
            showParameter.setCustomParams(params);
            showParameter.setCloseCallBack(new CloseCallBack("kd.mmc.phm.formplugin.bizmodel.BizModelList", "engdesignClose"));
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        super.closedCallBack(event);
        switch (actionId = event.getActionId()) {
            case "engdesignClose": {
                String bizModelId = this.getPageCache().get("bizModelId");
                MutexHelper.release((String)"phm_bizmodel", (String)"modify", (String)bizModelId);
                break;
            }
            case "importschema": {
                this.getView().invokeOperation("refresh");
            }
        }
        event.getClass();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate formOperate;
        String operateKey;
        super.beforeDoOperation(e);
        Object source = e.getSource();
        if (!(source instanceof FormOperate) || StringUtils.equals((CharSequence)(operateKey = (formOperate = (FormOperate)source).getOperateKey()), (CharSequence)"submit")) {
            // empty if block
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if (evt.getOperationResult() != null && evt.getOperationResult().isSuccess()) {
            String operationKey = evt.getOperateKey();
            if (operationKey.equals("exportmodel")) {
                List pkIds = evt.getOperationResult().getSuccessPkIds();
                DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((Object[])pkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"phm_bizmodel"));
            } else if (operationKey.equals("importmodel")) {
                // empty if block
            }
        }
    }
}

