/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.phm.common.consts.SysConsts;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class CalcResregistList
extends AbstractFormPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Donothing srcCtrl;
        super.beforeDoOperation(args);
        Object srcCtrlObj = args.getSource();
        Donothing donothing = srcCtrlObj == null ? null : (srcCtrl = srcCtrlObj instanceof Donothing ? (Donothing)srcCtrlObj : null);
        if (srcCtrl == null) {
            return;
        }
        String srcCtrlKey = srcCtrl.getOperateKey();
        if ("deleteentry".equals(srcCtrlKey)) {
            ListSelectedRow listFocusRow = srcCtrl.getListFocusRow();
            Object primaryKeyValue = listFocusRow.getPrimaryKeyValue();
            Object entryPrimaryKeyValue = listFocusRow.getEntryPrimaryKeyValue();
            DynamicObject resregist = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"phm_calc_resregist");
            DynamicObjectCollection entry = resregist.getDynamicObjectCollection("calc_res_regist_entry");
            for (int i = 0; i < entry.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)entry.get(i);
                Object pkValue = dynamicObject.getPkValue();
                if (!pkValue.equals(entryPrimaryKeyValue)) continue;
                entry.remove((Object)dynamicObject);
                break;
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{resregist});
            this.getView().updateView();
        } else if ("testconn".equals(srcCtrlKey)) {
            ListSelectedRowCollection rows = srcCtrl.getListSelectedData();
            StringBuilder message = new StringBuilder();
            HashSet<Object> ids = new HashSet<Object>();
            for (ListSelectedRow row : rows) {
                ids.add(row.getPrimaryKeyValue());
            }
            HashMap<String, DynamicObject> insts = this.loadSelections(ids);
            ids.clear();
            for (ListSelectedRow row : rows) {
                if (ids.contains(row.getPrimaryKeyValue())) continue;
                ids.add(row.getPrimaryKeyValue());
                DynamicObject instInfo = insts.get(row.getPrimaryKeyValue().toString());
                TestConnectionStatus status = this.testConnection(instInfo);
                if (status == TestConnectionStatus.SERVER_OK) {
                    message.append(instInfo.getString("instip")).append(": ").append(ResManager.loadKDString((String)"\u8fde\u63a5\u6b63\u5e38\uff01", (String)"CalcResregistList_0", (String)"mmc-phm-formplugin", (Object[])new Object[0])).append("\r\n");
                    continue;
                }
                if (status == TestConnectionStatus.SERVER_DOWN) {
                    message.append(instInfo.getString("instip")).append(": ").append(ResManager.loadKDString((String)"\u65e0\u6cd5\u8fde\u63a5\uff01", (String)"CalcResregistList_1", (String)"mmc-phm-formplugin", (Object[])new Object[0])).append("\r\n");
                    continue;
                }
                if (status != TestConnectionStatus.TEST_FAILED) continue;
                message.append(instInfo.getString("instip")).append(": ").append(ResManager.loadKDString((String)"\u68c0\u6d4b\u5931\u8d25\uff01", (String)"CalcResregistList_2", (String)"mmc-phm-formplugin", (Object[])new Object[0])).append("\r\n");
            }
            this.getView().showConfirm("", message.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, null);
        } else if ("clear".equals(srcCtrlKey)) {
            DynamicObject[] all = BusinessDataServiceHelper.load((String)"phm_calc_resregist", (String)"instid, instip", (QFilter[])new QFilter[]{new QFilter("1", "=", (Object)1)});
            ArrayList<Object> deletes = new ArrayList<Object>();
            for (DynamicObject instInfo : all) {
                TestConnectionStatus status = this.testConnection(instInfo);
                if (status != TestConnectionStatus.SERVER_DOWN) continue;
                deletes.add(instInfo.getPkValue());
            }
            DeleteServiceHelper.delete((String)"phm_calc_resregist", (QFilter[])new QFilter[]{new QFilter("id", "in", deletes)});
        } else if ("resregis".equals(srcCtrlKey)) {
            DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"Service", (String)"start", (Object[])new Object[0]);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6ce8\u518c\u6210\u529f\u3002", (String)"CalcResregistList_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
    }

    private HashMap<String, DynamicObject> loadSelections(HashSet<Object> ids) {
        DynamicObject[] insts;
        HashMap<String, DynamicObject> ret = new HashMap<String, DynamicObject>();
        for (DynamicObject instInfo : insts = BusinessDataServiceHelper.load((String)"phm_calc_resregist", (String)"instid, instip", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)})) {
            ret.put(instInfo.getPkValue().toString(), instInfo);
        }
        return ret;
    }

    private TestConnectionStatus testConnection(DynamicObject instInfo) {
        try {
            ZooKeeper zk = SysConsts.zk;
            Stat stat = zk.exists("/" + instInfo.getString("instid"), false);
            if (stat == null) {
                return TestConnectionStatus.SERVER_DOWN;
            }
            return TestConnectionStatus.SERVER_OK;
        }
        catch (Throwable e) {
            return TestConnectionStatus.TEST_FAILED;
        }
    }

    private static enum TestConnectionStatus {
        SERVER_OK,
        SERVER_DOWN,
        TEST_FAILED;

    }
}

