/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel;

import java.awt.Color;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ColorUtils;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;

public class ColorPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        String colorStr = (String)this.getView().getFormShowParameter().getCustomParam("backcolor");
        if (StringUtils.isNotBlank((CharSequence)colorStr)) {
            HashMap<String, String> data = new HashMap<String, String>(2);
            data.put("bc", colorStr);
            this.getView().updateControlMetadata("labelap", data);
            if (StringUtils.startsWith((CharSequence)colorStr, (CharSequence)"rgba")) {
                colorStr = colorStr.substring(5, colorStr.length() - 1);
                String[] split = StringUtils.split((String)colorStr, (String)",");
                int red = Integer.parseInt(split[0]);
                int green = Integer.parseInt(split[1]);
                int blue = Integer.parseInt(split[2]);
                Color color = new Color(red, green, blue);
                ColorUtils colorUtils = new ColorUtils();
                colorStr = colorUtils.toHexFromColor(color);
                String alphaStr = split[3];
                int alpha = new BigDecimal(alphaStr).multiply(new BigDecimal("100")).intValue();
                this.getModel().setValue("alpha", (Object)alpha);
            }
            this.getModel().setValue("colorvalue", (Object)colorStr);
            this.getModel().setValue("radiogroup", (Object)colorStr);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"colorvalue", (CharSequence)name) || StringUtils.equals((CharSequence)"alpha", (CharSequence)name)) {
            HashMap<String, String> data = new HashMap<String, String>(2);
            data.put("bc", this.getColor());
            this.getView().updateControlMetadata("labelap", data);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (StringUtils.equals((CharSequence)"ok", (CharSequence)args.getOperateKey()) && Objects.nonNull(args.getOperationResult()) && args.getOperationResult().isSuccess()) {
            this.getView().returnDataToParent((Object)this.getColor());
            this.getView().close();
        }
    }

    private String getColor() {
        String colorStr = (String)this.getModel().getValue("colorvalue");
        int alpha = (Integer)this.getModel().getValue("alpha");
        if (StringUtils.isNotBlank((CharSequence)colorStr) && alpha < 100) {
            double pellucidity = new BigDecimal(String.valueOf((float)alpha / 100.0f)).setScale(2, 4).doubleValue();
            ColorUtils colorUtils = new ColorUtils();
            Color color = colorUtils.toColorFromString(colorStr);
            colorStr = "rgba(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "," + pellucidity + ")";
        }
        return colorStr;
    }
}

