/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.mmc.phm.common.util.ShowFormUtils;
import kd.mmc.phm.formplugin.bizmodel.AbstractConfigurePlugin;

public class ConnectComponentPlugin
extends AbstractConfigurePlugin {
    private static final String CONNECTION_EIGENVALUE_ENTITY = "phm_connection_eigenvalue";
    private static final String LINE_SHAPE_ENTITY = "phm_line_shape";
    private static final String LINE_WIDTH_ENTITY = "phm_line_width";
    private static final String RELATION = "relation";
    private static final String SHAPE = "shape";
    private static final String LINE_WIDTH = "line_width";

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        IDataModel model = this.getModel();
        switch (e.getProperty().getName()) {
            case "line_width": 
            case "shape": 
            case "backcolor": {
                String width = (String)model.getValue(LINE_WIDTH);
                String shape = (String)model.getValue(SHAPE);
                String color = (String)model.getValue("backcolor");
                this.updateStyle(width, shape, color);
                break;
            }
            case "relation": {
                if (!StringUtils.isBlank((CharSequence)((String)newValue))) break;
                model.setValue("relation_data", null);
                model.setValue("relation_data_tag", null);
                break;
            }
        }
    }

    private void updateStyle(String width, String shape, String color) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)width)) {
            sb.append("strokeWidth=").append(width).append(';');
        }
        if (StringUtils.isNotBlank((CharSequence)shape)) {
            if (!StringUtils.equals((CharSequence)"dotted", (CharSequence)shape)) {
                sb.append(shape).append("=1;");
            } else {
                sb.append("dashed=1;dashPattern=1 2;");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)color)) {
            sb.append("strokeColor=").append(color).append(';');
        }
        sb.append("edgeStyle=orthogonalEdgeStyle;");
        params.put("Action", "updateStyle");
        params.put("id", this.getView().getFormShowParameter().getCustomParam("componentId"));
        params.put("style", sb.toString());
        this.setCustomControlData(params);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit relationTextEdit = (TextEdit)this.getControl(RELATION);
        relationTextEdit.addButtonClickListener((ClickListener)this);
        TextEdit shapeTextEdit = (TextEdit)this.getControl(SHAPE);
        shapeTextEdit.addButtonClickListener((ClickListener)this);
        TextEdit widthTextEdit = (TextEdit)this.getControl(LINE_WIDTH);
        widthTextEdit.addButtonClickListener((ClickListener)this);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        IFormView view = this.getView();
        if (StringUtils.equals((CharSequence)RELATION, (CharSequence)control.getKey())) {
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("componentId", view.getFormShowParameter().getCustomParam("componentId"));
            params.put("rootPageId", view.getFormShowParameter().getParentPageId());
            String relationData = (String)this.getModel().getValue("relation_data_tag");
            if (StringUtils.isNotBlank((CharSequence)relationData)) {
                params.put("data", this.getModel().getValue("relation_data_tag"));
            }
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, RELATION);
            FormShowParameter formShowParameter = ShowFormUtils.assembleShowFormParam((String)CONNECTION_EIGENVALUE_ENTITY, params, (CloseCallBack)closeCallBack, (ShowType)ShowType.Modal);
            view.showForm(formShowParameter);
        } else if (StringUtils.equals((CharSequence)SHAPE, (CharSequence)control.getKey())) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, SHAPE);
            FormShowParameter formShowParameter = ShowFormUtils.assembleShowFormParam((String)LINE_SHAPE_ENTITY, null, (CloseCallBack)closeCallBack, (ShowType)ShowType.Modal);
            view.showForm(formShowParameter);
        } else if (StringUtils.equals((CharSequence)LINE_WIDTH, (CharSequence)control.getKey())) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, LINE_WIDTH);
            FormShowParameter formShowParameter = ShowFormUtils.assembleShowFormParam((String)LINE_WIDTH_ENTITY, null, (CloseCallBack)closeCallBack, (ShowType)ShowType.Modal);
            view.showForm(formShowParameter);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        Object returnData = event.getReturnData();
        if (Objects.isNull(returnData)) {
            return;
        }
        String actionId = event.getActionId();
        IDataModel model = this.getModel();
        switch (actionId) {
            case "shape": 
            case "line_width": {
                String data = (String)returnData;
                model.setValue(actionId, (Object)data);
                break;
            }
            case "relation": {
                Map result = (Map)returnData;
                for (Map.Entry entry : result.entrySet()) {
                    model.setValue((String)entry.getKey(), entry.getValue());
                }
                break;
            }
        }
    }
}

