/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.mmc.phm.common.bizmodel.ComponentType;
import kd.mmc.phm.common.info.ComponentInfo;
import kd.mmc.phm.common.util.ComponentUtil;

public class ConnectEigenvaluePlugin
extends AbstractFormPlugin {
    private static final String ENTRYENTITY = "entryentity";
    private static final String SOURCE_REGION_NAME = "source_region_name";
    private static final String SOURCE_EIGENVALUE = "source_eigenvalue";
    private static final String TARGET_REGION_NAME = "target_region_name";
    private static final String TARGET_EIGENVALUE = "target_eigenvalue";
    private static final String SOURCE_REGION = "source_region";
    private static final String TARGET_REGION = "target_region";

    public void afterCreateNewData(EventObject e) {
        Object data = this.getView().getFormShowParameter().getCustomParam("data");
        if (Objects.nonNull(data)) {
            Object[] dataEntities = DynamicObjectSerializeUtil.deserialize((String)data.toString(), (DynamicObjectType)this.getModel().getDataEntityType());
            DynamicObject sourceDataEntity = (DynamicObject)dataEntities[0];
            DynamicObject targetDataEntity = this.getModel().getDataEntity(true);
            targetDataEntity.set(ENTRYENTITY, (Object)sourceDataEntity.getDynamicObjectCollection(ENTRYENTITY));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String componentId = (String)formShowParameter.getCustomParam("componentId");
        String bizModelPageId = (String)formShowParameter.getCustomParam("rootPageId");
        ComponentInfo componentInfo = ComponentUtil.getComponentInfo((String)bizModelPageId, (String)componentId);
        Map properties = componentInfo.getProperties();
        ComponentInfo sourceComponentInfo = ComponentUtil.getComponentInfo((String)bizModelPageId, (String)((String)properties.get(SOURCE_REGION)));
        ComponentInfo targetComponentInfo = ComponentUtil.getComponentInfo((String)bizModelPageId, (String)((String)properties.get(TARGET_REGION)));
        if (Objects.isNull(sourceComponentInfo) || Objects.isNull(targetComponentInfo)) {
            return;
        }
        if (sourceComponentInfo.getComponentType() == ComponentType.ELEMENT) {
            this.setComboItemByElememt(bizModelPageId, sourceComponentInfo.getComponentId(), SOURCE_EIGENVALUE);
        } else if (sourceComponentInfo.getComponentType() == ComponentType.EIGENVALUE) {
            this.setComboItemByEigen(sourceComponentInfo, SOURCE_EIGENVALUE);
        }
        if (targetComponentInfo.getComponentType() == ComponentType.ELEMENT) {
            this.setComboItemByElememt(bizModelPageId, targetComponentInfo.getComponentId(), TARGET_EIGENVALUE);
        } else if (targetComponentInfo.getComponentType() == ComponentType.EIGENVALUE) {
            this.setComboItemByEigen(targetComponentInfo, TARGET_EIGENVALUE);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        String ok = "ok";
        if (StringUtils.equals((CharSequence)ok, (CharSequence)operateKey) && Objects.nonNull(operationResult) && operationResult.isSuccess()) {
            IDataModel model = this.getModel();
            DynamicObjectCollection entryEntity = model.getEntryEntity(ENTRYENTITY);
            if (!entryEntity.isEmpty()) {
                StringBuilder sb = new StringBuilder("[");
                StringBuilder errorMessage = new StringBuilder();
                HashMap<String, HashSet<String>> sourceTargetMap = new HashMap<String, HashSet<String>>(16);
                int size = entryEntity.size();
                for (int i = 0; i < size; ++i) {
                    DynamicObject entry = (DynamicObject)entryEntity.get(i);
                    String sourceEigenvalue = entry.getString(SOURCE_EIGENVALUE);
                    String targetEigenvalue = entry.getString(TARGET_EIGENVALUE);
                    HashSet<String> set = (HashSet<String>)sourceTargetMap.get(sourceEigenvalue);
                    if (Objects.isNull(set)) {
                        set = new HashSet<String>(16);
                    }
                    if (!set.add(targetEigenvalue)) {
                        errorMessage.append(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c", (String)"ConnectEigenvaluePlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0])).append(i + 1).append(ResManager.loadKDString((String)"\u884c: ", (String)"ConnectEigenvaluePlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u8be5\u6e90\u7279\u5f81\u503c\u5bf9\u5e94\u7684\u76ee\u6807\u7279\u5f81\u503c\u5df2\u5b58\u5728\r\n", (String)"ConnectEigenvaluePlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                    }
                    sourceTargetMap.put(sourceEigenvalue, set);
                    sb.append('(').append(sourceEigenvalue).append(',').append(targetEigenvalue).append(')').append(',');
                }
                if (errorMessage.length() > 0) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c", (String)"ConnectEigenvaluePlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]), errorMessage.toString(), MessageTypes.Default);
                    return;
                }
                String resultStr = sb.substring(0, sb.length() - 1).concat("]");
                DynamicObject dataEntity = model.getDataEntity(true);
                String dataJson = DynamicObjectSerializeUtil.serialize((Object[])new Object[]{dataEntity}, (DynamicObjectType)dataEntity.getDynamicObjectType());
                HashMap<String, String> result = new HashMap<String, String>(4);
                result.put("relation", resultStr);
                result.put("relation_data_tag", dataJson);
                this.getView().returnDataToParent(result);
            }
            this.getView().close();
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String pageId = (String)formShowParameter.getCustomParam("rootPageId");
        String componentId = (String)formShowParameter.getCustomParam("componentId");
        ComponentInfo componentInfo = ComponentUtil.getComponentInfo((String)pageId, (String)componentId);
        Map properties = componentInfo.getProperties();
        ComponentInfo sourceComponentInfo = ComponentUtil.getComponentInfo((String)pageId, (String)((String)properties.get(SOURCE_REGION)));
        ComponentInfo targetComponentInfo = ComponentUtil.getComponentInfo((String)pageId, (String)((String)properties.get(TARGET_REGION)));
        IDataModel model = this.getModel();
        int rowIndex = e.getRowDataEntities()[0].getRowIndex();
        if (Objects.isNull(sourceComponentInfo) || Objects.isNull(targetComponentInfo)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6e90\u7ec4\u4ef6\u6216\u76ee\u6807\u7ec4\u4ef6\u4e0d\u5b58\u5728", (String)"ConnectEigenvaluePlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            model.deleteEntryRow(ENTRYENTITY, rowIndex);
            return;
        }
        model.setValue(SOURCE_REGION, (Object)sourceComponentInfo.getComponentId(), rowIndex);
        model.setValue(TARGET_REGION, (Object)targetComponentInfo.getComponentId(), rowIndex);
        if (sourceComponentInfo.getComponentType() == ComponentType.ELEMENT) {
            model.setValue(SOURCE_REGION_NAME, sourceComponentInfo.getProperties().get("name"), rowIndex);
        }
        if (targetComponentInfo.getComponentType() == ComponentType.ELEMENT) {
            model.setValue(TARGET_REGION_NAME, targetComponentInfo.getProperties().get("name"), rowIndex);
        }
    }

    private void setComboItemByEigen(ComponentInfo componentInfo, String comboEditKey) {
        ComboEdit comboEdit = (ComboEdit)this.getControl(comboEditKey);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        Map propertiess = componentInfo.getProperties();
        String name = (String)propertiess.get("name");
        ComboItem comboItem = new ComboItem(new LocaleString(name), name);
        comboItems.add(comboItem);
        comboEdit.setComboItems(comboItems);
    }

    private void setComboItemByElememt(String pageId, String elementId, String comboEditKey) {
        List eigenvalueInfoList = ComponentUtil.getEigenvalueInfoList((String)pageId, (String)elementId);
        ComboEdit comboEdit = (ComboEdit)this.getControl(comboEditKey);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(eigenvalueInfoList.size());
        for (ComponentInfo componentInfo : eigenvalueInfoList) {
            Map properties = componentInfo.getProperties();
            String name = (String)properties.get("name");
            comboItems.add(new ComboItem(new LocaleString(name), name));
        }
        comboEdit.setComboItems(comboItems);
    }
}

