/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.mmc.phm.common.info.DetailGridInfo;
import kd.mmc.phm.common.info.DetailParamInfo;
import kd.mmc.phm.common.util.ComponentUtil;
import kd.mmc.phm.common.util.ShowFormUtils;

public class DetailEntryGridPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String ENTITY = "phm_detail_entrygrid";
    private static final String ENTRYENTITY = "entryentity";
    private static final String RETURN = "return";
    private static final String CANCEL = "cancel";
    private static final String INFO = "info";
    private static final ThreadLocal<SimpleDateFormat> THREAD_LOCAL = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Label label = (Label)this.getControl(RETURN);
        label.addClickListener((ClickListener)this);
        Vector vector = (Vector)this.getControl(CANCEL);
        vector.addClickListener((ClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        DetailParamInfo detailParamInfo = this.getDetailParamInfo(formShowParameter);
        EntryAp entryAp = this.createDynamicEntryAp(detailParamInfo);
        HashMap<String, String> entryMap = new HashMap<String, String>(4);
        entryMap.put("id", ENTRYENTITY);
        entryMap.put("columns", (String)entryAp.createControl().get("columns"));
        e.getItems().add(entryMap);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("DetailEntryGridPlugin", exp.getMessage()), new Object[0]);
        }
        EntryType entryType = (EntryType)newMainType.getAllEntities().get(ENTRYENTITY);
        DetailParamInfo detailParamInfo = this.getDetailParamInfo(this.getView().getFormShowParameter());
        JSONObject data = (JSONObject)detailParamInfo.getData();
        if (Objects.nonNull(data)) {
            DynamicObject detailFieldSet = ComponentUtil.getDetailFieldSet((Object)detailParamInfo.getBizModelId(), (String)detailParamInfo.getComponentId());
            Map<String, String> fieldNames = this.getNameFromDetailSet(detailFieldSet, detailParamInfo.isDrilling());
            for (Map.Entry<String, String> entry : fieldNames.entrySet()) {
                TextProp textProp = new TextProp();
                textProp.setName(entry.getKey());
                textProp.setDisplayName(new LocaleString(entry.getValue()));
                textProp.setDbIgnore(true);
                entryType.registerSimpleProperty((DynamicSimpleProperty)textProp);
            }
        }
        e.setNewEntityType(newMainType);
        EntryAp entryAp = this.createDynamicEntryAp(detailParamInfo);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        List items = ((Container)entryAp.buildRuntimeControl()).getItems();
        for (Control item : items) {
            item.setView(this.getView());
            entryGrid.getItems().add(item);
        }
    }

    public void createNewData(BizDataEventArgs e) {
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        DynamicObjectCollection entryRows = dataEntity.getDynamicObjectCollection(ENTRYENTITY);
        DetailParamInfo detailParamInfo = this.getDetailParamInfo(this.getView().getFormShowParameter());
        JSONObject data = (JSONObject)detailParamInfo.getData();
        if (Objects.nonNull(data)) {
            JSONObject datas = data.getJSONObject("datas");
            JSONArray colNames = data.getJSONArray("sortedColLabels");
            HashMap<String, Integer> seqMap = new HashMap<String, Integer>(16);
            for (int i = 0; i < colNames.size(); ++i) {
                seqMap.put(colNames.getString(i), i);
            }
            JSONObject colTypes = data.getJSONObject("colTypes");
            JSONArray rows = datas.getJSONArray("rows");
            DynamicObject detailFieldSet = ComponentUtil.getDetailFieldSet((Object)detailParamInfo.getBizModelId(), (String)detailParamInfo.getComponentId());
            Map<String, String> fieldNames = this.getNameFromDetailSet(detailFieldSet, detailParamInfo.isDrilling());
            for (int i = 0; i < rows.size(); ++i) {
                DynamicObject entryRow = entryRows.addNew();
                for (Map.Entry<String, String> entry : fieldNames.entrySet()) {
                    String name = entry.getKey();
                    String vTypeName = colTypes.getString(name);
                    Object value = rows.getJSONArray(i).get(((Integer)seqMap.get(name)).intValue());
                    if (StringUtils.equals((CharSequence)"TIMESTAMP", (CharSequence)vTypeName)) {
                        if (value instanceof Number) {
                            value = new Date(((Number)value).longValue());
                        } else {
                            if (value != null) {
                                throw new KDBizException(new ErrorCode("UNKNOWN_DATE_CLASS", value.getClass().getName()), new Object[0]);
                            }
                            value = new Date();
                        }
                        value = THREAD_LOCAL.get().format(value);
                    } else if (value instanceof BigDecimal) {
                        value = ((BigDecimal)value).stripTrailingZeros().toPlainString();
                    }
                    entryRow.set(name, value);
                }
            }
        }
        e.setDataEntity((Object)dataEntity);
    }

    public void afterBindData(EventObject e) {
        DetailGridInfo detailGridInfo;
        super.afterBindData(e);
        DetailParamInfo detailParamInfo = this.getDetailParamInfo(this.getView().getFormShowParameter());
        if (!detailParamInfo.isDrilling()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{RETURN});
        }
        if (detailParamInfo.isRun() && !detailParamInfo.isHide()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CANCEL});
        }
        if (Objects.nonNull(detailGridInfo = detailParamInfo.getDetailGridInfo())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
            int entryRowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
            entryGrid.setRowBackcolor(detailGridInfo.getBackColor(), IntStream.range(0, entryRowCount).toArray());
            entryGrid.setPageRows(detailGridInfo.getPageRow());
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String controlKey = control.getKey();
        IFormView view = this.getView();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        DetailParamInfo detailParamInfo = this.getDetailParamInfo(parameter);
        if (StringUtils.equals((CharSequence)CANCEL, (CharSequence)controlKey)) {
            if (detailParamInfo.isHide()) {
                this.getView().getParentView().setVisible(Boolean.FALSE, new String[]{detailParamInfo.getComponentId()});
                this.getView().sendFormAction(this.getView().getParentView());
            } else {
                view.showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\r\n\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"DetailEntryGridPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener(CANCEL, (IFormPlugin)this));
            }
        } else if (StringUtils.equals((CharSequence)RETURN, (CharSequence)controlKey)) {
            detailParamInfo.setDrilling(false);
            detailParamInfo.setData(detailParamInfo.getDetailData());
            this.reload(detailParamInfo);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent args) {
        super.confirmCallBack(args);
        if (StringUtils.equals((CharSequence)CANCEL, (CharSequence)args.getCallBackId()) && StringUtils.equals((CharSequence)"Yes", (CharSequence)args.getResultValue())) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            DetailParamInfo detailParamInfo = this.getDetailParamInfo(formShowParameter);
            Container showPanel = (Container)this.getView().getParentView().getControl("show_panel");
            showPanel.deleteControls(new String[]{detailParamInfo.getComponentId()});
            this.getView().getParentView().setVisible(Boolean.FALSE, new String[]{"property_panel"});
            this.getView().sendFormAction(this.getView().getParentView());
            ComponentUtil.removeComponentInfo((String)formShowParameter.getParentPageId(), (String[])new String[]{detailParamInfo.getComponentId()});
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        try {
            DetailParamInfo detailParamInfo = this.getDetailParamInfo(this.getView().getFormShowParameter());
            String bizModelId = detailParamInfo.getBizModelId().toString();
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u94bb\u53d6\u4e2d...", (String)"DetailEntryGridPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0])));
            Serializable value = null;
            HashMap<String, String> filterParams = new HashMap<String, String>(2);
            String filterValue = this.getModel().getValue(fieldName, rowIndex).toString();
            String resultId = "drilling-" + detailParamInfo.getComponentId();
            String drillingIdFilterId = "drilling-" + detailParamInfo.getComponentId() + "\u0000" + fieldName;
            filterParams.put(drillingIdFilterId, filterValue);
            String keyTmp = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"start2CreateSnapshot", (Object[])new Object[]{bizModelId, filterParams});
            HashMap status = (HashMap)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"querySnapshotStatus", (Object[])new Object[]{bizModelId, keyTmp});
            while ("B".equals(status.get("sscp"))) {
                Thread.sleep(1000L);
                status = (HashMap)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"querySnapshotStatus", (Object[])new Object[]{bizModelId, keyTmp});
            }
            Object resData = DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"queryResRuntimeDatas", (Object[])new Object[]{bizModelId, keyTmp});
            if (resData instanceof Map) {
                Map datas = (Map)resData;
                value = (Serializable)datas.get(resultId);
            }
            detailParamInfo.setDrilling(true);
            detailParamInfo.setDetailData(detailParamInfo.getData());
            detailParamInfo.setData(value);
            this.reload(detailParamInfo);
        }
        catch (Exception ex) {
            this.getView().hideLoading();
            throw new KDBizException(ex.getMessage());
        }
    }

    private EntryAp createDynamicEntryAp(DetailParamInfo detailParamInfo) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey(ENTRYENTITY);
        String entityId = MetadataDao.getIdByNumber((String)ENTITY, (MetaCategory)MetaCategory.Entity);
        FormMetadata formmeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        EntityMetadata entitymeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        formmeta.bindEntityMetadata(entitymeta);
        for (ControlAp ap : formmeta.getItems()) {
            if (!StringUtils.equals((CharSequence)ENTRYENTITY, (CharSequence)ap.getKey())) continue;
            entryAp = (EntryAp)ap;
            break;
        }
        JSONObject data = (JSONObject)detailParamInfo.getData();
        DetailGridInfo detailGridInfo = detailParamInfo.getDetailGridInfo();
        if (Objects.nonNull(data) && Objects.nonNull(detailGridInfo)) {
            DynamicObject detailFieldSet = ComponentUtil.getDetailFieldSet((Object)detailParamInfo.getBizModelId(), (String)detailParamInfo.getComponentId());
            Set<String> relationField = this.getRelationFields(detailFieldSet);
            Map<String, String> fieldNames = this.getNameFromDetailSet(detailFieldSet, detailParamInfo.isDrilling());
            for (Map.Entry<String, String> entry : fieldNames.entrySet()) {
                String key = entry.getKey();
                EntryFieldAp entryFieldAp = new EntryFieldAp();
                entryFieldAp.setId(key);
                entryFieldAp.setKey(key);
                entryFieldAp.setName(new LocaleString(entry.getValue()));
                entryFieldAp.setForeColor(detailGridInfo.getFontColor());
                entryFieldAp.setFontSize(detailGridInfo.getFontSize());
                if (!detailParamInfo.isDrilling() && relationField.contains(key)) {
                    entryFieldAp.setHyperlink(true);
                }
                TextField textField = new TextField();
                textField.setId(key);
                textField.setKey(key);
                entryFieldAp.setField((Field)textField);
                entryAp.getItems().add(entryFieldAp);
            }
        }
        return entryAp;
    }

    private DetailParamInfo getDetailParamInfo(FormShowParameter formShowParameter) {
        Object paramInfo = formShowParameter.getCustomParam(INFO);
        DetailParamInfo detailParamInfo = paramInfo instanceof JSONObject ? (DetailParamInfo)JSONObject.toJavaObject((JSON)((JSONObject)paramInfo), DetailParamInfo.class) : (DetailParamInfo)paramInfo;
        return detailParamInfo;
    }

    private void reload(DetailParamInfo detailParamInfo) {
        HashMap<String, DetailParamInfo> customParmas = new HashMap<String, DetailParamInfo>(2);
        customParmas.put(INFO, detailParamInfo);
        FormShowParameter formShowParameter = ShowFormUtils.assembleShowFormParam((String)ENTITY, customParmas, null, (ShowType)ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(detailParamInfo.getComponentId());
        this.getView().getParentView().showForm(formShowParameter);
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private Map<String, String> getNameFromDetailSet(DynamicObject detailFieldSet, boolean isDrilling) {
        LinkedHashMap<String, String> fieldNameMap = new LinkedHashMap<String, String>(16);
        if (Objects.nonNull(detailFieldSet)) {
            String entryentity = "field_entryentity";
            String nameField = "field_name";
            String aliasField = "field_alias";
            if (isDrilling) {
                entryentity = "drilling_entryentity";
                nameField = "drilling_name";
                aliasField = "drilling_alias";
            }
            DynamicObjectCollection entryColls = detailFieldSet.getDynamicObjectCollection(entryentity);
            for (DynamicObject entryData : entryColls) {
                fieldNameMap.put(entryData.getString(nameField), entryData.getString(aliasField));
            }
        }
        return fieldNameMap;
    }

    private Set<String> getRelationFields(DynamicObject detailFieldSet) {
        HashSet<String> relationFields = new HashSet<String>();
        if (Objects.nonNull(detailFieldSet)) {
            DynamicObjectCollection entryentity = detailFieldSet.getDynamicObjectCollection("drilling_entryentity");
            for (DynamicObject entry : entryentity) {
                String relationField = entry.getString("drilling_relation");
                if (!StringUtils.isNotBlank((CharSequence)relationField)) continue;
                relationFields.add(relationField);
            }
        }
        return relationFields;
    }
}

