/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.mmc.phm.common.util.ShowFormUtils;

public class DetailFieldSetPlugin
extends AbstractFormPlugin {
    private static final String ENTITY = "phm_field_set";
    private static final String SQL_SET_ENTITY = "phm_deseigenquery";
    private static final String DETAIL_FORMULA_ENTITY = "phm_detail_formula";
    private static final String FILTER_CONTAINER = "filtercontainerap";
    private static final String FIELD_ENTRYENTITY = "field_entryentity";
    private static final String DRILLING_ENTRYENTITY = "drilling_entryentity";
    private static final String FIELD_CONFIGURATION = "field_configuration_tag";
    private static final String DRILLING_CONFIGURATION = "drilling_configuration_tag";
    private static final String FIELD_SET = "field_set";
    private static final String DRILLING_SET = "drilling_set";
    private static final String FIELD_SOURCE = "field_source";
    private static final String DRILLING_SOURCE = "drilling_source";
    private static final String FIELD_NAME = "field_name";
    private static final String DRILLING_NAME = "drilling_name";
    private static final String FIELD_ALIAS = "field_alias";
    private static final String DRILLING_ALIAS = "drilling_alias";
    private static final String QUERY_SOURCE = "query";

    public void initialize() {
        super.initialize();
        FilterContainer filterContainer = (FilterContainer)this.getControl(FILTER_CONTAINER);
        filterContainer.setBillFormId(ENTITY);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener(tabSelectEvent -> {
            if (StringUtils.equals((CharSequence)"drilling_tab", (CharSequence)tabSelectEvent.getTabKey())) {
                this.setComboItem();
            }
        });
        TextEdit fieldSetEdit1 = (TextEdit)this.getControl(FIELD_SET);
        fieldSetEdit1.addButtonClickListener((ClickListener)this);
        TextEdit fieldSetEdit2 = (TextEdit)this.getControl(DRILLING_SET);
        fieldSetEdit2.addButtonClickListener((ClickListener)this);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity rowDataEntity;
        int rowIndex;
        if (StringUtils.equals((CharSequence)DRILLING_ENTRYENTITY, (CharSequence)e.getEntryProp().getName()) && (rowIndex = (rowDataEntity = e.getRowDataEntities()[0]).getRowIndex()) != 0) {
            Object realSql = this.getModel().getValue(DRILLING_CONFIGURATION, rowIndex - 1);
            this.getModel().setValue(DRILLING_CONFIGURATION, realSql, rowIndex);
            Object sql = this.getModel().getValue(DRILLING_SET, rowIndex - 1);
            this.getModel().setValue(DRILLING_SET, sql, rowIndex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        String name = e.getProperty().getName();
        int rowIndex = changeData.getRowIndex();
        IDataModel model = this.getModel();
        if (StringUtils.equals((CharSequence)FIELD_SOURCE, (CharSequence)name)) {
            model.setValue(FIELD_CONFIGURATION, null, rowIndex);
            model.setValue(FIELD_SET, null, rowIndex);
            model.setValue(FIELD_NAME, null, rowIndex);
        } else if (StringUtils.equals((CharSequence)DRILLING_SOURCE, (CharSequence)name)) {
            model.setValue(DRILLING_CONFIGURATION, null, rowIndex);
            model.setValue(DRILLING_SET, null, rowIndex);
            model.setValue(DRILLING_NAME, null, rowIndex);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (StringUtils.equals((CharSequence)"ok", (CharSequence)operateKey) && Objects.nonNull(operationResult) && operationResult.isSuccess()) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            String json = DynamicObjectSerializeUtil.serialize((Object[])new Object[]{dataEntity}, (DynamicObjectType)dataEntity.getDynamicObjectType());
            int entryRowCount = this.getModel().getEntryRowCount(FIELD_ENTRYENTITY);
            HashMap<String, Object> params = new HashMap<String, Object>(3);
            params.put("count", entryRowCount);
            params.put("data", json);
            this.getView().returnDataToParent(params);
            this.getView().close();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String controlKey = control.getKey();
        if (StringUtils.equals((CharSequence)FIELD_SET, (CharSequence)controlKey)) {
            this.showFormBySource(true, controlKey);
        } else if (StringUtils.equals((CharSequence)DRILLING_SET, (CharSequence)controlKey)) {
            this.showFormBySource(false, controlKey);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (Objects.isNull(returnData)) {
            return;
        }
        if (returnData instanceof Map) {
            Map result = (Map)returnData;
            this.setConfigAndName(actionId, result);
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object data = formShowParameter.getCustomParam("data");
        Object fieldCountObj = formShowParameter.getCustomParam("fieldCount");
        IDataModel model = this.getModel();
        if (Objects.isNull(data)) {
            if (fieldCountObj instanceof Integer) {
                int fieldCount = (Integer)fieldCountObj;
                if (fieldCount <= 0) {
                    return;
                }
                model.batchCreateNewEntryRow(FIELD_ENTRYENTITY, fieldCount);
            }
        } else {
            int fieldCount;
            int count;
            Object[] dataEntities = DynamicObjectSerializeUtil.deserialize((String)data.toString(), (DynamicObjectType)model.getDataEntityType());
            DynamicObject sourceDataEntity = (DynamicObject)dataEntities[0];
            DynamicObjectCollection fieldEntryEntity = sourceDataEntity.getDynamicObjectCollection(FIELD_ENTRYENTITY);
            DynamicObject firstDyna = (DynamicObject)fieldEntryEntity.get(0);
            if (fieldCountObj instanceof Integer && (count = (fieldCount = ((Integer)fieldCountObj).intValue()) - fieldEntryEntity.size()) > 0) {
                for (int i = 0; i < count; ++i) {
                    DynamicObject dynamicObject = fieldEntryEntity.addNew();
                    dynamicObject.set(FIELD_SOURCE, (Object)QUERY_SOURCE);
                    dynamicObject.set(FIELD_CONFIGURATION, (Object)firstDyna.getString(FIELD_CONFIGURATION));
                    dynamicObject.set(FIELD_SET, (Object)firstDyna.getString(FIELD_SET));
                }
            }
            DynamicObject targetDataEntity = this.getModel().getDataEntity(true);
            targetDataEntity.set(FIELD_ENTRYENTITY, (Object)fieldEntryEntity);
            targetDataEntity.set(DRILLING_ENTRYENTITY, (Object)sourceDataEntity.getDynamicObjectCollection(DRILLING_ENTRYENTITY));
            this.setComboItem();
        }
    }

    private void setComboItem() {
        DynamicObjectCollection fieldEntryentity = this.getModel().getEntryEntity(FIELD_ENTRYENTITY);
        if (!fieldEntryentity.isEmpty()) {
            LinkedHashMap<String, String> names = new LinkedHashMap<String, String>(16);
            for (DynamicObject fieldEntry : fieldEntryentity) {
                String name = ResManager.loadKDString((String)"\u660e\u7ec6.", (String)"DetailFieldSetPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + fieldEntry.getString(FIELD_ALIAS);
                names.put(name, fieldEntry.getString(FIELD_NAME));
            }
            ComboEdit comboEdit = (ComboEdit)this.getControl("drilling_relation");
            int size = names.size();
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(size);
            for (Map.Entry entry : names.entrySet()) {
                comboItems.add(new ComboItem(new LocaleString((String)entry.getKey()), (String)entry.getValue()));
            }
            comboEdit.setComboItems(comboItems);
        }
    }

    private void showFormBySource(boolean isFiledSet, String actionId) {
        IDataModel model = this.getModel();
        String entryEntity = FIELD_ENTRYENTITY;
        String sourceField = FIELD_SOURCE;
        String configurationField = FIELD_CONFIGURATION;
        String nameField = FIELD_NAME;
        String aliasField = FIELD_ALIAS;
        if (!isFiledSet) {
            entryEntity = DRILLING_ENTRYENTITY;
            sourceField = DRILLING_SOURCE;
            configurationField = DRILLING_CONFIGURATION;
            nameField = DRILLING_NAME;
            aliasField = DRILLING_ALIAS;
        }
        int currentRowIndex = model.getEntryCurrentRowIndex(entryEntity);
        String source = (String)model.getValue(sourceField, currentRowIndex);
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        String entity = SQL_SET_ENTITY;
        if (StringUtils.equals((CharSequence)QUERY_SOURCE, (CharSequence)source)) {
            customParams.put("storevalue_tag", model.getValue(configurationField, currentRowIndex));
        } else {
            entity = DETAIL_FORMULA_ENTITY;
            DynamicObjectCollection entryColls = model.getEntryEntity(entryEntity);
            LinkedHashMap<String, String> fieldMap = new LinkedHashMap<String, String>(16);
            for (DynamicObject fieldEntry : entryColls) {
                String fieldSource = fieldEntry.getString(sourceField);
                if (!StringUtils.equals((CharSequence)QUERY_SOURCE, (CharSequence)fieldSource)) continue;
                fieldMap.put(fieldEntry.getString(nameField), fieldEntry.getString(aliasField));
            }
            customParams.put("fields", SerializationUtils.toJsonString(fieldMap));
            customParams.put("data", model.getValue(configurationField, currentRowIndex));
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        FormShowParameter formShowParameter = ShowFormUtils.assembleShowFormParam((String)entity, customParams, (CloseCallBack)closeCallBack, (ShowType)ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    private void setConfigAndName(String actionId, Map<String, Object> result) {
        Object source = result.get("source");
        String entryEntity = FIELD_ENTRYENTITY;
        String nameField = FIELD_NAME;
        String aliasField = FIELD_ALIAS;
        String sourceField = FIELD_SOURCE;
        String setField = FIELD_SET;
        String configurationField = FIELD_CONFIGURATION;
        if (StringUtils.equals((CharSequence)DRILLING_SET, (CharSequence)actionId)) {
            entryEntity = DRILLING_ENTRYENTITY;
            nameField = DRILLING_NAME;
            aliasField = DRILLING_ALIAS;
            sourceField = DRILLING_SOURCE;
            setField = DRILLING_SET;
            configurationField = DRILLING_CONFIGURATION;
        }
        if (Objects.isNull(source)) {
            String storevalueTag = (String)result.get("storevalue_tag");
            String sql = (String)result.get("sql");
            Map cellsDataMap = (Map)SerializationUtils.fromJsonString((String)storevalueTag, HashMap.class);
            ArrayList fieldNames = new ArrayList(16);
            HashMap namesMap = new HashMap(16);
            cellsDataMap.forEach((key, value) -> {
                List params = (List)SerializationUtils.fromJsonString((String)value.get("params_tag").toString(), List.class);
                Map nameInfo = (Map)SerializationUtils.fromJsonString((String)value.get("nameinfo_tag").toString(), HashMap.class);
                namesMap.putAll(nameInfo);
                fieldNames.addAll(params);
            });
            DynamicObjectCollection colls = this.getModel().getEntryEntity(entryEntity);
            int count = 0;
            for (DynamicObject entry : colls) {
                if (!StringUtils.equals((CharSequence)QUERY_SOURCE, (CharSequence)entry.getString(sourceField)) || count >= fieldNames.size()) continue;
                String fieldName = (String)fieldNames.get(count++);
                entry.set(nameField, (Object)fieldName.split("[.]")[1].toUpperCase());
                entry.set(aliasField, namesMap.get(fieldName));
                String cutStr = sql;
                if (sql.length() > 2000) {
                    cutStr = sql.substring(0, 2000);
                }
                entry.set(setField, (Object)cutStr);
                entry.set(configurationField, (Object)storevalueTag);
            }
            this.getView().updateView(entryEntity);
        } else {
            String expression = (String)result.get("expression");
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex(entryEntity);
            String cutStr = expression;
            if (expression.length() > 2000) {
                cutStr = expression.substring(0, 2000);
            }
            this.getModel().setValue(setField, (Object)cutStr, currentRowIndex);
            this.getModel().setValue(configurationField, (Object)expression, currentRowIndex);
            this.getModel().setValue(nameField, (Object)expression.replaceAll("@", ""), currentRowIndex);
        }
    }
}

