/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.formula.FormulaEngine;

public class DetailFormulaPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String TREEVIEWAP = "treeviewap";
    private static final String EXPRESSION = "fexpression";

    public void afterCreateNewData(EventObject e) {
        TreeView treeView = (TreeView)this.getControl(TREEVIEWAP);
        TreeNode root = new TreeNode(null, "0", ResManager.loadKDString((String)"\u5b57\u6bb5", (String)"DetailFormulaPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object fields = formShowParameter.getCustomParam("fields");
        if (Objects.nonNull(fields)) {
            Map fieldMap = (Map)SerializationUtils.fromJsonString((String)fields.toString(), Map.class);
            for (Map.Entry entry : fieldMap.entrySet()) {
                String text = (String)entry.getValue() + "(" + (String)entry.getKey() + ")";
                TreeNode treeNode = new TreeNode("0", (String)entry.getKey(), text);
                root.addChild(treeNode);
            }
        }
        treeView.addNode(root);
        treeView.expand(root.getId());
        String data = (String)formShowParameter.getCustomParam("data");
        if (StringUtils.isNotBlank((CharSequence)data)) {
            this.getModel().setValue(EXPRESSION, (Object)data);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getControl(TREEVIEWAP);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"btnok", "add", "subtract", "multiply", "divide", "left", "right", "clr"});
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        if (StringUtils.equals((CharSequence)"0", (CharSequence)nodeId)) {
            return;
        }
        Object expression = this.getModel().getValue(EXPRESSION);
        this.getModel().setValue(EXPRESSION, (Object)(expression + " @" + nodeId));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)"btnok", (CharSequence)key)) {
            try {
                String expression = (String)this.getModel().getValue(EXPRESSION);
                FormulaEngine.extractVariables((String)expression.replaceAll("@", ""));
                HashMap<String, String> map = new HashMap<String, String>(4);
                map.put("source", "formula");
                map.put("expression", expression.trim());
                this.getView().returnDataToParent(map);
                this.getView().close();
            }
            catch (Exception exception) {
                String message = Objects.nonNull(exception.getCause()) ? exception.getCause().getMessage() : exception.getMessage();
                throw new KDBizException(message);
            }
        } else if (StringUtils.equals((CharSequence)"clr", (CharSequence)key)) {
            this.getModel().setValue(EXPRESSION, (Object)"");
        } else {
            String sign = "";
            switch (key) {
                case "add": {
                    sign = "+";
                    break;
                }
                case "subtract": {
                    sign = "-";
                    break;
                }
                case "multiply": {
                    sign = "*";
                    break;
                }
                case "divide": {
                    sign = "/";
                    break;
                }
                case "left": {
                    sign = "(";
                    break;
                }
                case "right": {
                    sign = ")";
                    break;
                }
            }
            Object expression = this.getModel().getValue(EXPRESSION);
            this.getModel().setValue(EXPRESSION, (Object)(expression + " " + sign));
        }
    }
}

