/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.dataentity.DynamicObjectResultSetCallback;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class EffectiveSetPlugin
extends AbstractFormPlugin {
    private static final String PROP_STARTDATE = "startdate";
    private static final String PROP_ENDDATE = "enddate";
    private static final String PROP_EFFECTIVESTATUS = "effectivestatus";
    private static final String PROP_BIZMODELID = "bizModelId";
    private static final String KEY_BTN_OK = "btnok";

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        ChangeData[] cd = e.getChangeSet();
        Object value = cd[0].getNewValue();
        if (fieldKey.equalsIgnoreCase(PROP_STARTDATE)) {
            this.startDateChange(value);
        } else if (fieldKey.equalsIgnoreCase(PROP_ENDDATE)) {
            this.endDateChange(value);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTN_OK});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals(KEY_BTN_OK)) {
            this.save();
            this.getView().close();
        }
    }

    private void save() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map filters = formShowParameter.getCustomParams();
        if (!filters.containsKey(PROP_BIZMODELID)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u578bID\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5!", (String)"EffectiveSetPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        DBRoute dbRoute = new DBRoute("phm");
        Long id = Long.parseLong(filters.get(PROP_BIZMODELID).toString());
        if (!this.scheduleExists(dbRoute, id)) {
            StringBuilder insertSql = new StringBuilder();
            insertSql.append("insert into t_phm_bizmodel_i (FID,fallowedrunstatus) values(");
            insertSql.append(id);
            insertSql.append(",1");
            insertSql.append(')');
            DB.execute((DBRoute)dbRoute, (String)insertSql.toString());
        }
        DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(filters.get(PROP_BIZMODELID).toString()), (String)"phm_modelschedule", (String)"id,number,startdate,enddate");
        Object temp = this.getModel().getValue(PROP_STARTDATE);
        if (temp != null) {
            model.set(PROP_STARTDATE, temp);
        }
        if ((temp = this.getModel().getValue(PROP_ENDDATE)) != null) {
            model.set(PROP_ENDDATE, temp);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{model});
    }

    private boolean scheduleExists(DBRoute dbRoute, Long id) {
        String sql = "select fid from t_phm_bizmodel_i where fid =" + id;
        DynamicObjectCollection dataSet = (DynamicObjectCollection)DB.query((DBRoute)dbRoute, (String)sql, null, (ResultSetHandler)new DynamicObjectResultSetCallback(null));
        return !dataSet.isEmpty();
    }

    private void endDateChange(Object value) {
        Object startDate = this.getModel().getValue(PROP_STARTDATE);
        if (!this.dateCheck(startDate, value)) {
            this.getModel().setValue(PROP_ENDDATE, (Object)"");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u751f\u6548\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u751f\u6548\u5f00\u59cb\u65f6\u95f4", (String)"EffectiveSetPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            value = null;
        }
        String s = this.effectiveCheck(startDate, value) ? "1" : "0";
        this.getModel().setValue(PROP_EFFECTIVESTATUS, (Object)s);
    }

    private void startDateChange(Object value) {
        Object endDate = this.getModel().getValue(PROP_ENDDATE);
        if (!this.dateCheck(value, endDate)) {
            this.getModel().setValue(PROP_STARTDATE, (Object)"");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u751f\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u751f\u6548\u7ed3\u675f\u65f6\u95f4", (String)"EffectiveSetPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            value = null;
        }
        String s = this.effectiveCheck(value, endDate) ? "1" : "0";
        this.getModel().setValue(PROP_EFFECTIVESTATUS, (Object)s);
    }

    private boolean dateCheck(Object startDate, Object endDate) {
        if (startDate != null && endDate != null) {
            Date stDate = (Date)startDate;
            Date edDate = (Date)endDate;
            return this.diff(stDate, edDate);
        }
        return true;
    }

    private boolean effectiveCheck(Object startDate, Object endDate) {
        if (endDate == null && startDate == null) {
            return true;
        }
        if (endDate == null) {
            return this.diff((Date)startDate, new Date());
        }
        if (startDate == null) {
            return this.diff(new Date(), (Date)endDate);
        }
        return this.diff((Date)startDate, new Date()) && this.diff(new Date(), (Date)endDate);
    }

    private boolean diff(Date dt1, Date dt2) {
        Long diff = dt2.getTime() - dt1.getTime();
        return diff >= 0L;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map filters = formShowParameter.getCustomParams();
        if (!filters.containsKey(PROP_BIZMODELID)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u578bID\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5!", (String)"EffectiveSetPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.init(Long.parseLong(filters.get(PROP_BIZMODELID).toString()));
    }

    private void init(Long id) {
        DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)id, (String)"phm_modelschedule", (String)"id,startdate,enddate,effectivestatus");
        Object startDate = model.get(PROP_STARTDATE);
        Object endDate = model.get(PROP_ENDDATE);
        if (startDate != null) {
            this.getModel().setValue(PROP_STARTDATE, startDate);
        }
        if (endDate != null) {
            this.getModel().setValue(PROP_ENDDATE, endDate);
        }
        String s = this.effectiveCheck(startDate, endDate) ? "1" : "0";
        this.getModel().setValue(PROP_EFFECTIVESTATUS, (Object)s);
    }
}

