/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;

public class EigenTablePlugin
extends AbstractFormPlugin {
    private static final String ENTRYENTITY = "entryentity";
    private static final String ENTITYKEY = "phm_eigentable";
    private static final String FORECOLOR = "#000000";
    private static final int FONTSIZE = 12;
    private static final String ROWBACKCOLOR = "#FFFFFF";
    private static final int PAGEROWS = 20;
    private static final String CANCEL = "cancel";
    private static final String COLTYPES = "colTypes";
    private static final String DATAS = "datas";
    private static final String SORTEDCOLLABELS = "sortedColLabels";
    private static final String COLCOUNT = "colCount";
    private static final String ROWCOUNT = "rowCount";
    private static final String ROWS = "rows";
    private static final String TIMESTAMP = "TIMESTAMP";
    private Map<String, String> fieldNames;
    private List<Map<String, Object>> listMapDatas;
    private JSONArray sortedColLabels;
    private static final ThreadLocal<SimpleDateFormat> THREAD_LOCAL = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int entryRowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
        entryGrid.setRowBackcolor(ROWBACKCOLOR, IntStream.range(0, entryRowCount).toArray());
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        this.bulidFieldNames(formShowParameter);
        EntryAp entryAp = this.dynamicCreatEntryAp();
        HashMap<String, String> entryMap = new HashMap<String, String>(4);
        entryMap.put("id", ENTRYENTITY);
        entryMap.put("columns", (String)entryAp.createControl().get("columns"));
        e.getItems().add(entryMap);
    }

    public void createNewData(BizDataEventArgs e) {
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        DynamicObjectCollection entryRows = dataEntity.getDynamicObjectCollection(ENTRYENTITY);
        this.buildMapDatas();
        for (Map<String, Object> listMapData : this.listMapDatas) {
            DynamicObject entryRow = entryRows.addNew();
            for (Map.Entry<String, Object> entry : listMapData.entrySet()) {
                String key = entry.getKey();
                Object data = entry.getValue();
                entryRow.set(key, data);
            }
        }
        e.setDataEntity((Object)dataEntity);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType cloneEntityType;
        MainEntityType originalEntityType = e.getOriginalEntityType();
        try {
            cloneEntityType = (MainEntityType)originalEntityType.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new KDException((Throwable)ex, new ErrorCode("EigenTablePlugin.getEntityType", ex.getMessage()), new Object[0]);
        }
        EntryType entryType = (EntryType)cloneEntityType.getAllEntities().get(ENTRYENTITY);
        this.bulidFieldNames(this.getView().getFormShowParameter());
        for (Object sortedColLabel : this.sortedColLabels) {
            String key = sortedColLabel.toString();
            String fieldName = this.fieldNames.get(key);
            TextProp textProp = new TextProp();
            textProp.setName(key);
            textProp.setDisplayName(new LocaleString(fieldName));
            textProp.setDbIgnore(true);
            entryType.registerSimpleProperty((DynamicSimpleProperty)textProp);
        }
        e.setNewEntityType(cloneEntityType);
        EntryAp entryAp = this.dynamicCreatEntryAp();
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        List items = ((Container)entryAp.buildRuntimeControl()).getItems();
        for (Control item : items) {
            item.setView(this.getView());
            entryGrid.getItems().add(item);
        }
    }

    private void bulidFieldNames(FormShowParameter formShowParameter) {
        Object eigenValue = formShowParameter.getCustomParam("eigenValue");
        if (eigenValue == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5c55\u793a\u6570\u636e\u4e3a\u7a7a", (String)"EigenTablePlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
        HashMap<String, String> fieldNames = new HashMap<String, String>(16);
        Object o = JSONObject.toJSON((Object)eigenValue);
        if (o instanceof JSONObject) {
            JSONObject eigenData = JSONObject.parseObject((String)o.toString());
            JSONArray sortedColLabels = eigenData.getJSONArray(SORTEDCOLLABELS);
            for (Object colLabel : sortedColLabels) {
                String fieldName = colLabel.toString();
                fieldNames.put(fieldName, fieldName);
            }
            this.sortedColLabels = sortedColLabels;
        }
        this.fieldNames = fieldNames;
    }

    private EntryAp dynamicCreatEntryAp() {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey(ENTRYENTITY);
        String entityId = MetadataDao.getIdByNumber((String)ENTITYKEY, (MetaCategory)MetaCategory.Entity);
        FormMetadata formmeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        EntityMetadata entitymeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        formmeta.bindEntityMetadata(entitymeta);
        for (ControlAp ap : formmeta.getItems()) {
            if (!StringUtils.equals((CharSequence)ENTRYENTITY, (CharSequence)ap.getKey())) continue;
            entryAp = (EntryAp)ap;
            break;
        }
        for (Object sortedColLabel : this.sortedColLabels) {
            String key = sortedColLabel.toString();
            String fieldName = this.fieldNames.get(key);
            EntryFieldAp entryFieldAp = new EntryFieldAp();
            entryFieldAp.setId(key);
            entryFieldAp.setKey(key);
            entryFieldAp.setName(new LocaleString(fieldName));
            entryFieldAp.setForeColor(FORECOLOR);
            entryFieldAp.setFontSize(12);
            TextField textField = new TextField();
            textField.setId(key);
            textField.setKey(key);
            entryFieldAp.setField((Field)textField);
            entryAp.getItems().add(entryFieldAp);
        }
        return entryAp;
    }

    private void buildMapDatas() {
        ArrayList<Map<String, Object>> listMapDatas = new ArrayList<Map<String, Object>>();
        Object eigenValue = this.getView().getFormShowParameter().getCustomParam("eigenValue");
        if (eigenValue == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5c55\u793a\u6570\u636e\u4e3a\u7a7a", (String)"EigenTablePlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
        if (eigenValue instanceof JSONObject) {
            JSONObject eigenData = JSONObject.parseObject((String)eigenValue.toString());
            JSONObject colTypes = eigenData.getJSONObject(COLTYPES);
            JSONObject datas = eigenData.getJSONObject(DATAS);
            JSONArray sortedCollabels = eigenData.getJSONArray(SORTEDCOLLABELS);
            JSONArray rows = datas.getJSONArray(ROWS);
            for (Object row : rows) {
                JSONArray rowObj = (JSONArray)row;
                HashMap<String, Object> fieldDatas = new HashMap<String, Object>(16);
                for (int i = 0; i < sortedCollabels.size(); ++i) {
                    String fieldKey = sortedCollabels.get(i).toString();
                    String vTypeName = colTypes.getString(fieldKey);
                    Object value = rowObj.get(i);
                    value = this.getValueByType(vTypeName, value);
                    fieldDatas.put(fieldKey, value);
                }
                listMapDatas.add(fieldDatas);
            }
        }
        this.listMapDatas = listMapDatas;
    }

    private Object getValueByType(String vTypeName, Object value) {
        if (StringUtils.equals((CharSequence)TIMESTAMP, (CharSequence)vTypeName)) {
            if (value instanceof Number) {
                value = new Date(((Number)value).longValue());
            } else {
                if (value != null) {
                    throw new KDBizException(new ErrorCode("UNKNOWN_DATE_CLASS", value.getClass().getName()), new Object[0]);
                }
                value = new Date();
            }
            value = THREAD_LOCAL.get().format(value);
        } else if (value instanceof BigDecimal) {
            value = ((BigDecimal)value).stripTrailingZeros().toPlainString();
        }
        return value;
    }
}

