/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel;

import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.tools.Column;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.mmc.phm.common.bizmodel.TermEnums;
import kd.mmc.phm.common.info.EigenCalModelInfo;
import kd.mmc.phm.common.info.FieldEntryInfo;
import kd.mmc.phm.common.info.TableEntryInfo;
import kd.mmc.phm.common.info.TermEntryInfo;
import kd.mmc.phm.common.util.CalculationTreeNode;
import kd.mmc.phm.common.util.CalculationTreeUtils;
import kd.mmc.phm.formplugin.bizmodel.EigenCalModelEdit;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class EigenValueCalculatePlugin
extends AbstractFormPlugin
implements AfterF7SelectListener,
TreeNodeClickListener {
    protected static final Log logger = LogFactory.getLog(EigenCalModelEdit.class);
    protected static final String PHM_EIGENVALUE_F7 = "phm_eigenvalue_f7";
    protected static final String CELLSEQ = "cellseq";
    protected static final String RELATIONS = "relations";
    protected static final String SAVE = "save";
    protected static final String XMLDATA = "xmlData";
    protected static final String SELECTCELL = "selectCell";
    protected static final String INITXMLDATA = "initxmlData";
    protected static final String CLEARCONTROLDATA = "ClearControlData";
    protected static final String VERTEX = "vertex";
    protected static final String EDGE = "edge";
    protected static final String ID = "id";
    protected static final String VALUE = "value";
    protected static final String MXGEOMETRY = "mxGeometry";
    protected static final String MXCELL = "mxCell";
    protected static final String SOURCE = "source";
    protected static final String TARGET = "target";
    protected static final String X = "x";
    protected static final String Y = "y";
    protected static final String ACTION = "Action";
    protected static final String XML = "xml";
    protected static final String DELETECELLS = "deleteCells";
    protected static final String CLEANGRAPH = "cleanGraph";
    protected static final String ADDXML = "addxml";
    protected static final String SAVEMXGRAPH = "saveMxgraph";
    protected static final String UPDATEGRAPH = "updateGraph";
    protected static final String STYLE = "style";
    public static final String MODELNAME = "modelname";
    public static final String UPDATE_MODELNAME = "updateModelname";
    public static final String NAME = "name";
    public static final String SELECT_CELL_ID = "selectCellID";
    public static final String GRADE = "grade";
    public static final String TYPE = "type";
    public static final String BELONG = "belong";
    public static final String MODELISINT = "modelisint";
    public static final String ISFLOT = "isflot";
    public static final String ISMATRIX = "ismatrix";
    public static final String MODELREMARK = "modelremark";
    public static final String PHM_F7_IMPORT = "phmF7Import";
    public static final String NODELIST = "nodelist";
    public static final String ROOT_ID = "rootId";
    public static final String FLEXPANELAP_4 = "flexpanelap4";
    public static final String DELETE_CONFIRM = "deleteConfirm";
    public static final String DELETE_IDS = "deleteIds";
    public static final String DELETE_PHM_CELL = "deletePHMCell";
    public static final String DELETE_CELLS = "deleteCells";
    protected static final String[] fields = new String[]{"modelname", "cellseq", "grade", "type", "belong", "model", "isint", "isflot", "ismatrix", "modelremark", "setway", "eigen", "sql_tag", "params_tag", "groupinfo_tag", "orderinfo_tag", "isqueryset", "isdefsql", "functioninfo_tag", "linkinfo_tag", "eigenid", "eigenentry", "outputsql_tag", "outputinfo_tag", "nameinfo_tag", "defsql_tag", "descinfo_tag", "leftterm", "field", "term", "valuetype", "value", "rightterm", "linkterm"};

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btn_addnode", "btn_save", "btn_delete", "btn_savecell", "btn_clean", "btn_ok", "btn_test", "btn_viewsql"});
        BasedataEdit modelBase = (BasedataEdit)this.getView().getControl("model");
        modelBase.addAfterF7SelectListener((AfterF7SelectListener)this);
        TextEdit eigen = (TextEdit)this.getView().getControl("eigen");
        eigen.addClickListener((ClickListener)this);
        TreeView linkTree = (TreeView)this.getView().getControl("linktree");
        linkTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        TextEdit mainfield = (TextEdit)this.getView().getControl("mainfield");
        mainfield.addClickListener((ClickListener)this);
        TextEdit linkfield = (TextEdit)this.getView().getControl("linkfield");
        linkfield.addClickListener((ClickListener)this);
        TextEdit field = (TextEdit)this.getView().getControl("field");
        field.addClickListener((ClickListener)this);
        TextEdit value = (TextEdit)this.getView().getControl(VALUE);
        value.addClickListener((ClickListener)this);
        Vector btnnew = (Vector)this.getView().getControl("btnnew");
        btnnew.addClickListener((ClickListener)this);
        Vector btnedit = (Vector)this.getView().getControl("btnedit");
        btnedit.addClickListener((ClickListener)this);
        Vector btndel = (Vector)this.getView().getControl("btndel");
        btndel.addClickListener((ClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData cd = e.getChangeSet()[0];
        Object newValue = cd.getNewValue();
        if ("setway".equals(propertyName)) {
            this.setWayChanged(newValue);
        } else if ("isqueryset".equals(propertyName)) {
            this.querysetChanged(newValue);
        } else if ("isdefsql".equals(propertyName)) {
            this.defSQLChanged(newValue);
        } else if ("mainfield".equals(propertyName) || "linkfield".equals(propertyName) || "condition".equals(propertyName)) {
            this.storeTableEntry();
        } else if ("isparam".equals(propertyName)) {
            this.paramsChanged(e);
        } else if ("isgroup".equals(propertyName)) {
            this.isGroupChanged(e);
        } else if ("level".equals(propertyName)) {
            this.groupLevelChanged(e);
        } else if ("isorder".equals(propertyName)) {
            this.isOrderChanged(e);
        } else if ("orderlevel".equals(propertyName)) {
            this.orderLevelChanged(e);
        } else if ("function".equals(propertyName)) {
            this.functionChanged(e);
        } else if ("outputcol".equals(propertyName)) {
            this.outputColChanged(e);
        } else if ("namefield".equals(propertyName)) {
            this.nameFieldChanged(e);
        } else if ("sortway".equals(propertyName)) {
            this.sortWayChanged(e);
        } else if (MODELNAME.equals(propertyName)) {
            this.updateModelName(e);
        } else if ("valuetype".equals(propertyName)) {
            this.valueTypeChanged(e);
        }
        if (Arrays.asList(fields).contains(propertyName)) {
            this.saveCellsData();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if (StringUtils.equals((CharSequence)"newentry", (CharSequence)key)) {
            TreeView linkTree = this.getLinkTree();
            List selectIds = linkTree.getTreeState().getSelectedNodeId();
            if (selectIds.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8fde\u63a5\u8868\u914d\u7f6e\u8282\u70b9", (String)"EigenValueCalculatePlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            String selectId = (String)selectIds.get(0);
            if (StringUtils.equals((CharSequence)"0", (CharSequence)selectId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8fde\u63a5\u8868\u914d\u7f6e\u975e\u6839\u8282\u70b9", (String)"EigenValueCalculatePlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            TreeNode root = this.getRootNode();
            List children = root.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                TreeNode child = (TreeNode)children.get(i);
                if (!StringUtils.equals((CharSequence)child.getId(), (CharSequence)selectId)) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8fde\u63a5\u8868\u914d\u7f6e\u975e\u4e3b\u8868\u8282\u70b9", (String)"EigenValueCalculatePlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key = args.getOperateKey();
        if (StringUtils.equals((CharSequence)"deleteentry", (CharSequence)key)) {
            this.storeTableEntry();
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        Control con = (Control)evt.getSource();
        String key = con.getKey();
        if (StringUtils.equals((CharSequence)"eigen", (CharSequence)key)) {
            this.showEigenValueForm();
        } else if (StringUtils.equals((CharSequence)"mainfield", (CharSequence)key)) {
            this.showMainFieldForm();
        } else if (StringUtils.equals((CharSequence)"linkfield", (CharSequence)key)) {
            this.showLinkFieldForm();
        } else if (StringUtils.equals((CharSequence)"field", (CharSequence)key)) {
            this.showFieldForm();
        } else if (StringUtils.equals((CharSequence)VALUE, (CharSequence)key)) {
            this.showValueForm();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionid = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)PHM_EIGENVALUE_F7, (CharSequence)actionid)) {
            this.setEigenValue(closedCallBackEvent);
        } else if (StringUtils.equals((CharSequence)"mainfield", (CharSequence)actionid)) {
            this.setMainField(closedCallBackEvent);
        } else if (StringUtils.equals((CharSequence)"linkfield", (CharSequence)actionid)) {
            this.setLinkField(closedCallBackEvent);
        } else if (StringUtils.equals((CharSequence)"field", (CharSequence)actionid)) {
            this.setField(closedCallBackEvent);
        } else if (StringUtils.equals((CharSequence)VALUE, (CharSequence)actionid)) {
            this.setValue(closedCallBackEvent);
        } else if (StringUtils.equals((CharSequence)"root", (CharSequence)actionid)) {
            this.rootCallBack(closedCallBackEvent);
        } else if (StringUtils.equals((CharSequence)"other", (CharSequence)actionid)) {
            this.otherCallBack(closedCallBackEvent);
        } else if (StringUtils.equals((CharSequence)"edit", (CharSequence)actionid)) {
            this.editCallBack(closedCallBackEvent);
        }
    }

    public void click(EventObject evt) {
        Control con = (Control)evt.getSource();
        String srcCtrlKey = con.getKey().toLowerCase();
        if ("btn_save".equals(srcCtrlKey)) {
            this.saveMxgraph();
        } else if ("btn_savecell".equals(srcCtrlKey)) {
            boolean isApproveCheck = this.isApproveCheck();
            if (!isApproveCheck) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u542b\u6709\u81ea\u5b9aSQL\u7684\u53c2\u6570\u4fdd\u5b58\u8282\u70b9\u4fe1\u606f\u65f6\uff0c\u8bf7\u5148\u67e5\u8be2\u6d4b\u8bd5\u914d\u7f6e\u662f\u5426\u6b63\u786e", (String)"EigenValueCalculatePlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.saveMxgraph();
            this.saveCellsData();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u8282\u70b9\u4fe1\u606f\u6210\u529f", (String)"EigenValueCalculatePlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        } else if ("btn_addnode".equals(srcCtrlKey)) {
            this.addNode();
        } else if ("btn_clean".equals(srcCtrlKey)) {
            this.cleanMxgraph();
        } else if ("btn_delete".equals(srcCtrlKey)) {
            this.deleteSelectNode();
        } else if ("btn_ok".equals(srcCtrlKey)) {
            this.returnData();
        } else if ("btn_test".equals(srcCtrlKey)) {
            this.queryTest();
        } else if ("btnnew".equals(srcCtrlKey)) {
            this.clickBtnnew();
        } else if ("btnedit".equals(srcCtrlKey)) {
            this.clickBtnedit();
        } else if ("btndel".equals(srcCtrlKey)) {
            this.clickBtndel();
        } else if ("btn_viewsql".equals(srcCtrlKey)) {
            this.viewSQL();
        }
    }

    public void afterF7Select(AfterF7SelectEvent e) {
        Control con = (Control)e.getSource();
        String key = con.getKey();
        if ("model".equals(key)) {
            try {
                this.importCalModel(e);
            }
            catch (DocumentException e1) {
                throw new KDBizException((Throwable)e1, new ErrorCode("", ResManager.loadKDString((String)"\u5f15\u5165\u8ba1\u7b97\u6a21\u578b\u5931\u8d25\uff1a%s", (String)"EigenValueCalculatePlugin_5", (String)"mmc-phm-formplugin", (Object[])new Object[0])), new Object[]{e1.getMessage()});
            }
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String eventArgs = e.getEventArgs();
        if (XMLDATA.equalsIgnoreCase(eventName)) {
            this.getModel().setValue("xml_tag", (Object)eventArgs);
        }
        if (SELECTCELL.equalsIgnoreCase(eventName)) {
            this.changeNodeInfo(eventArgs);
        }
        if (INITXMLDATA.equalsIgnoreCase(eventName)) {
            this.initxmlData();
        }
        if (CLEARCONTROLDATA.equalsIgnoreCase(eventName)) {
            this.clearControlData();
        }
        if (DELETE_CONFIRM.equalsIgnoreCase(eventName)) {
            List ids = (List)SerializationUtils.fromJsonString((String)eventArgs, ArrayList.class);
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(DELETE_CONFIRM, (IFormPlugin)this);
            this.getPageCache().put(DELETE_IDS, eventArgs);
            String confirmMessage = String.format(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684%s\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\r\n\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"EigenValueCalculatePlugin_6", (String)"mmc-phm-formplugin", (Object[])new Object[0]), ids.size());
            this.getView().showConfirm(confirmMessage, MessageBoxOptions.OKCancel, ConfirmTypes.Delete, confirmCallBackListener);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Control con = (Control)evt.getSource();
        String key = con.getKey();
        if (StringUtils.equals((CharSequence)"linktree", (CharSequence)key)) {
            String selectId;
            String string = selectId = evt.getNodeId() == null ? "" : evt.getNodeId().toString();
            if (StringUtils.equals((CharSequence)"0", (CharSequence)selectId)) {
                this.getModel().deleteEntryData("fieldentry");
                this.getModel().deleteEntryData("linkentry");
                this.getModel().deleteEntryData("tableentry");
                return;
            }
            TreeNode selectNode = this.getNodeInfosById(this.getRootNode(), selectId);
            this.fillTableEntry(selectNode);
            this.fillFieldsEntry(selectNode);
        }
    }

    protected TableValueSetter constractTableEntry(Map<String, String> map) {
        String tableEntryStr = map.get("tableentry");
        TableValueSetter tableEntryVs = new TableValueSetter(new String[]{"seq", "mainfield", "linkfield", "condition"});
        List tableEntryList = (List)SerializationUtils.fromJsonString((String)tableEntryStr, List.class);
        for (int i = 0; i < tableEntryList.size(); ++i) {
            Map entryMap = (Map)tableEntryList.get(i);
            String seq = (String)entryMap.get("seq");
            String mainfield = (String)entryMap.get("mainfield");
            String linkfield = (String)entryMap.get("linkfield");
            String condition = (String)entryMap.get("condition");
            tableEntryVs.addRow(new Object[]{seq, mainfield, linkfield, condition});
        }
        return tableEntryVs;
    }

    protected void changeNodeInfo(String eventArgs) {
        String cellId = eventArgs;
        Object cellsdataObj = this.getModel().getValue("cellsdata_tag");
        this.getModel().setValue("selectid", (Object)cellId);
        if (cellsdataObj != null) {
            String cellsdata = cellsdataObj.toString();
            Map cellsDataMap = (Map)JSONObject.parse((String)cellsdata);
            if (cellsDataMap == null) {
                this.getModel().beginInit();
                this.getModel().setValue(MODELNAME, null);
                this.getModel().setValue("model", null);
                this.getModel().setValue(TYPE, null);
                this.getModel().setValue("isint", null);
                this.getModel().setValue(ISFLOT, null);
                this.getModel().setValue(ISMATRIX, null);
                this.getModel().setValue(MODELREMARK, null);
                this.getModel().setValue(GRADE, null);
                this.getModel().setValue(CELLSEQ, null);
                this.getModel().setValue(BELONG, null);
                this.getModel().setValue("setway", (Object)"eigen");
                this.getModel().setValue("eigen", null);
                this.getModel().setValue("isqueryset", (Object)Boolean.TRUE);
                this.getModel().setValue("isdoubles", (Object)Boolean.TRUE);
                this.getModel().setValue("isdefsql", (Object)Boolean.FALSE);
                this.getModel().setValue("issingle", (Object)Boolean.FALSE);
                this.getModel().setValue("sql_tag", null);
                this.getModel().setValue("linkinfo_tag", null);
                this.getModel().setValue("params_tag", null);
                this.getModel().setValue("groupinfo_tag", null);
                this.getModel().setValue("orderinfo_tag", null);
                this.getModel().setValue("functioninfo_tag", null);
                TreeView linktree = this.getLinkTree();
                linktree.deleteAllNodes();
                this.constractLinkTree();
                this.getModel().endInit();
                this.getView().updateView();
                return;
            }
            Map cellData = (Map)cellsDataMap.get(cellId);
            if (cellData != null) {
                this.getModel().beginInit();
                this.getModel().setValue(MODELNAME, cellData.get(MODELNAME));
                this.getModel().setValue("model", cellData.get("model"));
                this.getModel().setValue(TYPE, cellData.get(TYPE));
                this.getModel().setValue("isint", cellData.get("isint"));
                this.getModel().setValue(ISFLOT, cellData.get(ISFLOT));
                this.getModel().setValue(ISMATRIX, cellData.get(ISMATRIX));
                this.getModel().setValue(MODELREMARK, cellData.get(MODELREMARK));
                this.getModel().setValue(GRADE, cellData.get(GRADE));
                this.getModel().setValue(CELLSEQ, cellData.get(CELLSEQ));
                this.getModel().setValue(BELONG, cellData.get(BELONG));
                this.constractParamInfo(cellData);
                this.getModel().endInit();
                this.getView().updateView();
            } else {
                this.getModel().beginInit();
                this.getModel().setValue(MODELNAME, null);
                this.getModel().setValue("model", null);
                this.getModel().setValue(TYPE, null);
                this.getModel().setValue("isint", null);
                this.getModel().setValue(ISFLOT, null);
                this.getModel().setValue(ISMATRIX, null);
                this.getModel().setValue(MODELREMARK, null);
                this.getModel().setValue(GRADE, null);
                this.getModel().setValue(CELLSEQ, null);
                this.getModel().setValue(BELONG, null);
                this.getModel().setValue("setway", (Object)"eigen");
                this.getModel().setValue("eigen", null);
                this.getModel().setValue("isqueryset", (Object)Boolean.TRUE);
                this.getModel().setValue("isdoubles", (Object)Boolean.TRUE);
                this.getModel().setValue("isdefsql", (Object)Boolean.FALSE);
                this.getModel().setValue("issingle", (Object)Boolean.FALSE);
                this.getModel().setValue("sql_tag", null);
                this.getModel().deleteEntryData("fieldentry");
                this.getModel().deleteEntryData("tableentry");
                this.getModel().deleteEntryData("termentry");
                this.getModel().setValue("linkinfo_tag", null);
                this.getModel().setValue("params_tag", null);
                this.getModel().setValue("groupinfo_tag", null);
                this.getModel().setValue("orderinfo_tag", null);
                this.getModel().setValue("functioninfo_tag", null);
                TreeView linktree = this.getLinkTree();
                linktree.deleteAllNodes();
                this.constractLinkTree();
                this.getModel().endInit();
                this.getView().updateView();
            }
        }
    }

    protected void constractParamInfo(Map<String, Object> cellData) {
        String jsstr = JSONObject.toJSONString(cellData);
        EigenCalModelInfo eigenCalModelInfo = (EigenCalModelInfo)JSONObject.parseObject((String)jsstr, EigenCalModelInfo.class);
        String setway = "eigen";
        if (eigenCalModelInfo.getSetway() != null) {
            setway = eigenCalModelInfo.getSetway();
        }
        this.getModel().setValue("setway", (Object)setway);
        this.setWayChanged(setway);
        this.getModel().setValue("eigen", (Object)eigenCalModelInfo.getEigen());
        this.getModel().setValue("eigenid", (Object)eigenCalModelInfo.getEigenid());
        this.getModel().setValue("eigenentry", (Object)eigenCalModelInfo.getEigenentry());
        this.getModel().setValue("isqueryset", (Object)eigenCalModelInfo.isIsqueryset());
        this.getModel().setValue("isdefsql", (Object)eigenCalModelInfo.isIsdefsql());
        if (eigenCalModelInfo.isIsqueryset() && !eigenCalModelInfo.isIsdefsql()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap112", "flexpanelap114"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap51"});
        } else if (!eigenCalModelInfo.isIsqueryset() && eigenCalModelInfo.isIsdefsql()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap51"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap112", "flexpanelap114"});
        } else {
            this.getModel().setValue("isqueryset", (Object)Boolean.TRUE);
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap112", "flexpanelap114"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap51"});
        }
        this.getModel().setValue("isdoubles", (Object)eigenCalModelInfo.isIsdoubles());
        this.getModel().setValue("issingle", (Object)eigenCalModelInfo.isIssingle());
        this.getModel().setValue("sql_tag", (Object)eigenCalModelInfo.getSql_tag());
        this.getModel().setValue("linkinfo_tag", (Object)eigenCalModelInfo.getLinkinfo_tag());
        this.getModel().setValue("params_tag", (Object)eigenCalModelInfo.getParams_tag());
        this.getModel().setValue("groupinfo_tag", (Object)eigenCalModelInfo.getGroupinfo_tag());
        this.getModel().setValue("orderinfo_tag", (Object)eigenCalModelInfo.getOrderinfo_tag());
        this.getModel().setValue("functioninfo_tag", (Object)eigenCalModelInfo.getFunctioninfo_tag());
        this.getModel().setValue("outputinfo_tag", (Object)eigenCalModelInfo.getOutputinfo_tag());
        this.getModel().setValue("outputsql_tag", (Object)eigenCalModelInfo.getOutputsql_tag());
        this.getModel().setValue("nameinfo_tag", (Object)eigenCalModelInfo.getNameinfo_tag());
        this.getModel().setValue("descinfo_tag", (Object)eigenCalModelInfo.getDescinfo_tag());
        if (eigenCalModelInfo.isIsdefsql()) {
            CodeEdit sqlarea = (CodeEdit)this.getView().getControl("sqlarea");
            sqlarea.setText(eigenCalModelInfo.getDefsql_tag());
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        ArrayList fieldEntryList = eigenCalModelInfo.getFieldentry();
        if (fieldEntryList == null) {
            fieldEntryList = new ArrayList();
        }
        TableValueSetter fieldEntryVs = new TableValueSetter(new String[]{"seq", "fieldname", "fieldtype", "isparam", "maintable"});
        for (int i = 0; i < fieldEntryList.size(); ++i) {
            FieldEntryInfo fieldEntryInfo = (FieldEntryInfo)fieldEntryList.get(i);
            String fieldName = fieldEntryInfo.getFieldname();
            String fieldType = fieldEntryInfo.getFieldtype();
            boolean isParam = fieldEntryInfo.isIsparam();
            String maintable = fieldEntryInfo.getMaintable();
            fieldEntryVs.addRow(new Object[]{i, fieldName, fieldType, isParam, maintable});
        }
        ArrayList tableEntryList = eigenCalModelInfo.getTableentry();
        if (tableEntryList == null) {
            tableEntryList = new ArrayList();
        }
        TableValueSetter tableEntryVs = new TableValueSetter(new String[]{"seq", "mainfield", "linkfield", "condition"});
        for (int i = 0; i < tableEntryList.size(); ++i) {
            TableEntryInfo tableEntryInfo = (TableEntryInfo)tableEntryList.get(i);
            String mainField = tableEntryInfo.getMainfield();
            String linkField = tableEntryInfo.getLinkfield();
            String condition = tableEntryInfo.getCondition();
            tableEntryVs.addRow(new Object[]{i, mainField, linkField, condition});
        }
        ArrayList termEntryList = eigenCalModelInfo.getTermentry();
        if (termEntryList == null) {
            termEntryList = new ArrayList();
        }
        TableValueSetter termEntryVs = new TableValueSetter(new String[]{"seq", "field", "term", "valuetype", VALUE, "linkterm", "leftterm", "rightterm"});
        for (int i = 0; i < termEntryList.size(); ++i) {
            TermEntryInfo termEntryInfo = (TermEntryInfo)termEntryList.get(i);
            String field = termEntryInfo.getField();
            String term = termEntryInfo.getTerm();
            String valueType = termEntryInfo.getValuetype();
            String value = termEntryInfo.getValue();
            String linkterm = termEntryInfo.getLinkterm();
            String leftterm = termEntryInfo.getLeftterm();
            String rightterm = termEntryInfo.getRightterm();
            termEntryVs.addRow(new Object[]{i, field, term, valueType, value, linkterm, leftterm, rightterm});
        }
        model.deleteEntryData("fieldentry");
        model.deleteEntryData("tableentry");
        model.deleteEntryData("termentry");
        model.deleteEntryData("linkentry");
        model.batchCreateNewEntryRow("fieldentry", fieldEntryVs);
        model.batchCreateNewEntryRow("tableentry", tableEntryVs);
        model.batchCreateNewEntryRow("termentry", termEntryVs);
        model.endInit();
        this.getView().updateView("fieldentry");
        this.getView().updateView("tableentry");
        this.getView().updateView("termentry");
        String linkInfo = (String)this.getModel().getValue("linkinfo_tag");
        if (StringUtils.isNotEmpty((CharSequence)linkInfo)) {
            TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)linkInfo, TreeNode.class);
            TreeView linkTree = (TreeView)this.getView().getControl("linktree");
            linkTree.deleteAllNodes();
            linkTree.addNode(root);
            this.getPageCache().put("root", linkInfo);
            List children = root.getChildren();
            for (TreeNode child : children) {
                linkTree.expand(child.getId());
            }
            this.getView().updateView("linktree");
        } else {
            this.getLinkTree().deleteAllNodes();
            this.constractLinkTree();
        }
    }

    protected void initxmlData() {
        String xmlStr;
        CustomControl control = (CustomControl)this.getView().getControl("cc_mgdesigner");
        if (control == null) {
            return;
        }
        Object xml = this.getModel().getValue("xml_tag");
        if (xml != null && StringUtils.isNotEmpty((CharSequence)(xmlStr = xml.toString()))) {
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            paramsMap.put(ACTION, "initPHMXmlData");
            paramsMap.put(XML, xmlStr);
            control.setData(paramsMap);
        }
    }

    protected void clearControlData() {
        CustomControl control = (CustomControl)this.getView().getControl("cc_mgdesigner");
        if (control == null) {
            return;
        }
        control.setData(null);
    }

    protected void setWayChanged(Object newValue) {
        if (newValue == null || "eigen".equals(newValue.toString())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"eigen"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap6", "flexpanelap7"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap6", "flexpanelap7"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"eigen"});
        }
    }

    protected void defSQLChanged(Object newValue) {
        if (Boolean.parseBoolean(newValue.toString())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap51"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap112", "flexpanelap114"});
            this.getModel().setValue("isqueryset", (Object)Boolean.FALSE);
        } else {
            this.getModel().setValue("isqueryset", (Object)Boolean.TRUE);
        }
    }

    protected void querysetChanged(Object newValue) {
        if (Boolean.parseBoolean(newValue.toString())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap112", "flexpanelap114"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap51"});
            this.getModel().setValue("isdefsql", (Object)Boolean.FALSE);
            this.getModel().setValue("isdoubles", (Object)Boolean.TRUE);
        } else {
            this.getModel().setValue("isdefsql", (Object)Boolean.TRUE);
        }
    }

    protected void saveMxgraph() {
        CustomControl control = (CustomControl)this.getView().getControl("cc_mgdesigner");
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put(ACTION, SAVEMXGRAPH);
        control.setData(paramsMap);
    }

    protected void saveCellsData() {
        String upSelectidstr;
        Object cellsdataObj = this.getModel().getValue("cellsdata_tag");
        String upSelectid = (String)this.getModel().getValue("selectid");
        if (upSelectid != null && StringUtils.isNotEmpty((CharSequence)(upSelectidstr = upSelectid))) {
            Map stringObjectMap;
            String cellsdata;
            Map<String, Map<String, Object>> cellsDataMap = new HashMap();
            Map<String, Object> cellData = new HashMap();
            if (cellsdataObj != null && StringUtils.isNotEmpty((CharSequence)(cellsdata = cellsdataObj.toString()))) {
                cellsDataMap = (Map)JSONObject.parse((String)cellsdata);
            }
            if ((stringObjectMap = (Map)cellsDataMap.get(upSelectidstr)) != null) {
                cellData = stringObjectMap;
            }
            Object modelObj = this.getModel().getValue("model");
            Object modelnameObj = this.getModel().getValue(MODELNAME);
            Object typeObj = this.getModel().getValue(TYPE);
            Object isintObj = this.getModel().getValue("isint");
            Object isflotObj = this.getModel().getValue(ISFLOT);
            Object ismatrixObj = this.getModel().getValue(ISMATRIX);
            Object modelremarkObj = this.getModel().getValue(MODELREMARK);
            Object gradeObj = this.getModel().getValue(GRADE);
            Object cellseqObj = this.getModel().getValue(CELLSEQ);
            Object belongObj = this.getModel().getValue(BELONG);
            if (modelObj != null) {
                DynamicObject modelDyObj = (DynamicObject)modelObj;
                cellData.put("model", modelDyObj.getString(ID));
            } else {
                cellData.put("model", null);
            }
            cellData.put(MODELNAME, modelnameObj);
            cellData.put(TYPE, typeObj);
            cellData.put("isint", isintObj);
            cellData.put(ISFLOT, isflotObj);
            cellData.put(ISMATRIX, ismatrixObj);
            cellData.put(MODELREMARK, modelremarkObj);
            cellData.put(GRADE, gradeObj);
            cellData.put(CELLSEQ, cellseqObj);
            cellData.put(BELONG, belongObj);
            this.saveParamInfo(cellData);
            cellsDataMap.put(upSelectidstr, cellData);
            String jsonString = JSONObject.toJSONString(cellsDataMap);
            this.getModel().setValue("cellsdata_tag", (Object)jsonString);
        }
    }

    protected void saveParamInfo(Map<String, Object> cellData) {
        Object setWay = this.getModel().getValue("setway");
        Object eigen = this.getModel().getValue("eigen");
        Object eigenid = this.getModel().getValue("eigenid");
        Object eigenentry = this.getModel().getValue("eigenentry");
        Object isQuerySet = this.getModel().getValue("isqueryset");
        Object isDefSql = this.getModel().getValue("isdefsql");
        Object isSingle = this.getModel().getValue("issingle");
        Object isDoubles = this.getModel().getValue("isdoubles");
        Object sql = this.getModel().getValue("sql_tag");
        cellData.put("setway", setWay);
        cellData.put("isqueryset", isQuerySet);
        cellData.put("isdefsql", isDefSql);
        cellData.put("issingle", isSingle);
        cellData.put("isdoubles", isDoubles);
        cellData.put("sql_tag", sql);
        cellData.put("eigen", eigen);
        cellData.put("eigenid", eigenid);
        cellData.put("eigenentry", eigenentry);
        DynamicObjectCollection termEntryCol = this.getModel().getEntryEntity("termentry");
        ArrayList termEntryList = new ArrayList(termEntryCol.size());
        for (int i = 0; i < termEntryCol.size(); ++i) {
            DynamicObject entry = (DynamicObject)termEntryCol.get(i);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("field", entry.get("field"));
            map.put("term", entry.get("term"));
            map.put("valuetype", entry.get("valuetype"));
            map.put(VALUE, entry.get(VALUE));
            map.put("linkterm", entry.get("linkterm"));
            map.put("leftterm", entry.get("leftterm"));
            map.put("rightterm", entry.get("rightterm"));
            termEntryList.add(map);
        }
        cellData.put("termentry", termEntryList);
        Object linkInfo = this.getModel().getValue("linkinfo_tag");
        cellData.put("linkinfo_tag", linkInfo);
        Object params = this.getModel().getValue("params_tag");
        cellData.put("params_tag", params);
        Object groupInfo = this.getModel().getValue("groupinfo_tag");
        cellData.put("groupinfo_tag", groupInfo);
        Object orderInfo = this.getModel().getValue("orderinfo_tag");
        cellData.put("orderinfo_tag", orderInfo);
        Object functionInfo = this.getModel().getValue("functioninfo_tag");
        cellData.put("functioninfo_tag", functionInfo);
        Object defSql = this.getModel().getValue("defsql_tag");
        cellData.put("defsql_tag", defSql);
        Object outputInfo = this.getModel().getValue("outputinfo_tag");
        cellData.put("outputinfo_tag", outputInfo);
        Object outputSql = this.getModel().getValue("outputsql_tag");
        cellData.put("outputsql_tag", outputSql);
        Object nameInfo = this.getModel().getValue("nameinfo_tag");
        cellData.put("nameinfo_tag", nameInfo);
        Object descInfo = this.getModel().getValue("descinfo_tag");
        cellData.put("descinfo_tag", descInfo);
    }

    protected void addNode() {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("root");
        Element addElement = root.addElement(MXCELL);
        addElement.addAttribute(ID, this.getUUID()).addAttribute(STYLE, "editable=0;resizable=0;fillColor=#FFFFFF;strokeColor=#979797;arcSize=50;rounded=1;").addAttribute(VALUE, "").addAttribute(VERTEX, "1");
        addElement.addElement(MXGEOMETRY).addAttribute(X, "10").addAttribute(Y, "10").addAttribute("width", "100").addAttribute("height", "40").addAttribute("as", "geometry");
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put(ACTION, ADDXML);
        String xml = doc.asXML();
        paramsMap.put(XML, xml);
        CustomControl control = (CustomControl)this.getView().getControl("cc_mgdesigner");
        control.setData(paramsMap);
    }

    protected String getUUID() {
        return UUID.randomUUID().toString();
    }

    protected void cleanMxgraph() {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put(ACTION, CLEANGRAPH);
        CustomControl control = (CustomControl)this.getView().getControl("cc_mgdesigner");
        control.setData(paramsMap);
    }

    protected void deleteSelectNode() {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put(ACTION, "deleteCells");
        CustomControl control = (CustomControl)this.getView().getControl("cc_mgdesigner");
        control.setData(paramsMap);
    }

    protected void returnData() {
        HashMap<String, String> returnData = new HashMap<String, String>();
        String xml = (String)this.getModel().getValue("xml_tag");
        String cellsdata = (String)this.getModel().getValue("cellsdata_tag");
        returnData.put(XML, xml);
        returnData.put("cellsdata", cellsdata);
        this.checkData(xml, cellsdata);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    protected void checkData(String xml, String cellsdata) {
        if (StringUtils.isNotEmpty((CharSequence)xml) && StringUtils.isNotEmpty((CharSequence)cellsdata)) {
            CalculationTreeNode rootNode = CalculationTreeUtils.getTreeNodeByXml((String)xml);
            Map cellsDataMap = (Map)JSONObject.parse((String)cellsdata);
            Map cellsMap = (Map)cellsDataMap.get(rootNode.getId());
            String type = (String)cellsMap.get(TYPE);
            if (!StringUtils.equals((CharSequence)"A", (CharSequence)type)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9996\u5c42\u5143\u7d20\u7c7b\u578b\u5fc5\u987b\u4e3a\u7b97\u5b50", (String)"EigenValueCalculatePlugin_7", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            this.checkEigenValue(cellsDataMap, rootNode);
        }
    }

    protected void checkEigenValue(Map<String, Map<String, Object>> cellsDataMap, CalculationTreeNode node) {
        if (node == null) {
            return;
        }
        List children = node.getChilds();
        for (int i = 0; i < node.getChilds().size(); ++i) {
            CalculationTreeNode child = (CalculationTreeNode)children.get(i);
            String nodeId = child.getId();
            Map<String, Object> cellsMap = cellsDataMap.get(nodeId);
            if (cellsMap == null) {
                return;
            }
            String type = (String)cellsMap.get(TYPE);
            if (StringUtils.equals((CharSequence)"B", (CharSequence)type)) {
                String setway = (String)cellsMap.get("setway");
                String eigen = (String)cellsMap.get("eigen");
                String output = (String)cellsMap.get("params_tag");
                String param = (String)cellsMap.get("outputinfo_tag");
                String linkinfo = (String)cellsMap.get("linkinfo_tag");
                if (setway == null && eigen == null) {
                    throw new KDBizException(child.getName() + ResManager.loadKDString((String)"\u53c2\u6570\u8bbe\u7f6e\u7279\u5f81\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"EigenValueCalculatePlugin_8", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                }
                if (StringUtils.equals((CharSequence)"eigen", (CharSequence)setway) && StringUtils.isEmpty((CharSequence)eigen)) {
                    throw new KDBizException(child.getName() + ResManager.loadKDString((String)"\u53c2\u6570\u8bbe\u7f6e\u7279\u5f81\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"EigenValueCalculatePlugin_8", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                }
                if (!StringUtils.equals((CharSequence)"def", (CharSequence)setway)) continue;
                if (StringUtils.isEmpty((CharSequence)output)) {
                    throw new KDBizException(child.getName() + ResManager.loadKDString((String)"\u53c2\u6570\u8bbe\u7f6e\u8f93\u51fa\u5217\u4e0d\u80fd\u4e3a\u7a7a", (String)"EigenValueCalculatePlugin_9", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                }
                Set outputset = (Set)SerializationUtils.fromJsonString((String)output, Set.class);
                if (outputset.isEmpty()) {
                    throw new KDBizException(child.getName() + ResManager.loadKDString((String)"\u53c2\u6570\u8bbe\u7f6e\u8f93\u51fa\u5217\u4e0d\u80fd\u4e3a\u7a7a", (String)"EigenValueCalculatePlugin_9", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                }
                if (StringUtils.isEmpty((CharSequence)param)) {
                    throw new KDBizException(child.getName() + ResManager.loadKDString((String)"\u53c2\u6570\u8bbe\u7f6e\u53c2\u6570\u5217\u4e0d\u80fd\u4e3a\u7a7a", (String)"EigenValueCalculatePlugin_10", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                }
                Set paramset = (Set)SerializationUtils.fromJsonString((String)param, Set.class);
                if (paramset.isEmpty()) {
                    throw new KDBizException(child.getName() + ResManager.loadKDString((String)"\u53c2\u6570\u8bbe\u7f6e\u53c2\u6570\u5217\u4e0d\u80fd\u4e3a\u7a7a", (String)"EigenValueCalculatePlugin_10", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                }
                if (!StringUtils.isNotEmpty((CharSequence)linkinfo)) continue;
                TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)linkinfo, TreeNode.class);
                this.checkLinkInfo(root, child.getName());
                continue;
            }
            this.checkEigenValue(cellsDataMap, child);
        }
    }

    private void checkLinkInfo(TreeNode node, String nodeName) {
        String longnumber;
        String parentid = node.getParentid();
        List linkchildren = node.getChildren();
        if (StringUtils.equals((CharSequence)parentid, (CharSequence)"0") || StringUtils.equals((CharSequence)node.getId(), (CharSequence)"0")) {
            for (int i = 0; i < linkchildren.size(); ++i) {
                TreeNode child = (TreeNode)linkchildren.get(i);
                this.checkLinkInfo(child, nodeName);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(longnumber = node.getLongNumber())) && !StringUtils.equals((CharSequence)parentid, (CharSequence)"0")) {
            Map map = (Map)SerializationUtils.fromJsonString((String)longnumber, Map.class);
            String tableentry = (String)map.get("tableentry");
            if (StringUtils.isEmpty((CharSequence)tableentry)) {
                throw new KDBizException(nodeName + ResManager.loadKDString((String)"\u53c2\u6570\u8bbe\u7f6e\u4e2d\u8868", (String)"EigenValueCalculatePlugin_11", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + node.getText() + ResManager.loadKDString((String)"\u8fde\u63a5\u4fe1\u606f\u4e3a\u7a7a", (String)"EigenValueCalculatePlugin_12", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            List tableEntryList = (List)SerializationUtils.fromJsonString((String)tableentry, List.class);
            if (tableEntryList.isEmpty()) {
                throw new KDBizException(nodeName + ResManager.loadKDString((String)"\u53c2\u6570\u8bbe\u7f6e\u4e2d\u8868", (String)"EigenValueCalculatePlugin_11", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + node.getText() + ResManager.loadKDString((String)"\u8fde\u63a5\u4fe1\u606f\u4e3a\u7a7a", (String)"EigenValueCalculatePlugin_12", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
        }
        if (linkchildren == null || linkchildren.isEmpty()) {
            return;
        }
    }

    protected void importCalModel(AfterF7SelectEvent e) throws DocumentException {
        this.saveCellsData();
        ListSelectedRow listSelectedRow = e.getListSelectedRow();
        if (listSelectedRow == null) {
            return;
        }
        Object selectidObj = this.getModel().getValue("selectid");
        if (selectidObj == null || StringUtils.isEmpty((CharSequence)selectidObj.toString())) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u8282\u70b9", (String)"EigenValueCalculatePlugin_13", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        String selectId = selectidObj.toString();
        Long primaryKeyValue = (Long)listSelectedRow.getPrimaryKeyValue();
        DynamicObject f7DyData = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"phm_calculationmodel");
        String f7Xml = f7DyData.getString("xml_tag");
        String f7CellsData = f7DyData.getString("cellsdata_tag");
        if (StringUtils.isEmpty((CharSequence)f7Xml)) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u6240\u9009\u8ba1\u7b97\u6a21\u578b[%s]\u6ca1\u6709\u56fe\u50cf\u4fe1\u606f", (String)"EigenValueCalculatePlugin_14", (String)"mmc-phm-formplugin", (Object[])new Object[0]), f7DyData.get("number")));
            return;
        }
        CalculationTreeNode treeNodeByXml = CalculationTreeUtils.getTreeNodeByXml((String)f7Xml);
        if (treeNodeByXml == null) {
            return;
        }
        Map calculationTreeNodeIdMap = CalculationTreeUtils.getCalculationTreeNodeIdMap(null, (CalculationTreeNode)treeNodeByXml);
        Set ids = calculationTreeNodeIdMap.keySet();
        for (String f7NodeId : ids) {
            String uuid = this.getUUID();
            f7Xml = f7Xml.replace(f7NodeId, uuid);
            f7CellsData = f7CellsData.replace(f7NodeId, uuid);
        }
        treeNodeByXml = CalculationTreeUtils.getTreeNodeByXml((String)f7Xml);
        String rootId = treeNodeByXml.getId();
        Map calculationTreeNodeIdMapAndRelation = CalculationTreeUtils.getCalculationTreeNodeIdMapAndRelation(null, (CalculationTreeNode)treeNodeByXml);
        List nodelist = (List)calculationTreeNodeIdMapAndRelation.get(NODELIST);
        List relations = (List)calculationTreeNodeIdMapAndRelation.get(RELATIONS);
        CustomControl control = (CustomControl)this.getView().getControl("cc_mgdesigner");
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(8);
        paramsMap.put(ACTION, PHM_F7_IMPORT);
        paramsMap.put(ID, selectId);
        paramsMap.put(NODELIST, nodelist);
        paramsMap.put(RELATIONS, relations);
        paramsMap.put(ROOT_ID, rootId);
        control.setData(paramsMap);
        this.addCellsData(f7CellsData, rootId);
        this.getModel().setValue(TYPE, (Object)"A");
    }

    protected void addCellsData(String f7CellsData, String rootId) {
        Map<String, Map<String, Object>> cellsDataMap = null;
        if (f7CellsData != null) {
            Map<String, Map<String, Object>> f7CellsDataMap = this.getCellsDataMap(f7CellsData);
            if (f7CellsDataMap != null && !f7CellsDataMap.isEmpty()) {
                Object cellsdata = this.getModel().getValue("cellsdata_tag");
                cellsDataMap = cellsdata != null ? this.getCellsDataMap(cellsdata.toString()) : new HashMap<String, Map<String, Object>>(4);
                for (Map.Entry<String, Map<String, Object>> cellMap : f7CellsDataMap.entrySet()) {
                    String key = cellMap.getKey();
                    if (StringUtils.equals((CharSequence)key, (CharSequence)rootId)) continue;
                    Map<String, Object> value = cellMap.getValue();
                    cellsDataMap.put(key, value);
                }
            }
            if (cellsDataMap != null && !cellsDataMap.isEmpty()) {
                String jsonString = JSONObject.toJSONString((Object)cellsDataMap);
                this.getModel().setValue("cellsdata_tag", (Object)jsonString);
            }
        }
    }

    protected Map<String, Map<String, Object>> getCellsDataMap(String cellsStr) {
        if (StringUtils.isEmpty((CharSequence)cellsStr)) {
            return new HashMap<String, Map<String, Object>>();
        }
        return (Map)JSONObject.parse((String)cellsStr);
    }

    protected boolean isApproveCheck() {
        String setway = (String)this.getModel().getValue("setway");
        if ("eigen".equals(setway)) {
            return true;
        }
        boolean isQuerySet = (Boolean)this.getModel().getValue("isqueryset");
        if (isQuerySet) {
            return true;
        }
        String sql = (String)this.getModel().getValue("sql_tag");
        return !StringUtils.isEmpty((CharSequence)sql);
    }

    protected void queryTest() {
        block7: {
            try {
                String paramSql = this.generateSQL(true);
                String outputSql = this.generateSQL(false);
                if (StringUtils.isEmpty((CharSequence)paramSql)) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    String valuetype = "cal";
                    String componentid = this.getUUID();
                    String storevalue_tag = (String)this.getModel().getValue("xml_tag");
                    String value_tag = (String)this.getModel().getValue("cellsdata_tag");
                    map.put("valuetype", valuetype);
                    map.put("componentid", componentid);
                    map.put("storevalue_tag", storevalue_tag);
                    map.put("value_tag", value_tag);
                    this.checkData(storevalue_tag, value_tag);
                    String result = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"testFeatureQueryDefine", (Object[])new Object[]{map});
                    if (StringUtils.isEmpty((CharSequence)result)) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u67e5\u8be2\u6d4b\u8bd5\u6210\u529f", (String)"EigenValueCalculatePlugin_15", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                        break block7;
                    }
                    throw new KDBizException(result);
                }
                try {
                    String dbkey = "PHM";
                    TreeNode root = this.getRootNode();
                    TreeNode mainTableNode = (TreeNode)root.getChildren().get(0);
                    if (mainTableNode.getText().contains("@")) {
                        dbkey = mainTableNode.getText().split("@")[1].split(" ")[0];
                    }
                    DBRoute dbRoute = DBRoute.of((String)dbkey);
                    this.executeQuery(dbRoute, paramSql);
                }
                catch (Exception e) {
                    throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u6267\u884cSQL\u5931\u8d25\uff1a%s", (String)"EigenValueCalculatePlugin_16", (String)"mmc-phm-formplugin", (Object[])new Object[0])), new Object[]{e.getMessage()});
                }
                this.getModel().setValue("sql_tag", (Object)paramSql);
                this.getModel().setValue("outputsql_tag", (Object)outputSql);
                this.getView().showMessage(ResManager.loadKDString((String)"\u67e5\u8be2\u6d4b\u8bd5\u6210\u529f", (String)"EigenValueCalculatePlugin_15", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                this.getModel().setValue("sql_tag", (Object)"");
                this.getModel().setValue("outputsql_tag", (Object)"");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u6d4b\u8bd5\u672a\u901a\u8fc7\uff1a", (String)"EigenValueCalculatePlugin_17", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + e.getMessage());
            }
        }
    }

    protected void executeQuery(DBRoute dbRoute, String sql) {
        ArrayList<Column> columnList = new ArrayList<Column>();
        this.getData(dbRoute, sql, columnList);
    }

    protected List<List<Object>> getData(DBRoute dbRoute, String sql, final List<Column> columnList) {
        List rs = null;
        try {
            rs = (List)DB.query((DBRoute)dbRoute, (String)sql, (ResultSetHandler)new ResultSetHandler<List<List<Object>>>(){

                public List<List<Object>> handle(ResultSet rs) throws Exception {
                    int i;
                    ArrayList<List<Object>> data = new ArrayList<List<Object>>(rs.getRow());
                    ResultSetMetaData meta = rs.getMetaData();
                    int columnNumber = meta.getColumnCount();
                    for (i = 1; i <= columnNumber; ++i) {
                        Column column = new Column();
                        column.setName(meta.getColumnName(i));
                        column.setcType(meta.getColumnType(i));
                        columnList.add(column);
                    }
                    i = 0;
                    while (rs.next()) {
                        ArrayList<Object> row = new ArrayList<Object>();
                        int index = ++i;
                        row.add(index);
                        row.add(index);
                        for (int n = 1; n <= columnNumber; ++n) {
                            row.add(rs.getObject(n) == null ? "" : rs.getObject(n).toString());
                        }
                        data.add(row);
                    }
                    return data;
                }
            });
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1a%s", (String)"EigenValueCalculatePlugin_18", (String)"mmc-phm-formplugin", (Object[])new Object[0])), new Object[]{ex.getMessage()});
        }
        return rs;
    }

    protected String generateSQL(boolean isParamSQL) {
        StringBuilder sql = new StringBuilder();
        boolean isQuerySet = (Boolean)this.getModel().getValue("isqueryset");
        if (isQuerySet) {
            this.constractFieldSQL(sql, isParamSQL);
        } else {
            this.constractSQLByDef(sql, isParamSQL);
        }
        return sql.toString();
    }

    protected void constractSQLByDef(StringBuilder sql, boolean isParamSQL) {
        this.constractParamsSQL(sql, isParamSQL);
        this.constractFromSQL(sql);
        CodeEdit sqlEditor = (CodeEdit)this.getView().getControl("sqlarea");
        String termSql = sqlEditor.getText();
        if (!termSql.startsWith("where")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u80fd\u591f\u81ea\u5b9a\u4e49SQL\u6761\u4ef6\u8bed\u53e5(\u4ee5where\u5f00\u59cb)", (String)"EigenValueCalculatePlugin_19", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
        sql.append(termSql).append('\n');
        this.getModel().setValue("defsql_tag", (Object)sqlEditor.getText());
        this.constractGroupSQL(sql);
        this.constractOrderSQL(sql);
    }

    protected void constractFieldSQL(StringBuilder sql, boolean isParamSQL) {
        this.constractParamsSQL(sql, isParamSQL);
        this.constractFromSQL(sql);
        this.constractTermSQL(sql);
        this.constractGroupSQL(sql);
        this.constractOrderSQL(sql);
    }

    protected void constractParamsSQL(StringBuilder sql, boolean isParamSQL) {
        Set paramsSet;
        sql.append("select \n");
        String params = "";
        if (isParamSQL) {
            params = (String)this.getModel().getValue("params_tag");
            if (StringUtils.isEmpty((CharSequence)params)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u4e2a\u8f93\u51fa\u5217", (String)"EigenValueCalculatePlugin_20", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
        } else {
            params = (String)this.getModel().getValue("outputinfo_tag");
            if (StringUtils.isEmpty((CharSequence)params)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u4e2a\u53c2\u6570\u5bf9\u8c61", (String)"EigenValueCalculatePlugin_21", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
        }
        if ((paramsSet = (Set)SerializationUtils.fromJsonString((String)params, Set.class)).isEmpty() && isParamSQL) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u4e2a\u8f93\u51fa\u5217", (String)"EigenValueCalculatePlugin_20", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
        if (paramsSet.isEmpty() && !isParamSQL) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u4e2a\u53c2\u6570\u5bf9\u8c61", (String)"EigenValueCalculatePlugin_21", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
        ArrayList paramsList = new ArrayList(paramsSet);
        String functionInfo = (String)this.getModel().getValue("functioninfo_tag");
        Map functionMap = new HashMap();
        if (StringUtils.isNotEmpty((CharSequence)functionInfo)) {
            functionMap = (Map)SerializationUtils.fromJsonString((String)functionInfo, Map.class);
        }
        String nameInfo = (String)this.getModel().getValue("nameinfo_tag");
        Map nameMap = new HashMap();
        if (StringUtils.isNotEmpty((CharSequence)nameInfo)) {
            nameMap = (Map)SerializationUtils.fromJsonString((String)nameInfo, Map.class);
        }
        String otherName = "";
        for (int i = 0; i < paramsList.size(); ++i) {
            String param = (String)paramsList.get(i);
            otherName = (String)nameMap.get(param);
            String function = (String)functionMap.get(param);
            if (function != null) {
                if (i == paramsList.size() - 1) {
                    sql.append(function).append('(').append(param).append(')').append('\n');
                    if (otherName == null) continue;
                    sql.append(otherName).append('\n');
                    continue;
                }
                sql.append(function).append('(').append(param).append(')').append('\n');
                if (otherName != null) {
                    sql.append(otherName).append(',').append('\n');
                    continue;
                }
                sql.append(',').append('\n');
                continue;
            }
            if (i == paramsList.size() - 1) {
                sql.append(param).append('\n');
                if (otherName == null) continue;
                sql.append(otherName).append('\n');
                continue;
            }
            sql.append(param).append('\n');
            if (otherName != null) {
                sql.append(otherName).append(',').append('\n');
                continue;
            }
            sql.append(',').append('\n');
        }
    }

    protected void constractFromSQL(StringBuilder sql) {
        TreeNode root = this.getRootNode();
        TreeNode mainTableNode = (TreeNode)root.getChildren().get(0);
        sql.append("from").append('\n');
        String mainTableText = this.splitAtWithTable(mainTableNode.getText());
        sql.append(mainTableText).append('\n');
        this.linkTreeToTableSQL(mainTableNode, sql);
    }

    protected String splitAtWithTable(String tableText) {
        if (tableText.contains("@")) {
            String[] atStr = tableText.split("@");
            tableText = atStr[0] + " " + atStr[1].split(" ")[1];
        }
        return tableText;
    }

    protected void constractTermSQL(StringBuilder sql) {
        DynamicObjectCollection termEntrys = this.getModel().getEntryEntity("termentry");
        if (termEntrys.isEmpty()) {
            return;
        }
        sql.append("where 1=1 ").append('\n');
        String allLeftTerm = "";
        String allRightTerm = "";
        for (int i = 0; i < termEntrys.size(); ++i) {
            if (i == 0) {
                sql.append(" and ");
            }
            DynamicObject termEntry = (DynamicObject)termEntrys.get(i);
            String field = termEntry.getString("field");
            String term = termEntry.getString("term");
            String value = termEntry.getString(VALUE);
            String linkterm = termEntry.getString("linkterm");
            String valuetype = termEntry.getString("valuetype");
            String leftterm = termEntry.getString("leftterm");
            String rightterm = termEntry.getString("rightterm");
            if (i == termEntrys.size() - 1 && StringUtils.isNotEmpty((CharSequence)linkterm)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6761\u4ef6\u8bbe\u7f6e\u6700\u540e\u4e00\u884c\u7684\u8fde\u63a5\u6761\u4ef6\u5fc5\u987b\u4e3a\u7a7a", (String)"EigenValueCalculatePlugin_22", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((CharSequence)linkterm) && i != termEntrys.size() - 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6761\u4ef6\u8bbe\u7f6e\u7b2c", (String)"EigenValueCalculatePlugin_23", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + (i + 1) + ResManager.loadKDString((String)"\u884c\u8fde\u63a5\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (String)"EigenValueCalculatePlugin_24", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((CharSequence)field)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6761\u4ef6\u8bbe\u7f6e\u7b2c", (String)"EigenValueCalculatePlugin_23", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + (i + 1) + ResManager.loadKDString((String)"\u884c\u5b57\u6bb5\u4e3a\u7a7a", (String)"EigenValueCalculatePlugin_25", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((CharSequence)term)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6761\u4ef6\u8bbe\u7f6e\u7b2c", (String)"EigenValueCalculatePlugin_23", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + (i + 1) + ResManager.loadKDString((String)"\u884c\u6761\u4ef6\u4e3a\u7a7a", (String)"EigenValueCalculatePlugin_26", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            if (!StringUtils.equals((CharSequence)TermEnums.NULL.getValue(), (CharSequence)term) && !StringUtils.equals((CharSequence)TermEnums.NOTNULL.getValue(), (CharSequence)term) && StringUtils.isEmpty((CharSequence)value)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6761\u4ef6\u8bbe\u7f6e\u7b2c", (String)"EigenValueCalculatePlugin_23", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + (i + 1) + ResManager.loadKDString((String)"\u884c\u503c\u4e3a\u7a7a", (String)"EigenValueCalculatePlugin_27", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            if (linkterm == null) {
                linkterm = "";
            }
            leftterm = this.dealLeftTerm(leftterm);
            rightterm = this.dealRightTerm(rightterm);
            allLeftTerm = allLeftTerm + leftterm;
            allRightTerm = allRightTerm + rightterm;
            if (VALUE.equals(valuetype)) {
                if (StringUtils.equals((CharSequence)TermEnums.LIKE.getValue(), (CharSequence)term)) {
                    sql.append(leftterm).append(field).append('\n').append(this.conversionTerm(term)).append('\n').append('\'').append('%').append(value).append('%').append('\'').append('\n').append(rightterm).append(linkterm).append('\n');
                    continue;
                }
                if (StringUtils.equals((CharSequence)TermEnums.NULL.getValue(), (CharSequence)term) || StringUtils.equals((CharSequence)TermEnums.NOTNULL.getValue(), (CharSequence)term)) {
                    sql.append(leftterm).append(field).append('\n').append(this.conversionTerm(term)).append('\n').append(rightterm).append(linkterm).append('\n');
                    continue;
                }
                sql.append(leftterm).append(field).append('\n').append(this.conversionTerm(term)).append('\n').append('\'').append(value).append('\'').append('\n').append(rightterm).append(linkterm).append('\n');
                continue;
            }
            if (StringUtils.equals((CharSequence)TermEnums.LIKE.getValue(), (CharSequence)term)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6761\u4ef6\u8bbe\u7f6e\u4e2d\u6a21\u7cca\u5339\u914d\u65f6\u503c\u7c7b\u578b\u5fc5\u987b\u4e3a\u503c", (String)"EigenValueCalculatePlugin_28", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.equals((CharSequence)TermEnums.NULL.getValue(), (CharSequence)term) || StringUtils.equals((CharSequence)TermEnums.NOTNULL.getValue(), (CharSequence)term)) {
                sql.append(leftterm).append(field).append('\n').append(this.conversionTerm(term)).append('\n').append(rightterm).append(linkterm).append('\n');
                continue;
            }
            sql.append(leftterm).append(field).append('\n').append(this.conversionTerm(term)).append('\n').append(value).append('\n').append(rightterm).append(linkterm).append('\n');
        }
        if (allLeftTerm.trim().length() != allRightTerm.trim().length()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5de6\u62ec\u53f7\u548c\u53f3\u62ec\u53f7\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u6761\u4ef6\u8bbe\u7f6e", (String)"EigenValueCalculatePlugin_29", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
    }

    protected void constractGroupSQL(StringBuilder sql) {
        String groupInfo = (String)this.getModel().getValue("groupinfo_tag");
        if (StringUtils.isEmpty((CharSequence)groupInfo)) {
            return;
        }
        Map groupMap = (Map)SerializationUtils.fromJsonString((String)groupInfo, Map.class);
        if (groupMap.isEmpty()) {
            return;
        }
        sql.append("group by").append('\n');
        Comparator<Map.Entry<String, Integer>> comparator = new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return o1.getValue() - o2.getValue();
            }
        };
        ArrayList list = new ArrayList(groupMap.entrySet());
        Collections.sort(list, comparator);
        for (int i = 0; i < list.size(); ++i) {
            Map.Entry entry = (Map.Entry)list.get(i);
            String groupField = (String)entry.getKey();
            int groupLevel = (Integer)entry.getValue();
            if (groupLevel == 0) {
                throw new KDBizException(groupField + ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u5206\u7ec4\u7ea7\u522b\u4e0d\u80fd\u4e3a\u7a7a", (String)"EigenValueCalculatePlugin_30", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            if (i == list.size() - 1) {
                sql.append(groupField).append('\n');
                continue;
            }
            sql.append(groupField).append(',').append('\n');
        }
    }

    protected void constractOrderSQL(StringBuilder sql) {
        String orderInfo = (String)this.getModel().getValue("orderinfo_tag");
        if (StringUtils.isEmpty((CharSequence)orderInfo)) {
            return;
        }
        Map orderMap = (Map)SerializationUtils.fromJsonString((String)orderInfo, Map.class);
        if (orderMap.isEmpty()) {
            return;
        }
        sql.append("order by").append('\n');
        Comparator<Map.Entry<String, Integer>> comparator = new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return o1.getValue() - o2.getValue();
            }
        };
        ArrayList list = new ArrayList(orderMap.entrySet());
        Collections.sort(list, comparator);
        for (int i = 0; i < list.size(); ++i) {
            Map.Entry entry = (Map.Entry)list.get(i);
            String orderField = (String)entry.getKey();
            int orderLevel = (Integer)entry.getValue();
            if (orderLevel == 0) {
                throw new KDBizException(orderField + ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u6392\u5e8f\u7ea7\u522b\u4e0d\u80fd\u4e3a\u7a7a", (String)"EigenValueCalculatePlugin_31", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            if (i == list.size() - 1) {
                sql.append(orderField).append('\n');
                continue;
            }
            sql.append(orderField).append(',').append('\n');
        }
    }

    protected void linkTreeToTableSQL(TreeNode treeNode, StringBuilder sql) {
        List children = treeNode.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        List tableEntryList = new ArrayList();
        for (int i = 0; i < children.size(); ++i) {
            tableEntryList.clear();
            TreeNode child = (TreeNode)children.get(i);
            String infoStr = child.getLongNumber();
            Map map = (Map)SerializationUtils.fromJsonString((String)infoStr, Map.class);
            String tableEntryListStr = (String)map.get("tableentry");
            if (!StringUtils.isNotEmpty((CharSequence)tableEntryListStr)) {
                throw new KDBizException(treeNode.getText() + ResManager.loadKDString((String)"\u4e0e", (String)"EigenValueCalculatePlugin_32", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + child.getText() + ResManager.loadKDString((String)"\u8fde\u63a5\u5173\u7cfb\u4e3a\u7a7a", (String)"EigenValueCalculatePlugin_33", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            tableEntryList = (List)SerializationUtils.fromJsonString((String)tableEntryListStr, List.class);
            String linkType = (String)map.get("linktype");
            String childText = this.splitAtWithTable(child.getText());
            sql.append(this.conversionLinkType(linkType)).append('\n').append(childText).append('\n').append("on");
            int conditionCounts = 0;
            for (Map entry : tableEntryList) {
                String mainfield = (String)entry.get("mainfield");
                String linkfield = (String)entry.get("linkfield");
                String condition = (String)entry.get("condition");
                if (condition == null) {
                    condition = "";
                }
                if (conditionCounts > 0) {
                    condition = "and";
                }
                sql.append(condition).append('\n').append(mainfield).append('\n').append('=').append('\n').append(linkfield).append('\n');
                ++conditionCounts;
            }
            this.linkTreeToTableSQL(child, sql);
        }
    }

    protected String dealLeftTerm(String leftterm) {
        if ("1".equals(leftterm)) {
            return "(";
        }
        if ("2".equals(leftterm)) {
            return "((";
        }
        if ("3".equals(leftterm)) {
            return "(((";
        }
        return "";
    }

    protected String dealRightTerm(String rightterm) {
        if ("-1".equals(rightterm)) {
            return ")";
        }
        if ("-2".equals(rightterm)) {
            return "))";
        }
        if ("-3".equals(rightterm)) {
            return ")))";
        }
        return "";
    }

    protected String conversionLinkType(String linktype) {
        HashMap<String, String> linkTypeMap = new HashMap<String, String>();
        linkTypeMap.put("left", "left join");
        linkTypeMap.put("right", "right join");
        linkTypeMap.put("inner", "inner join");
        return (String)linkTypeMap.get(linktype);
    }

    protected String conversionTerm(String term) {
        HashMap<String, String> termMap = new HashMap<String, String>();
        termMap.put(TermEnums.GT.getValue(), ">");
        termMap.put(TermEnums.LT.getValue(), "<");
        termMap.put(TermEnums.EQU.getValue(), "=");
        termMap.put(TermEnums.NEQ.getValue(), "!=");
        termMap.put(TermEnums.LE.getValue(), "<=");
        termMap.put(TermEnums.GE.getValue(), ">=");
        termMap.put(TermEnums.NULL.getValue(), "is null");
        termMap.put(TermEnums.NOTNULL.getValue(), "is not null");
        termMap.put(TermEnums.LIKE.getValue(), "like");
        return (String)termMap.get(term);
    }

    protected void setEigenValue(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        this.getModel().setValue("eigen", returnData.get("eigen"));
        this.getModel().setValue("eigenid", returnData.get("eigenid"));
        this.getModel().setValue("eigenentry", returnData.get("eigenentry"));
    }

    protected void fillFieldsEntry(TreeNode selectNode) {
        String infoStr = selectNode.getLongNumber();
        Map infoMap = (Map)SerializationUtils.fromJsonString((String)infoStr, Map.class);
        String tableName = (String)infoMap.get("othername");
        String tableId = (String)infoMap.get("table");
        String source = (String)infoMap.get(SOURCE);
        if (StringUtils.isEmpty((CharSequence)source)) {
            source = "phm_datatable";
        }
        DynamicObject dataTable = null;
        DynamicObjectCollection entryCol = null;
        if (StringUtils.equals((CharSequence)"phm_datatable", (CharSequence)source)) {
            dataTable = BusinessDataServiceHelper.loadSingle((Object)tableId, (String)"phm_datatable");
            entryCol = dataTable.getDynamicObjectCollection("entryentity");
        } else {
            dataTable = BusinessDataServiceHelper.loadSingle((Object)tableId, (String)"isc_metadata_schema");
            entryCol = dataTable.getDynamicObjectCollection("prop_entryentity");
        }
        TableValueSetter fieldEntryVs = new TableValueSetter(new String[]{"seq", "fieldname", "fieldtype", "isparam", "maintable", "isgroup", "level", "isorder", "orderlevel", "function", "outputcol", "namefield", "sortway"});
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        String params = (String)this.getModel().getValue("params_tag");
        Set paramsSet = new HashSet();
        if (StringUtils.isNotEmpty((CharSequence)params)) {
            paramsSet = (Set)SerializationUtils.fromJsonString((String)params, Set.class);
        }
        String groupInfo = (String)this.getModel().getValue("groupinfo_tag");
        Map groupMap = new HashMap();
        if (StringUtils.isNotEmpty((CharSequence)groupInfo)) {
            groupMap = (Map)SerializationUtils.fromJsonString((String)groupInfo, Map.class);
        }
        String orderInfo = (String)this.getModel().getValue("orderinfo_tag");
        Map orderMap = new HashMap();
        if (StringUtils.isNotEmpty((CharSequence)orderInfo)) {
            orderMap = (Map)SerializationUtils.fromJsonString((String)orderInfo, Map.class);
        }
        String functionInfo = (String)this.getModel().getValue("functioninfo_tag");
        Map functionMap = new HashMap();
        if (StringUtils.isNotEmpty((CharSequence)functionInfo)) {
            functionMap = (Map)SerializationUtils.fromJsonString((String)functionInfo, Map.class);
        }
        String outputInfo = (String)this.getModel().getValue("outputinfo_tag");
        Set outputSet = new HashSet();
        if (StringUtils.isNotEmpty((CharSequence)outputInfo)) {
            outputSet = (Set)SerializationUtils.fromJsonString((String)outputInfo, Set.class);
        }
        String nameInfo = (String)this.getModel().getValue("nameinfo_tag");
        Map<String, String> nameMap = new HashMap(18);
        if (StringUtils.isNotEmpty((CharSequence)nameInfo)) {
            nameMap = (Map)SerializationUtils.fromJsonString((String)nameInfo, Map.class);
        }
        String descInfo = (String)this.getModel().getValue("descinfo_tag");
        Set descSet = new HashSet();
        if (StringUtils.isNotEmpty((CharSequence)descInfo)) {
            descSet = (Set)SerializationUtils.fromJsonString((String)descInfo, Set.class);
        }
        model.beginInit();
        for (int i = 0; i < entryCol.size(); ++i) {
            String nameField;
            String function;
            DynamicObject entry = (DynamicObject)entryCol.get(i);
            String maintable = dataTable.getString("number");
            String fieldName = "";
            fieldName = StringUtils.equals((CharSequence)"phm_datatable", (CharSequence)source) ? entry.getString("fieldname") : entry.getString("prop_name");
            fieldName = tableName + "." + fieldName;
            String fieldType = "";
            fieldType = StringUtils.equals((CharSequence)"phm_datatable", (CharSequence)source) ? entry.getString("fieldtype") : entry.getString("data_type");
            boolean isParam = false;
            if (paramsSet.contains(fieldName)) {
                isParam = true;
            }
            boolean isGroup = false;
            int groupLevel = 0;
            Object groupField = groupMap.get(fieldName);
            if (groupField != null) {
                isGroup = true;
                groupLevel = (Integer)groupMap.get(fieldName);
            }
            boolean isOrder = false;
            int orderLevel = 0;
            Object orderField = orderMap.get(fieldName);
            if (orderField != null) {
                isOrder = true;
                orderLevel = (Integer)orderMap.get(fieldName);
            }
            if ((function = (String)functionMap.get(fieldName)) == null) {
                function = "";
            }
            boolean isOutputCol = false;
            if (outputSet.contains(fieldName)) {
                isOutputCol = true;
            }
            if ((nameField = (String)nameMap.get(fieldName)) == null) {
                nameField = StringUtils.equals((CharSequence)"phm_datatable", (CharSequence)source) ? entry.getString("fielddescription") : entry.getString("prop_label");
            }
            if (StringUtils.isEmpty((CharSequence)nameField)) {
                nameField = StringUtils.equals((CharSequence)"phm_datatable", (CharSequence)source) ? entry.getString("fieldname") : entry.getString("prop_name");
            }
            nameMap.put(fieldName, nameField);
            String sortWay = "asc";
            if (descSet.contains(fieldName)) {
                sortWay = "desc";
            }
            fieldEntryVs.addRow(new Object[]{i, fieldName, fieldType, isParam, maintable, isGroup, groupLevel, isOrder, orderLevel, function, isOutputCol, nameField, sortWay});
        }
        model.deleteEntryData("fieldentry");
        model.batchCreateNewEntryRow("fieldentry", fieldEntryVs);
        model.endInit();
        this.getModel().setValue("nameinfo_tag", (Object)SerializationUtils.toJsonString(nameMap));
        this.getView().updateView("fieldentry");
    }

    protected void fillTableEntry(TreeNode selectNode) {
        String infos = selectNode.getLongNumber();
        Map map = (Map)SerializationUtils.fromJsonString((String)infos, Map.class);
        String sourcetable = (String)map.get("sourcetable");
        String linktable = (String)map.get("tablename");
        String linktype = (String)map.get("linktype");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter linkEntryVs = new TableValueSetter(new String[]{"seq", "sourcetable", "linktable", "linktype"});
        linkEntryVs.addRow(new Object[]{0, sourcetable, linktable, linktype});
        model.deleteEntryData("linkentry");
        model.batchCreateNewEntryRow("linkentry", linkEntryVs);
        this.getView().updateView("linkentry");
        model.deleteEntryData("tableentry");
        if (map.containsKey("tableentry")) {
            TableValueSetter tableEntryVs = this.constractTableEntry(map);
            model.batchCreateNewEntryRow("tableentry", tableEntryVs);
        }
        this.getView().updateView("tableentry");
        model.endInit();
    }

    protected void showEigenValueForm() {
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)PHM_EIGENVALUE_F7, (boolean)false);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, PHM_EIGENVALUE_F7);
        Object pkValue = this.getView().getParentView().getModel().getDataEntity().getPkValue();
        QFilter qfilter = new QFilter(ID, "!=", pkValue);
        qfilter = qfilter.and(new QFilter("status", "=", (Object)"C"));
        qfilter = qfilter.and(new QFilter("enable", "=", (Object)"1"));
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getListFilterParameter().getQFilters().add(qfilter);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("calmodel", "1");
        map.put("ismergerows", Boolean.FALSE);
        showParameter.setCustomParams(map);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    protected void showMainFieldForm() {
        FormShowParameter showParameter = new FormShowParameter();
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "mainfield");
        showParameter.setFormId("phm_eigencal_field");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(callBack);
        TreeView treeView = this.getLinkTree();
        List selectIds = treeView.getTreeState().getSelectedNodeId();
        String selectId = (String)selectIds.get(0);
        TreeNode treeNode = this.getNodeInfosById(this.getRootNode(), selectId);
        String infos = treeNode.getLongNumber();
        Map map = (Map)SerializationUtils.fromJsonString((String)infos, Map.class);
        String tableId = (String)map.get("table");
        String otherName = (String)map.get("othername");
        String source = (String)map.get(SOURCE);
        if (StringUtils.isEmpty((CharSequence)source)) {
            source = "phm_datatable";
        }
        DynamicObject dataTable = null;
        DynamicObjectCollection entryCol = null;
        if (StringUtils.equals((CharSequence)"phm_datatable", (CharSequence)source)) {
            dataTable = BusinessDataServiceHelper.loadSingle((Object)tableId, (String)"phm_datatable");
            entryCol = dataTable.getDynamicObjectCollection("entryentity");
        } else {
            dataTable = BusinessDataServiceHelper.loadSingle((Object)tableId, (String)"isc_metadata_schema");
            entryCol = dataTable.getDynamicObjectCollection("prop_entryentity");
        }
        ArrayList<String> fieldsList = new ArrayList<String>();
        HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
        for (DynamicObject entry : entryCol) {
            String fieldName = "";
            fieldName = StringUtils.equals((CharSequence)"phm_datatable", (CharSequence)source) ? entry.getString("fieldname") : entry.getString("prop_name");
            fieldName = otherName + "." + fieldName;
            fieldsList.add(fieldName);
        }
        params.put("mainfield", fieldsList);
        showParameter.setCustomParams(params);
        this.getView().showForm(showParameter);
    }

    protected void showLinkFieldForm() {
        FormShowParameter showParameter = new FormShowParameter();
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "linkfield");
        showParameter.setFormId("phm_eigencal_field");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(callBack);
        TreeView treeView = this.getLinkTree();
        List selectIds = treeView.getTreeState().getSelectedNodeId();
        String selectId = (String)selectIds.get(0);
        TreeNode treeNode = this.getNodeInfosById(this.getRootNode(), selectId);
        String infos = treeNode.getLongNumber();
        String parentId = treeNode.getParentid();
        TreeNode parentNode = this.getNodeInfosById(this.getRootNode(), parentId);
        Map parentMap = (Map)SerializationUtils.fromJsonString((String)parentNode.getLongNumber(), Map.class);
        Map map = (Map)SerializationUtils.fromJsonString((String)infos, Map.class);
        String sourceTableId = (String)map.get("sourcetableid");
        String sourceTableName = (String)parentMap.get("othername");
        HashMap params = new HashMap();
        ArrayList<String> fieldsList = new ArrayList<String>();
        String source = (String)parentMap.get(SOURCE);
        if (StringUtils.isEmpty((CharSequence)source)) {
            source = "phm_datatable";
        }
        DynamicObject dataTable = null;
        DynamicObjectCollection entryCol = null;
        if (StringUtils.equals((CharSequence)"phm_datatable", (CharSequence)source)) {
            dataTable = BusinessDataServiceHelper.loadSingle((Object)sourceTableId, (String)"phm_datatable");
            entryCol = dataTable.getDynamicObjectCollection("entryentity");
        } else {
            dataTable = BusinessDataServiceHelper.loadSingle((Object)sourceTableId, (String)"isc_metadata_schema");
            entryCol = dataTable.getDynamicObjectCollection("prop_entryentity");
        }
        for (DynamicObject entry : entryCol) {
            String fieldName = "";
            fieldName = StringUtils.equals((CharSequence)"phm_datatable", (CharSequence)source) ? entry.getString("fieldname") : entry.getString("prop_name");
            fieldName = sourceTableName + "." + fieldName;
            fieldsList.add(fieldName);
        }
        params.put("linkfield", fieldsList);
        showParameter.setCustomParams(params);
        this.getView().showForm(showParameter);
    }

    protected void showFieldForm() {
        FormShowParameter showParameter = new FormShowParameter();
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "field");
        showParameter.setFormId("phm_eigencal_field");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(callBack);
        TreeNode root = this.getRootNode();
        Map<String, String> map = new HashMap<String, String>();
        HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
        ArrayList<String> fieldsList = new ArrayList<String>();
        map = this.getIdAndOtherName(root, map);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.constractFieldList(entry.getKey(), entry.getValue(), fieldsList);
        }
        params.put("field", fieldsList);
        showParameter.setCustomParams(params);
        this.getView().showForm(showParameter);
    }

    protected void showValueForm() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("termentry");
        String valueType = (String)this.getModel().getValue("valuetype", rowIndex);
        if (StringUtils.isEmpty((CharSequence)valueType) || StringUtils.equals((CharSequence)valueType, (CharSequence)VALUE)) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, VALUE);
        showParameter.setFormId("phm_eigencal_field");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(callBack);
        TreeNode root = this.getRootNode();
        Map<String, String> map = new HashMap<String, String>();
        HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
        ArrayList<String> fieldsList = new ArrayList<String>();
        map = this.getIdAndOtherName(root, map);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.constractFieldList(entry.getKey(), entry.getValue(), fieldsList);
        }
        params.put(VALUE, fieldsList);
        showParameter.setCustomParams(params);
        this.getView().showForm(showParameter);
    }

    protected void setMainField(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        EntryGrid tableEntry = (EntryGrid)this.getView().getControl("tableentry");
        int[] selectRows = tableEntry.getSelectRows();
        if (selectRows.length == 0) {
            return;
        }
        int rowIndex = selectRows[0];
        String mainField = (String)returnData.get("mainfield");
        this.getModel().setValue("mainfield", (Object)mainField, rowIndex);
    }

    protected void setLinkField(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        EntryGrid tableEntry = (EntryGrid)this.getView().getControl("tableentry");
        int[] selectRows = tableEntry.getSelectRows();
        if (selectRows.length == 0) {
            return;
        }
        int rowIndex = selectRows[0];
        String linkField = (String)returnData.get("linkfield");
        this.getModel().setValue("linkfield", (Object)linkField, rowIndex);
    }

    protected void setField(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        EntryGrid termEntry = (EntryGrid)this.getView().getControl("termentry");
        int[] selectRows = termEntry.getSelectRows();
        if (selectRows.length == 0) {
            return;
        }
        int rowIndex = selectRows[0];
        String field = (String)returnData.get("field");
        this.getModel().setValue("field", (Object)field, rowIndex);
    }

    protected void setValue(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        EntryGrid termEntry = (EntryGrid)this.getView().getControl("termentry");
        int[] selectRows = termEntry.getSelectRows();
        if (selectRows.length == 0) {
            return;
        }
        int rowIndex = selectRows[0];
        String value = (String)returnData.get(VALUE);
        this.getModel().setValue(VALUE, (Object)value, rowIndex);
    }

    protected void rootCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        String tablename = (String)returnData.get("tablename");
        String othername = (String)returnData.get("othername");
        TreeNode root = this.getRootNode();
        TreeNode treeNode = new TreeNode();
        treeNode.setParentid(root.getId());
        treeNode.setId(this.getUUID());
        treeNode.addChildren(new ArrayList());
        treeNode.setText(tablename + " " + othername);
        treeNode.setLongNumber(SerializationUtils.toJsonString((Object)returnData));
        root.addChild(treeNode);
        root.setIsOpened(true);
        this.getPageCache().put("root", SerializationUtils.toJsonString((Object)root));
        TreeView linkTree = this.getLinkTree();
        linkTree.addNode(treeNode);
        linkTree.expand(treeNode.getId());
        linkTree.focusNode(treeNode);
        this.fillFieldsEntry(treeNode);
        this.fillTableEntry(treeNode);
        this.getView().updateView("linktree");
        String str = SerializationUtils.toJsonString((Object)root);
        this.getModel().setValue("linkinfo_tag", (Object)str);
    }

    protected void otherCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        String tablename = (String)returnData.get("tablename");
        String othername = (String)returnData.get("othername");
        TreeView linkTree = this.getLinkTree();
        Map selectNode = (Map)linkTree.getTreeState().getSelectedNodes().get(0);
        TreeNode child = new TreeNode();
        child.setParentid((String)selectNode.get(ID));
        child.setId(this.getUUID());
        child.setText(tablename + " " + othername);
        child.setLongNumber(SerializationUtils.toJsonString((Object)returnData));
        child.addChildren(new ArrayList());
        child.setIsOpened(true);
        linkTree.addNode(child);
        TreeNode root = this.getRootNode();
        TreeNode selectTreeNode = this.getNodeInfosById(root, (String)selectNode.get(ID));
        selectTreeNode.addChild(child);
        linkTree.expand(child.getId());
        linkTree.focusNode(child);
        this.fillFieldsEntry(child);
        this.fillTableEntry(child);
        this.getPageCache().put("root", SerializationUtils.toJsonString((Object)root));
        this.getView().updateView("linktree");
        String str = SerializationUtils.toJsonString((Object)root);
        this.getModel().setValue("linkinfo_tag", (Object)str);
    }

    protected void editCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String nameInfo;
        String functionInfo;
        String orderInfo;
        String groupInfo;
        String outputInfo;
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        String tablename = (String)returnData.get("tablename");
        String othername = (String)returnData.get("othername");
        String linktype = (String)returnData.get("linktype");
        TreeView linkTree = this.getLinkTree();
        List selectNodeIds = linkTree.getTreeState().getSelectedNodeId();
        if (selectNodeIds.isEmpty()) {
            return;
        }
        String selectNodeId = (String)selectNodeIds.get(0);
        TreeNode root = this.getRootNode();
        TreeNode selectNode = this.getNodeInfosById(root, selectNodeId);
        String infos = selectNode.getLongNumber();
        Map infoMap = (Map)SerializationUtils.fromJsonString((String)infos, Map.class);
        String oldOthername = (String)infoMap.get("othername");
        String params = (String)this.getModel().getValue("params_tag");
        if (StringUtils.isNotEmpty((CharSequence)params)) {
            params = params.replaceAll(oldOthername, othername);
            this.getModel().setValue("params_tag", (Object)params);
        }
        if (StringUtils.isNotEmpty((CharSequence)(outputInfo = (String)this.getModel().getValue("outputinfo_tag")))) {
            outputInfo = outputInfo.replaceAll(oldOthername, othername);
            this.getModel().setValue("outputinfo_tag", (Object)outputInfo);
        }
        if (StringUtils.isNotEmpty((CharSequence)(groupInfo = (String)this.getModel().getValue("groupinfo_tag")))) {
            groupInfo = groupInfo.replaceAll(oldOthername, othername);
            this.getModel().setValue("groupinfo_tag", (Object)groupInfo);
        }
        if (StringUtils.isNotEmpty((CharSequence)(orderInfo = (String)this.getModel().getValue("orderinfo_tag")))) {
            orderInfo = orderInfo.replaceAll(oldOthername, othername);
            this.getModel().setValue("orderinfo_tag", (Object)orderInfo);
        }
        if (StringUtils.isNotEmpty((CharSequence)(functionInfo = (String)this.getModel().getValue("functioninfo_tag")))) {
            functionInfo = functionInfo.replaceAll(oldOthername, othername);
            this.getModel().setValue("functioninfo_tag", (Object)functionInfo);
        }
        if (StringUtils.isNotEmpty((CharSequence)(nameInfo = (String)this.getModel().getValue("nameinfo_tag")))) {
            nameInfo = nameInfo.replaceAll(oldOthername, othername);
            this.getModel().setValue("nameinfo_tag", (Object)nameInfo);
        }
        selectNode.setText(tablename + " " + othername);
        infoMap.put("othername", othername);
        infoMap.put("linktype", linktype);
        String tableEntryStr = (String)infoMap.get("tableentry");
        if (StringUtils.isNotEmpty((CharSequence)tableEntryStr)) {
            tableEntryStr = tableEntryStr.replaceAll(oldOthername, othername);
            infoMap.put("tableentry", tableEntryStr);
        }
        List selectChildren = selectNode.getChildren();
        for (Object child : selectChildren) {
            String childInfos = child.getLongNumber();
            if (!StringUtils.isNotEmpty((CharSequence)childInfos)) continue;
            Map childMap = (Map)SerializationUtils.fromJsonString((String)childInfos, Map.class);
            String childTableEntry = (String)childMap.get("tableentry");
            if (StringUtils.isNotEmpty((CharSequence)childTableEntry)) {
                childTableEntry = childTableEntry.replaceAll(oldOthername, othername);
                childMap.put("tableentry", childTableEntry);
            }
            child.setLongNumber(SerializationUtils.toJsonString((Object)childMap));
        }
        selectNode.setLongNumber(SerializationUtils.toJsonString((Object)infoMap));
        this.getPageCache().put("root", SerializationUtils.toJsonString((Object)root));
        this.getModel().setValue("linkinfo_tag", (Object)SerializationUtils.toJsonString((Object)root));
        linkTree.updateNode(root);
        linkTree.focusNode(selectNode);
        List children = root.getChildren();
        for (TreeNode child : children) {
            linkTree.expand(child.getId());
        }
        this.refreshLinkEntry();
        this.fillFieldsEntry(selectNode);
        this.fillTableEntry(selectNode);
        for (int i = 0; i < this.getModel().getEntryRowCount("termentry"); ++i) {
            String fieldName = (String)this.getModel().getValue("field", i);
            fieldName = fieldName.replaceAll(oldOthername, othername);
            String valueType = (String)this.getModel().getValue("valuetype", i);
            if ("field".equals(valueType)) {
                String value = (String)this.getModel().getValue(VALUE, i);
                value = value.replaceAll(oldOthername, othername);
                this.getModel().setValue(VALUE, (Object)value, i);
            }
            this.getModel().setValue("field", (Object)fieldName, i);
        }
        this.getModel().setValue("sql_tag", (Object)"");
        this.getModel().setValue("outputsql_tag", (Object)"");
    }

    protected void constractLinkTree() {
        TreeView dataTableTree = (TreeView)this.getView().getControl("linktree");
        dataTableTree.setMulti(false);
        TreeNode root = new TreeNode("", "0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"EigenValueCalculatePlugin_34", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        root.addChildren(new ArrayList());
        dataTableTree.setRootVisible(true);
        dataTableTree.addNode(root);
        dataTableTree.setDraggable(false);
        dataTableTree.setDroppable(false);
        dataTableTree.expand(root.getId());
        dataTableTree.focusNode(root);
        this.getPageCache().put("root", SerializationUtils.toJsonString((Object)root));
    }

    protected void clickBtnnew() {
        TreeView dataTableTree = (TreeView)this.getView().getControl("linktree");
        List selectNodes = dataTableTree.getTreeState().getSelectedNodes();
        if (selectNodes.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u8fde\u63a5\u8868\u914d\u7f6e\u8282\u70b9", (String)"EigenValueCalculatePlugin_35", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
        Map selectNode = (Map)selectNodes.get(0);
        String selectId = selectNode.get(ID).toString();
        if ("0".equals(selectId)) {
            this.dealSelectRootNode(dataTableTree);
        } else {
            this.dealSelectOtherNode(dataTableTree);
        }
    }

    protected void dealSelectRootNode(TreeView dataTableTree) {
        TreeNode root = this.getRootNode();
        List children = root.getChildren();
        if (!children.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u6709\u4e00\u4e2a\u4e3b\u8868", (String)"EigenValueCalculatePlugin_36", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
        FormShowParameter showParameter = new FormShowParameter();
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "root");
        showParameter.setFormId("phm_tablerelation");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(callBack);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("isroot", Boolean.TRUE);
        params.put("isaddnew", Boolean.TRUE);
        params.put("root", this.getPageCache().get("root"));
        showParameter.setCustomParams(params);
        this.getView().showForm(showParameter);
    }

    protected void dealSelectOtherNode(TreeView linkTree) {
        String parentId;
        String dbkey;
        List selectNodes = linkTree.getTreeState().getSelectedNodeId();
        String selectId = (String)selectNodes.get(0);
        TreeNode treeNode = this.getNodeInfosById(this.getRootNode(), selectId);
        if (treeNode == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u8fde\u63a5\u8868\u914d\u7f6e\u8282\u70b9", (String)"EigenValueCalculatePlugin_35", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
        String infos = treeNode.getLongNumber();
        if (StringUtils.isEmpty((CharSequence)infos)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u8fde\u63a5\u8868\u914d\u7f6e\u8282\u70b9", (String)"EigenValueCalculatePlugin_35", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)infos, Map.class);
        String source = (String)map.get(SOURCE);
        if (StringUtils.isEmpty((CharSequence)source)) {
            source = "phm_datatable";
        }
        if (StringUtils.isEmpty((CharSequence)(dbkey = (String)map.get("dbkey")))) {
            dbkey = "PHM";
        }
        if (!StringUtils.equals((CharSequence)"0", (CharSequence)(parentId = treeNode.getParentid())) && !map.containsKey("tableentry")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u8fde\u63a5\u5173\u7cfb", (String)"EigenValueCalculatePlugin_37", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
        FormShowParameter showParameter = new FormShowParameter();
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "other");
        showParameter.setFormId("phm_tablerelation");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(callBack);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("isroot", Boolean.FALSE);
        params.put("isaddnew", Boolean.TRUE);
        params.put("sourcetable", map.get("tablename"));
        params.put("sourcetableid", map.get("table"));
        params.put("root", this.getPageCache().get("root"));
        params.put(SOURCE, source);
        params.put("dbkey", dbkey);
        showParameter.setCustomParams(params);
        this.getView().showForm(showParameter);
    }

    protected void clickBtnedit() {
        TreeView linkTree = this.getLinkTree();
        List selectNodes = linkTree.getTreeState().getSelectedNodes();
        if (selectNodes.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u8fde\u63a5\u8868\u914d\u7f6e\u8282\u70b9", (String)"EigenValueCalculatePlugin_35", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
        Map selectNode = (Map)selectNodes.get(0);
        if (StringUtils.isEmpty((CharSequence)selectNode.get(ID).toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u8fde\u63a5\u8868\u914d\u7f6e\u8282\u70b9", (String)"EigenValueCalculatePlugin_35", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
        if ("0".equals(selectNode.get(ID))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8fde\u63a5\u8868\u914d\u7f6e\u6839\u8282\u70b9\u4e0d\u80fd\u4fee\u6539", (String)"EigenValueCalculatePlugin_38", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
        String selectNodeId = (String)((Map)selectNodes.get(0)).get(ID);
        TreeNode treeNode = this.getNodeInfosById(this.getRootNode(), selectNodeId);
        String info = treeNode.getLongNumber();
        if (StringUtils.isEmpty((CharSequence)info)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u8fde\u63a5\u8868\u914d\u7f6e\u8282\u70b9", (String)"EigenValueCalculatePlugin_35", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)info, Map.class);
        String source = (String)map.get(SOURCE);
        if (StringUtils.isEmpty((CharSequence)source)) {
            source = "phm_datatable";
        }
        FormShowParameter showParameter = new FormShowParameter();
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "edit");
        showParameter.setFormId("phm_tablerelation");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(callBack);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("isroot", Boolean.FALSE);
        params.put("isaddnew", Boolean.FALSE);
        params.put("info", info);
        params.put("root", this.getPageCache().get("root"));
        params.put("nodeid", selectNodeId);
        params.put(SOURCE, source);
        showParameter.setCustomParams(params);
        this.getView().showForm(showParameter);
    }

    protected void clickBtndel() {
        TreeView linkTree = this.getLinkTree();
        List selectNodes = linkTree.getTreeState().getSelectedNodes();
        if (selectNodes.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u8fde\u63a5\u8868\u914d\u7f6e\u8282\u70b9", (String)"EigenValueCalculatePlugin_35", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
        Map selectNode = (Map)selectNodes.get(0);
        if ("0".equals(selectNode.get(ID))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8fde\u63a5\u8868\u914d\u7f6e\u6839\u8282\u70b9\u4e0d\u80fd\u5220\u9664", (String)"EigenValueCalculatePlugin_39", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
        TreeNode root = this.getRootNode();
        linkTree.updateNode(root);
        TreeNode node = this.getNodeInfosById(root, (String)selectNode.get(ID));
        String infos = node.getLongNumber();
        if (StringUtils.isEmpty((CharSequence)infos)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u8fde\u63a5\u8868\u914d\u7f6e\u8282\u70b9", (String)"EigenValueCalculatePlugin_35", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        }
        String str = ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u9009\u4e2d\u8868\uff1f", (String)"EigenValueCalculatePlugin_40", (String)"mmc-phm-formplugin", (Object[])new Object[0]);
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("del", (IFormPlugin)this);
        this.getView().showConfirm(str, MessageBoxOptions.YesNo, confirmCallBacks);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("del".equals(messageBoxClosedEvent.getCallBackId())) {
            TreeView linkTree = this.getLinkTree();
            List selectNodes = linkTree.getTreeState().getSelectedNodes();
            Map selectNode = (Map)selectNodes.get(0);
            TreeNode root = this.getRootNode();
            linkTree.updateNode(root);
            TreeNode node = this.getNodeInfosById(root, (String)selectNode.get(ID));
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                String orderInfo;
                String groupInfo;
                String nameInfo;
                String functionInfo;
                String output;
                String infos = node.getLongNumber();
                Map map = (Map)SerializationUtils.fromJsonString((String)infos, Map.class);
                String otherName = (String)map.get("othername");
                root.deleteChildNode(node.getId());
                List children = root.getChildren();
                for (TreeNode child : children) {
                    linkTree.expand(child.getId());
                }
                this.getPageCache().put("root", SerializationUtils.toJsonString((Object)root));
                this.getView().updateView("linktree");
                this.getModel().setValue("linkinfo_tag", (Object)SerializationUtils.toJsonString((Object)root));
                this.getModel().deleteEntryData("linkentry");
                this.getModel().deleteEntryData("fieldentry");
                String params = (String)this.getModel().getValue("params_tag");
                if (StringUtils.isNotEmpty((CharSequence)params)) {
                    Set paramsSet = (Set)SerializationUtils.fromJsonString((String)params, Set.class);
                    Iterator iterator = paramsSet.iterator();
                    while (iterator.hasNext()) {
                        String fieldName = (String)iterator.next();
                        if (!fieldName.contains(otherName)) continue;
                        iterator.remove();
                    }
                    this.getModel().setValue("params_tag", (Object)SerializationUtils.toJsonString((Object)paramsSet));
                }
                if (StringUtils.isNotEmpty((CharSequence)(output = (String)this.getModel().getValue("outputinfo_tag")))) {
                    Set outputSet = (Set)SerializationUtils.fromJsonString((String)output, Set.class);
                    Iterator iterator = outputSet.iterator();
                    while (iterator.hasNext()) {
                        String fieldName = (String)iterator.next();
                        if (!fieldName.contains(otherName)) continue;
                        iterator.remove();
                    }
                    this.getModel().setValue("outputinfo_tag", (Object)SerializationUtils.toJsonString((Object)outputSet));
                }
                if (StringUtils.isNotEmpty((CharSequence)(functionInfo = (String)this.getModel().getValue("functioninfo_tag")))) {
                    Map functionMap = (Map)SerializationUtils.fromJsonString((String)functionInfo, Map.class);
                    Set entrySet = functionMap.entrySet();
                    Iterator iterator = entrySet.iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        String fieldName = (String)entry.getKey();
                        if (!fieldName.contains(otherName)) continue;
                        iterator.remove();
                    }
                    this.getModel().setValue("functioninfo_tag", (Object)SerializationUtils.toJsonString((Object)functionMap));
                }
                if (StringUtils.isNotEmpty((CharSequence)(nameInfo = (String)this.getModel().getValue("nameinfo_tag")))) {
                    Map nameMap = (Map)SerializationUtils.fromJsonString((String)nameInfo, Map.class);
                    Set entrySet = nameMap.entrySet();
                    Iterator iterator = entrySet.iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        String fieldName = (String)entry.getKey();
                        if (!fieldName.contains(otherName)) continue;
                        iterator.remove();
                    }
                    this.getModel().setValue("nameinfo_tag", (Object)SerializationUtils.toJsonString((Object)nameMap));
                }
                if (StringUtils.isNotEmpty((CharSequence)(groupInfo = (String)this.getModel().getValue("groupinfo_tag")))) {
                    Map groupMap = (Map)SerializationUtils.fromJsonString((String)groupInfo, Map.class);
                    Set entrySet = groupMap.entrySet();
                    Iterator iterator = entrySet.iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        String fieldName = (String)entry.getKey();
                        if (!fieldName.contains(otherName)) continue;
                        iterator.remove();
                    }
                    this.getModel().setValue("groupinfo_tag", (Object)SerializationUtils.toJsonString((Object)groupMap));
                }
                if (StringUtils.isNotEmpty((CharSequence)(orderInfo = (String)this.getModel().getValue("orderinfo_tag")))) {
                    Map orderMap = (Map)SerializationUtils.fromJsonString((String)orderInfo, Map.class);
                    Set entrySet = orderMap.entrySet();
                    Iterator iterator = entrySet.iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        String fieldName = (String)entry.getKey();
                        if (!fieldName.contains(otherName)) continue;
                        iterator.remove();
                    }
                    this.getModel().setValue("orderinfo_tag", (Object)SerializationUtils.toJsonString((Object)orderMap));
                }
                this.getModel().setValue("sql_tag", (Object)"");
                this.getModel().setValue("outputsql_tag", (Object)"");
            } else {
                List children = root.getChildren();
                for (TreeNode child : children) {
                    linkTree.expand(child.getId());
                }
                linkTree.focusNode(node);
            }
        }
        if (StringUtils.equals((CharSequence)DELETE_CONFIRM, (CharSequence)messageBoxClosedEvent.getCallBackId()) && StringUtils.equals((CharSequence)"Yes", (CharSequence)messageBoxClosedEvent.getResultValue())) {
            String s = this.getPageCache().get(DELETE_IDS);
            List ids = (List)SerializationUtils.fromJsonString((String)s, ArrayList.class);
            this.deleteNodes(ids);
            this.getModel().beginInit();
            this.clearAttribute();
            this.getModel().endInit();
            this.getView().updateView(FLEXPANELAP_4);
        }
    }

    private void clearAttribute() {
        this.getModel().beginInit();
        this.getModel().setValue(MODELNAME, null);
        this.getModel().setValue("model", null);
        this.getModel().setValue(TYPE, null);
        this.getModel().setValue("isint", null);
        this.getModel().setValue(ISFLOT, null);
        this.getModel().setValue(ISMATRIX, null);
        this.getModel().setValue(MODELREMARK, null);
        this.getModel().setValue(GRADE, null);
        this.getModel().setValue(CELLSEQ, null);
        this.getModel().setValue(BELONG, null);
        this.getModel().setValue("setway", (Object)"eigen");
        this.getModel().setValue("eigen", null);
        this.getModel().setValue("isqueryset", (Object)Boolean.TRUE);
        this.getModel().setValue("isdoubles", (Object)Boolean.TRUE);
        this.getModel().setValue("isdefsql", (Object)Boolean.FALSE);
        this.getModel().setValue("issingle", (Object)Boolean.FALSE);
        this.getModel().setValue("sql_tag", null);
        this.getModel().setValue("linkinfo_tag", null);
        this.getModel().setValue("params_tag", null);
        this.getModel().setValue("groupinfo_tag", null);
        this.getModel().setValue("orderinfo_tag", null);
        this.getModel().setValue("functioninfo_tag", null);
        TreeView linktree = this.getLinkTree();
        linktree.deleteAllNodes();
        this.constractLinkTree();
        this.getModel().endInit();
        this.getView().updateView();
    }

    private void deleteNodes(List<String> ids) {
        CustomControl control = (CustomControl)this.getView().getControl("cc_mgdesigner");
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(8);
        paramsMap.put(ACTION, DELETE_PHM_CELL);
        paramsMap.put("deleteCells", ids);
        control.setData(paramsMap);
        this.deleteCellsData(ids);
    }

    private void deleteCellsData(List<String> ids) {
        String cellsdata;
        Object cellsdataObj = this.getModel().getValue("cellsdata_tag");
        if (cellsdataObj != null && StringUtils.isNotEmpty((CharSequence)(cellsdata = cellsdataObj.toString()))) {
            Map cellsDataMap = (Map)JSONObject.parse((String)cellsdata);
            ids.forEach(id -> {
                Map cfr_ignored_0 = (Map)cellsDataMap.remove(id);
            });
            String jsonString = JSONObject.toJSONString((Object)cellsDataMap);
            this.getModel().setValue("cellsdata_tag", (Object)jsonString);
        }
    }

    protected void viewSQL() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ide_largertextedit");
        showParameter.setCustomParam("fieldKey", (Object)"sql");
        showParameter.setCustomParam("largeTextValue", this.getModel().getValue("sql_tag"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "sql_tag");
        showParameter.setCloseCallBack(callBack);
        this.getView().showForm(showParameter);
    }

    protected TreeNode getRootNode() {
        String rootNodeStr = this.getPageCache().get("root");
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeStr, TreeNode.class);
        return root;
    }

    protected TreeNode getNodeInfosById(TreeNode treeNode, String nodeId) {
        HashMap<String, TreeNode> treeNodeMap = new HashMap<String, TreeNode>();
        this.getAllTreeNodeMap(treeNodeMap, treeNode);
        if ("0".equals(nodeId)) {
            return this.getRootNode();
        }
        return (TreeNode)treeNodeMap.get(nodeId);
    }

    protected void getAllTreeNodeMap(Map<String, TreeNode> treeNodeMap, TreeNode treeNode) {
        List children = treeNode.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            TreeNode child = (TreeNode)children.get(i);
            treeNodeMap.put(child.getId(), child);
            if (child.getChildren().isEmpty()) continue;
            this.getAllTreeNodeMap(treeNodeMap, child);
        }
    }

    protected TreeView getLinkTree() {
        TreeView treeView = (TreeView)this.getView().getControl("linktree");
        return treeView;
    }

    protected void refreshLinkEntry() {
        TreeView treeView = this.getLinkTree();
        List selectIds = treeView.getTreeState().getSelectedNodeId();
        String selectId = (String)selectIds.get(0);
        if (StringUtils.equals((CharSequence)"0", (CharSequence)selectId)) {
            return;
        }
        TreeNode selectNode = this.getNodeInfosById(this.getRootNode(), selectId);
        String infos = selectNode.getLongNumber();
        Map map = (Map)SerializationUtils.fromJsonString((String)infos, Map.class);
        String sourcetable = (String)map.get("sourcetable");
        String linktable = (String)map.get("tablename");
        String linktype = (String)map.get("linktype");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter linkEntryVs = new TableValueSetter(new String[]{"seq", "sourcetable", "linktable", "linktype"});
        linkEntryVs.addRow(new Object[]{0, sourcetable, linktable, linktype});
        model.deleteEntryData("linkentry");
        model.batchCreateNewEntryRow("linkentry", linkEntryVs);
        model.endInit();
        this.getView().updateView("linkentry");
    }

    protected void storeTableEntry() {
        TreeView treeView = this.getLinkTree();
        List selectIds = treeView.getTreeState().getSelectedNodeId();
        if (selectIds.isEmpty()) {
            return;
        }
        String selectId = (String)selectIds.get(0);
        if (StringUtils.equals((CharSequence)"0", (CharSequence)selectId)) {
            return;
        }
        TreeNode rootNode = this.getRootNode();
        TreeNode selectNode = this.getNodeInfosById(rootNode, selectId);
        String infos = selectNode.getLongNumber();
        Map map = (Map)SerializationUtils.fromJsonString((String)infos, Map.class);
        int rowCount = this.getModel().getEntryRowCount("tableentry");
        ArrayList tableEntryList = new ArrayList(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            HashMap<String, String> entryMap = new HashMap<String, String>();
            String seq = Integer.toString(i);
            String mainfield = (String)this.getModel().getValue("mainfield", i);
            String linkfield = (String)this.getModel().getValue("linkfield", i);
            String condition = (String)this.getModel().getValue("condition", i);
            entryMap.put("seq", seq);
            entryMap.put("mainfield", mainfield);
            entryMap.put("linkfield", linkfield);
            entryMap.put("condition", condition);
            tableEntryList.add(entryMap);
        }
        map.put("tableentry", SerializationUtils.toJsonString(tableEntryList));
        selectNode.setLongNumber(SerializationUtils.toJsonString((Object)map));
        this.getPageCache().put("root", SerializationUtils.toJsonString((Object)rootNode));
        this.getModel().setValue("linkinfo_tag", (Object)SerializationUtils.toJsonString((Object)rootNode));
    }

    protected Map<String, String> getIdAndOtherName(TreeNode treeNode, Map<String, String> map) {
        List children = treeNode.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            TreeNode child = (TreeNode)children.get(i);
            List childs = child.getChildren();
            String childInfo = child.getLongNumber();
            Map infos = (Map)SerializationUtils.fromJsonString((String)childInfo, Map.class);
            String otherName = (String)infos.get("othername");
            String tableId = (String)infos.get("table");
            if (map.containsKey(otherName)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u522b\u540d", (String)"EigenValueCalculatePlugin_41", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + otherName + ResManager.loadKDString((String)"\u91cd\u590d\uff0c\u8bf7\u8fdb\u884c\u4fee\u6539", (String)"EigenValueCalculatePlugin_42", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
            map.put(otherName, tableId);
            if (childs == null) continue;
            this.getIdAndOtherName(child, map);
        }
        return map;
    }

    protected void constractFieldList(String otherName, String tableId, List<String> fieldsList) {
        DynamicObject dataTable = BusinessDataServiceHelper.loadSingle((Object)tableId, (String)"phm_datatable");
        DynamicObjectCollection entryCol = dataTable.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryCol) {
            String fieldName = entry.getString("fieldname");
            fieldName = otherName + "." + fieldName;
            fieldsList.add(fieldName);
        }
    }

    protected void paramsChanged(PropertyChangedArgs e) {
        ChangeData[] cds = e.getChangeSet();
        ChangeData cd = cds[0];
        String params = (String)this.getModel().getValue("params_tag");
        Set<String> paramsSet = new HashSet();
        if (StringUtils.isNotEmpty((CharSequence)params)) {
            paramsSet = (Set)SerializationUtils.fromJsonString((String)params, Set.class);
        }
        Object newValue = cd.getNewValue();
        Object oldValue = cd.getOldValue();
        int rowIndex = cd.getRowIndex();
        String fieldName = (String)this.getModel().getValue("fieldname", rowIndex);
        if (oldValue == null && Boolean.parseBoolean(newValue.toString())) {
            paramsSet.add(fieldName);
        } else if (oldValue != null && Boolean.parseBoolean(newValue.toString())) {
            paramsSet.add(fieldName);
        } else if (oldValue != null && !Boolean.parseBoolean(newValue.toString())) {
            paramsSet.remove(fieldName);
        }
        this.getModel().setValue("params_tag", (Object)SerializationUtils.toJsonString(paramsSet));
    }

    protected void isGroupChanged(PropertyChangedArgs e) {
        ChangeData[] cds = e.getChangeSet();
        ChangeData cd = cds[0];
        Object newValue = cd.getNewValue();
        Object oldValue = cd.getOldValue();
        int rowIndex = cd.getRowIndex();
        String groupInfo = (String)this.getModel().getValue("groupinfo_tag");
        Map<String, Integer> groupMap = new HashMap();
        if (StringUtils.isNotEmpty((CharSequence)groupInfo)) {
            groupMap = (Map)SerializationUtils.fromJsonString((String)groupInfo, Map.class);
        }
        String fieldName = (String)this.getModel().getValue("fieldname", rowIndex);
        int groupLevel = (Integer)this.getModel().getValue("level", rowIndex);
        if (oldValue == null && Boolean.parseBoolean(newValue.toString())) {
            groupMap.put(fieldName, groupLevel);
        } else if (oldValue != null && Boolean.parseBoolean(newValue.toString())) {
            groupMap.put(fieldName, groupLevel);
        } else if (oldValue != null && !Boolean.parseBoolean(newValue.toString())) {
            groupMap.remove(fieldName);
        }
        this.getModel().setValue("groupinfo_tag", (Object)SerializationUtils.toJsonString(groupMap));
    }

    protected void groupLevelChanged(PropertyChangedArgs e) {
        String fieldName;
        ChangeData[] cds = e.getChangeSet();
        ChangeData cd = cds[0];
        Object newValue = cd.getNewValue();
        int groupLevel = 0;
        if (newValue != null) {
            groupLevel = Integer.parseInt(newValue.toString());
        }
        int rowIndex = cd.getRowIndex();
        String groupInfo = (String)this.getModel().getValue("groupinfo_tag");
        Map<String, Integer> groupMap = new HashMap();
        if (StringUtils.isNotEmpty((CharSequence)groupInfo)) {
            groupMap = (Map)SerializationUtils.fromJsonString((String)groupInfo, Map.class);
        }
        if (groupMap.containsKey(fieldName = (String)this.getModel().getValue("fieldname", rowIndex))) {
            groupMap.put(fieldName, groupLevel);
        }
        this.getModel().setValue("groupinfo_tag", (Object)SerializationUtils.toJsonString(groupMap));
    }

    protected void isOrderChanged(PropertyChangedArgs e) {
        ChangeData[] cds = e.getChangeSet();
        ChangeData cd = cds[0];
        Object newValue = cd.getNewValue();
        Object oldValue = cd.getOldValue();
        int rowIndex = cd.getRowIndex();
        String orderInfo = (String)this.getModel().getValue("orderinfo_tag");
        Map<String, Integer> orderMap = new HashMap();
        if (StringUtils.isNotEmpty((CharSequence)orderInfo)) {
            orderMap = (Map)SerializationUtils.fromJsonString((String)orderInfo, Map.class);
        }
        String fieldName = (String)this.getModel().getValue("fieldname", rowIndex);
        int orderLevel = (Integer)this.getModel().getValue("orderlevel", rowIndex);
        if (oldValue == null && Boolean.parseBoolean(newValue.toString())) {
            orderMap.put(fieldName, orderLevel);
        } else if (oldValue != null && Boolean.parseBoolean(newValue.toString())) {
            orderMap.put(fieldName, orderLevel);
        } else if (oldValue != null && !Boolean.parseBoolean(newValue.toString())) {
            orderMap.remove(fieldName);
        }
        this.getModel().setValue("orderinfo_tag", (Object)SerializationUtils.toJsonString(orderMap));
    }

    protected void orderLevelChanged(PropertyChangedArgs e) {
        String fieldName;
        ChangeData[] cds = e.getChangeSet();
        ChangeData cd = cds[0];
        Object newValue = cd.getNewValue();
        int orderLevel = 0;
        if (newValue != null) {
            orderLevel = Integer.parseInt(newValue.toString());
        }
        int rowIndex = cd.getRowIndex();
        String orderInfo = (String)this.getModel().getValue("orderinfo_tag");
        Map<String, Integer> orderMap = new HashMap();
        if (StringUtils.isNotEmpty((CharSequence)orderInfo)) {
            orderMap = (Map)SerializationUtils.fromJsonString((String)orderInfo, Map.class);
        }
        if (orderMap.containsKey(fieldName = (String)this.getModel().getValue("fieldname", rowIndex))) {
            orderMap.put(fieldName, orderLevel);
        }
        this.getModel().setValue("orderinfo_tag", (Object)SerializationUtils.toJsonString(orderMap));
    }

    protected void functionChanged(PropertyChangedArgs e) {
        String fieldName;
        ChangeData[] cds = e.getChangeSet();
        ChangeData cd = cds[0];
        Object newValue = cd.getNewValue();
        String function = "";
        if (newValue != null) {
            function = newValue.toString();
        }
        int rowIndex = cd.getRowIndex();
        String functionInfo = (String)this.getModel().getValue("functioninfo_tag");
        Map<String, String> functionMap = new HashMap();
        if (StringUtils.isNotEmpty((CharSequence)functionInfo)) {
            functionMap = (Map)SerializationUtils.fromJsonString((String)functionInfo, Map.class);
        }
        if (functionMap.containsKey(fieldName = (String)this.getModel().getValue("fieldname", rowIndex)) && StringUtils.isNotEmpty((CharSequence)function)) {
            functionMap.put(fieldName, function);
        } else if (functionMap.containsKey(fieldName) && StringUtils.isEmpty((CharSequence)function)) {
            functionMap.remove(fieldName);
        } else if (!functionMap.containsKey(fieldName) && StringUtils.isNotEmpty((CharSequence)function)) {
            functionMap.put(fieldName, function);
        }
        this.getModel().setValue("functioninfo_tag", (Object)SerializationUtils.toJsonString(functionMap));
    }

    protected void outputColChanged(PropertyChangedArgs e) {
        ChangeData[] cds = e.getChangeSet();
        ChangeData cd = cds[0];
        String outputInfo = (String)this.getModel().getValue("outputinfo_tag");
        Set<String> outputSet = new HashSet();
        if (StringUtils.isNotEmpty((CharSequence)outputInfo)) {
            outputSet = (Set)SerializationUtils.fromJsonString((String)outputInfo, Set.class);
        }
        Object newValue = cd.getNewValue();
        Object oldValue = cd.getOldValue();
        int rowIndex = cd.getRowIndex();
        String fieldName = (String)this.getModel().getValue("fieldname", rowIndex);
        if (oldValue == null && Boolean.parseBoolean(newValue.toString())) {
            outputSet.add(fieldName);
        } else if (oldValue != null && Boolean.parseBoolean(newValue.toString())) {
            outputSet.add(fieldName);
        } else if (oldValue != null && !Boolean.parseBoolean(newValue.toString())) {
            outputSet.remove(fieldName);
        }
        this.getModel().setValue("outputinfo_tag", (Object)SerializationUtils.toJsonString(outputSet));
    }

    protected void nameFieldChanged(PropertyChangedArgs e) {
        ChangeData[] cds = e.getChangeSet();
        ChangeData cd = cds[0];
        Object newValue = cd.getNewValue();
        String function = "";
        if (newValue != null) {
            function = newValue.toString();
        }
        int rowIndex = cd.getRowIndex();
        String nameInfo = (String)this.getModel().getValue("nameinfo_tag");
        Map<String, String> nameMap = new HashMap();
        if (StringUtils.isNotEmpty((CharSequence)nameInfo)) {
            nameMap = (Map)SerializationUtils.fromJsonString((String)nameInfo, Map.class);
        }
        String fieldName = (String)this.getModel().getValue("fieldname", rowIndex);
        if (nameMap.containsValue(function)) {
            this.getView().showTipNotification(fieldName + ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u5b57\u6bb5\u547d\u540d\u91cd\u590d", (String)"EigenValueCalculatePlugin_43", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("namefield", (Object)"", rowIndex);
            return;
        }
        if (StringUtils.isEmpty((CharSequence)function)) {
            function = fieldName.split("\\.")[1];
        }
        if (nameMap.containsKey(fieldName) && StringUtils.isNotEmpty((CharSequence)function)) {
            nameMap.put(fieldName, function);
        } else if (nameMap.containsKey(fieldName) && StringUtils.isEmpty((CharSequence)function)) {
            nameMap.remove(fieldName);
        } else if (!nameMap.containsKey(fieldName) && StringUtils.isNotEmpty((CharSequence)function)) {
            nameMap.put(fieldName, function);
        }
        this.getModel().setValue("nameinfo_tag", (Object)SerializationUtils.toJsonString(nameMap));
    }

    protected void sortWayChanged(PropertyChangedArgs e) {
        String fieldName;
        ChangeData[] cds = e.getChangeSet();
        ChangeData cd = cds[0];
        Object newValue = cd.getNewValue();
        String sortWay = "asc";
        if (newValue != null) {
            sortWay = newValue.toString();
        }
        int rowIndex = cd.getRowIndex();
        String descInfo = (String)this.getModel().getValue("descinfo_tag");
        Set<String> descSet = new HashSet();
        if (StringUtils.isNotEmpty((CharSequence)descInfo)) {
            descSet = (Set)SerializationUtils.fromJsonString((String)descInfo, Set.class);
        }
        if (descSet.contains(fieldName = (String)this.getModel().getValue("fieldname", rowIndex)) && StringUtils.equals((CharSequence)"desc", (CharSequence)sortWay)) {
            descSet.add(fieldName);
        } else if (descSet.contains(fieldName) && !StringUtils.equals((CharSequence)"desc", (CharSequence)sortWay)) {
            descSet.remove(fieldName);
        } else if (!descSet.contains(fieldName) && StringUtils.equals((CharSequence)"desc", (CharSequence)sortWay)) {
            descSet.add(fieldName);
        }
        this.getModel().setValue("descinfo_tag", (Object)SerializationUtils.toJsonString(descSet));
    }

    protected void updateModelName(PropertyChangedArgs e) {
        ChangeData[] cds = e.getChangeSet();
        ChangeData cd = cds[0];
        CustomControl control = (CustomControl)this.getView().getControl("cc_mgdesigner");
        String upSelectid = (String)this.getModel().getValue("selectid");
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(8);
        paramsMap.put(ACTION, UPDATE_MODELNAME);
        paramsMap.put(ID, upSelectid);
        paramsMap.put(NAME, cd.getNewValue());
        control.setData(paramsMap);
    }

    protected void valueTypeChanged(PropertyChangedArgs e) {
        ChangeData[] cds = e.getChangeSet();
        ChangeData cd = cds[0];
        int rowIndex = cd.getRowIndex();
        this.getModel().setValue(VALUE, null, rowIndex);
    }
}

