/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.mmc.phm.common.adaptor.ExcelAdaptor;
import kd.mmc.phm.common.bizmodel.ComponentType;
import kd.mmc.phm.common.bizmodel.DataModel;
import kd.mmc.phm.common.bizmodel.DetailStyle;
import kd.mmc.phm.common.bizmodel.DetailTable;
import kd.mmc.phm.common.info.ComponentInfo;
import kd.mmc.phm.common.util.ComponentUtil;
import kd.mmc.phm.common.util.DesignerUtils;
import kd.mmc.phm.common.util.ShowFormUtils;
import kd.mmc.phm.common.util.TableUtils;

public class EngdesignRunPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String DETAIL_ENTRYGRID = "phm_detail_entrygrid";
    public static final String TOOLBARAP = "toolbarap";
    public static final String PROPERTY_PANEL = "property_panel";
    public static final String CALCULALPROGRESS = "calculalprogress";
    public static final String SHOTPROGRESS = "shotprogress";
    public static final String CALCULALABELAP = "calculalabelap";
    public static final String SHOTLABEL = "shotlabel";
    public static final String SHOWPROGRESS = "showprogress";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{TOOLBARAP});
        this.addClickListeners(new String[]{PROPERTY_PANEL});
        ProgressBar calculalBar = (ProgressBar)this.getView().getControl(CALCULALPROGRESS);
        calculalBar.addProgressListener((ProgresssListener)this);
        ProgressBar shotBar = (ProgressBar)this.getView().getControl(SHOTPROGRESS);
        shotBar.addProgressListener((ProgresssListener)this);
        ProgressBar showBar = (ProgressBar)this.getView().getControl(SHOWPROGRESS);
        showBar.addProgressListener((ProgresssListener)this);
        Label label = (Label)this.getView().getControl(CALCULALABELAP);
        label.addItemClickListener((ItemClickListener)this);
        label.addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.FALSE, new String[]{"btn_save"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"btn_unsave"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"btn_run"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"btn_cancelrun"});
        this.getView().setVisible(Boolean.FALSE, new String[]{PROPERTY_PANEL});
        this.queryShotStatus();
    }

    private void queryShotStatus() {
        DynamicObject bizModel = this.getBizModel();
        if (bizModel == null) {
            return;
        }
        Object bizmodelid = bizModel.getPkValue();
        String resId = bizmodelid.toString();
        Date modifytime = bizModel.getDate("modifytime");
        DynamicObject calclog = QueryServiceHelper.queryOne((String)"phm_bizmodel_calclog", (String)"start_time", (QFilter[])new QFilter[]{new QFilter("bizmodel", "=", bizmodelid)});
        if (calclog == null || modifytime.after(calclog.getDate("start_time"))) {
            return;
        }
        HashMap all = (HashMap)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"getLatestSnapshotByUser", (Object[])new Object[]{resId});
        if (all != null) {
            ProgressBar showBar = (ProgressBar)this.getView().getControl(SHOWPROGRESS);
            showBar.setPercent(0);
            showBar.start();
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_save"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_unsave"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_run"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"btn_cancelrun"});
        } else {
            Object o = DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"queryLatestStatus", (Object[])new Object[]{resId});
            if (o instanceof Map) {
                String status;
                HashMap ret = (HashMap)o;
                switch (status = ret.get("status").toString()) {
                    case "A": 
                    case "B": 
                    case "C": 
                    case "D": {
                        this.startCalculaProgress();
                        break;
                    }
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String operationKey;
        super.itemClick(evt);
        switch (operationKey = evt.getOperationKey()) {
            case "save": {
                this.doSave();
                break;
            }
            case "unsave": {
                this.doUnSave();
                break;
            }
            case "run": {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("run", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8ba1\u7b97\u65f6\u95f4\u53ef\u80fd\u8f83\u957f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"EngdesignRunPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
                break;
            }
            case "cancelrun": {
                ProgressBar calculalBar = (ProgressBar)this.getView().getControl(CALCULALPROGRESS);
                calculalBar.setPercent(0);
                calculalBar.stop();
                ProgressBar shotplBar = (ProgressBar)this.getView().getControl(SHOTPROGRESS);
                shotplBar.setPercent(0);
                shotplBar.stop();
                ProgressBar showplBar = (ProgressBar)this.getView().getControl(SHOWPROGRESS);
                showplBar.setPercent(0);
                showplBar.stop();
                Object bizModelId = this.getView().getFormShowParameter().getCustomParam("bizModelId");
                String resId = bizModelId.toString();
                HashMap params = new HashMap();
                DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"stopCalc", (Object[])new Object[]{resId, params});
                this.getView().setEnable(Boolean.TRUE, new String[]{"btn_run"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"btn_cancelrun"});
                Label label = (Label)this.getControl(CALCULALABELAP);
                label.setText(ResManager.loadKDString((String)"\u8ba1\u7b97\u8fdb\u5ea6", (String)"EngdesignRunPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (StringUtils.equals((CharSequence)"run", (CharSequence)event.getCallBackId()) && StringUtils.equals((CharSequence)"Yes", (CharSequence)event.getResultValue())) {
            this.doRun();
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_run"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"btn_cancelrun"});
        } else if (StringUtils.equals((CharSequence)"doUnSave", (CharSequence)event.getCallBackId()) && StringUtils.equals((CharSequence)"Yes", (CharSequence)event.getResultValue())) {
            DynamicObject bizModel = this.getBizModel();
            if (bizModel == null) {
                return;
            }
            Object pkValue = bizModel.getPkValue();
            String resId = pkValue.toString();
            DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"cancelModelSnapshot", (Object[])new Object[]{resId, RequestContext.get().getUserId()});
            this.getView().setEnable(Boolean.TRUE, new String[]{"btn_save"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_unsave"});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String controlKey = control.getKey();
        if (StringUtils.equals((CharSequence)CALCULALABELAP, (CharSequence)controlKey)) {
            Object bizModelId = this.getView().getFormShowParameter().getCustomParam("bizModelId");
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"phm_bizmodel_calclog", (String)"id", (QFilter[])new QFilter[]{new QFilter("bizmodel", "=", bizModelId)});
            if (dynamicObject != null) {
                BillShowParameter formShowParameter = new BillShowParameter();
                formShowParameter.setFormId("phm_bizmodel_calclog");
                formShowParameter.setPkId(dynamicObject.get("id"));
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                StyleCss styleCss = new StyleCss();
                styleCss.setHeight("600");
                styleCss.setWidth("800");
                formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
                this.getView().showForm((FormShowParameter)formShowParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u65e5\u5fd7", (String)"EngdesignRunPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String eventArgs = e.getEventArgs();
        switch (eventName) {
            case "initData": {
                this.init();
                break;
            }
            case "ClearControlData": {
                this.setCustomControlData(null);
                break;
            }
            case "hidePropertyPanel": {
                this.getView().setVisible(Boolean.FALSE, new String[]{PROPERTY_PANEL});
                break;
            }
            case "selectCell": {
                Map selectParams = (Map)SerializationUtils.fromJsonString((String)eventArgs, HashMap.class);
                String key = (String)selectParams.get("cellId");
                String formId = (String)selectParams.get("componentType");
                if (StringUtils.equals((CharSequence)ComponentType.EIGENVALUE.getValue(), (CharSequence)formId)) {
                    DataModel dataModel = this.getDataModel();
                    Object eigenvalue = dataModel.getEigenvalue(key);
                    if (!(eigenvalue instanceof Map)) break;
                    HashMap<String, Object> customParmas = new HashMap<String, Object>(2);
                    customParmas.put("eigenValue", eigenvalue);
                    FormShowParameter formShowParameter = ShowFormUtils.assembleShowFormParam((String)"phm_eigentable", customParmas, null, (ShowType)ShowType.InContainer);
                    formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    formShowParameter.setShowTitle(false);
                    this.getView().showForm(formShowParameter);
                    break;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{PROPERTY_PANEL});
                break;
            }
            case "showFilterForm": {
                Map params = (Map)SerializationUtils.fromJsonString((String)eventArgs, HashMap.class);
                FormShowParameter formShowParameter = ShowFormUtils.assembleShowFormParam((String)"phm_filter_form", (Map)params, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "filterValue"), (ShowType)ShowType.Modal);
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u8f93\u5165", (String)"EngdesignRunPlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                this.getView().showForm(formShowParameter);
                break;
            }
            case "showDetail": {
                this.showDetail(eventArgs);
                break;
            }
            case "getElementGroup": {
                HashMap<String, Object> elementParams = new HashMap<String, Object>(3);
                elementParams.put("Action", "initElementGroup");
                elementParams.put("returnData", new ArrayList());
                elementParams.put("isRun", Boolean.TRUE);
                this.setCustomControlData(elementParams);
                break;
            }
            case "pageTurning": {
                this.pageTurning(eventArgs);
                break;
            }
            case "drilling": {
                this.drilling(eventArgs);
                break;
            }
            case "exportExcel": {
                DetailTable detailTable;
                DataModel dataModel = this.getDataModel();
                Map exportParams = (Map)SerializationUtils.fromJsonString((String)eventArgs, HashMap.class);
                String detailId = (String)exportParams.get("cellId");
                boolean isDrilling = (Boolean)exportParams.get("drilling");
                if (isDrilling) {
                    detailId = "drilling-" + detailId;
                }
                if (!Objects.nonNull(detailTable = dataModel.getDetailTable(detailId))) break;
                ExcelAdaptor excelAdaptor = new ExcelAdaptor(detailTable);
                String fileName = ResManager.loadKDString((String)"\u660e\u7ec6", (String)"EngdesignRunPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]);
                if (isDrilling) {
                    fileName = ResManager.loadKDString((String)"\u94bb\u53d6\u660e\u7ec6", (String)"EngdesignRunPlugin_5", (String)"mmc-phm-formplugin", (Object[])new Object[0]);
                }
                String excelFileTempUrl = excelAdaptor.getExcelFileTempUrl(fileName);
                this.getView().download(excelFileTempUrl);
                break;
            }
            case "eigen_detail": {
                Map selectParams_eigen = (Map)SerializationUtils.fromJsonString((String)eventArgs, HashMap.class);
                String _id = (String)selectParams_eigen.get("id");
                String _formId = (String)selectParams_eigen.get("componentType");
                if (!StringUtils.equals((CharSequence)"phm_eigen_component", (CharSequence)_formId)) break;
                String _detailId = "";
                long bizModelId = (Long)this.getView().getFormShowParameter().getCustomParam("bizModelId");
                Map _componentInfoMap = DesignerUtils.wrapperComponentInfo((long)bizModelId);
                Map<String, ComponentInfo> newComponentInfoMap = _componentInfoMap.entrySet().stream().filter(_e -> ((ComponentInfo)_e.getValue()).getComponentType() == ComponentType.DETAIL && StringUtils.equals((CharSequence)(((ComponentInfo)_e.getValue()).getProperties().get("eigencomponent") == null ? "" : ((ComponentInfo)_e.getValue()).getProperties().get("eigencomponent").toString()), (CharSequence)_id)).collect(Collectors.toMap(k -> (String)k.getKey(), v -> (ComponentInfo)v.getValue()));
                if (!newComponentInfoMap.isEmpty()) {
                    Set<String> detailKeys = newComponentInfoMap.keySet();
                    Iterator<String> iterator = detailKeys.iterator();
                    while (iterator.hasNext()) {
                        String detailKey;
                        _detailId = detailKey = iterator.next();
                    }
                }
                if (!StringUtils.isNotEmpty((CharSequence)_detailId)) break;
                HashMap<String, Object> _params = new HashMap<String, Object>(2);
                _params.put("Action", "eigen_detail");
                _params.put("detailid", _detailId);
                this.setCustomControlData(_params);
                break;
            }
        }
    }

    private void drilling(String eventArgs) {
        Map drillingParams = (Map)SerializationUtils.fromJsonString((String)eventArgs, HashMap.class);
        String id = (String)drillingParams.get("id");
        String field = (String)drillingParams.get("field");
        String value = (String)drillingParams.get("value");
        Map<String, Serializable> cacheFilters = this.getFilterParams();
        String resultId = "drilling-" + id;
        String drillingIdFilterId = "drilling-" + id + "\u0000" + field.toUpperCase();
        cacheFilters.put(drillingIdFilterId, (Serializable)((Object)value));
        this.getPageCache().put("filter", SerializationUtils.toJsonString(cacheFilters));
        HashMap<String, Serializable> filterParams = new HashMap<String, Serializable>(16);
        filterParams.putAll(cacheFilters);
        Object bizModelId = this.getView().getFormShowParameter().getCustomParam("bizModelId");
        Object result = this.filter(filterParams, bizModelId.toString());
        if (result instanceof Map) {
            Map datas = (Map)result;
            String bizModelPageId = this.getView().getFormShowParameter().getParentPageId();
            ComponentInfo componentInfo = ComponentUtil.getComponentInfo((String)bizModelPageId, (String)id);
            DetailTable detailTable = this.wrapperDetailTable((Serializable)datas.get(resultId), componentInfo, true);
            DataModel dataModel = this.getDataModel();
            Map details = dataModel.getDetails();
            DetailTable parent = (DetailTable)details.get(id);
            detailTable.setParent(parent);
            details.put(resultId, detailTable);
            this.getPageCache().put("dataModel", SerializationUtils.toJsonString((Object)dataModel));
            HashMap params = Maps.newHashMapWithExpectedSize((int)2);
            params.put("Action", "showDrillingDetail");
            params.put("detail", detailTable);
            this.setCustomControlData(params);
        }
    }

    private void showDetail(String eventArgs) {
        Map showDetailParams = (Map)SerializationUtils.fromJsonString((String)eventArgs, HashMap.class);
        long bizModelId = (Long)this.getView().getFormShowParameter().getCustomParam("bizModelId");
        List componentInfos = ComponentUtil.getDetailFromEigenvalueByBizId((long)bizModelId, (String)((String)showDetailParams.get("eigenId")));
        if (componentInfos.isEmpty()) {
            return;
        }
        String componentId = ((ComponentInfo)componentInfos.get(0)).getComponentId();
        boolean isShow = (Boolean)showDetailParams.get("isShow");
        HashMap params = Maps.newHashMapWithExpectedSize((int)3);
        params.put("Action", "setDetailVisible");
        params.put("visible", isShow);
        params.put("id", componentId);
        this.setCustomControlData(params);
    }

    private void pageTurning(String eventArgs) {
        Map pageParams = (Map)SerializationUtils.fromJsonString((String)eventArgs, HashMap.class);
        String detailId = (String)pageParams.get("id");
        int targetPage = (Integer)pageParams.get("targetPage");
        int pageSize = (Integer)pageParams.get("pageSize");
        DataModel dataModel = this.getDataModel();
        DetailTable detailTable = dataModel.getDetailTable(detailId);
        detailTable.setCurrentPage(targetPage);
        detailTable.setPageSize(pageSize);
        detailTable.paging();
        HashMap params = Maps.newHashMapWithExpectedSize((int)2);
        params.put("Action", "changeDetailPage");
        params.put("detail", detailTable);
        this.setCustomControlData(params);
    }

    private void init() {
        FormShowParameter formShowParameter;
        Object xml;
        HashMap params = Maps.newHashMapWithExpectedSize((int)4);
        params.put("Action", "init");
        params.put("running", Boolean.TRUE);
        DynamicObject bizModel = this.getBizModel();
        if (null != bizModel) {
            String background = bizModel.getString("background");
            String number = bizModel.getString("number");
            String name = bizModel.getString("name");
            params.put("name", name);
            params.put("number", number);
            params.put("backgroundcolor", background);
        }
        if (Objects.isNull(xml = (formShowParameter = this.getView().getFormShowParameter()).getCustomParam("xml"))) {
            return;
        }
        params.put("xml", xml.toString());
        long bizModelId = (Long)this.getView().getFormShowParameter().getCustomParam("bizModelId");
        List details = ComponentUtil.getAllComponentInfoByType((long)bizModelId, (ComponentType)ComponentType.DETAIL);
        List detailTables = details.stream().map(detail -> DesignerUtils.wrapperDetailTable((ComponentInfo)detail, (boolean)true)).collect(Collectors.toList());
        params.put("details", detailTables);
        this.setCustomControlData(params);
    }

    private void setCustomControlData(Map<String, Object> data) {
        CustomControl customControl = (CustomControl)this.getControl("customcontrolap");
        customControl.setData(data);
    }

    /*
     * Unable to fully structure code
     */
    private void filterData(Map<String, Object> params) {
        view = this.getView();
        bizModelId = view.getFormShowParameter().getCustomParam("bizModelId");
        componentId = (String)params.get("componentId");
        value = (String)params.get("value");
        if (StringUtils.isBlank((CharSequence)value)) {
            value = null;
        }
        bizModelPageId = view.getFormShowParameter().getParentPageId();
        compareData = null;
        if (DesignerUtils.exists((Object)bizModelId)) {
            dataSet = DesignerUtils.queryComponent((Object)bizModelId, (String)componentId);
            var9_9 = null;
            try {
                if (!dataSet.hasNext()) ** GOTO lbl35
                properties = (Map)SerializationUtils.fromJsonString((String)dataSet.next().getString("data_tag"), HashMap.class);
                compareData = (String)properties.get("comparison_data_tag");
            }
            catch (Throwable properties) {
                var9_9 = properties;
                throw properties;
            }
            finally {
                if (dataSet != null) {
                    if (var9_9 != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable properties) {
                            var9_9.addSuppressed(properties);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        } else {
            filters = new QFilter("bizmodelid", "=", bizModelId).and(new QFilter("componentid", "=", (Object)componentId)).toArray();
            queryInfo = QueryServiceHelper.queryOne((String)"phm_bizmodel_query", (String)"comparison_data_tag", (QFilter[])filters);
            if (Objects.nonNull(queryInfo)) {
                compareData = queryInfo.getString("comparison_data_tag");
            }
        }
lbl35:
        // 5 sources

        if (StringUtils.isBlank(compareData)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u914d\u7f6e\u5bf9\u6bd4\u5b57\u6bb5\u4fe1\u606f", (String)"EngdesignRunPlugin_6", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        filterParams = new HashMap<String, Serializable>(16);
        cacheFilters = this.getFilterParams();
        cacheFilters.put(componentId, (Serializable)value);
        filterParams.putAll(cacheFilters);
        this.getPageCache().put("filter", SerializationUtils.toJsonString(cacheFilters));
        resData = this.filter(filterParams, bizModelId.toString());
        if (resData instanceof Map) {
            dataModel = this.getDataModel();
            datas = (Map)resData;
            componentInfoMap = ComponentUtil.getComponentInfoMap((String)bizModelPageId);
            compareDataMap = (Map)SerializationUtils.fromJsonString((String)compareData, HashMap.class);
            detailTableMap = new HashMap<String, DetailTable>(16);
            eigenvalueMap = new HashMap<String, Serializable>(16);
            for (Map.Entry<K, V> entry : compareDataMap.entrySet()) {
                key = (String)entry.getKey();
                if (StringUtils.startsWith((CharSequence)key, (CharSequence)"detail")) {
                    data = (Serializable)datas.get(key);
                    componentInfo = (ComponentInfo)componentInfoMap.get(key);
                    detailTable = this.wrapperDetailTable(data, componentInfo, false);
                    detailTableMap.put(key, detailTable);
                    continue;
                }
                if (StringUtils.startsWith((CharSequence)key, (CharSequence)"drilling")) {
                    if (!dataModel.existDetail(key)) continue;
                    data = (Serializable)datas.get(key);
                    detailKey = key.substring("drilling-".length());
                    componentInfo = (ComponentInfo)componentInfoMap.get(detailKey);
                    detailTable = this.wrapperDetailTable(data, componentInfo, true);
                    parent = this.wrapperDetailTable((Serializable)datas.get(detailKey), componentInfo, false);
                    detailTable.setParent(parent);
                    detailTableMap.put(key, detailTable);
                    continue;
                }
                if (!StringUtils.contains((CharSequence)key, (CharSequence)"param")) continue;
                key = key.split("_")[0];
                data = (Serializable)datas.get(key);
                eigenvalueMap.put(key, data);
            }
            customControlParams = Maps.newHashMapWithExpectedSize((int)4);
            customControlParams.put("Action", "showAll");
            detailTables = new ArrayList<V>(detailTableMap.values());
            customControlParams.put("details", detailTables);
            handledEigenvalue = DesignerUtils.getHandledEigenvalue(eigenvalueMap, (Object)bizModelId);
            formatEigenvalue = DesignerUtils.getFormatEigenvalue((Map)handledEigenvalue);
            formatEigenvalue.put(componentId, Objects.isNull(value) != false ? "" : value);
            customControlParams.put("eigenvalues", JSONObject.toJSONString((Object)formatEigenvalue));
            this.setCustomControlData(customControlParams);
            dataModel.getDetails().putAll(detailTableMap);
            dataModel.getEigenvalues().putAll(handledEigenvalue);
            this.getPageCache().put("dataModel", SerializationUtils.toJsonString((Object)dataModel));
        }
    }

    private Object filter(Map<String, Serializable> filterParams, String bizModelId) {
        String keyTmp = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"start2CreateSnapshot", (Object[])new Object[]{bizModelId, filterParams});
        HashMap status = (HashMap)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"querySnapshotStatus", (Object[])new Object[]{bizModelId, keyTmp});
        while ("B".equals(status.get("sscp"))) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new KDBizException(new ErrorCode("EngdesignRunPlugin-filterData", ResManager.loadKDString((String)"\u7b49\u5f85\u8ba1\u7b97\u6a21\u578b\u5feb\u7167\u521b\u5efa\u51fa\u9519", (String)"EngdesignRunPlugin_7", (String)"mmc-phm-formplugin", (Object[])new Object[0])), new Object[]{e});
            }
            status = (HashMap)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"querySnapshotStatus", (Object[])new Object[]{bizModelId, keyTmp});
        }
        return DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"queryResRuntimeDatas", (Object[])new Object[]{bizModelId, keyTmp});
    }

    private Map<String, Serializable> getFilterParams() {
        String filter = this.getPageCache().get("filter");
        return StringUtils.isBlank((CharSequence)filter) ? new HashMap(16) : (Map)SerializationUtils.fromJsonString((String)filter, HashMap.class);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (StringUtils.equals((CharSequence)"filterValue", (CharSequence)actionId) && returnData instanceof Map) {
            Map result = (Map)returnData;
            this.filterData(result);
        }
    }

    private void runComplete(boolean isInit, String skey) {
        Object result;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object bizModelId = formShowParameter.getCustomParam("bizModelId");
        if (Objects.isNull(bizModelId)) {
            return;
        }
        String resId = bizModelId.toString();
        if (isInit) {
            result = DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"getLatestSnapshotByUser", (Object[])new Object[]{resId});
            this.getView().setEnable(Boolean.FALSE, new String[0]);
            this.getView().setEnable(Boolean.TRUE, new String[0]);
        } else {
            result = DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"queryResRuntimeDatas", (Object[])new Object[]{resId, skey});
        }
        if (result instanceof Map) {
            Map datas = (Map)result;
            HashMap params = Maps.newHashMapWithExpectedSize((int)3);
            params.put("Action", "showAll");
            List<DetailTable> detailTables = this.getDetailTable(datas);
            params.put("details", detailTables);
            Map<String, DetailTable> details = detailTables.stream().collect(Collectors.toMap(DetailTable::getId, detailTable -> detailTable));
            Map handledEigenvalue = DesignerUtils.getHandledEigenvalue((Map)datas, (Object)bizModelId);
            Map formatEigenvalue = DesignerUtils.getFormatEigenvalue((Map)handledEigenvalue);
            params.put("eigenvalues", JSONObject.toJSONString((Object)formatEigenvalue));
            this.setCustomControlData(params);
            DataModel dataModel = new DataModel();
            dataModel.setDetails(details);
            dataModel.setEigenvalues(handledEigenvalue);
            this.getPageCache().put("dataModel", SerializationUtils.toJsonString((Object)dataModel));
        }
    }

    private List<DetailTable> getDetailTable(Map<String, Serializable> datas) {
        long bizModelId = (Long)this.getView().getFormShowParameter().getCustomParam("bizModelId");
        Map componentInfoMap = DesignerUtils.wrapperComponentInfo((long)bizModelId);
        return datas.entrySet().stream().filter(entry -> StringUtils.startsWith((CharSequence)((CharSequence)entry.getKey()), (CharSequence)"detail")).map(entry -> {
            ComponentInfo componentInfo = (ComponentInfo)componentInfoMap.get(entry.getKey());
            return this.wrapperDetailTable((Serializable)entry.getValue(), componentInfo, false);
        }).collect(Collectors.toList());
    }

    private DetailTable wrapperDetailTable(Serializable value, ComponentInfo componentInfo, boolean isDrilling) {
        Map properties = componentInfo.getProperties();
        Tuple<Map<String, String>, Set<String>> detailConfiguration = this.getDetailConfiguration(properties, isDrilling);
        DetailStyle detailStyle = DesignerUtils.wrapperDetailStyle((Map)properties);
        DetailTable detailTable = TableUtils.initDetailTable((int)detailStyle.getPageSize(), (JSONObject)((JSONObject)value), detailConfiguration);
        detailTable.setId(componentInfo.getComponentId());
        detailTable.setRunning(true);
        boolean hide = (Boolean)properties.get("hide_runtime");
        detailTable.setHide(hide);
        detailTable.setStyle(detailStyle);
        return detailTable;
    }

    private Tuple<Map<String, String>, Set<String>> getDetailConfiguration(Map<String, Object> properties, boolean isDrilling) {
        LinkedHashMap<String, String> fieldNameMap = new LinkedHashMap<String, String>(16);
        HashSet<String> relationFields = new HashSet<String>();
        String dataJson = (String)properties.get("field_set_data_tag");
        if (StringUtils.isNotBlank((CharSequence)dataJson)) {
            String entryentity = "field_entryentity";
            String nameField = "field_name";
            String aliasField = "field_alias";
            if (isDrilling) {
                entryentity = "drilling_entryentity";
                nameField = "drilling_name";
                aliasField = "drilling_alias";
            }
            Object[] fieldSets = DynamicObjectSerializeUtil.deserialize((String)dataJson, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"phm_field_set"));
            DynamicObject detailFieldSet = (DynamicObject)fieldSets[0];
            DynamicObjectCollection entryColls = detailFieldSet.getDynamicObjectCollection(entryentity);
            for (DynamicObject entryData : entryColls) {
                fieldNameMap.put(entryData.getString(nameField), entryData.getString(aliasField));
            }
            if (!isDrilling) {
                DynamicObjectCollection drillingEntryentity = detailFieldSet.getDynamicObjectCollection("drilling_entryentity");
                for (DynamicObject entry : drillingEntryentity) {
                    String relationField = entry.getString("drilling_relation");
                    if (!StringUtils.isNotBlank((CharSequence)relationField)) continue;
                    relationFields.add(relationField);
                }
            }
        }
        return Tuple.create(fieldNameMap, relationFields);
    }

    private DataModel getDataModel() {
        String json = this.getPageCache().get("dataModel");
        return StringUtils.isBlank((CharSequence)json) ? new DataModel() : (DataModel)SerializationUtils.fromJsonString((String)json, DataModel.class);
    }

    private void doRun() {
        DynamicObject bizModel = this.getBizModel();
        if (bizModel == null) {
            return;
        }
        Object bizModelId = bizModel.getPkValue();
        String resId = bizModelId.toString();
        HashMap all = (HashMap)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"getLatestSnapshotByUser", (Object[])new Object[]{resId});
        if (all != null) {
            DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"cancelModelSnapshot", (Object[])new Object[]{resId, RequestContext.get().getUserId()});
        }
        this.cheakRunData();
        DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"startCalc", (Object[])new Object[]{bizModel});
        this.startCalculaProgress();
    }

    private void startCalculaProgress() {
        ProgressBar calculalBar = (ProgressBar)this.getView().getControl(CALCULALPROGRESS);
        calculalBar.setPercent(0);
        ProgressBar shotplBar = (ProgressBar)this.getView().getControl(SHOTPROGRESS);
        shotplBar.setPercent(0);
        ProgressBar showplBar = (ProgressBar)this.getView().getControl(SHOWPROGRESS);
        showplBar.setPercent(0);
        calculalBar.start();
    }

    private void showProgress(DynamicObject bizmodel) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("phm_progress");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(OperationStatus.EDIT);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("bizmodelid", bizmodel.getPkValue());
        formShowParameter.setCustomParams(params);
        formShowParameter.setCloseCallBack(new CloseCallBack("kd.mmc.phm.formplugin.bizmodel.EngdesignRunPlugin", "progressClose"));
        this.getView().showForm(formShowParameter);
    }

    private void doUnSave() {
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("doUnSave", (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u53d6\u6d88\u4fdd\u5b58\u4f1a\u5220\u9664\u5feb\u7167\u8bb0\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"EngdesignRunPlugin_8", (String)"mmc-phm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
    }

    private void doSave() {
        DynamicObject bizModel = this.getBizModel();
        if (bizModel != null) {
            Object pkValue = bizModel.getPkValue();
            String resId = pkValue.toString();
            DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"saveModelSnapshot", (Object[])new Object[]{resId, RequestContext.get().getUserId(), null});
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"btn_save"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"btn_unsave"});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5feb\u7167\u6210\u529f\u3002", (String)"EngdesignRunPlugin_9", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
    }

    private void cheakRunData() {
    }

    private DynamicObject getBizModel() {
        Object bizModelId = this.getView().getFormShowParameter().getCustomParam("bizModelId");
        if (bizModelId != null) {
            DynamicObject bizmodel = BusinessDataServiceHelper.loadSingle((Object)bizModelId, (String)"phm_bizmodel");
            return bizmodel;
        }
        return null;
    }

    public void onProgress(ProgressEvent progressEvent) {
        String key;
        Object source = progressEvent.getSource();
        if (!(source instanceof ProgressBar)) {
            return;
        }
        ProgressBar bar = (ProgressBar)source;
        switch (key = bar.getKey()) {
            case "calculalprogress": {
                this.calculaProgress(progressEvent, bar);
                break;
            }
            case "shotprogress": {
                this.shotProgress(progressEvent, bar);
                break;
            }
            case "showprogress": {
                this.runComplete(true, null);
                progressEvent.setProgress(100);
                bar.stop();
                this.getView().setEnable(Boolean.FALSE, new String[]{"btn_save"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"btn_unsave"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"btn_run"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"btn_cancelrun"});
                break;
            }
        }
    }

    private void calculaProgress(ProgressEvent progressEvent, ProgressBar bar) {
        Object bizModelId = this.getView().getFormShowParameter().getCustomParam("bizModelId");
        this.getView().setEnable(Boolean.FALSE, new String[]{"btn_save"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"btn_unsave"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"btn_run"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"btn_cancelrun"});
        if (bizModelId == null) {
            bar.stop();
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578bID\u4e3a\u7a7a,\u8fd0\u7b97\u505c\u6b62", (String)"EngdesignRunPlugin_10", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_save"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_unsave"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"btn_run"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_cancelrun"});
            return;
        }
        String resId = bizModelId.toString();
        if (StringUtils.isEmpty((CharSequence)resId)) {
            bar.stop();
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578bID\u4e3a\u7a7a,\u8fd0\u7b97\u505c\u6b62", (String)"EngdesignRunPlugin_10", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_save"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_unsave"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"btn_run"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_cancelrun"});
            return;
        }
        Object o = DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"queryLatestStatus", (Object[])new Object[]{resId});
        if (o instanceof Map) {
            HashMap ret = (HashMap)o;
            String status = ret.get("status").toString();
            String cacheProgressStr = this.getPageCache().get(CALCULALPROGRESS);
            Integer progress = (Integer)ret.get("progress");
            int newProgress = 0;
            if (StringUtils.isEmpty((CharSequence)cacheProgressStr)) {
                newProgress = progress;
            } else {
                int cacheProgress = Integer.parseInt(cacheProgressStr);
                newProgress = progress > cacheProgress ? progress : cacheProgress + 10;
            }
            if (newProgress >= 100) {
                newProgress = 90;
            }
            this.getPageCache().put(CALCULALPROGRESS, String.valueOf(newProgress));
            progressEvent.setProgress(newProgress);
            Label label = (Label)this.getControl(CALCULALABELAP);
            switch (status) {
                case "A": {
                    label.setText(ResManager.loadKDString((String)"\u6a21\u578b\u5f00\u59cb\u8fd0\u884c", (String)"EngdesignRunPlugin_11", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "B": {
                    label.setText(ResManager.loadKDString((String)"\u6a21\u578b\u8ba1\u7b97\u4e2d(", (String)"EngdesignRunPlugin_12", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + newProgress + "%)");
                    this.getView().setEnable(Boolean.FALSE, new String[]{"btn_save"});
                    this.getView().setEnable(Boolean.FALSE, new String[]{"btn_unsave"});
                    this.getView().setEnable(Boolean.FALSE, new String[]{"btn_run"});
                    this.getView().setEnable(Boolean.TRUE, new String[]{"btn_cancelrun"});
                    break;
                }
                case "C": {
                    progressEvent.setProgress(100);
                    bar.stop();
                    label.setText(ResManager.loadKDString((String)"\u6a21\u578b\u8fd0\u884c\u5b8c\u6210", (String)"EngdesignRunPlugin_13", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                    String returnKey = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"start2CreateSnapshot", (Object[])new Object[]{resId, null});
                    this.getPageCache().put("returnKey", returnKey);
                    ProgressBar shotplBar = (ProgressBar)this.getView().getControl(SHOTPROGRESS);
                    shotplBar.start();
                    this.getView().setEnable(Boolean.FALSE, new String[]{"btn_save"});
                    this.getView().setEnable(Boolean.FALSE, new String[]{"btn_unsave"});
                    this.getView().setEnable(Boolean.TRUE, new String[]{"btn_run"});
                    this.getView().setEnable(Boolean.FALSE, new String[]{"btn_cancelrun"});
                    break;
                }
                case "D": {
                    bar.stop();
                    label.setText(ResManager.loadKDString((String)"\u6a21\u578b\u8fd0\u884c\u51fa\u9519", (String)"EngdesignRunPlugin_14", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u578b\u51fa\u9519\uff0c\u8fd0\u7b97\u505c\u6b62", (String)"EngdesignRunPlugin_15", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                    this.getView().setEnable(Boolean.FALSE, new String[]{"btn_save"});
                    this.getView().setEnable(Boolean.FALSE, new String[]{"btn_unsave"});
                    this.getView().setEnable(Boolean.TRUE, new String[]{"btn_run"});
                    this.getView().setEnable(Boolean.FALSE, new String[]{"btn_cancelrun"});
                    break;
                }
                case "E": {
                    break;
                }
                case "F": {
                    break;
                }
                default: {
                    bar.stop();
                    label.setText(ResManager.loadKDString((String)"\u6a21\u578b\u72b6\u6001\u672a\u77e5\u9519\u8bef", (String)"EngdesignRunPlugin_16", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u578b\u72b6\u6001\u672a\u77e5\u9519\u8bef\uff0c\u8fd0\u7b97\u505c\u6b62", (String)"EngdesignRunPlugin_17", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                    this.getView().setEnable(Boolean.FALSE, new String[]{"btn_save"});
                    this.getView().setEnable(Boolean.FALSE, new String[]{"btn_unsave"});
                    this.getView().setEnable(Boolean.TRUE, new String[]{"btn_run"});
                    this.getView().setEnable(Boolean.FALSE, new String[]{"btn_cancelrun"});
                }
            }
        }
    }

    private void shotProgress(ProgressEvent progressEvent, ProgressBar bar) {
        Object bizModelId = this.getView().getFormShowParameter().getCustomParam("bizModelId");
        if (bizModelId == null) {
            bar.stop();
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578bID\u4e3a\u7a7a,\u5feb\u7167\u505c\u6b62", (String)"EngdesignRunPlugin_18", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_save"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_unsave"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"btn_run"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_cancelrun"});
            return;
        }
        String resId = bizModelId.toString();
        if (StringUtils.isEmpty((CharSequence)resId)) {
            bar.stop();
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578bID\u4e3a\u7a7a,\u5feb\u7167\u505c\u6b62", (String)"EngdesignRunPlugin_18", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_save"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_unsave"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"btn_run"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_cancelrun"});
            return;
        }
        String shotProgressStr = this.getPageCache().get(SHOTPROGRESS);
        int newProgress = 0;
        newProgress = StringUtils.isEmpty((CharSequence)shotProgressStr) ? 10 : Integer.parseInt(shotProgressStr) + 10;
        if (newProgress >= 100) {
            newProgress = 90;
        }
        progressEvent.setProgress(newProgress);
        String returnKey = this.getPageCache().get("returnKey");
        HashMap snapshotStatus = (HashMap)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"ICalcRuntimeService", (String)"querySnapshotStatus", (Object[])new Object[]{resId, returnKey});
        String sscp = snapshotStatus.get("sscp") == null ? "" : ((Serializable)snapshotStatus.get("sscp")).toString();
        Label label = (Label)this.getControl(SHOTLABEL);
        switch (sscp) {
            case "A": {
                label.setText(ResManager.loadKDString((String)"\u5feb\u7167\u5f00\u59cb\u521b\u5efa", (String)"EngdesignRunPlugin_19", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "B": {
                label.setText(ResManager.loadKDString((String)"\u5feb\u7167\u521b\u5efa\u4e2d(", (String)"EngdesignRunPlugin_20", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + newProgress + "%)");
                this.getView().setEnable(Boolean.FALSE, new String[]{"btn_save"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"btn_unsave"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"btn_run"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"btn_cancelrun"});
                break;
            }
            case "C": {
                progressEvent.setProgress(100);
                bar.stop();
                label.setText(ResManager.loadKDString((String)"\u5feb\u7167\u521b\u5efa\u5b8c\u6210", (String)"EngdesignRunPlugin_21", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                this.runComplete(false, returnKey);
                ProgressBar showplBar = (ProgressBar)this.getView().getControl(SHOWPROGRESS);
                showplBar.setPercent(100);
                this.getView().setEnable(Boolean.TRUE, new String[]{"btn_save"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"btn_unsave"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"btn_run"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"btn_cancelrun"});
                break;
            }
            case "D": {
                bar.stop();
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5feb\u7167\u521b\u5efa\u51fa\u9519\uff0c\u5feb\u7167\u505c\u6b62", (String)"EngdesignRunPlugin_22", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                label.setText(ResManager.loadKDString((String)"\u5feb\u7167\u521b\u5efa\u51fa\u9519", (String)"EngdesignRunPlugin_23", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                this.getView().setEnable(Boolean.FALSE, new String[]{"btn_save"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"btn_unsave"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"btn_run"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"btn_cancelrun"});
                break;
            }
            case "E": {
                bar.stop();
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5feb\u7167\u672a\u542f\u52a8\uff0c\u5feb\u7167\u505c\u6b62", (String)"EngdesignRunPlugin_24", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                label.setText(ResManager.loadKDString((String)"\u5feb\u7167\u672a\u542f\u52a8", (String)"EngdesignRunPlugin_25", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                this.getView().setEnable(Boolean.FALSE, new String[]{"btn_save"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"btn_unsave"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"btn_run"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"btn_cancelrun"});
                break;
            }
            case "F": {
                bar.stop();
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5feb\u7167\u672a\u6ce8\u518c\uff0c\u5feb\u7167\u505c\u6b62", (String)"EngdesignRunPlugin_26", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                label.setText(ResManager.loadKDString((String)"\u5feb\u7167\u672a\u6ce8\u518c", (String)"EngdesignRunPlugin_27", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                this.getView().setEnable(Boolean.FALSE, new String[]{"btn_save"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"btn_unsave"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"btn_run"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"btn_cancelrun"});
                break;
            }
            default: {
                bar.stop();
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5feb\u7167\u72b6\u6001\u672a\u77e5\u9519\u8bef\uff0c\u5feb\u7167\u505c\u6b62", (String)"EngdesignRunPlugin_28", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                label.setText(ResManager.loadKDString((String)"\u5feb\u7167\u72b6\u6001\u672a\u77e5\u9519\u8bef", (String)"EngdesignRunPlugin_29", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                this.getView().setEnable(Boolean.FALSE, new String[]{"btn_save"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"btn_unsave"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"btn_run"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"btn_cancelrun"});
            }
        }
    }
}

