/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel;

import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.phm.common.CronStruct;
import kd.mmc.phm.common.basemanager.MonthEnum;
import kd.mmc.phm.common.basemanager.ScheduleConsts;
import kd.mmc.phm.common.basemanager.WeekEnum;
import org.quartz.TriggerUtils;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.OperableTrigger;

public class ModelRunPlanEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final CronParser CRON_PARSER = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
    private static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String PROP_BIZMODEL = "bizmodel";
    private static final String PROP_EFFECTIVESTATUS = "effectivestatus";
    private static final String PROP_ENTRYENTITY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit model = (BasedataEdit)this.getControl(PROP_BIZMODEL);
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener(tabSelectEvent -> {
            String key = tabSelectEvent.getTabKey();
            if (StringUtils.equals((CharSequence)"tabdatepage", (CharSequence)key)) {
                this.getModel().setValue("combdorw", (Object)"d");
            } else if (StringUtils.equals((CharSequence)"tabweekpage", (CharSequence)key)) {
                this.getModel().setValue("combdorw", (Object)"w");
            }
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (!status.equals((Object)OperationStatus.ADDNEW)) {
            String repeatMode;
            this.init();
            this.adjustByRepeatMode();
            Object comNo = this.getModel().getValue("comno");
            Object comWeek = this.getModel().getValue("comweek");
            Tab tab = (Tab)this.getControl("tabap");
            String comBdOrw = (String)this.getModel().getValue("combdorw");
            if (StringUtils.equals((CharSequence)comBdOrw, (CharSequence)"w")) {
                tab.activeTab("tabweekpage");
            }
            if (StringUtils.equals((CharSequence)(repeatMode = (String)this.getModel().getValue("repeatmode")), (CharSequence)"m")) {
                this.getModel().setValue("comnobyweek", comNo);
                this.getModel().setValue("comweekbyweek", comWeek);
            } else if (StringUtils.equals((CharSequence)repeatMode, (CharSequence)"y")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"comnobymonth", "comweekbymonth"});
                this.getModel().setValue("comnobymonth", comNo);
                this.getModel().setValue("comweekbymonth", comWeek);
            }
            this.adjustByCron();
            this.getModel().setValue("txtdesc", (Object)this.genDesc());
        }
        this.getModel().setDataChanged(false);
    }

    private void init() {
        DynamicObject entity = this.getModel().getDataEntity();
        DynamicObjectCollection rows = entity.getDynamicObjectCollection(PROP_ENTRYENTITY);
        for (DynamicObject row : rows) {
            if (row == null) continue;
            DynamicObject obj = row.getDynamicObject(PROP_BIZMODEL);
            String value = this.effectiveCheck(obj.get("startdate"), obj.get("enddate")) ? ResManager.loadKDString((String)"\u5df2\u751f\u6548", (String)"ModelRunPlanEditPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u672a\u751f\u6548", (String)"ModelRunPlanEditPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]);
            row.set(PROP_EFFECTIVESTATUS, (Object)value);
        }
        this.getView().updateView(PROP_ENTRYENTITY);
    }

    private void adjustByCron() {
        String repeatMode = (String)this.getModel().getValue("repeatmode");
        String cron = (String)this.getModel().getValue("plan");
        if (StringUtils.isBlank((CharSequence)cron)) {
            return;
        }
        String[] crons = cron.split(" ");
        if (crons.length < 6) {
            return;
        }
        String hourCron = crons[2];
        String dayCron = crons[3];
        if (StringUtils.isNotBlank((CharSequence)hourCron) && !StringUtils.equalsIgnoreCase((CharSequence)"h", (CharSequence)repeatMode)) {
            Stream.iterate(0, x -> {
                x = x + 1;
                return x;
            }).limit(24L).forEachOrdered(h -> {
                String hour = h < 10 ? "ckhour_0" + h : "ckhour_" + h;
                this.getModel().setValue(hour, (Object)"0");
            });
            if (!StringUtils.equals((CharSequence)"*", (CharSequence)hourCron)) {
                String[] hours = hourCron.split(",");
                Arrays.stream(hours).forEach(x -> {
                    String hour = Integer.parseInt(x) < 10 ? "ckhour_0" + x : "ckhour_" + x;
                    this.getModel().setValue(hour, (Object)"1");
                });
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dayCron) && StringUtils.equals((CharSequence)"L", (CharSequence)dayCron)) {
            this.getModel().setValue("cklastday", (Object)"1");
            ScheduleConsts.CKDATE.forEach(x -> this.getModel().setValue(x, (Object)"0"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)PROP_BIZMODEL, (CharSequence)name)) {
            Object edDate;
            ChangeData changeData = e.getChangeSet()[0];
            DynamicObject model = (DynamicObject)this.getModel().getValue(PROP_BIZMODEL, changeData.getRowIndex());
            Object stDate = model.get("startdate");
            String value = this.effectiveCheck(stDate, edDate = model.get("enddate")) ? ResManager.loadKDString((String)"\u5df2\u751f\u6548", (String)"ModelRunPlanEditPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u672a\u751f\u6548", (String)"ModelRunPlanEditPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]);
            this.getModel().setValue(PROP_EFFECTIVESTATUS, (Object)value, changeData.getRowIndex());
            return;
        }
        if (StringUtils.equals((CharSequence)"txtdesc", (CharSequence)name) || StringUtils.equals((CharSequence)"plan", (CharSequence)name) || StringUtils.equals((CharSequence)PROP_EFFECTIVESTATUS, (CharSequence)name) || StringUtils.equals((CharSequence)"useorg", (CharSequence)name)) {
            return;
        }
        if (name.startsWith("comnoby") || name.startsWith("comweekby")) {
            this.getModel().setValue("comno", this.getModel().getValue(name.replace("comweek", "comno")));
            this.getModel().setValue("comweek", this.getModel().getValue(name.replace("comno", "comweek")));
            String comNo = (String)this.getModel().getValue("comno");
            String comWeek = (String)this.getModel().getValue("comweek");
            if (name.endsWith("bymonth")) {
                this.getModel().setValue("ckbyweek", (Object)(StringUtils.isNotBlank((CharSequence)comNo) && StringUtils.isNotBlank((CharSequence)comWeek) ? 1 : 0));
            }
        }
        if (StringUtils.equals((CharSequence)"repeatmode", (CharSequence)name)) {
            this.adjustByRepeatMode();
        }
        this.adjustByMonth(name);
        this.getModel().setValue("txtdesc", (Object)this.genDesc());
    }

    private boolean effectiveCheck(Object startDate, Object endDate) {
        if (endDate == null && startDate == null) {
            return true;
        }
        if (endDate == null) {
            return this.diff((Date)startDate, new Date());
        }
        if (startDate == null) {
            return this.diff(new Date(), (Date)endDate);
        }
        return this.diff((Date)startDate, new Date()) && this.diff(new Date(), (Date)endDate);
    }

    private boolean diff(Date dt1, Date dt2) {
        Long diff = dt2.getTime() - dt1.getTime();
        return diff >= 0L;
    }

    private void adjustByMonth(String name) {
        boolean isMonth = false;
        for (String propMonth : ScheduleConsts.CKMONTH) {
            if (!StringUtils.equals((CharSequence)propMonth, (CharSequence)name)) continue;
            isMonth = true;
            break;
        }
        if (isMonth) {
            boolean changeMonth = false;
            for (String month : ScheduleConsts.CKMONTH) {
                boolean selected = (Boolean)this.getModel().getValue(month);
                if (!selected) continue;
                changeMonth = true;
                break;
            }
            this.getView().setVisible(Boolean.valueOf(changeMonth), new String[]{"comnobymonth"});
            this.getView().setVisible(Boolean.valueOf(changeMonth), new String[]{"comweekbymonth"});
        }
    }

    private String genDesc() {
        int cycleNum = (Integer)this.getModel().getValue("cyclenum");
        if (cycleNum <= 0) {
            return "";
        }
        Calendar startTime = this.getStartTime();
        CronStruct cron = this.getCronStruct(startTime);
        StringBuilder descBuf = cron.getDescBuf();
        String repeatMode = (String)this.getModel().getValue("repeatmode");
        descBuf.append(ResManager.loadKDString((String)"\u4e8b\u4ef6\u5c06\u4e8e", (String)"ModelRunPlanEditPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        String startTimeStr = new SimpleDateFormat(DATETIME_FORMAT).format(startTime.getTime());
        descBuf.append(startTimeStr).append(ResManager.loadKDString((String)"\u8d77\uff0c", (String)"ModelRunPlanEditPlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        switch (repeatMode) {
            case "n": {
                descBuf.setLength(0);
                descBuf.append(ResManager.loadKDString((String)"\u4e8b\u4ef6\u4e0d\u91cd\u590d\u3002 ", (String)"ModelRunPlanEditPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "mi": {
                this.repeatByHour(cron, repeatMode);
                descBuf.append('\u6bcf').append(cycleNum).append(ResManager.loadKDString((String)"\u5206\u949f\u91cd\u590d\u3002 ", (String)"ModelRunPlanEditPlugin_5", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                if (cycleNum > 1) {
                    cron.setMinutes("0/" + cycleNum);
                } else {
                    cron.setMinutes("*");
                }
                cron.setDayOfMonth("*");
                cron.setMonth("*");
                cron.setDayOfWeek("?");
                cron.setYear(null);
                break;
            }
            case "h": {
                if (cycleNum > 23) {
                    cycleNum = 23;
                    this.getModel().setValue("cyclenum", (Object)23);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u6bcf23\u5c0f\u65f6\u91cd\u590d", (String)"ModelRunPlanEditPlugin_6", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                }
                String hours = "0/" + cycleNum;
                cron.setHours(hours);
                cron.setDayOfMonth("*");
                cron.setMonth("*");
                cron.setDayOfWeek("?");
                cron.setYear(null);
                descBuf.append('\u6bcf').append(cycleNum).append(ResManager.loadKDString((String)"\u5c0f\u65f6\u91cd\u590d\u3002 ", (String)"ModelRunPlanEditPlugin_7", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "d": {
                descBuf.append('\u6bcf').append(cycleNum).append('\u5929');
                if (cycleNum > 1) {
                    String day = String.valueOf(startTime.get(5));
                    cron.setDayOfMonth(day + "/" + cycleNum);
                } else {
                    cron.setDayOfMonth("*");
                }
                this.repeatByHour(cron, repeatMode);
                cron.setMonth("*");
                cron.setDayOfWeek("?");
                cron.setYear(null);
                descBuf.append(ResManager.loadKDString((String)"\u91cd\u590d\u3002 ", (String)"ModelRunPlanEditPlugin_8", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "w": {
                descBuf.append('\u6bcf').append(cycleNum).append('\u5468');
                cron.setDayOfMonth("*");
                cron.setMonth("*");
                cron.setYear(null);
                this.repeatByWeek(cron);
                this.repeatByHour(cron, repeatMode);
                descBuf.append(ResManager.loadKDString((String)"\u91cd\u590d\u3002 ", (String)"ModelRunPlanEditPlugin_8", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "m": {
                descBuf.append('\u6bcf').append(cycleNum).append('\u6708');
                if (cycleNum > 1) {
                    String month = String.valueOf(startTime.get(2) + 1);
                    cron.setMonth(month + "/" + cycleNum);
                } else {
                    cron.setMonth("*");
                }
                cron.setYear(null);
                this.repeatByMonthDay(cron);
                this.repeatByHour(cron, repeatMode);
                descBuf.append(ResManager.loadKDString((String)"\u91cd\u590d\u3002 ", (String)"ModelRunPlanEditPlugin_8", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "y": {
                descBuf.append('\u6bcf').append(cycleNum).append('\u5e74');
                cron.setYear(null);
                this.repeatByMonthly(cron);
                this.repeatByHour(cron, repeatMode);
                descBuf.append(ResManager.loadKDString((String)"\u91cd\u590d\u3002 ", (String)"ModelRunPlanEditPlugin_8", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
        this.getModel().setValue("plan", (Object)cron.toString());
        if (!StringUtils.equals((CharSequence)"n", (CharSequence)repeatMode)) {
            descBuf.append(ResManager.loadKDString((String)"\u9884\u8ba1\u4e0b\u4e00\u6b21\u6267\u884c\u65f6\u95f4\uff1a", (String)"ModelRunPlanEditPlugin_9", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            descBuf.append(this.computeFireTimes(cron.toString(), startTime.getTime(), 1));
        }
        return descBuf.toString();
    }

    private CronStruct getCronStruct(Calendar startTime) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        CronStruct cron = new CronStruct();
        if (status.equals((Object)OperationStatus.ADDNEW)) {
            cron = CronStruct.init((Calendar)startTime);
        } else {
            String cronExp = (String)this.getModel().getValue("plan");
            if (StringUtils.isNotEmpty((CharSequence)cronExp)) {
                cron = CronStruct.parse((String)cronExp);
            }
        }
        return cron;
    }

    private String computeFireTimes(String cronExp, Date startDate, Integer numTimes) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATETIME_FORMAT);
        try {
            CronTriggerImpl cronTriggerImpl = new CronTriggerImpl();
            cronTriggerImpl.setCronExpression(cronExp);
            cronTriggerImpl.setStartTime(startDate);
            List dateList = TriggerUtils.computeFireTimes((OperableTrigger)cronTriggerImpl, null, (int)numTimes);
            return dateFormat.format((Date)dateList.get(0));
        }
        catch (ParseException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"cron\u8868\u8fbe\u5f0f\u8bbe\u7f6e\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\uff1a%s", (String)"ModelRunPlanEditPlugin_10", (String)"mmc-phm-formplugin", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
    }

    private void repeatByHour(CronStruct cron, String repeatMode) {
        String cronExpStr;
        IDataModel dataModel = this.getView().getModel();
        StringBuilder cronExp = new StringBuilder();
        StringBuilder cronDesc = new StringBuilder();
        Stream.iterate(0, x -> {
            x = x + 1;
            return x;
        }).limit(24L).forEachOrdered(h -> {
            String hour = h < 10 ? "ckhour_0" + h : "ckhour_" + h;
            boolean checked = (Boolean)dataModel.getValue(hour);
            if (checked) {
                cronExp.append(h).append(',');
                cronDesc.append(h).append(ResManager.loadKDString((String)"\u65f6\uff0c", (String)"ModelRunPlanEditPlugin_11", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            }
        });
        if (cronExp.length() > 0) {
            cronExpStr = cronExp.substring(0, cronExp.length() - 1);
        } else {
            String string = cronExpStr = "mi".equals(repeatMode) ? "*" : cron.getHours();
        }
        if (cronDesc.length() > 0) {
            cron.getDescBuf().append(cronDesc.substring(0, cronDesc.length() - 1));
        }
        cron.setHours(cronExpStr);
    }

    private void repeatByMonthly(CronStruct cron) {
        IDataModel dataModel = this.getModel();
        String conStr = ResManager.loadKDString((String)"\u7684", (String)"ModelRunPlanEditPlugin_12", (String)"mmc-phm-formplugin", (Object[])new Object[0]);
        StringBuilder months = new StringBuilder();
        StringBuilder descBuf = cron.getDescBuf();
        MonthEnum[] values = MonthEnum.values();
        for (int i = 0; i < ScheduleConsts.CKMONTH.size(); ++i) {
            if (!((Boolean)dataModel.getValue((String)ScheduleConsts.CKMONTH.get(i))).booleanValue()) continue;
            descBuf.append(conStr).append(values[i].getName());
            conStr = ",";
            months.append(values[i].getValue()).append(',');
        }
        if (months.length() == 0) {
            months.append(this.getStartTime().get(2) + 1);
        } else {
            String substring = months.substring(0, months.length() - 1);
            months.setLength(0);
            months.append(substring);
        }
        cron.setMonth(months.toString());
        if (((Boolean)dataModel.getValue("ckbyweek")).booleanValue()) {
            this.repeatByNoWeek(cron);
        }
    }

    private void repeatByMonthDay(CronStruct cron) {
        IDataModel dataModel = this.getModel();
        String byDayOrWeek = (String)dataModel.getValue("combdorw");
        if (StringUtils.equals((CharSequence)byDayOrWeek, (CharSequence)"d")) {
            this.setCronByMonthDay(cron);
        } else if (StringUtils.equals((CharSequence)byDayOrWeek, (CharSequence)"w")) {
            this.repeatByNoWeek(cron);
        }
    }

    private void setCronByMonthDay(CronStruct cron) {
        StringBuilder days = new StringBuilder();
        int conStr = 30340;
        if (((Boolean)this.getModel().getValue("cklastday")).booleanValue()) {
            cron.getDescBuf().append((char)conStr).append(ResManager.loadKDString((String)"\u6700\u540e\u4e00\u65e5", (String)"ModelRunPlanEditPlugin_13", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            days.append('L').append(',');
        } else {
            for (int i = 0; i < ScheduleConsts.CKDATE.size(); ++i) {
                if (!((Boolean)this.getModel().getValue((String)ScheduleConsts.CKDATE.get(i))).booleanValue()) continue;
                cron.getDescBuf().append((char)conStr).append(i + 1).append('\u65e5');
                conStr = 44;
                days.append(i + 1).append(',');
            }
        }
        if (days.length() == 0) {
            if (StringUtils.isBlank((CharSequence)cron.getDayOfMonth())) {
                days.append(this.getStartTime().get(5));
            } else {
                days.append(cron.getDayOfMonth());
            }
        } else {
            String subString = days.substring(0, days.length() - 1);
            days.setLength(0);
            days.append(subString);
        }
        cron.setDayOfMonth(days.toString());
        if (!StringUtils.equals((CharSequence)"?", (CharSequence)days.toString())) {
            cron.setDayOfWeek("?");
        }
    }

    private void repeatByNoWeek(CronStruct cron) {
        IDataModel dataModel = this.getModel();
        String no = (String)dataModel.getValue("comno");
        String noWeek = (String)dataModel.getValue("comweek");
        StringBuilder descBuf = cron.getDescBuf();
        if (no == null || noWeek == null) {
            return;
        }
        this.setDescByNoWeek(no, noWeek, descBuf);
        this.setPlanByNoWeek(cron, no, noWeek);
    }

    private void setPlanByNoWeek(CronStruct cron, String no, String noWeek) {
        boolean inWeek;
        boolean bl = inWeek = no.compareTo("1") >= 0 && no.compareTo("5") <= 0;
        if (noWeek.compareTo("1") >= 0 && noWeek.compareTo("8") < 0) {
            if (inWeek) {
                cron.setDayOfWeek(noWeek + "#" + no);
            } else {
                cron.setDayOfWeek(noWeek + "L");
            }
            cron.setDayOfMonth("?");
        } else if (StringUtils.equals((CharSequence)noWeek, (CharSequence)"8")) {
            if (inWeek) {
                cron.setDayOfMonth(no);
            } else {
                cron.setDayOfMonth("1L");
            }
            cron.setDayOfWeek("?");
        } else {
            if (inWeek) {
                String workday = String.valueOf(Integer.parseInt(no) + 1);
                cron.setDayOfWeek(workday + "#" + no);
            } else {
                cron.setDayOfWeek("6L");
            }
            cron.setDayOfMonth("?");
        }
    }

    private void setDescByNoWeek(String no, String noWeek, StringBuilder descBuf) {
        switch (no) {
            case "1": {
                descBuf.append(ResManager.loadKDString((String)"\u7b2c\u4e00\u4e2a", (String)"ModelRunPlanEditPlugin_14", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "2": {
                descBuf.append(ResManager.loadKDString((String)"\u7b2c\u4e8c\u4e2a", (String)"ModelRunPlanEditPlugin_15", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "3": {
                descBuf.append(ResManager.loadKDString((String)"\u7b2c\u4e09\u4e2a", (String)"ModelRunPlanEditPlugin_16", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "4": {
                descBuf.append(ResManager.loadKDString((String)"\u7b2c\u56db\u4e2a", (String)"ModelRunPlanEditPlugin_17", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "5": {
                descBuf.append(ResManager.loadKDString((String)"\u7b2c\u4e94\u4e2a", (String)"ModelRunPlanEditPlugin_18", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "L": {
                descBuf.append(ResManager.loadKDString((String)"\u6700\u540e\u4e00\u4e2a", (String)"ModelRunPlanEditPlugin_19", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
        descBuf.append(ResManager.loadKDString((String)"\u661f\u671f\u7684", (String)"ModelRunPlanEditPlugin_20", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        switch (noWeek) {
            case "1": {
                descBuf.append(ResManager.loadKDString((String)"\u661f\u671f\u65e5", (String)"ModelRunPlanEditPlugin_21", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "2": {
                descBuf.append(ResManager.loadKDString((String)"\u661f\u671f\u4e00", (String)"ModelRunPlanEditPlugin_22", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "3": {
                descBuf.append(ResManager.loadKDString((String)"\u661f\u671f\u4e8c", (String)"ModelRunPlanEditPlugin_23", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "4": {
                descBuf.append(ResManager.loadKDString((String)"\u661f\u671f\u4e09", (String)"ModelRunPlanEditPlugin_24", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "5": {
                descBuf.append(ResManager.loadKDString((String)"\u661f\u671f\u56db", (String)"ModelRunPlanEditPlugin_25", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "6": {
                descBuf.append(ResManager.loadKDString((String)"\u661f\u671f\u4e94", (String)"ModelRunPlanEditPlugin_26", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "7": {
                descBuf.append(ResManager.loadKDString((String)"\u661f\u671f\u516d", (String)"ModelRunPlanEditPlugin_27", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "8": {
                descBuf.append(ResManager.loadKDString((String)"\u81ea\u7136\u65e5", (String)"ModelRunPlanEditPlugin_28", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "9": {
                descBuf.append(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5", (String)"ModelRunPlanEditPlugin_29", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void repeatByWeek(CronStruct cron) {
        IDataModel dataModel = this.getModel();
        String conStr = ResManager.loadKDString((String)"\u7684", (String)"ModelRunPlanEditPlugin_12", (String)"mmc-phm-formplugin", (Object[])new Object[0]);
        StringBuilder descBuf = cron.getDescBuf();
        StringBuilder weekDays = new StringBuilder();
        WeekEnum[] values = WeekEnum.values();
        for (int i = 0; i < ScheduleConsts.CKWEEK.size(); ++i) {
            if (!((Boolean)dataModel.getValue((String)ScheduleConsts.CKWEEK.get(i))).booleanValue()) continue;
            descBuf.append(conStr).append(values[i].getName());
            conStr = ",";
            weekDays.append(values[i].getValue()).append(',');
        }
        if (weekDays.length() == 0) {
            weekDays.append(this.getStartTime().get(7));
        } else {
            String subString = weekDays.substring(0, weekDays.length() - 1);
            weekDays.setLength(0);
            weekDays.append(subString);
        }
        cron.setDayOfMonth("?");
        cron.setDayOfWeek(weekDays.toString());
    }

    private Calendar getStartTime() {
        Date startTime = (Date)this.getModel().getValue("validated_time");
        Calendar crStartTime = Calendar.getInstance();
        if (startTime != null) {
            crStartTime.setTimeInMillis(startTime.getTime());
        } else {
            this.getModel().setValue("validated_time", (Object)crStartTime.getTime());
        }
        return crStartTime;
    }

    private void adjustByRepeatMode() {
        String repeatMode = (String)this.getModel().getValue("repeatmode");
        IFormView formView = this.getView();
        formView.setVisible(Boolean.FALSE, new String[]{"flexpweek", "flexpworday", "flexpmonths", "flexphour"});
        formView.setEnable(Boolean.TRUE, new String[]{"cyclenum"});
        switch (repeatMode) {
            case "mi": 
            case "d": {
                formView.setVisible(Boolean.TRUE, new String[]{"flexphour"});
                break;
            }
            case "h": {
                formView.setVisible(Boolean.FALSE, new String[]{"flexphour"});
                break;
            }
            case "w": {
                formView.setVisible(Boolean.TRUE, new String[]{"flexpweek", "flexphour"});
                this.getModel().setValue("cyclenum", (Object)1);
                formView.setEnable(Boolean.FALSE, new String[]{"cyclenum"});
                break;
            }
            case "m": {
                formView.setVisible(Boolean.TRUE, new String[]{"flexpworday", "flexphour"});
                break;
            }
            case "y": {
                formView.setVisible(Boolean.TRUE, new String[]{"flexpmonths", "flexphour"});
                this.getModel().setValue("cyclenum", (Object)1);
                formView.setEnable(Boolean.FALSE, new String[]{"cyclenum"});
                break;
            }
            case "n": {
                formView.setEnable(Boolean.FALSE, new String[]{"cyclenum"});
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Control control = (Control)beforeF7SelectEvent.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)PROP_BIZMODEL, (CharSequence)key)) {
            QFilter f = new QFilter("scheduleplan", "!=", (Object)0);
            DynamicObjectCollection mods = QueryServiceHelper.query((String)"phm_modelschedule", (String)"id,scheduleplan", (QFilter[])new QFilter[]{f});
            HashSet<Long> modelIdSet = new HashSet<Long>();
            if (mods != null) {
                for (Iterator mod : mods) {
                    modelIdSet.add(mod.getLong("id"));
                }
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(PROP_ENTRYENTITY);
            for (DynamicObject entry : entryEntity) {
                DynamicObject model = entry.getDynamicObject(PROP_BIZMODEL);
                if (model == null) continue;
                long modId = model.getLong("id");
                modelIdSet.add(modId);
            }
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (!modelIdSet.isEmpty()) {
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", modelIdSet));
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }
}

