/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ModelRunPlanListPlugin
extends AbstractListPlugin {
    private static final String ENTRY_MODELSCHEDULEPLAN = "phm_modelscheduleplan";
    private static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final CronParser CRON_PARSER = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));

    public void packageData(PackageDataEvent e) {
        DynamicObject listData;
        Object repeatmode;
        ColumnDesc columnDesc;
        if (e.getSource() instanceof ColumnDesc && "nextruntime".equals((columnDesc = (ColumnDesc)e.getSource()).getKey()) && !"n".equals(repeatmode = (listData = e.getRowData()).get("repeatmode"))) {
            Object status = listData.get("status");
            Object enable = listData.get("enable");
            if ("A".equals(status) || "0".equals(enable)) {
                return;
            }
            Date now = new Date();
            DynamicObject plan = BusinessDataServiceHelper.loadSingle((Object)listData.getLong("id"), (String)ENTRY_MODELSCHEDULEPLAN, (String)"id,plan");
            String cron = plan.getString("plan");
            e.setFormatValue((Object)this.getNextExeTime(cron, now));
        }
        super.packageData(e);
    }

    private String getNextExeTime(String cronExp, Date date) {
        String nextExeTime = "";
        ZonedDateTime zonedDate = ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)CRON_PARSER.parse(cronExp));
        Optional opt = executionTime.nextExecution(zonedDate);
        if (opt.isPresent()) {
            nextExeTime = ((ZonedDateTime)opt.get()).format(DateTimeFormatter.ofPattern(DATETIME_FORMAT));
        }
        return nextExeTime;
    }
}

