/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.dataentity.DynamicObjectResultSetCallback;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.phm.common.util.ShowFormUtils;

public class ModelScheduleListPlugin
extends AbstractListPlugin {
    private static final String ACTION_SCHEDULESET = "scheduleset";
    private static final String ACTION_RUNTASKSET = "runtaskset";
    private static final String PROP_EFFECTIVESTATUS = "effectivestatus";
    private static final String PROP_STARTDATE = "startdate";
    private static final String PROP_ENDDATE = "enddate";

    public void packageData(PackageDataEvent e) {
        ColumnDesc columnDesc;
        if (e.getSource() instanceof ColumnDesc && PROP_EFFECTIVESTATUS.equals((columnDesc = (ColumnDesc)e.getSource()).getKey())) {
            Object edDate;
            DynamicObject listData = e.getRowData();
            Object stDate = listData.get(PROP_STARTDATE);
            String value = this.effectiveCheck(stDate, edDate = listData.get(PROP_ENDDATE)) ? ResManager.loadKDString((String)"\u5df2\u751f\u6548", (String)"ModelScheduleListPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u672a\u751f\u6548", (String)"ModelScheduleListPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]);
            e.setFormatValue((Object)value);
        }
        super.packageData(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (operateKey.equals("effective")) {
            this.toEffective();
        } else if (operateKey.equals("unrelease")) {
            this.toUnrelease(args);
        } else if (operateKey.equals("runset")) {
            this.runTaskSet();
        } else if (operateKey.equals("run")) {
            this.allowedRunSet(true);
        } else if (operateKey.equals("stoprun")) {
            this.allowedRunSet(false);
        } else if (operateKey.equals("runresultquery")) {
            this.showRunResult();
        } else if (operateKey.equals("tostandard")) {
            this.tostandard(args);
        }
    }

    private void tostandard(BeforeDoOperationEventArgs args) {
        QFilter f1 = new QFilter("operation", "=", (Object)"tostandard");
        QFilter f2 = new QFilter("entrabill", "=", (Object)"phm_modelschedule");
        QFilter f3 = new QFilter("publish", "=", (Object)"1");
        DynamicObject[] mods = BusinessDataServiceHelper.load((String)"wf_model", (String)"id", (QFilter[])new QFilter[]{f1, f2, f3});
        if (mods == null || mods.length < 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6807\u51c6\u5316\u5ba1\u6279\u6d41\u7a0b\u6ca1\u6709\u627e\u5230\u6216\u8fd8\u672a\u53d1\u5e03\uff01", (String)"ModelScheduleListPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void showRunResult() {
        Object primaryKeyValue = this.getSelectedPk();
        if (primaryKeyValue == null) {
            return;
        }
        DynamicObject bizMod = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"phm_bizmodel");
        HashMap<String, Object> customParams = new HashMap<String, Object>(2);
        customParams.put("xml", bizMod.getString("xml_tag"));
        customParams.put("bizModelId", primaryKeyValue);
        FormShowParameter formShowParameter = ShowFormUtils.assembleShowFormParam((String)"phm_engdesign_run", customParams, null, (ShowType)ShowType.Modal);
        formShowParameter.setShowTitle(false);
        this.getView().showForm(formShowParameter);
    }

    private void allowedRunSet(boolean canRun) {
        Object primaryKeyValue = this.getSelectedPk();
        if (primaryKeyValue == null) {
            return;
        }
        DBRoute route = new DBRoute("phm");
        Long bizModId = (Long)primaryKeyValue;
        if (!this.scheduleExists(route, bizModId)) {
            StringBuilder insertSql = new StringBuilder();
            insertSql.append("insert into t_phm_bizmodel_i (FID,fallowedrunstatus) values(");
            insertSql.append(bizModId);
            insertSql.append(",1");
            insertSql.append(')');
            DB.execute((DBRoute)route, (String)insertSql.toString());
        }
        int i = canRun ? 1 : 0;
        String sql = String.format("update t_phm_bizmodel_i set fallowedrunstatus =%d where fid =%s", i, bizModId);
        DB.execute((DBRoute)route, (String)sql);
        String msg = canRun ? ResManager.loadKDString((String)"\u5141\u8bb8\u8fd0\u884c", (String)"ModelScheduleListPlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7981\u6b62\u8fd0\u884c", (String)"ModelScheduleListPlugin_4", (String)"mmc-phm-formplugin", (Object[])new Object[0]);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u88ab", (String)"ModelScheduleListPlugin_5", (String)"mmc-phm-formplugin", (Object[])new Object[0]) + msg);
        this.getView().updateView();
    }

    private boolean scheduleExists(DBRoute dbRoute, Long id) {
        String sql = "select fid from t_phm_bizmodel_i where fid =" + id;
        DynamicObjectCollection dataSet = (DynamicObjectCollection)DB.query((DBRoute)dbRoute, (String)sql, null, (ResultSetHandler)new DynamicObjectResultSetCallback(null));
        return !dataSet.isEmpty();
    }

    private void runTaskSet() {
        Object primaryKeyValue = this.getSelectedPk();
        if (primaryKeyValue == null) {
            return;
        }
        this.openForm("phm_runtaskset", ACTION_RUNTASKSET, primaryKeyValue);
    }

    private void toUnrelease(BeforeDoOperationEventArgs args) {
        Object endDate;
        Object primaryKeyValue = this.getSelectedPk();
        if (primaryKeyValue == null) {
            return;
        }
        DynamicObject mod = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"phm_modelschedule");
        Object startDate = mod.get(PROP_STARTDATE);
        if (this.effectiveCheck(startDate, endDate = mod.get(PROP_ENDDATE))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u64a4\u9500\u53d1\u5e03\u672a\u751f\u6548\u7684\u6a21\u578b\uff01", (String)"ModelScheduleListPlugin_6", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String sql = String.format("delete from t_phm_bizmodel_i where fid = %s", primaryKeyValue);
        DB.execute((DBRoute)new DBRoute("phm"), (String)sql);
    }

    private Object getSelectedPk() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows == null) {
            return null;
        }
        if (rows.size() != 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u652f\u6301\u5355\u884c\u64cd\u4f5c\uff01", (String)"ModelScheduleListPlugin_7", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return null;
        }
        return rows.get(0).getPrimaryKeyValue();
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String action = e.getActionId();
        if (action.equals(ACTION_SCHEDULESET)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void toEffective() {
        Object primaryKeyValue = this.getSelectedPk();
        if (primaryKeyValue == null) {
            return;
        }
        this.openForm("phm_dateset", ACTION_SCHEDULESET, primaryKeyValue);
    }

    private void openForm(String formId, String action, Object id) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.EDIT);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("bizModelId", id);
        showParameter.setCustomParams(params);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, action));
        this.getView().showForm(showParameter);
    }

    private boolean effectiveCheck(Object startDate, Object endDate) {
        if (endDate == null && startDate == null) {
            return true;
        }
        if (endDate == null) {
            return this.diff((Date)startDate, new Date());
        }
        if (startDate == null) {
            return this.diff(new Date(), (Date)endDate);
        }
        return this.diff((Date)startDate, new Date()) && this.diff(new Date(), (Date)endDate);
    }

    private boolean diff(Date dt1, Date dt2) {
        Long diff = dt2.getTime() - dt1.getTime();
        return diff >= 0L;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        ArrayList<QFilter> addFilters = new ArrayList<QFilter>();
        ArrayList<QFilter> removeFilters = new ArrayList<QFilter>();
        for (QFilter qf : qFilters) {
            QFilter f2;
            QFilter f1;
            if (!qf.getProperty().equals(PROP_EFFECTIVESTATUS)) continue;
            String val = qf.getValue().toString();
            removeFilters.add(qf);
            Date now = new Date();
            if (val.equals("0")) {
                f1 = new QFilter(PROP_STARTDATE, ">", (Object)now);
                f2 = new QFilter(PROP_ENDDATE, "<", (Object)now);
                addFilters.add(f1.or(f2));
                continue;
            }
            if (!val.equals("1")) continue;
            f1 = QFilter.isNull((String)PROP_STARTDATE).and(QFilter.isNull((String)PROP_ENDDATE));
            f2 = QFilter.isNull((String)PROP_ENDDATE).and(new QFilter(PROP_STARTDATE, "<", (Object)now));
            QFilter f3 = QFilter.isNull((String)PROP_STARTDATE).and(new QFilter(PROP_ENDDATE, ">", (Object)now));
            QFilter f4 = new QFilter(PROP_ENDDATE, ">", (Object)now).and(new QFilter(PROP_STARTDATE, "<", (Object)now));
            addFilters.add(f1.or(f2).or(f3).or(f4));
        }
        qFilters.removeAll(removeFilters);
        qFilters.addAll(addFilters);
        qFilters.add(new QFilter("releasestatus", "=", (Object)"B"));
    }
}

