/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.mmc.phm.common.bizmodel.ComponentType;
import kd.mmc.phm.common.info.ComponentInfo;
import kd.mmc.phm.common.util.ComponentUtil;
import kd.mmc.phm.common.util.EigenValueUtils;

public class QueryComparisonSetPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String TREEVIEWAP = "treeviewap";
    private static final String ENTRYENTITY = "entryentity";
    private static final String CACHEKEY_ROOT = "root";
    private static final String CACHEKEY_DATA = "data";
    private static final String CACHEKEY_NODEID = "nodeId";
    private static final String[] SHOW_COLUMN_NAME = new String[]{"field_type", "isparam"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getControl(TREEVIEWAP);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        boolean isCompareDetail;
        TreeView treeView = (TreeView)this.getControl(TREEVIEWAP);
        TreeNode root = new TreeNode(null, "0", ResManager.loadKDString((String)"\u5bb9\u5668", (String)"QueryComparisonSetPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String rootPageId = (String)formShowParameter.getCustomParam("rootPageId");
        String eigenComponentIds = (String)formShowParameter.getCustomParam("eigenComponentIds");
        if (StringUtils.contains((CharSequence)eigenComponentIds, (CharSequence)",")) {
            String[] split = StringUtils.split((String)eigenComponentIds.substring(1, eigenComponentIds.length() - 1), (String)", ");
            List componentInfoList = ComponentUtil.getComponentInfoByIds((String)rootPageId, Arrays.asList(split));
            for (ComponentInfo componentInfo : componentInfoList) {
                this.addEigenvalueNode(root, componentInfo);
            }
        } else if (StringUtils.isNotBlank((CharSequence)eigenComponentIds)) {
            String componentId = eigenComponentIds.substring(1, eigenComponentIds.length() - 1);
            ComponentInfo componentInfo = ComponentUtil.getComponentInfo((String)rootPageId, (String)componentId);
            this.addEigenvalueNode(root, componentInfo);
        }
        if (isCompareDetail = ((Boolean)formShowParameter.getCustomParam("isCompareDetail")).booleanValue()) {
            List allDetailInfo = ComponentUtil.getAllComponentInfoByType((String)rootPageId, (ComponentType)ComponentType.DETAIL);
            for (ComponentInfo componentInfo : allDetailInfo) {
                this.addDetailNode(root, componentInfo);
            }
        }
        this.getPageCache().put(CACHEKEY_ROOT, SerializationUtils.toJsonString((Object)root));
        treeView.addNode(root);
        treeView.focusNode(root);
        this.showAllNode(treeView, root);
        this.getPageCache().put(CACHEKEY_DATA, (String)formShowParameter.getCustomParam(CACHEKEY_DATA));
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        Map<String, String> dataMap = this.getData();
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(ENTRYENTITY);
        if (!entryEntity.isEmpty()) {
            if (this.isModified(entryEntity)) {
                DynamicObject dataEntity = model.getDataEntity(true);
                dataMap.put(this.getPageCache().get(CACHEKEY_NODEID), DynamicObjectSerializeUtil.serialize((Object[])new Object[]{dataEntity}, (DynamicObjectType)dataEntity.getDynamicObjectType()));
            } else {
                dataMap.remove(this.getPageCache().get(CACHEKEY_NODEID));
            }
            this.getPageCache().put(CACHEKEY_DATA, SerializationUtils.toJsonString(dataMap));
            model.deleteEntryData(ENTRYENTITY);
        }
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return;
        }
        String dataJson = dataMap.get(nodeId);
        this.getPageCache().put(CACHEKEY_NODEID, nodeId);
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHEKEY_ROOT), TreeNode.class);
        TreeNode currentNode = rootNode.getTreeNode(nodeId, 10);
        String type = currentNode.getType();
        Object currentNodeData = currentNode.getData();
        if (StringUtils.equals((CharSequence)"eigenvalue", (CharSequence)type)) {
            this.showColumn();
        } else if (StringUtils.equals((CharSequence)"param", (CharSequence)type)) {
            this.showColumn();
            if (Objects.isNull(dataJson) && currentNodeData instanceof Map) {
                Map map = (Map)currentNodeData;
                for (Map.Entry entry : map.entrySet()) {
                    int newEntryRow = model.createNewEntryRow(ENTRYENTITY);
                    model.setValue("name", entry.getKey(), newEntryRow);
                    model.setValue("field_type", ((Map)entry.getValue()).get("item1"), newEntryRow);
                    model.setValue("alias", ((Map)entry.getValue()).get("item2"), newEntryRow);
                    model.setValue("nodeid", ((Map)entry.getValue()).get("item3"), newEntryRow);
                }
            } else {
                this.setEntryData(dataJson);
            }
        } else if (currentNodeData instanceof Map) {
            this.hideColumn();
            Map componentInfo = (Map)currentNodeData;
            if (StringUtils.isBlank((CharSequence)dataJson)) {
                Map properties = (Map)componentInfo.get("properties");
                String fieldSetData = (String)properties.get("field_set_data_tag");
                if (StringUtils.isBlank((CharSequence)fieldSetData)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5b57\u6bb5\u4fe1\u606f, \u8bf7\u5148\u8fdb\u884c\u660e\u7ec6\u5b57\u6bb5\u914d\u7f6e", (String)"QueryComparisonSetPlugin_1", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject fieldSet = (DynamicObject)DynamicObjectSerializeUtil.deserialize((String)fieldSetData, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"phm_field_set"))[0];
                if (StringUtils.equals((CharSequence)"detail", (CharSequence)type)) {
                    DynamicObjectCollection field_entryentity = fieldSet.getDynamicObjectCollection("field_entryentity");
                    for (DynamicObject fieldEntry : field_entryentity) {
                        int newEntryRow = model.createNewEntryRow(ENTRYENTITY);
                        model.setValue("name", (Object)fieldEntry.getString("field_name"), newEntryRow);
                        model.setValue("alias", (Object)fieldEntry.getString("field_alias"), newEntryRow);
                    }
                } else {
                    DynamicObjectCollection drilling_entryentity = fieldSet.getDynamicObjectCollection("drilling_entryentity");
                    for (DynamicObject drillingEntry : drilling_entryentity) {
                        int newEntryRow = model.createNewEntryRow(ENTRYENTITY);
                        model.setValue("name", (Object)drillingEntry.getString("drilling_name"), newEntryRow);
                        model.setValue("alias", (Object)drillingEntry.getString("drilling_alias"), newEntryRow);
                    }
                }
            } else {
                this.setEntryData(dataJson);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)"btnok", (CharSequence)control.getKey())) {
            Map<String, String> dataMap = this.getData();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
            if (!entryEntity.isEmpty()) {
                if (this.isModified(entryEntity)) {
                    DynamicObject dataEntity = this.getModel().getDataEntity(true);
                    dataMap.put(this.getPageCache().get(CACHEKEY_NODEID), DynamicObjectSerializeUtil.serialize((Object[])new Object[]{dataEntity}, (DynamicObjectType)dataEntity.getDynamicObjectType()));
                }
                this.getView().returnDataToParent(dataMap);
            }
            this.getView().close();
        }
    }

    private void showAllNode(TreeView treeView, TreeNode treeNode) {
        List children = treeNode.getChildren();
        if (Objects.isNull(children)) {
            treeView.showNode(treeNode.getId());
        } else {
            for (TreeNode child : children) {
                this.showAllNode(treeView, child);
            }
        }
    }

    private void setEntryData(String dataJson) {
        DynamicObject cacheDataEntity = (DynamicObject)DynamicObjectSerializeUtil.deserialize((String)dataJson, (DynamicObjectType)this.getModel().getDataEntityType())[0];
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        dataEntity.set(ENTRYENTITY, (Object)cacheDataEntity.getDynamicObjectCollection(ENTRYENTITY));
        this.getView().updateView(ENTRYENTITY);
    }

    private void addDetailNode(TreeNode root, ComponentInfo componentInfo) {
        DynamicObject fieldSet;
        DynamicObjectCollection drilling_entryentity;
        String componentId = componentInfo.getComponentId();
        Map properties = componentInfo.getProperties();
        String name = (String)properties.get("name");
        TreeNode treeNode = new TreeNode(root.getId(), componentId, name, (Object)componentInfo);
        treeNode.setType("detail");
        String fieldSetData = (String)properties.get("field_set_data_tag");
        if (StringUtils.isNotBlank((CharSequence)fieldSetData) && !(drilling_entryentity = (fieldSet = (DynamicObject)DynamicObjectSerializeUtil.deserialize((String)fieldSetData, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"phm_field_set"))[0]).getDynamicObjectCollection("drilling_entryentity")).isEmpty()) {
            TreeNode node = new TreeNode(componentId, "drilling-" + componentId, name + ResManager.loadKDString((String)"_\u94bb\u53d6", (String)"QueryComparisonSetPlugin_2", (String)"mmc-phm-formplugin", (Object[])new Object[0]), (Object)componentInfo);
            node.setType("drilling");
            treeNode.addChild(node);
        }
        root.addChild(treeNode);
    }

    private void addEigenvalueNode(TreeNode root, ComponentInfo componentInfo) {
        Map properties = componentInfo.getProperties();
        String valuetype = (String)properties.get("valuetype");
        String text = (String)properties.get("name");
        TreeNode treeNode = new TreeNode(root.getId(), componentInfo.getComponentId(), text, (Object)componentInfo);
        treeNode.setType("eigenvalue");
        List valueTags = new ArrayList();
        if (StringUtils.equals((CharSequence)"cal", (CharSequence)valuetype)) {
            valueTags = EigenValueUtils.getTableAndOutputFields((String)((String)properties.get("value_tag")));
        } else if (StringUtils.equals((CharSequence)"query", (CharSequence)valuetype)) {
            valueTags = EigenValueUtils.getQueryTableAndOutputFields((String)((String)properties.get("storevalue_tag")));
        }
        if (!valueTags.isEmpty()) {
            for (Map valueTag : valueTags) {
                int count = 0;
                for (Map.Entry entry : valueTag.entrySet()) {
                    String childNodeText = StringUtils.isBlank((CharSequence)((CharSequence)entry.getKey())) ? ResManager.loadKDString((String)"\u672a\u547d\u540d\u53c2\u6570", (String)"QueryComparisonSetPlugin_3", (String)"mmc-phm-formplugin", (Object[])new Object[0]) : (String)entry.getKey();
                    TreeNode childNode = new TreeNode(treeNode.getId(), treeNode.getId() + "_param" + ++count, childNodeText, entry.getValue());
                    childNode.setType("param");
                    treeNode.addChild(childNode);
                }
            }
        }
        root.addChild(treeNode);
    }

    private void setColumnVisible(boolean visible, String ... fieldKeys) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        for (String fieldKey : fieldKeys) {
            entryGrid.setColumnProperty(fieldKey, "vi", (Object)visible);
        }
    }

    private void showColumn() {
        this.setColumnVisible(true, SHOW_COLUMN_NAME);
    }

    private void hideColumn() {
        this.setColumnVisible(false, SHOW_COLUMN_NAME);
    }

    private Map<String, String> getData() {
        String json = this.getPageCache().get(CACHEKEY_DATA);
        return StringUtils.isBlank((CharSequence)json) ? new HashMap(16) : (Map)SerializationUtils.fromJsonString((String)json, HashMap.class);
    }

    private boolean isModified(DynamicObjectCollection entryEntity) {
        boolean modifyed = false;
        for (DynamicObject entry : entryEntity) {
            String type = entry.getString("type");
            if (!StringUtils.isNotBlank((CharSequence)type)) continue;
            modifyed = true;
            break;
        }
        return modifyed;
    }
}

