/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.mmc.phm.common.info.ComponentInfo;
import kd.mmc.phm.common.util.ComponentUtil;
import kd.mmc.phm.common.util.ShowFormUtils;
import kd.mmc.phm.formplugin.bizmodel.AbstractConfigurePlugin;

public class QueryComponentPlugin
extends AbstractConfigurePlugin {
    private static final String NAME = "name";
    private static final String VALUE_TYPE = "value_type";
    private static final String COMPARISON_FIELD = "comparison_field";
    private static final String COMPARISON_SET_ENTITY = "phm_comparison_set";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit comparisonTextEdit = (TextEdit)this.getControl(COMPARISON_FIELD);
        comparisonTextEdit.addButtonClickListener((ClickListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String eigenvalue = (String)this.getModel().getValue("eigencomponent");
        if (StringUtils.isNotBlank((CharSequence)eigenvalue)) {
            String bizModelPageId = this.getView().getFormShowParameter().getParentPageId();
            this.getModel().endInit();
            ArrayList<String> names = new ArrayList<String>();
            if (StringUtils.contains((CharSequence)eigenvalue, (CharSequence)",")) {
                String[] split = StringUtils.split((String)eigenvalue.substring(1, eigenvalue.length() - 1), (String)", ");
                List componentInfoList = ComponentUtil.getComponentInfoByIds((String)bizModelPageId, Arrays.asList(split));
                for (ComponentInfo componentInfo : componentInfoList) {
                    names.add((String)componentInfo.getProperties().get(NAME));
                }
            } else {
                String componentId = eigenvalue.substring(1, eigenvalue.length() - 1);
                ComponentInfo componentInfo = ComponentUtil.getComponentInfo((String)bizModelPageId, (String)componentId);
                names.add((String)componentInfo.getProperties().get(NAME));
            }
            this.getModel().setValue("action_eigenvalue", (Object)((Object)names).toString());
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)NAME, (CharSequence)key)) {
            String name = (String)newValue;
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("Action", "updateLabel");
            params.put("id", this.getView().getFormShowParameter().getCustomParam("componentId"));
            params.put("params", new String[]{name});
            this.setCustomControlData(params);
        } else if (StringUtils.equals((CharSequence)VALUE_TYPE, (CharSequence)key)) {
            String valueType = (String)newValue;
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("Action", "updateLabel");
            params.put("id", this.getView().getFormShowParameter().getCustomParam("componentId"));
            params.put("params", new String[]{"", valueType});
            this.setCustomControlData(params);
        } else if (StringUtils.equals((CharSequence)"backcolor", (CharSequence)key)) {
            this.addStyle("fillColor", newValue);
        } else if (StringUtils.equals((CharSequence)"fontcolor", (CharSequence)key)) {
            this.addStyle("fontColor", newValue);
        } else if (StringUtils.equals((CharSequence)"fontsize", (CharSequence)key)) {
            this.addStyle("fontSize", newValue);
        } else if (StringUtils.equals((CharSequence)COMPARISON_FIELD, (CharSequence)key) && StringUtils.isBlank((CharSequence)((String)newValue))) {
            this.getModel().setValue("comparison_data", null);
            this.getModel().setValue("comparison_data_tag", null);
        } else if (StringUtils.equals((CharSequence)"width", (CharSequence)key) || StringUtils.equals((CharSequence)"height", (CharSequence)key)) {
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("Action", "updateQueryHeight");
            params.put("id", this.getView().getFormShowParameter().getCustomParam("componentId"));
            params.put(key, newValue);
            this.setCustomControlData(params);
        }
    }

    @Override
    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)"action_eigenvalue", (CharSequence)control.getKey())) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "action_eigenvalue");
            HashMap<String, Object> customParams = new HashMap<String, Object>(8);
            customParams.put("isFromQueryComponent", Boolean.TRUE);
            customParams.put("bizModelId", this.getView().getParentView().getFormShowParameter().getCustomParam("bizModelId"));
            customParams.put("bizModelPageId", this.getView().getFormShowParameter().getParentPageId());
            FormShowParameter formShowParameter = ShowFormUtils.assembleShowFormParam((String)"phm_action_eigenvalue", customParams, (CloseCallBack)closeCallBack, (ShowType)ShowType.Modal);
            this.getView().showForm(formShowParameter);
        } else if (StringUtils.equals((CharSequence)COMPARISON_FIELD, (CharSequence)control.getKey())) {
            String eigenComponentIds = (String)this.getModel().getValue("eigencomponent");
            boolean isCompareDetail = (Boolean)this.getModel().getValue("comparison_details");
            String comparisonData = (String)this.getModel().getValue("comparison_data_tag");
            HashMap<String, Object> customParams = new HashMap<String, Object>(8);
            customParams.put("eigenComponentIds", eigenComponentIds);
            customParams.put("isCompareDetail", isCompareDetail);
            customParams.put("rootPageId", this.getView().getFormShowParameter().getParentPageId());
            customParams.put("data", comparisonData);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, COMPARISON_FIELD);
            FormShowParameter formShowParameter = ShowFormUtils.assembleShowFormParam((String)COMPARISON_SET_ENTITY, customParams, (CloseCallBack)closeCallBack, (ShowType)ShowType.Modal);
            this.getView().showForm(formShowParameter);
        } else {
            super.click(evt);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (StringUtils.equals((CharSequence)COMPARISON_FIELD, (CharSequence)event.getActionId()) && event.getReturnData() instanceof HashMap) {
            Map returnData = (Map)event.getReturnData();
            this.getModel().setValue(COMPARISON_FIELD, (Object)ResManager.loadKDString((String)"\u5df2\u914d\u7f6e", (String)"QueryComponentPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("comparison_data_tag", (Object)SerializationUtils.toJsonString((Object)returnData));
        }
    }
}

