/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;

public class QueryFilterFieldPlugin
extends AbstractFormPlugin {
    private static final String CHARACTER = "character";
    private static final String NUMBER = "number";
    private static final String DATE = "date";
    private static final String DATETIME = "datetime";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String valueType = (String)this.getView().getFormShowParameter().getCustomParam("valueType");
        if (StringUtils.equals((CharSequence)CHARACTER, (CharSequence)valueType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{NUMBER, DATE, DATETIME});
        } else if (StringUtils.equals((CharSequence)NUMBER, (CharSequence)valueType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CHARACTER, DATE, DATETIME});
        } else if (StringUtils.equals((CharSequence)DATE, (CharSequence)valueType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CHARACTER, NUMBER, DATETIME});
        } else if (StringUtils.equals((CharSequence)DATETIME, (CharSequence)valueType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CHARACTER, NUMBER, DATE});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"ok"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)"ok", (CharSequence)control.getKey())) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Map customParams = formShowParameter.getCustomParams();
            String valueType = (String)customParams.get("valueType");
            Object value = this.getModel().getValue(valueType);
            String returnValue = "";
            if (Objects.isNull(value)) {
                returnValue = "";
            } else if (StringUtils.equals((CharSequence)CHARACTER, (CharSequence)valueType)) {
                returnValue = (String)value;
            } else if (StringUtils.equals((CharSequence)NUMBER, (CharSequence)valueType)) {
                returnValue = ((BigDecimal)value).stripTrailingZeros().toPlainString();
            } else if (StringUtils.equals((CharSequence)DATE, (CharSequence)valueType)) {
                returnValue = new SimpleDateFormat("yyyy-MM-dd").format(value);
            } else if (StringUtils.equals((CharSequence)DATETIME, (CharSequence)valueType)) {
                returnValue = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(value);
            }
            customParams.put("value", returnValue);
            this.getView().returnDataToParent((Object)customParams);
            this.getView().close();
        }
    }
}

