/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.formplugin.bizmodel;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.dataentity.DynamicObjectResultSetCallback;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.phm.common.bizmodel.TaskUtils;

public class SchedulePlanSetPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String PROP_BIZMODELID = "bizModelId";
    private static final String PROP_SCHEDULEPLAN = "scheduleplan";
    private static final String KEY_BTN_OK = "btnok";
    private static final String PROP_NEWPLAN = "newplan";
    private static final String PROP_CURRENTPLAN = "currentplan";
    private static final String ENTITY_PHM_MODELSCHEDULEPLAN = "phm_modelscheduleplan";

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Control control = (Control)beforeF7SelectEvent.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)PROP_NEWPLAN, (CharSequence)key)) {
            DynamicObject currentplan = (DynamicObject)this.getModel().getValue(PROP_CURRENTPLAN);
            if (currentplan == null) {
                return;
            }
            Long id = currentplan.getLong("id");
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "!=", (Object)id));
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals(KEY_BTN_OK)) {
            this.save();
            this.getView().close();
        }
    }

    private void save() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map filters = formShowParameter.getCustomParams();
        if (!filters.containsKey(PROP_BIZMODELID)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u578bID\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5!", (String)"SchedulePlanSetPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        Long id = Long.parseLong(filters.get(PROP_BIZMODELID).toString());
        DBRoute dbRoute = new DBRoute("phm");
        this.updateBizModel(dbRoute, id);
        this.updateModSchedulePlan(dbRoute, id);
    }

    private void updateModSchedulePlan(DBRoute dbRoute, Long bizModId) {
        DynamicObject oldPlan = (DynamicObject)this.getModel().getValue(PROP_CURRENTPLAN);
        DynamicObject newPlan = (DynamicObject)this.getModel().getValue(PROP_NEWPLAN);
        if (newPlan == null) {
            return;
        }
        Long nPlanId = newPlan.getLong("id");
        this.updateNewPlan(nPlanId, bizModId);
        if (oldPlan != null) {
            Long oPlanId = oldPlan.getLong("id");
            this.updateOldPlan(dbRoute, oPlanId, bizModId);
        }
    }

    private void updateNewPlan(Long planId, Long bizModId) {
        DynamicObject plan = BusinessDataServiceHelper.loadSingle((Object)planId, (String)ENTITY_PHM_MODELSCHEDULEPLAN, (String)"id,enable,entryentity.bizmodel,entryentity.seq");
        DynamicObjectCollection rows = plan.getDynamicObjectCollection("entryentity");
        for (DynamicObject obj : rows) {
            DynamicObject bizModIdold = (DynamicObject)obj.get("bizmodel");
            Long bizModIdoldId = (Long)bizModIdold.getPkValue();
            if (bizModIdoldId.longValue() != bizModId.longValue()) continue;
            return;
        }
        DynamicObject row = rows.addNew();
        row.set("seq", (Object)rows.size());
        row.set("bizmodel", (Object)bizModId);
        plan.set("enable", (Object)1);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{plan});
        plan = BusinessDataServiceHelper.loadSingle((Object)planId, (String)ENTITY_PHM_MODELSCHEDULEPLAN);
        OperationResult result = TaskUtils.taskUpdate((DynamicObject)plan);
        if (!result.isSuccess()) {
            this.getView().showErrorNotification(this.getErrorInfo(result));
        }
    }

    private void updateOldPlan(DBRoute dbRoute, Long planId, Long bizModId) {
        String sql = String.format("delete from t_phm_runobj where fid = %d and fbizmodel = %d", planId, bizModId);
        DB.execute((DBRoute)dbRoute, (String)sql);
        DynamicObject plan = BusinessDataServiceHelper.loadSingle((Object)planId, (String)ENTITY_PHM_MODELSCHEDULEPLAN, (String)"id,enable,entryentity");
        DynamicObjectCollection rows = plan.getDynamicObjectCollection("entryentity");
        if (rows == null || rows.size() == 0) {
            plan.set("enable", (Object)0);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{plan});
        }
    }

    private void updateBizModel(DBRoute dbRoute, Long bizModId) {
        if (!this.scheduleExists(dbRoute, bizModId)) {
            StringBuilder insertSql = new StringBuilder();
            insertSql.append("insert into t_phm_bizmodel_i (FID,fallowedrunstatus) values(");
            insertSql.append(bizModId);
            insertSql.append(",1");
            insertSql.append(')');
            DB.execute((DBRoute)dbRoute, (String)insertSql.toString());
        }
        DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)bizModId, (String)"phm_modelschedule", (String)"id,scheduleplan");
        DynamicObject temp = (DynamicObject)this.getModel().getValue(PROP_NEWPLAN);
        model.set(PROP_SCHEDULEPLAN, (Object)temp.getLong("id"));
        model.set("scheduleplan_id", (Object)temp.getLong("id"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{model});
    }

    private boolean scheduleExists(DBRoute dbRoute, Long id) {
        String sql = "select fid from t_phm_bizmodel_i where fid =" + id;
        DynamicObjectCollection dataSet = (DynamicObjectCollection)DB.query((DBRoute)dbRoute, (String)sql, null, (ResultSetHandler)new DynamicObjectResultSetCallback(null));
        return !dataSet.isEmpty();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTN_OK});
        BasedataEdit plan = (BasedataEdit)this.getControl(PROP_NEWPLAN);
        plan.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map filters = formShowParameter.getCustomParams();
        if (!filters.containsKey(PROP_BIZMODELID)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u578bID\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5!", (String)"SchedulePlanSetPlugin_0", (String)"mmc-phm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.init(Long.parseLong(filters.get(PROP_BIZMODELID).toString()));
    }

    private void init(Long id) {
        DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)id, (String)"phm_modelschedule", (String)"id,scheduleplan");
        DynamicObject plan = (DynamicObject)model.get(PROP_SCHEDULEPLAN);
        if (plan != null) {
            this.getModel().setValue(PROP_CURRENTPLAN, plan.get("id"));
        }
    }

    private String getErrorInfo(OperationResult result) {
        List vErr;
        List err = result.getAllErrorInfo();
        StringBuilder sb = new StringBuilder();
        if (err.size() > 0) {
            for (OperateErrorInfo errInfo : err) {
                sb.append('|');
                sb.append(errInfo.getMessage());
            }
        }
        if ((vErr = result.getAllErrorOrValidateInfo()).size() > 0) {
            for (IOperateInfo errInfo : vErr) {
                sb.append('|');
                sb.append(errInfo.getMessage());
            }
        }
        return sb.toString();
    }
}

